/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The predicted gender of a detected face.
 * </p>
 * <p>
 * Amazon Rekognition makes gender binary (male/female) predictions based on the physical appearance of a face in a
 * particular image. This kind of prediction is not designed to categorize a person’s gender identity, and you shouldn't
 * use Amazon Rekognition to make such a determination. For example, a male actor wearing a long-haired wig and earrings
 * for a role might be predicted as female.
 * </p>
 * <p>
 * Using Amazon Rekognition to make gender binary predictions is best suited for use cases where aggregate gender
 * distribution statistics need to be analyzed without identifying specific users. For example, the percentage of female
 * users compared to male users on a social media platform.
 * </p>
 * <p>
 * We don't recommend using gender binary predictions to make decisions that impact&#x2028; an individual's rights,
 * privacy, or access to services.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Gender implements SdkPojo, Serializable, ToCopyableBuilder<Gender.Builder, Gender> {
    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(Gender::valueAsString)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<Float> CONFIDENCE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("Confidence").getter(getter(Gender::confidence)).setter(setter(Builder::confidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(VALUE_FIELD, CONFIDENCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String value;

    private final Float confidence;

    private Gender(BuilderImpl builder) {
        this.value = builder.value;
        this.confidence = builder.confidence;
    }

    /**
     * <p>
     * The predicted gender of the face.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #value} will return
     * {@link GenderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #valueAsString}.
     * </p>
     * 
     * @return The predicted gender of the face.
     * @see GenderType
     */
    public GenderType value() {
        return GenderType.fromValue(value);
    }

    /**
     * <p>
     * The predicted gender of the face.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #value} will return
     * {@link GenderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #valueAsString}.
     * </p>
     * 
     * @return The predicted gender of the face.
     * @see GenderType
     */
    public String valueAsString() {
        return value;
    }

    /**
     * <p>
     * Level of confidence in the prediction.
     * </p>
     * 
     * @return Level of confidence in the prediction.
     */
    public Float confidence() {
        return confidence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(valueAsString());
        hashCode = 31 * hashCode + Objects.hashCode(confidence());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Gender)) {
            return false;
        }
        Gender other = (Gender) obj;
        return Objects.equals(valueAsString(), other.valueAsString()) && Objects.equals(confidence(), other.confidence());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Gender").add("Value", valueAsString()).add("Confidence", confidence()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Value":
            return Optional.ofNullable(clazz.cast(valueAsString()));
        case "Confidence":
            return Optional.ofNullable(clazz.cast(confidence()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Gender, T> g) {
        return obj -> g.apply((Gender) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Gender> {
        /**
         * <p>
         * The predicted gender of the face.
         * </p>
         * 
         * @param value
         *        The predicted gender of the face.
         * @see GenderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GenderType
         */
        Builder value(String value);

        /**
         * <p>
         * The predicted gender of the face.
         * </p>
         * 
         * @param value
         *        The predicted gender of the face.
         * @see GenderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GenderType
         */
        Builder value(GenderType value);

        /**
         * <p>
         * Level of confidence in the prediction.
         * </p>
         * 
         * @param confidence
         *        Level of confidence in the prediction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Float confidence);
    }

    static final class BuilderImpl implements Builder {
        private String value;

        private Float confidence;

        private BuilderImpl() {
        }

        private BuilderImpl(Gender model) {
            value(model.value);
            confidence(model.confidence);
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public final Builder value(GenderType value) {
            this.value(value == null ? null : value.toString());
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final Float getConfidence() {
            return confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        public Gender build() {
            return new Gender(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
