/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a detected celebrity and the time the celebrity was detected in a stored video. For more
 * information, see GetCelebrityRecognition in the Amazon Rekognition Developer Guide.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CelebrityRecognition implements SdkPojo, Serializable,
        ToCopyableBuilder<CelebrityRecognition.Builder, CelebrityRecognition> {
    private static final SdkField<Long> TIMESTAMP_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Timestamp")
            .getter(getter(CelebrityRecognition::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final SdkField<CelebrityDetail> CELEBRITY_FIELD = SdkField.<CelebrityDetail> builder(MarshallingType.SDK_POJO)
            .memberName("Celebrity").getter(getter(CelebrityRecognition::celebrity)).setter(setter(Builder::celebrity))
            .constructor(CelebrityDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Celebrity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD,
            CELEBRITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long timestamp;

    private final CelebrityDetail celebrity;

    private CelebrityRecognition(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.celebrity = builder.celebrity;
    }

    /**
     * <p>
     * The time, in milliseconds from the start of the video, that the celebrity was recognized.
     * </p>
     * 
     * @return The time, in milliseconds from the start of the video, that the celebrity was recognized.
     */
    public Long timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * Information about a recognized celebrity.
     * </p>
     * 
     * @return Information about a recognized celebrity.
     */
    public CelebrityDetail celebrity() {
        return celebrity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(celebrity());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CelebrityRecognition)) {
            return false;
        }
        CelebrityRecognition other = (CelebrityRecognition) obj;
        return Objects.equals(timestamp(), other.timestamp()) && Objects.equals(celebrity(), other.celebrity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CelebrityRecognition").add("Timestamp", timestamp()).add("Celebrity", celebrity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "Celebrity":
            return Optional.ofNullable(clazz.cast(celebrity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CelebrityRecognition, T> g) {
        return obj -> g.apply((CelebrityRecognition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CelebrityRecognition> {
        /**
         * <p>
         * The time, in milliseconds from the start of the video, that the celebrity was recognized.
         * </p>
         * 
         * @param timestamp
         *        The time, in milliseconds from the start of the video, that the celebrity was recognized.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Long timestamp);

        /**
         * <p>
         * Information about a recognized celebrity.
         * </p>
         * 
         * @param celebrity
         *        Information about a recognized celebrity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder celebrity(CelebrityDetail celebrity);

        /**
         * <p>
         * Information about a recognized celebrity.
         * </p>
         * This is a convenience that creates an instance of the {@link CelebrityDetail.Builder} avoiding the need to
         * create one manually via {@link CelebrityDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link CelebrityDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #celebrity(CelebrityDetail)}.
         * 
         * @param celebrity
         *        a consumer that will call methods on {@link CelebrityDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #celebrity(CelebrityDetail)
         */
        default Builder celebrity(Consumer<CelebrityDetail.Builder> celebrity) {
            return celebrity(CelebrityDetail.builder().applyMutation(celebrity).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Long timestamp;

        private CelebrityDetail celebrity;

        private BuilderImpl() {
        }

        private BuilderImpl(CelebrityRecognition model) {
            timestamp(model.timestamp);
            celebrity(model.celebrity);
        }

        public final Long getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        public final CelebrityDetail.Builder getCelebrity() {
            return celebrity != null ? celebrity.toBuilder() : null;
        }

        @Override
        public final Builder celebrity(CelebrityDetail celebrity) {
            this.celebrity = celebrity;
            return this;
        }

        public final void setCelebrity(CelebrityDetail.BuilderImpl celebrity) {
            this.celebrity = celebrity != null ? celebrity.build() : null;
        }

        @Override
        public CelebrityRecognition build() {
            return new CelebrityRecognition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
