/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The evaluation results for the training of a model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationResult implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationResult.Builder, EvaluationResult> {
    private static final SdkField<Float> F1_SCORE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("F1Score")
            .getter(getter(EvaluationResult::f1Score)).setter(setter(Builder::f1Score))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("F1Score").build()).build();

    private static final SdkField<Summary> SUMMARY_FIELD = SdkField.<Summary> builder(MarshallingType.SDK_POJO)
            .memberName("Summary").getter(getter(EvaluationResult::summary)).setter(setter(Builder::summary))
            .constructor(Summary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Summary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(F1_SCORE_FIELD, SUMMARY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Float f1Score;

    private final Summary summary;

    private EvaluationResult(BuilderImpl builder) {
        this.f1Score = builder.f1Score;
        this.summary = builder.summary;
    }

    /**
     * <p>
     * The F1 score for the evaluation of all labels. The F1 score metric evaluates the overall precision and recall
     * performance of the model as a single value. A higher value indicates better precision and recall performance. A
     * lower score indicates that precision, recall, or both are performing poorly.
     * </p>
     * 
     * @return The F1 score for the evaluation of all labels. The F1 score metric evaluates the overall precision and
     *         recall performance of the model as a single value. A higher value indicates better precision and recall
     *         performance. A lower score indicates that precision, recall, or both are performing poorly.
     */
    public Float f1Score() {
        return f1Score;
    }

    /**
     * <p>
     * The S3 bucket that contains the training summary.
     * </p>
     * 
     * @return The S3 bucket that contains the training summary.
     */
    public Summary summary() {
        return summary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(f1Score());
        hashCode = 31 * hashCode + Objects.hashCode(summary());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationResult)) {
            return false;
        }
        EvaluationResult other = (EvaluationResult) obj;
        return Objects.equals(f1Score(), other.f1Score()) && Objects.equals(summary(), other.summary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EvaluationResult").add("F1Score", f1Score()).add("Summary", summary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "F1Score":
            return Optional.ofNullable(clazz.cast(f1Score()));
        case "Summary":
            return Optional.ofNullable(clazz.cast(summary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EvaluationResult, T> g) {
        return obj -> g.apply((EvaluationResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationResult> {
        /**
         * <p>
         * The F1 score for the evaluation of all labels. The F1 score metric evaluates the overall precision and recall
         * performance of the model as a single value. A higher value indicates better precision and recall performance.
         * A lower score indicates that precision, recall, or both are performing poorly.
         * </p>
         * 
         * @param f1Score
         *        The F1 score for the evaluation of all labels. The F1 score metric evaluates the overall precision and
         *        recall performance of the model as a single value. A higher value indicates better precision and
         *        recall performance. A lower score indicates that precision, recall, or both are performing poorly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder f1Score(Float f1Score);

        /**
         * <p>
         * The S3 bucket that contains the training summary.
         * </p>
         * 
         * @param summary
         *        The S3 bucket that contains the training summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summary(Summary summary);

        /**
         * <p>
         * The S3 bucket that contains the training summary.
         * </p>
         * This is a convenience that creates an instance of the {@link Summary.Builder} avoiding the need to create one
         * manually via {@link Summary#builder()}.
         *
         * When the {@link Consumer} completes, {@link Summary.Builder#build()} is called immediately and its result is
         * passed to {@link #summary(Summary)}.
         * 
         * @param summary
         *        a consumer that will call methods on {@link Summary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summary(Summary)
         */
        default Builder summary(Consumer<Summary.Builder> summary) {
            return summary(Summary.builder().applyMutation(summary).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Float f1Score;

        private Summary summary;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationResult model) {
            f1Score(model.f1Score);
            summary(model.summary);
        }

        public final Float getF1Score() {
            return f1Score;
        }

        @Override
        public final Builder f1Score(Float f1Score) {
            this.f1Score = f1Score;
            return this;
        }

        public final void setF1Score(Float f1Score) {
            this.f1Score = f1Score;
        }

        public final Summary.Builder getSummary() {
            return summary != null ? summary.toBuilder() : null;
        }

        @Override
        public final Builder summary(Summary summary) {
            this.summary = summary;
            return this;
        }

        public final void setSummary(Summary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        @Override
        public EvaluationResult build() {
            return new EvaluationResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
