/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartSegmentDetectionRequest extends RekognitionRequest implements
        ToCopyableBuilder<StartSegmentDetectionRequest.Builder, StartSegmentDetectionRequest> {
    private static final SdkField<Video> VIDEO_FIELD = SdkField.<Video> builder(MarshallingType.SDK_POJO).memberName("Video")
            .getter(getter(StartSegmentDetectionRequest::video)).setter(setter(Builder::video)).constructor(Video::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Video").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken").getter(getter(StartSegmentDetectionRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build())
            .build();

    private static final SdkField<NotificationChannel> NOTIFICATION_CHANNEL_FIELD = SdkField
            .<NotificationChannel> builder(MarshallingType.SDK_POJO).memberName("NotificationChannel")
            .getter(getter(StartSegmentDetectionRequest::notificationChannel)).setter(setter(Builder::notificationChannel))
            .constructor(NotificationChannel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationChannel").build())
            .build();

    private static final SdkField<String> JOB_TAG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("JobTag")
            .getter(getter(StartSegmentDetectionRequest::jobTag)).setter(setter(Builder::jobTag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobTag").build()).build();

    private static final SdkField<StartSegmentDetectionFilters> FILTERS_FIELD = SdkField
            .<StartSegmentDetectionFilters> builder(MarshallingType.SDK_POJO).memberName("Filters")
            .getter(getter(StartSegmentDetectionRequest::filters)).setter(setter(Builder::filters))
            .constructor(StartSegmentDetectionFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()).build();

    private static final SdkField<List<String>> SEGMENT_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SegmentTypes")
            .getter(getter(StartSegmentDetectionRequest::segmentTypesAsStrings))
            .setter(setter(Builder::segmentTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIDEO_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD, NOTIFICATION_CHANNEL_FIELD, JOB_TAG_FIELD, FILTERS_FIELD, SEGMENT_TYPES_FIELD));

    private final Video video;

    private final String clientRequestToken;

    private final NotificationChannel notificationChannel;

    private final String jobTag;

    private final StartSegmentDetectionFilters filters;

    private final List<String> segmentTypes;

    private StartSegmentDetectionRequest(BuilderImpl builder) {
        super(builder);
        this.video = builder.video;
        this.clientRequestToken = builder.clientRequestToken;
        this.notificationChannel = builder.notificationChannel;
        this.jobTag = builder.jobTag;
        this.filters = builder.filters;
        this.segmentTypes = builder.segmentTypes;
    }

    /**
     * Returns the value of the Video property for this object.
     * 
     * @return The value of the Video property for this object.
     */
    public Video video() {
        return video;
    }

    /**
     * <p>
     * Idempotent token used to identify the start request. If you use the same token with multiple
     * <code>StartSegmentDetection</code> requests, the same <code>JobId</code> is returned. Use
     * <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once.
     * </p>
     * 
     * @return Idempotent token used to identify the start request. If you use the same token with multiple
     *         <code>StartSegmentDetection</code> requests, the same <code>JobId</code> is returned. Use
     *         <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The ARN of the Amazon SNS topic to which you want Amazon Rekognition Video to publish the completion status of
     * the segment detection operation.
     * </p>
     * 
     * @return The ARN of the Amazon SNS topic to which you want Amazon Rekognition Video to publish the completion
     *         status of the segment detection operation.
     */
    public NotificationChannel notificationChannel() {
        return notificationChannel;
    }

    /**
     * <p>
     * An identifier you specify that's returned in the completion notification that's published to your Amazon Simple
     * Notification Service topic. For example, you can use <code>JobTag</code> to group related jobs and identify them
     * in the completion notification.
     * </p>
     * 
     * @return An identifier you specify that's returned in the completion notification that's published to your Amazon
     *         Simple Notification Service topic. For example, you can use <code>JobTag</code> to group related jobs and
     *         identify them in the completion notification.
     */
    public String jobTag() {
        return jobTag;
    }

    /**
     * <p>
     * Filters for technical cue or shot detection.
     * </p>
     * 
     * @return Filters for technical cue or shot detection.
     */
    public StartSegmentDetectionFilters filters() {
        return filters;
    }

    /**
     * <p>
     * An array of segment types to detect in the video. Valid values are TECHNICAL_CUE and SHOT.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSegmentTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of segment types to detect in the video. Valid values are TECHNICAL_CUE and SHOT.
     */
    public List<SegmentType> segmentTypes() {
        return SegmentTypesCopier.copyStringToEnum(segmentTypes);
    }

    /**
     * Returns true if the SegmentTypes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSegmentTypes() {
        return segmentTypes != null && !(segmentTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of segment types to detect in the video. Valid values are TECHNICAL_CUE and SHOT.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSegmentTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of segment types to detect in the video. Valid values are TECHNICAL_CUE and SHOT.
     */
    public List<String> segmentTypesAsStrings() {
        return segmentTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(video());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(notificationChannel());
        hashCode = 31 * hashCode + Objects.hashCode(jobTag());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(hasSegmentTypes() ? segmentTypesAsStrings() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSegmentDetectionRequest)) {
            return false;
        }
        StartSegmentDetectionRequest other = (StartSegmentDetectionRequest) obj;
        return Objects.equals(video(), other.video()) && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(notificationChannel(), other.notificationChannel()) && Objects.equals(jobTag(), other.jobTag())
                && Objects.equals(filters(), other.filters()) && hasSegmentTypes() == other.hasSegmentTypes()
                && Objects.equals(segmentTypesAsStrings(), other.segmentTypesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StartSegmentDetectionRequest").add("Video", video())
                .add("ClientRequestToken", clientRequestToken()).add("NotificationChannel", notificationChannel())
                .add("JobTag", jobTag()).add("Filters", filters())
                .add("SegmentTypes", hasSegmentTypes() ? segmentTypesAsStrings() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Video":
            return Optional.ofNullable(clazz.cast(video()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "NotificationChannel":
            return Optional.ofNullable(clazz.cast(notificationChannel()));
        case "JobTag":
            return Optional.ofNullable(clazz.cast(jobTag()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "SegmentTypes":
            return Optional.ofNullable(clazz.cast(segmentTypesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartSegmentDetectionRequest, T> g) {
        return obj -> g.apply((StartSegmentDetectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartSegmentDetectionRequest> {
        /**
         * Sets the value of the Video property for this object.
         *
         * @param video
         *        The new value for the Video property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder video(Video video);

        /**
         * Sets the value of the Video property for this object.
         *
         * This is a convenience that creates an instance of the {@link Video.Builder} avoiding the need to create one
         * manually via {@link Video#builder()}.
         *
         * When the {@link Consumer} completes, {@link Video.Builder#build()} is called immediately and its result is
         * passed to {@link #video(Video)}.
         * 
         * @param video
         *        a consumer that will call methods on {@link Video.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #video(Video)
         */
        default Builder video(Consumer<Video.Builder> video) {
            return video(Video.builder().applyMutation(video).build());
        }

        /**
         * <p>
         * Idempotent token used to identify the start request. If you use the same token with multiple
         * <code>StartSegmentDetection</code> requests, the same <code>JobId</code> is returned. Use
         * <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once.
         * </p>
         * 
         * @param clientRequestToken
         *        Idempotent token used to identify the start request. If you use the same token with multiple
         *        <code>StartSegmentDetection</code> requests, the same <code>JobId</code> is returned. Use
         *        <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The ARN of the Amazon SNS topic to which you want Amazon Rekognition Video to publish the completion status
         * of the segment detection operation.
         * </p>
         * 
         * @param notificationChannel
         *        The ARN of the Amazon SNS topic to which you want Amazon Rekognition Video to publish the completion
         *        status of the segment detection operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationChannel(NotificationChannel notificationChannel);

        /**
         * <p>
         * The ARN of the Amazon SNS topic to which you want Amazon Rekognition Video to publish the completion status
         * of the segment detection operation.
         * </p>
         * This is a convenience that creates an instance of the {@link NotificationChannel.Builder} avoiding the need
         * to create one manually via {@link NotificationChannel#builder()}.
         *
         * When the {@link Consumer} completes, {@link NotificationChannel.Builder#build()} is called immediately and
         * its result is passed to {@link #notificationChannel(NotificationChannel)}.
         * 
         * @param notificationChannel
         *        a consumer that will call methods on {@link NotificationChannel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notificationChannel(NotificationChannel)
         */
        default Builder notificationChannel(Consumer<NotificationChannel.Builder> notificationChannel) {
            return notificationChannel(NotificationChannel.builder().applyMutation(notificationChannel).build());
        }

        /**
         * <p>
         * An identifier you specify that's returned in the completion notification that's published to your Amazon
         * Simple Notification Service topic. For example, you can use <code>JobTag</code> to group related jobs and
         * identify them in the completion notification.
         * </p>
         * 
         * @param jobTag
         *        An identifier you specify that's returned in the completion notification that's published to your
         *        Amazon Simple Notification Service topic. For example, you can use <code>JobTag</code> to group
         *        related jobs and identify them in the completion notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobTag(String jobTag);

        /**
         * <p>
         * Filters for technical cue or shot detection.
         * </p>
         * 
         * @param filters
         *        Filters for technical cue or shot detection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(StartSegmentDetectionFilters filters);

        /**
         * <p>
         * Filters for technical cue or shot detection.
         * </p>
         * This is a convenience that creates an instance of the {@link StartSegmentDetectionFilters.Builder} avoiding
         * the need to create one manually via {@link StartSegmentDetectionFilters#builder()}.
         *
         * When the {@link Consumer} completes, {@link StartSegmentDetectionFilters.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(StartSegmentDetectionFilters)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link StartSegmentDetectionFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(StartSegmentDetectionFilters)
         */
        default Builder filters(Consumer<StartSegmentDetectionFilters.Builder> filters) {
            return filters(StartSegmentDetectionFilters.builder().applyMutation(filters).build());
        }

        /**
         * <p>
         * An array of segment types to detect in the video. Valid values are TECHNICAL_CUE and SHOT.
         * </p>
         * 
         * @param segmentTypes
         *        An array of segment types to detect in the video. Valid values are TECHNICAL_CUE and SHOT.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentTypesWithStrings(Collection<String> segmentTypes);

        /**
         * <p>
         * An array of segment types to detect in the video. Valid values are TECHNICAL_CUE and SHOT.
         * </p>
         * 
         * @param segmentTypes
         *        An array of segment types to detect in the video. Valid values are TECHNICAL_CUE and SHOT.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentTypesWithStrings(String... segmentTypes);

        /**
         * <p>
         * An array of segment types to detect in the video. Valid values are TECHNICAL_CUE and SHOT.
         * </p>
         * 
         * @param segmentTypes
         *        An array of segment types to detect in the video. Valid values are TECHNICAL_CUE and SHOT.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentTypes(Collection<SegmentType> segmentTypes);

        /**
         * <p>
         * An array of segment types to detect in the video. Valid values are TECHNICAL_CUE and SHOT.
         * </p>
         * 
         * @param segmentTypes
         *        An array of segment types to detect in the video. Valid values are TECHNICAL_CUE and SHOT.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentTypes(SegmentType... segmentTypes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private Video video;

        private String clientRequestToken;

        private NotificationChannel notificationChannel;

        private String jobTag;

        private StartSegmentDetectionFilters filters;

        private List<String> segmentTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartSegmentDetectionRequest model) {
            super(model);
            video(model.video);
            clientRequestToken(model.clientRequestToken);
            notificationChannel(model.notificationChannel);
            jobTag(model.jobTag);
            filters(model.filters);
            segmentTypesWithStrings(model.segmentTypes);
        }

        public final Video.Builder getVideo() {
            return video != null ? video.toBuilder() : null;
        }

        @Override
        public final Builder video(Video video) {
            this.video = video;
            return this;
        }

        public final void setVideo(Video.BuilderImpl video) {
            this.video = video != null ? video.build() : null;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final NotificationChannel.Builder getNotificationChannel() {
            return notificationChannel != null ? notificationChannel.toBuilder() : null;
        }

        @Override
        public final Builder notificationChannel(NotificationChannel notificationChannel) {
            this.notificationChannel = notificationChannel;
            return this;
        }

        public final void setNotificationChannel(NotificationChannel.BuilderImpl notificationChannel) {
            this.notificationChannel = notificationChannel != null ? notificationChannel.build() : null;
        }

        public final String getJobTag() {
            return jobTag;
        }

        @Override
        public final Builder jobTag(String jobTag) {
            this.jobTag = jobTag;
            return this;
        }

        public final void setJobTag(String jobTag) {
            this.jobTag = jobTag;
        }

        public final StartSegmentDetectionFilters.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        @Override
        public final Builder filters(StartSegmentDetectionFilters filters) {
            this.filters = filters;
            return this;
        }

        public final void setFilters(StartSegmentDetectionFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        public final Collection<String> getSegmentTypes() {
            if (segmentTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return segmentTypes;
        }

        @Override
        public final Builder segmentTypesWithStrings(Collection<String> segmentTypes) {
            this.segmentTypes = SegmentTypesCopier.copy(segmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segmentTypesWithStrings(String... segmentTypes) {
            segmentTypesWithStrings(Arrays.asList(segmentTypes));
            return this;
        }

        @Override
        public final Builder segmentTypes(Collection<SegmentType> segmentTypes) {
            this.segmentTypes = SegmentTypesCopier.copyEnumToString(segmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segmentTypes(SegmentType... segmentTypes) {
            segmentTypes(Arrays.asList(segmentTypes));
            return this;
        }

        public final void setSegmentTypes(Collection<String> segmentTypes) {
            this.segmentTypes = SegmentTypesCopier.copy(segmentTypes);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartSegmentDetectionRequest build() {
            return new StartSegmentDetectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
