/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.FaceRecord;
import software.amazon.awssdk.services.rekognition.model.FaceRecordListCopier;
import software.amazon.awssdk.services.rekognition.model.OrientationCorrection;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.services.rekognition.model.UnindexedFace;
import software.amazon.awssdk.services.rekognition.model.UnindexedFacesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IndexFacesResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, IndexFacesResponse> {
    private static final SdkField<List<FaceRecord>> FACE_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FaceRecords").getter(IndexFacesResponse.getter(IndexFacesResponse::faceRecords)).setter(IndexFacesResponse.setter(Builder::faceRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceRecords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FaceRecord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ORIENTATION_CORRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrientationCorrection").getter(IndexFacesResponse.getter(IndexFacesResponse::orientationCorrectionAsString)).setter(IndexFacesResponse.setter(Builder::orientationCorrection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrientationCorrection").build()}).build();
    private static final SdkField<String> FACE_MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FaceModelVersion").getter(IndexFacesResponse.getter(IndexFacesResponse::faceModelVersion)).setter(IndexFacesResponse.setter(Builder::faceModelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceModelVersion").build()}).build();
    private static final SdkField<List<UnindexedFace>> UNINDEXED_FACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnindexedFaces").getter(IndexFacesResponse.getter(IndexFacesResponse::unindexedFaces)).setter(IndexFacesResponse.setter(Builder::unindexedFaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnindexedFaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UnindexedFace::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FACE_RECORDS_FIELD, ORIENTATION_CORRECTION_FIELD, FACE_MODEL_VERSION_FIELD, UNINDEXED_FACES_FIELD));
    private final List<FaceRecord> faceRecords;
    private final String orientationCorrection;
    private final String faceModelVersion;
    private final List<UnindexedFace> unindexedFaces;

    private IndexFacesResponse(BuilderImpl builder) {
        super(builder);
        this.faceRecords = builder.faceRecords;
        this.orientationCorrection = builder.orientationCorrection;
        this.faceModelVersion = builder.faceModelVersion;
        this.unindexedFaces = builder.unindexedFaces;
    }

    public boolean hasFaceRecords() {
        return this.faceRecords != null && !(this.faceRecords instanceof SdkAutoConstructList);
    }

    public List<FaceRecord> faceRecords() {
        return this.faceRecords;
    }

    public OrientationCorrection orientationCorrection() {
        return OrientationCorrection.fromValue(this.orientationCorrection);
    }

    public String orientationCorrectionAsString() {
        return this.orientationCorrection;
    }

    public String faceModelVersion() {
        return this.faceModelVersion;
    }

    public boolean hasUnindexedFaces() {
        return this.unindexedFaces != null && !(this.unindexedFaces instanceof SdkAutoConstructList);
    }

    public List<UnindexedFace> unindexedFaces() {
        return this.unindexedFaces;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFaceRecords() ? this.faceRecords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.orientationCorrectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.faceModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnindexedFaces() ? this.unindexedFaces() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexFacesResponse)) {
            return false;
        }
        IndexFacesResponse other = (IndexFacesResponse)((Object)obj);
        return this.hasFaceRecords() == other.hasFaceRecords() && Objects.equals(this.faceRecords(), other.faceRecords()) && Objects.equals(this.orientationCorrectionAsString(), other.orientationCorrectionAsString()) && Objects.equals(this.faceModelVersion(), other.faceModelVersion()) && this.hasUnindexedFaces() == other.hasUnindexedFaces() && Objects.equals(this.unindexedFaces(), other.unindexedFaces());
    }

    public String toString() {
        return ToString.builder((String)"IndexFacesResponse").add("FaceRecords", this.hasFaceRecords() ? this.faceRecords() : null).add("OrientationCorrection", (Object)this.orientationCorrectionAsString()).add("FaceModelVersion", (Object)this.faceModelVersion()).add("UnindexedFaces", this.hasUnindexedFaces() ? this.unindexedFaces() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FaceRecords": {
                return Optional.ofNullable(clazz.cast(this.faceRecords()));
            }
            case "OrientationCorrection": {
                return Optional.ofNullable(clazz.cast(this.orientationCorrectionAsString()));
            }
            case "FaceModelVersion": {
                return Optional.ofNullable(clazz.cast(this.faceModelVersion()));
            }
            case "UnindexedFaces": {
                return Optional.ofNullable(clazz.cast(this.unindexedFaces()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IndexFacesResponse, T> g) {
        return obj -> g.apply((IndexFacesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private List<FaceRecord> faceRecords = DefaultSdkAutoConstructList.getInstance();
        private String orientationCorrection;
        private String faceModelVersion;
        private List<UnindexedFace> unindexedFaces = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IndexFacesResponse model) {
            super(model);
            this.faceRecords(model.faceRecords);
            this.orientationCorrection(model.orientationCorrection);
            this.faceModelVersion(model.faceModelVersion);
            this.unindexedFaces(model.unindexedFaces);
        }

        public final Collection<FaceRecord.Builder> getFaceRecords() {
            if (this.faceRecords instanceof SdkAutoConstructList) {
                return null;
            }
            return this.faceRecords != null ? (Collection)this.faceRecords.stream().map(FaceRecord::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder faceRecords(Collection<FaceRecord> faceRecords) {
            this.faceRecords = FaceRecordListCopier.copy(faceRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceRecords(FaceRecord ... faceRecords) {
            this.faceRecords(Arrays.asList(faceRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceRecords(Consumer<FaceRecord.Builder> ... faceRecords) {
            this.faceRecords(Stream.of(faceRecords).map(c -> (FaceRecord)((FaceRecord.Builder)FaceRecord.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFaceRecords(Collection<FaceRecord.BuilderImpl> faceRecords) {
            this.faceRecords = FaceRecordListCopier.copyFromBuilder(faceRecords);
        }

        public final String getOrientationCorrection() {
            return this.orientationCorrection;
        }

        @Override
        public final Builder orientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
            return this;
        }

        @Override
        public final Builder orientationCorrection(OrientationCorrection orientationCorrection) {
            this.orientationCorrection(orientationCorrection == null ? null : orientationCorrection.toString());
            return this;
        }

        public final void setOrientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
        }

        public final String getFaceModelVersion() {
            return this.faceModelVersion;
        }

        @Override
        public final Builder faceModelVersion(String faceModelVersion) {
            this.faceModelVersion = faceModelVersion;
            return this;
        }

        public final void setFaceModelVersion(String faceModelVersion) {
            this.faceModelVersion = faceModelVersion;
        }

        public final Collection<UnindexedFace.Builder> getUnindexedFaces() {
            if (this.unindexedFaces instanceof SdkAutoConstructList) {
                return null;
            }
            return this.unindexedFaces != null ? (Collection)this.unindexedFaces.stream().map(UnindexedFace::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder unindexedFaces(Collection<UnindexedFace> unindexedFaces) {
            this.unindexedFaces = UnindexedFacesCopier.copy(unindexedFaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unindexedFaces(UnindexedFace ... unindexedFaces) {
            this.unindexedFaces(Arrays.asList(unindexedFaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unindexedFaces(Consumer<UnindexedFace.Builder> ... unindexedFaces) {
            this.unindexedFaces(Stream.of(unindexedFaces).map(c -> (UnindexedFace)((UnindexedFace.Builder)UnindexedFace.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUnindexedFaces(Collection<UnindexedFace.BuilderImpl> unindexedFaces) {
            this.unindexedFaces = UnindexedFacesCopier.copyFromBuilder(unindexedFaces);
        }

        @Override
        public IndexFacesResponse build() {
            return new IndexFacesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, IndexFacesResponse> {
        public Builder faceRecords(Collection<FaceRecord> var1);

        public Builder faceRecords(FaceRecord ... var1);

        public Builder faceRecords(Consumer<FaceRecord.Builder> ... var1);

        public Builder orientationCorrection(String var1);

        public Builder orientationCorrection(OrientationCorrection var1);

        public Builder faceModelVersion(String var1);

        public Builder unindexedFaces(Collection<UnindexedFace> var1);

        public Builder unindexedFaces(UnindexedFace ... var1);

        public Builder unindexedFaces(Consumer<UnindexedFace.Builder> ... var1);
    }
}

