/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about text detected in a video. Incudes the detected text, the time in milliseconds from the start of the
 * video that the text was detected, and where it was detected on the screen.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TextDetectionResult implements SdkPojo, Serializable,
        ToCopyableBuilder<TextDetectionResult.Builder, TextDetectionResult> {
    private static final SdkField<Long> TIMESTAMP_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Timestamp")
            .getter(getter(TextDetectionResult::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final SdkField<TextDetection> TEXT_DETECTION_FIELD = SdkField
            .<TextDetection> builder(MarshallingType.SDK_POJO).memberName("TextDetection")
            .getter(getter(TextDetectionResult::textDetection)).setter(setter(Builder::textDetection))
            .constructor(TextDetection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextDetection").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD,
            TEXT_DETECTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long timestamp;

    private final TextDetection textDetection;

    private TextDetectionResult(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.textDetection = builder.textDetection;
    }

    /**
     * <p>
     * The time, in milliseconds from the start of the video, that the text was detected.
     * </p>
     * 
     * @return The time, in milliseconds from the start of the video, that the text was detected.
     */
    public final Long timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * Details about text detected in a video.
     * </p>
     * 
     * @return Details about text detected in a video.
     */
    public final TextDetection textDetection() {
        return textDetection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(textDetection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextDetectionResult)) {
            return false;
        }
        TextDetectionResult other = (TextDetectionResult) obj;
        return Objects.equals(timestamp(), other.timestamp()) && Objects.equals(textDetection(), other.textDetection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TextDetectionResult").add("Timestamp", timestamp()).add("TextDetection", textDetection())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "TextDetection":
            return Optional.ofNullable(clazz.cast(textDetection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TextDetectionResult, T> g) {
        return obj -> g.apply((TextDetectionResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TextDetectionResult> {
        /**
         * <p>
         * The time, in milliseconds from the start of the video, that the text was detected.
         * </p>
         * 
         * @param timestamp
         *        The time, in milliseconds from the start of the video, that the text was detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Long timestamp);

        /**
         * <p>
         * Details about text detected in a video.
         * </p>
         * 
         * @param textDetection
         *        Details about text detected in a video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textDetection(TextDetection textDetection);

        /**
         * <p>
         * Details about text detected in a video.
         * </p>
         * This is a convenience that creates an instance of the {@link TextDetection.Builder} avoiding the need to
         * create one manually via {@link TextDetection#builder()}.
         *
         * When the {@link Consumer} completes, {@link TextDetection.Builder#build()} is called immediately and its
         * result is passed to {@link #textDetection(TextDetection)}.
         * 
         * @param textDetection
         *        a consumer that will call methods on {@link TextDetection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textDetection(TextDetection)
         */
        default Builder textDetection(Consumer<TextDetection.Builder> textDetection) {
            return textDetection(TextDetection.builder().applyMutation(textDetection).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Long timestamp;

        private TextDetection textDetection;

        private BuilderImpl() {
        }

        private BuilderImpl(TextDetectionResult model) {
            timestamp(model.timestamp);
            textDetection(model.textDetection);
        }

        public final Long getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        public final TextDetection.Builder getTextDetection() {
            return textDetection != null ? textDetection.toBuilder() : null;
        }

        @Override
        public final Builder textDetection(TextDetection textDetection) {
            this.textDetection = textDetection;
            return this;
        }

        public final void setTextDetection(TextDetection.BuilderImpl textDetection) {
            this.textDetection = textDetection != null ? textDetection.build() : null;
        }

        @Override
        public TextDetectionResult build() {
            return new TextDetectionResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
