/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteProjectVersionRequest extends RekognitionRequest implements
        ToCopyableBuilder<DeleteProjectVersionRequest.Builder, DeleteProjectVersionRequest> {
    private static final SdkField<String> PROJECT_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectVersionArn").getter(getter(DeleteProjectVersionRequest::projectVersionArn))
            .setter(setter(Builder::projectVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectVersionArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_VERSION_ARN_FIELD));

    private final String projectVersionArn;

    private DeleteProjectVersionRequest(BuilderImpl builder) {
        super(builder);
        this.projectVersionArn = builder.projectVersionArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the model version that you want to delete.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the model version that you want to delete.
     */
    public String projectVersionArn() {
        return projectVersionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectVersionArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteProjectVersionRequest)) {
            return false;
        }
        DeleteProjectVersionRequest other = (DeleteProjectVersionRequest) obj;
        return Objects.equals(projectVersionArn(), other.projectVersionArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteProjectVersionRequest").add("ProjectVersionArn", projectVersionArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProjectVersionArn":
            return Optional.ofNullable(clazz.cast(projectVersionArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteProjectVersionRequest, T> g) {
        return obj -> g.apply((DeleteProjectVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteProjectVersionRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the model version that you want to delete.
         * </p>
         * 
         * @param projectVersionArn
         *        The Amazon Resource Name (ARN) of the model version that you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectVersionArn(String projectVersionArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private String projectVersionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteProjectVersionRequest model) {
            super(model);
            projectVersionArn(model.projectVersionArn);
        }

        public final String getProjectVersionArn() {
            return projectVersionArn;
        }

        @Override
        public final Builder projectVersionArn(String projectVersionArn) {
            this.projectVersionArn = projectVersionArn;
            return this;
        }

        public final void setProjectVersionArn(String projectVersionArn) {
            this.projectVersionArn = projectVersionArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteProjectVersionRequest build() {
            return new DeleteProjectVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
