/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The dataset used for training.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrainingData implements SdkPojo, Serializable, ToCopyableBuilder<TrainingData.Builder, TrainingData> {
    private static final SdkField<List<Asset>> ASSETS_FIELD = SdkField
            .<List<Asset>> builder(MarshallingType.LIST)
            .memberName("Assets")
            .getter(getter(TrainingData::assets))
            .setter(setter(Builder::assets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Assets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Asset> builder(MarshallingType.SDK_POJO)
                                            .constructor(Asset::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSETS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Asset> assets;

    private TrainingData(BuilderImpl builder) {
        this.assets = builder.assets;
    }

    /**
     * Returns true if the Assets property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAssets() {
        return assets != null && !(assets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A Sagemaker GroundTruth manifest file that contains the training images (assets).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAssets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A Sagemaker GroundTruth manifest file that contains the training images (assets).
     */
    public final List<Asset> assets() {
        return assets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAssets() ? assets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainingData)) {
            return false;
        }
        TrainingData other = (TrainingData) obj;
        return hasAssets() == other.hasAssets() && Objects.equals(assets(), other.assets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrainingData").add("Assets", hasAssets() ? assets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Assets":
            return Optional.ofNullable(clazz.cast(assets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrainingData, T> g) {
        return obj -> g.apply((TrainingData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrainingData> {
        /**
         * <p>
         * A Sagemaker GroundTruth manifest file that contains the training images (assets).
         * </p>
         * 
         * @param assets
         *        A Sagemaker GroundTruth manifest file that contains the training images (assets).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assets(Collection<Asset> assets);

        /**
         * <p>
         * A Sagemaker GroundTruth manifest file that contains the training images (assets).
         * </p>
         * 
         * @param assets
         *        A Sagemaker GroundTruth manifest file that contains the training images (assets).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assets(Asset... assets);

        /**
         * <p>
         * A Sagemaker GroundTruth manifest file that contains the training images (assets).
         * </p>
         * This is a convenience that creates an instance of the {@link List<Asset>.Builder} avoiding the need to create
         * one manually via {@link List<Asset>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Asset>.Builder#build()} is called immediately and its result
         * is passed to {@link #assets(List<Asset>)}.
         * 
         * @param assets
         *        a consumer that will call methods on {@link List<Asset>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assets(List<Asset>)
         */
        Builder assets(Consumer<Asset.Builder>... assets);
    }

    static final class BuilderImpl implements Builder {
        private List<Asset> assets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TrainingData model) {
            assets(model.assets);
        }

        public final Collection<Asset.Builder> getAssets() {
            if (assets instanceof SdkAutoConstructList) {
                return null;
            }
            return assets != null ? assets.stream().map(Asset::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder assets(Collection<Asset> assets) {
            this.assets = AssetsCopier.copy(assets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assets(Asset... assets) {
            assets(Arrays.asList(assets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assets(Consumer<Asset.Builder>... assets) {
            assets(Stream.of(assets).map(c -> Asset.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAssets(Collection<Asset.BuilderImpl> assets) {
            this.assets = AssetsCopier.copyFromBuilder(assets);
        }

        @Override
        public TrainingData build() {
            return new TrainingData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
