/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecognizeCelebritiesResponse extends RekognitionResponse implements
        ToCopyableBuilder<RecognizeCelebritiesResponse.Builder, RecognizeCelebritiesResponse> {
    private static final SdkField<List<Celebrity>> CELEBRITY_FACES_FIELD = SdkField
            .<List<Celebrity>> builder(MarshallingType.LIST)
            .memberName("CelebrityFaces")
            .getter(getter(RecognizeCelebritiesResponse::celebrityFaces))
            .setter(setter(Builder::celebrityFaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CelebrityFaces").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Celebrity> builder(MarshallingType.SDK_POJO)
                                            .constructor(Celebrity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ComparedFace>> UNRECOGNIZED_FACES_FIELD = SdkField
            .<List<ComparedFace>> builder(MarshallingType.LIST)
            .memberName("UnrecognizedFaces")
            .getter(getter(RecognizeCelebritiesResponse::unrecognizedFaces))
            .setter(setter(Builder::unrecognizedFaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnrecognizedFaces").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ComparedFace> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComparedFace::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ORIENTATION_CORRECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrientationCorrection").getter(getter(RecognizeCelebritiesResponse::orientationCorrectionAsString))
            .setter(setter(Builder::orientationCorrection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrientationCorrection").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CELEBRITY_FACES_FIELD,
            UNRECOGNIZED_FACES_FIELD, ORIENTATION_CORRECTION_FIELD));

    private final List<Celebrity> celebrityFaces;

    private final List<ComparedFace> unrecognizedFaces;

    private final String orientationCorrection;

    private RecognizeCelebritiesResponse(BuilderImpl builder) {
        super(builder);
        this.celebrityFaces = builder.celebrityFaces;
        this.unrecognizedFaces = builder.unrecognizedFaces;
        this.orientationCorrection = builder.orientationCorrection;
    }

    /**
     * Returns true if the CelebrityFaces property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasCelebrityFaces() {
        return celebrityFaces != null && !(celebrityFaces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details about each celebrity found in the image. Amazon Rekognition can detect a maximum of 64 celebrities in an
     * image.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCelebrityFaces()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Details about each celebrity found in the image. Amazon Rekognition can detect a maximum of 64
     *         celebrities in an image.
     */
    public final List<Celebrity> celebrityFaces() {
        return celebrityFaces;
    }

    /**
     * Returns true if the UnrecognizedFaces property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasUnrecognizedFaces() {
        return unrecognizedFaces != null && !(unrecognizedFaces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details about each unrecognized face in the image.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUnrecognizedFaces()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Details about each unrecognized face in the image.
     */
    public final List<ComparedFace> unrecognizedFaces() {
        return unrecognizedFaces;
    }

    /**
     * <p>
     * The orientation of the input image (counterclockwise direction). If your application displays the image, you can
     * use this value to correct the orientation. The bounding box coordinates returned in <code>CelebrityFaces</code>
     * and <code>UnrecognizedFaces</code> represent face locations before the image orientation is corrected.
     * </p>
     * <note>
     * <p>
     * If the input image is in .jpeg format, it might contain exchangeable image (Exif) metadata that includes the
     * image's orientation. If so, and the Exif metadata for the input image populates the orientation field, the value
     * of <code>OrientationCorrection</code> is null. The <code>CelebrityFaces</code> and <code>UnrecognizedFaces</code>
     * bounding box coordinates represent face locations after Exif metadata is used to correct the image orientation.
     * Images in .png format don't contain Exif metadata.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #orientationCorrection} will return {@link OrientationCorrection#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #orientationCorrectionAsString}.
     * </p>
     * 
     * @return The orientation of the input image (counterclockwise direction). If your application displays the image,
     *         you can use this value to correct the orientation. The bounding box coordinates returned in
     *         <code>CelebrityFaces</code> and <code>UnrecognizedFaces</code> represent face locations before the image
     *         orientation is corrected. </p> <note>
     *         <p>
     *         If the input image is in .jpeg format, it might contain exchangeable image (Exif) metadata that includes
     *         the image's orientation. If so, and the Exif metadata for the input image populates the orientation
     *         field, the value of <code>OrientationCorrection</code> is null. The <code>CelebrityFaces</code> and
     *         <code>UnrecognizedFaces</code> bounding box coordinates represent face locations after Exif metadata is
     *         used to correct the image orientation. Images in .png format don't contain Exif metadata.
     *         </p>
     * @see OrientationCorrection
     */
    public final OrientationCorrection orientationCorrection() {
        return OrientationCorrection.fromValue(orientationCorrection);
    }

    /**
     * <p>
     * The orientation of the input image (counterclockwise direction). If your application displays the image, you can
     * use this value to correct the orientation. The bounding box coordinates returned in <code>CelebrityFaces</code>
     * and <code>UnrecognizedFaces</code> represent face locations before the image orientation is corrected.
     * </p>
     * <note>
     * <p>
     * If the input image is in .jpeg format, it might contain exchangeable image (Exif) metadata that includes the
     * image's orientation. If so, and the Exif metadata for the input image populates the orientation field, the value
     * of <code>OrientationCorrection</code> is null. The <code>CelebrityFaces</code> and <code>UnrecognizedFaces</code>
     * bounding box coordinates represent face locations after Exif metadata is used to correct the image orientation.
     * Images in .png format don't contain Exif metadata.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #orientationCorrection} will return {@link OrientationCorrection#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #orientationCorrectionAsString}.
     * </p>
     * 
     * @return The orientation of the input image (counterclockwise direction). If your application displays the image,
     *         you can use this value to correct the orientation. The bounding box coordinates returned in
     *         <code>CelebrityFaces</code> and <code>UnrecognizedFaces</code> represent face locations before the image
     *         orientation is corrected. </p> <note>
     *         <p>
     *         If the input image is in .jpeg format, it might contain exchangeable image (Exif) metadata that includes
     *         the image's orientation. If so, and the Exif metadata for the input image populates the orientation
     *         field, the value of <code>OrientationCorrection</code> is null. The <code>CelebrityFaces</code> and
     *         <code>UnrecognizedFaces</code> bounding box coordinates represent face locations after Exif metadata is
     *         used to correct the image orientation. Images in .png format don't contain Exif metadata.
     *         </p>
     * @see OrientationCorrection
     */
    public final String orientationCorrectionAsString() {
        return orientationCorrection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCelebrityFaces() ? celebrityFaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUnrecognizedFaces() ? unrecognizedFaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(orientationCorrectionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecognizeCelebritiesResponse)) {
            return false;
        }
        RecognizeCelebritiesResponse other = (RecognizeCelebritiesResponse) obj;
        return hasCelebrityFaces() == other.hasCelebrityFaces() && Objects.equals(celebrityFaces(), other.celebrityFaces())
                && hasUnrecognizedFaces() == other.hasUnrecognizedFaces()
                && Objects.equals(unrecognizedFaces(), other.unrecognizedFaces())
                && Objects.equals(orientationCorrectionAsString(), other.orientationCorrectionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecognizeCelebritiesResponse")
                .add("CelebrityFaces", hasCelebrityFaces() ? celebrityFaces() : null)
                .add("UnrecognizedFaces", hasUnrecognizedFaces() ? unrecognizedFaces() : null)
                .add("OrientationCorrection", orientationCorrectionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CelebrityFaces":
            return Optional.ofNullable(clazz.cast(celebrityFaces()));
        case "UnrecognizedFaces":
            return Optional.ofNullable(clazz.cast(unrecognizedFaces()));
        case "OrientationCorrection":
            return Optional.ofNullable(clazz.cast(orientationCorrectionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecognizeCelebritiesResponse, T> g) {
        return obj -> g.apply((RecognizeCelebritiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionResponse.Builder, SdkPojo, CopyableBuilder<Builder, RecognizeCelebritiesResponse> {
        /**
         * <p>
         * Details about each celebrity found in the image. Amazon Rekognition can detect a maximum of 64 celebrities in
         * an image.
         * </p>
         * 
         * @param celebrityFaces
         *        Details about each celebrity found in the image. Amazon Rekognition can detect a maximum of 64
         *        celebrities in an image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder celebrityFaces(Collection<Celebrity> celebrityFaces);

        /**
         * <p>
         * Details about each celebrity found in the image. Amazon Rekognition can detect a maximum of 64 celebrities in
         * an image.
         * </p>
         * 
         * @param celebrityFaces
         *        Details about each celebrity found in the image. Amazon Rekognition can detect a maximum of 64
         *        celebrities in an image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder celebrityFaces(Celebrity... celebrityFaces);

        /**
         * <p>
         * Details about each celebrity found in the image. Amazon Rekognition can detect a maximum of 64 celebrities in
         * an image.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Celebrity>.Builder} avoiding the need to
         * create one manually via {@link List<Celebrity>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Celebrity>.Builder#build()} is called immediately and its
         * result is passed to {@link #celebrityFaces(List<Celebrity>)}.
         * 
         * @param celebrityFaces
         *        a consumer that will call methods on {@link List<Celebrity>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #celebrityFaces(List<Celebrity>)
         */
        Builder celebrityFaces(Consumer<Celebrity.Builder>... celebrityFaces);

        /**
         * <p>
         * Details about each unrecognized face in the image.
         * </p>
         * 
         * @param unrecognizedFaces
         *        Details about each unrecognized face in the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unrecognizedFaces(Collection<ComparedFace> unrecognizedFaces);

        /**
         * <p>
         * Details about each unrecognized face in the image.
         * </p>
         * 
         * @param unrecognizedFaces
         *        Details about each unrecognized face in the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unrecognizedFaces(ComparedFace... unrecognizedFaces);

        /**
         * <p>
         * Details about each unrecognized face in the image.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ComparedFace>.Builder} avoiding the need to
         * create one manually via {@link List<ComparedFace>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ComparedFace>.Builder#build()} is called immediately and its
         * result is passed to {@link #unrecognizedFaces(List<ComparedFace>)}.
         * 
         * @param unrecognizedFaces
         *        a consumer that will call methods on {@link List<ComparedFace>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unrecognizedFaces(List<ComparedFace>)
         */
        Builder unrecognizedFaces(Consumer<ComparedFace.Builder>... unrecognizedFaces);

        /**
         * <p>
         * The orientation of the input image (counterclockwise direction). If your application displays the image, you
         * can use this value to correct the orientation. The bounding box coordinates returned in
         * <code>CelebrityFaces</code> and <code>UnrecognizedFaces</code> represent face locations before the image
         * orientation is corrected.
         * </p>
         * <note>
         * <p>
         * If the input image is in .jpeg format, it might contain exchangeable image (Exif) metadata that includes the
         * image's orientation. If so, and the Exif metadata for the input image populates the orientation field, the
         * value of <code>OrientationCorrection</code> is null. The <code>CelebrityFaces</code> and
         * <code>UnrecognizedFaces</code> bounding box coordinates represent face locations after Exif metadata is used
         * to correct the image orientation. Images in .png format don't contain Exif metadata.
         * </p>
         * </note>
         * 
         * @param orientationCorrection
         *        The orientation of the input image (counterclockwise direction). If your application displays the
         *        image, you can use this value to correct the orientation. The bounding box coordinates returned in
         *        <code>CelebrityFaces</code> and <code>UnrecognizedFaces</code> represent face locations before the
         *        image orientation is corrected. </p> <note>
         *        <p>
         *        If the input image is in .jpeg format, it might contain exchangeable image (Exif) metadata that
         *        includes the image's orientation. If so, and the Exif metadata for the input image populates the
         *        orientation field, the value of <code>OrientationCorrection</code> is null. The
         *        <code>CelebrityFaces</code> and <code>UnrecognizedFaces</code> bounding box coordinates represent face
         *        locations after Exif metadata is used to correct the image orientation. Images in .png format don't
         *        contain Exif metadata.
         *        </p>
         * @see OrientationCorrection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrientationCorrection
         */
        Builder orientationCorrection(String orientationCorrection);

        /**
         * <p>
         * The orientation of the input image (counterclockwise direction). If your application displays the image, you
         * can use this value to correct the orientation. The bounding box coordinates returned in
         * <code>CelebrityFaces</code> and <code>UnrecognizedFaces</code> represent face locations before the image
         * orientation is corrected.
         * </p>
         * <note>
         * <p>
         * If the input image is in .jpeg format, it might contain exchangeable image (Exif) metadata that includes the
         * image's orientation. If so, and the Exif metadata for the input image populates the orientation field, the
         * value of <code>OrientationCorrection</code> is null. The <code>CelebrityFaces</code> and
         * <code>UnrecognizedFaces</code> bounding box coordinates represent face locations after Exif metadata is used
         * to correct the image orientation. Images in .png format don't contain Exif metadata.
         * </p>
         * </note>
         * 
         * @param orientationCorrection
         *        The orientation of the input image (counterclockwise direction). If your application displays the
         *        image, you can use this value to correct the orientation. The bounding box coordinates returned in
         *        <code>CelebrityFaces</code> and <code>UnrecognizedFaces</code> represent face locations before the
         *        image orientation is corrected. </p> <note>
         *        <p>
         *        If the input image is in .jpeg format, it might contain exchangeable image (Exif) metadata that
         *        includes the image's orientation. If so, and the Exif metadata for the input image populates the
         *        orientation field, the value of <code>OrientationCorrection</code> is null. The
         *        <code>CelebrityFaces</code> and <code>UnrecognizedFaces</code> bounding box coordinates represent face
         *        locations after Exif metadata is used to correct the image orientation. Images in .png format don't
         *        contain Exif metadata.
         *        </p>
         * @see OrientationCorrection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrientationCorrection
         */
        Builder orientationCorrection(OrientationCorrection orientationCorrection);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private List<Celebrity> celebrityFaces = DefaultSdkAutoConstructList.getInstance();

        private List<ComparedFace> unrecognizedFaces = DefaultSdkAutoConstructList.getInstance();

        private String orientationCorrection;

        private BuilderImpl() {
        }

        private BuilderImpl(RecognizeCelebritiesResponse model) {
            super(model);
            celebrityFaces(model.celebrityFaces);
            unrecognizedFaces(model.unrecognizedFaces);
            orientationCorrection(model.orientationCorrection);
        }

        public final List<Celebrity.Builder> getCelebrityFaces() {
            List<Celebrity.Builder> result = CelebrityListCopier.copyToBuilder(this.celebrityFaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder celebrityFaces(Collection<Celebrity> celebrityFaces) {
            this.celebrityFaces = CelebrityListCopier.copy(celebrityFaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder celebrityFaces(Celebrity... celebrityFaces) {
            celebrityFaces(Arrays.asList(celebrityFaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder celebrityFaces(Consumer<Celebrity.Builder>... celebrityFaces) {
            celebrityFaces(Stream.of(celebrityFaces).map(c -> Celebrity.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCelebrityFaces(Collection<Celebrity.BuilderImpl> celebrityFaces) {
            this.celebrityFaces = CelebrityListCopier.copyFromBuilder(celebrityFaces);
        }

        public final List<ComparedFace.Builder> getUnrecognizedFaces() {
            List<ComparedFace.Builder> result = ComparedFaceListCopier.copyToBuilder(this.unrecognizedFaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder unrecognizedFaces(Collection<ComparedFace> unrecognizedFaces) {
            this.unrecognizedFaces = ComparedFaceListCopier.copy(unrecognizedFaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unrecognizedFaces(ComparedFace... unrecognizedFaces) {
            unrecognizedFaces(Arrays.asList(unrecognizedFaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unrecognizedFaces(Consumer<ComparedFace.Builder>... unrecognizedFaces) {
            unrecognizedFaces(Stream.of(unrecognizedFaces).map(c -> ComparedFace.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUnrecognizedFaces(Collection<ComparedFace.BuilderImpl> unrecognizedFaces) {
            this.unrecognizedFaces = ComparedFaceListCopier.copyFromBuilder(unrecognizedFaces);
        }

        public final String getOrientationCorrection() {
            return orientationCorrection;
        }

        @Override
        public final Builder orientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
            return this;
        }

        @Override
        public final Builder orientationCorrection(OrientationCorrection orientationCorrection) {
            this.orientationCorrection(orientationCorrection == null ? null : orientationCorrection.toString());
            return this;
        }

        public final void setOrientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
        }

        @Override
        public RecognizeCelebritiesResponse build() {
            return new RecognizeCelebritiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
