/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.BoundingBox;
import software.amazon.awssdk.services.rekognition.model.CoversBodyPart;
import software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EquipmentDetection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EquipmentDetection> {
    private static final SdkField<BoundingBox> BOUNDING_BOX_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BoundingBox").getter(EquipmentDetection.getter(EquipmentDetection::boundingBox)).setter(EquipmentDetection.setter(Builder::boundingBox)).constructor(BoundingBox::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoundingBox").build()}).build();
    private static final SdkField<Float> CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Confidence").getter(EquipmentDetection.getter(EquipmentDetection::confidence)).setter(EquipmentDetection.setter(Builder::confidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(EquipmentDetection.getter(EquipmentDetection::typeAsString)).setter(EquipmentDetection.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<CoversBodyPart> COVERS_BODY_PART_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CoversBodyPart").getter(EquipmentDetection.getter(EquipmentDetection::coversBodyPart)).setter(EquipmentDetection.setter(Builder::coversBodyPart)).constructor(CoversBodyPart::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoversBodyPart").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOUNDING_BOX_FIELD, CONFIDENCE_FIELD, TYPE_FIELD, COVERS_BODY_PART_FIELD));
    private static final long serialVersionUID = 1L;
    private final BoundingBox boundingBox;
    private final Float confidence;
    private final String type;
    private final CoversBodyPart coversBodyPart;

    private EquipmentDetection(BuilderImpl builder) {
        this.boundingBox = builder.boundingBox;
        this.confidence = builder.confidence;
        this.type = builder.type;
        this.coversBodyPart = builder.coversBodyPart;
    }

    public final BoundingBox boundingBox() {
        return this.boundingBox;
    }

    public final Float confidence() {
        return this.confidence;
    }

    public final ProtectiveEquipmentType type() {
        return ProtectiveEquipmentType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final CoversBodyPart coversBodyPart() {
        return this.coversBodyPart;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.boundingBox());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.coversBodyPart());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EquipmentDetection)) {
            return false;
        }
        EquipmentDetection other = (EquipmentDetection)obj;
        return Objects.equals(this.boundingBox(), other.boundingBox()) && Objects.equals(this.confidence(), other.confidence()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.coversBodyPart(), other.coversBodyPart());
    }

    public final String toString() {
        return ToString.builder((String)"EquipmentDetection").add("BoundingBox", (Object)this.boundingBox()).add("Confidence", (Object)this.confidence()).add("Type", (Object)this.typeAsString()).add("CoversBodyPart", (Object)this.coversBodyPart()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BoundingBox": {
                return Optional.ofNullable(clazz.cast(this.boundingBox()));
            }
            case "Confidence": {
                return Optional.ofNullable(clazz.cast(this.confidence()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "CoversBodyPart": {
                return Optional.ofNullable(clazz.cast(this.coversBodyPart()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EquipmentDetection, T> g) {
        return obj -> g.apply((EquipmentDetection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private BoundingBox boundingBox;
        private Float confidence;
        private String type;
        private CoversBodyPart coversBodyPart;

        private BuilderImpl() {
        }

        private BuilderImpl(EquipmentDetection model) {
            this.boundingBox(model.boundingBox);
            this.confidence(model.confidence);
            this.type(model.type);
            this.coversBodyPart(model.coversBodyPart);
        }

        public final BoundingBox.Builder getBoundingBox() {
            return this.boundingBox != null ? this.boundingBox.toBuilder() : null;
        }

        @Override
        public final Builder boundingBox(BoundingBox boundingBox) {
            this.boundingBox = boundingBox;
            return this;
        }

        public final void setBoundingBox(BoundingBox.BuilderImpl boundingBox) {
            this.boundingBox = boundingBox != null ? boundingBox.build() : null;
        }

        public final Float getConfidence() {
            return this.confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ProtectiveEquipmentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final CoversBodyPart.Builder getCoversBodyPart() {
            return this.coversBodyPart != null ? this.coversBodyPart.toBuilder() : null;
        }

        @Override
        public final Builder coversBodyPart(CoversBodyPart coversBodyPart) {
            this.coversBodyPart = coversBodyPart;
            return this;
        }

        public final void setCoversBodyPart(CoversBodyPart.BuilderImpl coversBodyPart) {
            this.coversBodyPart = coversBodyPart != null ? coversBodyPart.build() : null;
        }

        public EquipmentDetection build() {
            return new EquipmentDetection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EquipmentDetection> {
        public Builder boundingBox(BoundingBox var1);

        default public Builder boundingBox(Consumer<BoundingBox.Builder> boundingBox) {
            return this.boundingBox((BoundingBox)((BoundingBox.Builder)BoundingBox.builder().applyMutation(boundingBox)).build());
        }

        public Builder confidence(Float var1);

        public Builder type(String var1);

        public Builder type(ProtectiveEquipmentType var1);

        public Builder coversBodyPart(CoversBodyPart var1);

        default public Builder coversBodyPart(Consumer<CoversBodyPart.Builder> coversBodyPart) {
            return this.coversBodyPart((CoversBodyPart)((CoversBodyPart.Builder)CoversBodyPart.builder().applyMutation(coversBodyPart)).build());
        }
    }
}

