/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.BoundingBox;
import software.amazon.awssdk.services.rekognition.model.FaceMatch;
import software.amazon.awssdk.services.rekognition.model.FaceMatchListCopier;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchFacesByImageResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, SearchFacesByImageResponse> {
    private static final SdkField<BoundingBox> SEARCHED_FACE_BOUNDING_BOX_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SearchedFaceBoundingBox").getter(SearchFacesByImageResponse.getter(SearchFacesByImageResponse::searchedFaceBoundingBox)).setter(SearchFacesByImageResponse.setter(Builder::searchedFaceBoundingBox)).constructor(BoundingBox::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchedFaceBoundingBox").build()}).build();
    private static final SdkField<Float> SEARCHED_FACE_CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("SearchedFaceConfidence").getter(SearchFacesByImageResponse.getter(SearchFacesByImageResponse::searchedFaceConfidence)).setter(SearchFacesByImageResponse.setter(Builder::searchedFaceConfidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchedFaceConfidence").build()}).build();
    private static final SdkField<List<FaceMatch>> FACE_MATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FaceMatches").getter(SearchFacesByImageResponse.getter(SearchFacesByImageResponse::faceMatches)).setter(SearchFacesByImageResponse.setter(Builder::faceMatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceMatches").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FaceMatch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FACE_MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FaceModelVersion").getter(SearchFacesByImageResponse.getter(SearchFacesByImageResponse::faceModelVersion)).setter(SearchFacesByImageResponse.setter(Builder::faceModelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceModelVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEARCHED_FACE_BOUNDING_BOX_FIELD, SEARCHED_FACE_CONFIDENCE_FIELD, FACE_MATCHES_FIELD, FACE_MODEL_VERSION_FIELD));
    private final BoundingBox searchedFaceBoundingBox;
    private final Float searchedFaceConfidence;
    private final List<FaceMatch> faceMatches;
    private final String faceModelVersion;

    private SearchFacesByImageResponse(BuilderImpl builder) {
        super(builder);
        this.searchedFaceBoundingBox = builder.searchedFaceBoundingBox;
        this.searchedFaceConfidence = builder.searchedFaceConfidence;
        this.faceMatches = builder.faceMatches;
        this.faceModelVersion = builder.faceModelVersion;
    }

    public final BoundingBox searchedFaceBoundingBox() {
        return this.searchedFaceBoundingBox;
    }

    public final Float searchedFaceConfidence() {
        return this.searchedFaceConfidence;
    }

    public final boolean hasFaceMatches() {
        return this.faceMatches != null && !(this.faceMatches instanceof SdkAutoConstructList);
    }

    public final List<FaceMatch> faceMatches() {
        return this.faceMatches;
    }

    public final String faceModelVersion() {
        return this.faceModelVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.searchedFaceBoundingBox());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchedFaceConfidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFaceMatches() ? this.faceMatches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.faceModelVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchFacesByImageResponse)) {
            return false;
        }
        SearchFacesByImageResponse other = (SearchFacesByImageResponse)((Object)obj);
        return Objects.equals(this.searchedFaceBoundingBox(), other.searchedFaceBoundingBox()) && Objects.equals(this.searchedFaceConfidence(), other.searchedFaceConfidence()) && this.hasFaceMatches() == other.hasFaceMatches() && Objects.equals(this.faceMatches(), other.faceMatches()) && Objects.equals(this.faceModelVersion(), other.faceModelVersion());
    }

    public final String toString() {
        return ToString.builder((String)"SearchFacesByImageResponse").add("SearchedFaceBoundingBox", (Object)this.searchedFaceBoundingBox()).add("SearchedFaceConfidence", (Object)this.searchedFaceConfidence()).add("FaceMatches", this.hasFaceMatches() ? this.faceMatches() : null).add("FaceModelVersion", (Object)this.faceModelVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SearchedFaceBoundingBox": {
                return Optional.ofNullable(clazz.cast(this.searchedFaceBoundingBox()));
            }
            case "SearchedFaceConfidence": {
                return Optional.ofNullable(clazz.cast(this.searchedFaceConfidence()));
            }
            case "FaceMatches": {
                return Optional.ofNullable(clazz.cast(this.faceMatches()));
            }
            case "FaceModelVersion": {
                return Optional.ofNullable(clazz.cast(this.faceModelVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchFacesByImageResponse, T> g) {
        return obj -> g.apply((SearchFacesByImageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private BoundingBox searchedFaceBoundingBox;
        private Float searchedFaceConfidence;
        private List<FaceMatch> faceMatches = DefaultSdkAutoConstructList.getInstance();
        private String faceModelVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchFacesByImageResponse model) {
            super(model);
            this.searchedFaceBoundingBox(model.searchedFaceBoundingBox);
            this.searchedFaceConfidence(model.searchedFaceConfidence);
            this.faceMatches(model.faceMatches);
            this.faceModelVersion(model.faceModelVersion);
        }

        public final BoundingBox.Builder getSearchedFaceBoundingBox() {
            return this.searchedFaceBoundingBox != null ? this.searchedFaceBoundingBox.toBuilder() : null;
        }

        public final void setSearchedFaceBoundingBox(BoundingBox.BuilderImpl searchedFaceBoundingBox) {
            this.searchedFaceBoundingBox = searchedFaceBoundingBox != null ? searchedFaceBoundingBox.build() : null;
        }

        @Override
        @Transient
        public final Builder searchedFaceBoundingBox(BoundingBox searchedFaceBoundingBox) {
            this.searchedFaceBoundingBox = searchedFaceBoundingBox;
            return this;
        }

        public final Float getSearchedFaceConfidence() {
            return this.searchedFaceConfidence;
        }

        public final void setSearchedFaceConfidence(Float searchedFaceConfidence) {
            this.searchedFaceConfidence = searchedFaceConfidence;
        }

        @Override
        @Transient
        public final Builder searchedFaceConfidence(Float searchedFaceConfidence) {
            this.searchedFaceConfidence = searchedFaceConfidence;
            return this;
        }

        public final List<FaceMatch.Builder> getFaceMatches() {
            List<FaceMatch.Builder> result = FaceMatchListCopier.copyToBuilder(this.faceMatches);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFaceMatches(Collection<FaceMatch.BuilderImpl> faceMatches) {
            this.faceMatches = FaceMatchListCopier.copyFromBuilder(faceMatches);
        }

        @Override
        @Transient
        public final Builder faceMatches(Collection<FaceMatch> faceMatches) {
            this.faceMatches = FaceMatchListCopier.copy(faceMatches);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder faceMatches(FaceMatch ... faceMatches) {
            this.faceMatches(Arrays.asList(faceMatches));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder faceMatches(Consumer<FaceMatch.Builder> ... faceMatches) {
            this.faceMatches(Stream.of(faceMatches).map(c -> (FaceMatch)((FaceMatch.Builder)FaceMatch.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getFaceModelVersion() {
            return this.faceModelVersion;
        }

        public final void setFaceModelVersion(String faceModelVersion) {
            this.faceModelVersion = faceModelVersion;
        }

        @Override
        @Transient
        public final Builder faceModelVersion(String faceModelVersion) {
            this.faceModelVersion = faceModelVersion;
            return this;
        }

        @Override
        public SearchFacesByImageResponse build() {
            return new SearchFacesByImageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchFacesByImageResponse> {
        public Builder searchedFaceBoundingBox(BoundingBox var1);

        default public Builder searchedFaceBoundingBox(Consumer<BoundingBox.Builder> searchedFaceBoundingBox) {
            return this.searchedFaceBoundingBox((BoundingBox)((BoundingBox.Builder)BoundingBox.builder().applyMutation(searchedFaceBoundingBox)).build());
        }

        public Builder searchedFaceConfidence(Float var1);

        public Builder faceMatches(Collection<FaceMatch> var1);

        public Builder faceMatches(FaceMatch ... var1);

        public Builder faceMatches(Consumer<FaceMatch.Builder> ... var1);

        public Builder faceModelVersion(String var1);
    }
}

