/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchFacesResponse extends RekognitionResponse implements
        ToCopyableBuilder<SearchFacesResponse.Builder, SearchFacesResponse> {
    private static final SdkField<String> SEARCHED_FACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SearchedFaceId").getter(getter(SearchFacesResponse::searchedFaceId))
            .setter(setter(Builder::searchedFaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchedFaceId").build()).build();

    private static final SdkField<List<FaceMatch>> FACE_MATCHES_FIELD = SdkField
            .<List<FaceMatch>> builder(MarshallingType.LIST)
            .memberName("FaceMatches")
            .getter(getter(SearchFacesResponse::faceMatches))
            .setter(setter(Builder::faceMatches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceMatches").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FaceMatch> builder(MarshallingType.SDK_POJO)
                                            .constructor(FaceMatch::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FACE_MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FaceModelVersion").getter(getter(SearchFacesResponse::faceModelVersion))
            .setter(setter(Builder::faceModelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceModelVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEARCHED_FACE_ID_FIELD,
            FACE_MATCHES_FIELD, FACE_MODEL_VERSION_FIELD));

    private final String searchedFaceId;

    private final List<FaceMatch> faceMatches;

    private final String faceModelVersion;

    private SearchFacesResponse(BuilderImpl builder) {
        super(builder);
        this.searchedFaceId = builder.searchedFaceId;
        this.faceMatches = builder.faceMatches;
        this.faceModelVersion = builder.faceModelVersion;
    }

    /**
     * <p>
     * ID of the face that was searched for matches in a collection.
     * </p>
     * 
     * @return ID of the face that was searched for matches in a collection.
     */
    public final String searchedFaceId() {
        return searchedFaceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the FaceMatches property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFaceMatches() {
        return faceMatches != null && !(faceMatches instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of faces that matched the input face, along with the confidence in the match.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFaceMatches} method.
     * </p>
     * 
     * @return An array of faces that matched the input face, along with the confidence in the match.
     */
    public final List<FaceMatch> faceMatches() {
        return faceMatches;
    }

    /**
     * <p>
     * Latest face model being used with the collection. For more information, see <a
     * href="https://docs.aws.amazon.com/rekognition/latest/dg/face-detection-model.html">Model versioning</a>.
     * </p>
     * 
     * @return Latest face model being used with the collection. For more information, see <a
     *         href="https://docs.aws.amazon.com/rekognition/latest/dg/face-detection-model.html">Model versioning</a>.
     */
    public final String faceModelVersion() {
        return faceModelVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(searchedFaceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasFaceMatches() ? faceMatches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(faceModelVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchFacesResponse)) {
            return false;
        }
        SearchFacesResponse other = (SearchFacesResponse) obj;
        return Objects.equals(searchedFaceId(), other.searchedFaceId()) && hasFaceMatches() == other.hasFaceMatches()
                && Objects.equals(faceMatches(), other.faceMatches())
                && Objects.equals(faceModelVersion(), other.faceModelVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchFacesResponse").add("SearchedFaceId", searchedFaceId())
                .add("FaceMatches", hasFaceMatches() ? faceMatches() : null).add("FaceModelVersion", faceModelVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SearchedFaceId":
            return Optional.ofNullable(clazz.cast(searchedFaceId()));
        case "FaceMatches":
            return Optional.ofNullable(clazz.cast(faceMatches()));
        case "FaceModelVersion":
            return Optional.ofNullable(clazz.cast(faceModelVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchFacesResponse, T> g) {
        return obj -> g.apply((SearchFacesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionResponse.Builder, SdkPojo, CopyableBuilder<Builder, SearchFacesResponse> {
        /**
         * <p>
         * ID of the face that was searched for matches in a collection.
         * </p>
         * 
         * @param searchedFaceId
         *        ID of the face that was searched for matches in a collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchedFaceId(String searchedFaceId);

        /**
         * <p>
         * An array of faces that matched the input face, along with the confidence in the match.
         * </p>
         * 
         * @param faceMatches
         *        An array of faces that matched the input face, along with the confidence in the match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceMatches(Collection<FaceMatch> faceMatches);

        /**
         * <p>
         * An array of faces that matched the input face, along with the confidence in the match.
         * </p>
         * 
         * @param faceMatches
         *        An array of faces that matched the input face, along with the confidence in the match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceMatches(FaceMatch... faceMatches);

        /**
         * <p>
         * An array of faces that matched the input face, along with the confidence in the match.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FaceMatch>.Builder} avoiding the need to
         * create one manually via {@link List<FaceMatch>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FaceMatch>.Builder#build()} is called immediately and its
         * result is passed to {@link #faceMatches(List<FaceMatch>)}.
         * 
         * @param faceMatches
         *        a consumer that will call methods on {@link List<FaceMatch>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #faceMatches(List<FaceMatch>)
         */
        Builder faceMatches(Consumer<FaceMatch.Builder>... faceMatches);

        /**
         * <p>
         * Latest face model being used with the collection. For more information, see <a
         * href="https://docs.aws.amazon.com/rekognition/latest/dg/face-detection-model.html">Model versioning</a>.
         * </p>
         * 
         * @param faceModelVersion
         *        Latest face model being used with the collection. For more information, see <a
         *        href="https://docs.aws.amazon.com/rekognition/latest/dg/face-detection-model.html">Model
         *        versioning</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceModelVersion(String faceModelVersion);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private String searchedFaceId;

        private List<FaceMatch> faceMatches = DefaultSdkAutoConstructList.getInstance();

        private String faceModelVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchFacesResponse model) {
            super(model);
            searchedFaceId(model.searchedFaceId);
            faceMatches(model.faceMatches);
            faceModelVersion(model.faceModelVersion);
        }

        public final String getSearchedFaceId() {
            return searchedFaceId;
        }

        public final void setSearchedFaceId(String searchedFaceId) {
            this.searchedFaceId = searchedFaceId;
        }

        @Override
        @Transient
        public final Builder searchedFaceId(String searchedFaceId) {
            this.searchedFaceId = searchedFaceId;
            return this;
        }

        public final List<FaceMatch.Builder> getFaceMatches() {
            List<FaceMatch.Builder> result = FaceMatchListCopier.copyToBuilder(this.faceMatches);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFaceMatches(Collection<FaceMatch.BuilderImpl> faceMatches) {
            this.faceMatches = FaceMatchListCopier.copyFromBuilder(faceMatches);
        }

        @Override
        @Transient
        public final Builder faceMatches(Collection<FaceMatch> faceMatches) {
            this.faceMatches = FaceMatchListCopier.copy(faceMatches);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder faceMatches(FaceMatch... faceMatches) {
            faceMatches(Arrays.asList(faceMatches));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder faceMatches(Consumer<FaceMatch.Builder>... faceMatches) {
            faceMatches(Stream.of(faceMatches).map(c -> FaceMatch.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getFaceModelVersion() {
            return faceModelVersion;
        }

        public final void setFaceModelVersion(String faceModelVersion) {
            this.faceModelVersion = faceModelVersion;
        }

        @Override
        @Transient
        public final Builder faceModelVersion(String faceModelVersion) {
            this.faceModelVersion = faceModelVersion;
            return this;
        }

        @Override
        public SearchFacesResponse build() {
            return new SearchFacesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
