/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class PersonMatchesCopier {
    static List<PersonMatch> copy(Collection<? extends PersonMatch> personMatchesParam) {
        List<PersonMatch> list;
        if (personMatchesParam == null || personMatchesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<PersonMatch> modifiableList = new ArrayList<>();
            personMatchesParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<PersonMatch> copyFromBuilder(Collection<? extends PersonMatch.Builder> personMatchesParam) {
        List<PersonMatch> list;
        if (personMatchesParam == null || personMatchesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<PersonMatch> modifiableList = new ArrayList<>();
            personMatchesParam.forEach(entry -> {
                PersonMatch member = entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<PersonMatch.Builder> copyToBuilder(Collection<? extends PersonMatch> personMatchesParam) {
        List<PersonMatch.Builder> list;
        if (personMatchesParam == null || personMatchesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<PersonMatch.Builder> modifiableList = new ArrayList<>();
            personMatchesParam.forEach(entry -> {
                PersonMatch.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
