/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class PersonDetectionsCopier {
    static List<PersonDetection> copy(Collection<? extends PersonDetection> personDetectionsParam) {
        List<PersonDetection> list;
        if (personDetectionsParam == null || personDetectionsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<PersonDetection> modifiableList = new ArrayList<>();
            personDetectionsParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<PersonDetection> copyFromBuilder(Collection<? extends PersonDetection.Builder> personDetectionsParam) {
        List<PersonDetection> list;
        if (personDetectionsParam == null || personDetectionsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<PersonDetection> modifiableList = new ArrayList<>();
            personDetectionsParam.forEach(entry -> {
                PersonDetection member = entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<PersonDetection.Builder> copyToBuilder(Collection<? extends PersonDetection> personDetectionsParam) {
        List<PersonDetection.Builder> list;
        if (personDetectionsParam == null || personDetectionsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<PersonDetection.Builder> modifiableList = new ArrayList<>();
            personDetectionsParam.forEach(entry -> {
                PersonDetection.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
