/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class IndexFacesRequest extends RekognitionRequest implements
        ToCopyableBuilder<IndexFacesRequest.Builder, IndexFacesRequest> {
    private static final SdkField<String> COLLECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CollectionId").getter(getter(IndexFacesRequest::collectionId)).setter(setter(Builder::collectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionId").build()).build();

    private static final SdkField<Image> IMAGE_FIELD = SdkField.<Image> builder(MarshallingType.SDK_POJO).memberName("Image")
            .getter(getter(IndexFacesRequest::image)).setter(setter(Builder::image)).constructor(Image::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Image").build()).build();

    private static final SdkField<String> EXTERNAL_IMAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExternalImageId").getter(getter(IndexFacesRequest::externalImageId))
            .setter(setter(Builder::externalImageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalImageId").build()).build();

    private static final SdkField<List<String>> DETECTION_ATTRIBUTES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DetectionAttributes")
            .getter(getter(IndexFacesRequest::detectionAttributesAsStrings))
            .setter(setter(Builder::detectionAttributesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetectionAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_FACES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxFaces").getter(getter(IndexFacesRequest::maxFaces)).setter(setter(Builder::maxFaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxFaces").build()).build();

    private static final SdkField<String> QUALITY_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QualityFilter").getter(getter(IndexFacesRequest::qualityFilterAsString))
            .setter(setter(Builder::qualityFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QualityFilter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_ID_FIELD,
            IMAGE_FIELD, EXTERNAL_IMAGE_ID_FIELD, DETECTION_ATTRIBUTES_FIELD, MAX_FACES_FIELD, QUALITY_FILTER_FIELD));

    private final String collectionId;

    private final Image image;

    private final String externalImageId;

    private final List<String> detectionAttributes;

    private final Integer maxFaces;

    private final String qualityFilter;

    private IndexFacesRequest(BuilderImpl builder) {
        super(builder);
        this.collectionId = builder.collectionId;
        this.image = builder.image;
        this.externalImageId = builder.externalImageId;
        this.detectionAttributes = builder.detectionAttributes;
        this.maxFaces = builder.maxFaces;
        this.qualityFilter = builder.qualityFilter;
    }

    /**
     * <p>
     * The ID of an existing collection to which you want to add the faces that are detected in the input images.
     * </p>
     * 
     * @return The ID of an existing collection to which you want to add the faces that are detected in the input
     *         images.
     */
    public final String collectionId() {
        return collectionId;
    }

    /**
     * <p>
     * The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition
     * operations, passing base64-encoded image bytes isn't supported.
     * </p>
     * <p>
     * If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed
     * using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition developer guide.
     * </p>
     * 
     * @return The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon
     *         Rekognition operations, passing base64-encoded image bytes isn't supported. </p>
     *         <p>
     *         If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes
     *         passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition
     *         developer guide.
     */
    public final Image image() {
        return image;
    }

    /**
     * <p>
     * The ID you want to assign to all the faces detected in the image.
     * </p>
     * 
     * @return The ID you want to assign to all the faces detected in the image.
     */
    public final String externalImageId() {
        return externalImageId;
    }

    /**
     * <p>
     * An array of facial attributes that you want to be returned. This can be the default list of attributes or all
     * attributes. If you don't specify a value for <code>Attributes</code> or if you specify <code>["DEFAULT"]</code>,
     * the API returns the following subset of facial attributes: <code>BoundingBox</code>, <code>Confidence</code>,
     * <code>Pose</code>, <code>Quality</code>, and <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all
     * facial attributes are returned, but the operation takes longer to complete.
     * </p>
     * <p>
     * If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to determine which
     * attributes to return (in this case, all attributes).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDetectionAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of facial attributes that you want to be returned. This can be the default list of attributes or
     *         all attributes. If you don't specify a value for <code>Attributes</code> or if you specify
     *         <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes:
     *         <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code>, and
     *         <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all facial attributes are returned, but the
     *         operation takes longer to complete.</p>
     *         <p>
     *         If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to
     *         determine which attributes to return (in this case, all attributes).
     */
    public final List<Attribute> detectionAttributes() {
        return AttributesCopier.copyStringToEnum(detectionAttributes);
    }

    /**
     * Returns true if the DetectionAttributes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasDetectionAttributes() {
        return detectionAttributes != null && !(detectionAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of facial attributes that you want to be returned. This can be the default list of attributes or all
     * attributes. If you don't specify a value for <code>Attributes</code> or if you specify <code>["DEFAULT"]</code>,
     * the API returns the following subset of facial attributes: <code>BoundingBox</code>, <code>Confidence</code>,
     * <code>Pose</code>, <code>Quality</code>, and <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all
     * facial attributes are returned, but the operation takes longer to complete.
     * </p>
     * <p>
     * If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to determine which
     * attributes to return (in this case, all attributes).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDetectionAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of facial attributes that you want to be returned. This can be the default list of attributes or
     *         all attributes. If you don't specify a value for <code>Attributes</code> or if you specify
     *         <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes:
     *         <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code>, and
     *         <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all facial attributes are returned, but the
     *         operation takes longer to complete.</p>
     *         <p>
     *         If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to
     *         determine which attributes to return (in this case, all attributes).
     */
    public final List<String> detectionAttributesAsStrings() {
        return detectionAttributes;
    }

    /**
     * <p>
     * The maximum number of faces to index. The value of <code>MaxFaces</code> must be greater than or equal to 1.
     * <code>IndexFaces</code> returns no more than 100 detected faces in an image, even if you specify a larger value
     * for <code>MaxFaces</code>.
     * </p>
     * <p>
     * If <code>IndexFaces</code> detects more faces than the value of <code>MaxFaces</code>, the faces with the lowest
     * quality are filtered out first. If there are still more faces than the value of <code>MaxFaces</code>, the faces
     * with the smallest bounding boxes are filtered out (up to the number that's needed to satisfy the value of
     * <code>MaxFaces</code>). Information about the unindexed faces is available in the <code>UnindexedFaces</code>
     * array.
     * </p>
     * <p>
     * The faces that are returned by <code>IndexFaces</code> are sorted by the largest face bounding box size to the
     * smallest size, in descending order.
     * </p>
     * <p>
     * <code>MaxFaces</code> can be used with a collection associated with any version of the face model.
     * </p>
     * 
     * @return The maximum number of faces to index. The value of <code>MaxFaces</code> must be greater than or equal to
     *         1. <code>IndexFaces</code> returns no more than 100 detected faces in an image, even if you specify a
     *         larger value for <code>MaxFaces</code>.</p>
     *         <p>
     *         If <code>IndexFaces</code> detects more faces than the value of <code>MaxFaces</code>, the faces with the
     *         lowest quality are filtered out first. If there are still more faces than the value of
     *         <code>MaxFaces</code>, the faces with the smallest bounding boxes are filtered out (up to the number
     *         that's needed to satisfy the value of <code>MaxFaces</code>). Information about the unindexed faces is
     *         available in the <code>UnindexedFaces</code> array.
     *         </p>
     *         <p>
     *         The faces that are returned by <code>IndexFaces</code> are sorted by the largest face bounding box size
     *         to the smallest size, in descending order.
     *         </p>
     *         <p>
     *         <code>MaxFaces</code> can be used with a collection associated with any version of the face model.
     */
    public final Integer maxFaces() {
        return maxFaces;
    }

    /**
     * <p>
     * A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces aren't
     * indexed. If you specify <code>AUTO</code>, Amazon Rekognition chooses the quality bar. If you specify
     * <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>, filtering removes all faces that don’t meet the
     * chosen quality bar. The default value is <code>AUTO</code>. The quality bar is based on a variety of common use
     * cases. Low-quality detections can occur for a number of reasons. Some examples are an object that's misidentified
     * as a face, a face that's too blurry, or a face with a pose that's too extreme to use. If you specify
     * <code>NONE</code>, no filtering is performed.
     * </p>
     * <p>
     * To use quality filtering, the collection you are using must be associated with version 3 of the face model or
     * higher.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #qualityFilter}
     * will return {@link QualityFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #qualityFilterAsString}.
     * </p>
     * 
     * @return A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces
     *         aren't indexed. If you specify <code>AUTO</code>, Amazon Rekognition chooses the quality bar. If you
     *         specify <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>, filtering removes all faces that
     *         don’t meet the chosen quality bar. The default value is <code>AUTO</code>. The quality bar is based on a
     *         variety of common use cases. Low-quality detections can occur for a number of reasons. Some examples are
     *         an object that's misidentified as a face, a face that's too blurry, or a face with a pose that's too
     *         extreme to use. If you specify <code>NONE</code>, no filtering is performed. </p>
     *         <p>
     *         To use quality filtering, the collection you are using must be associated with version 3 of the face
     *         model or higher.
     * @see QualityFilter
     */
    public final QualityFilter qualityFilter() {
        return QualityFilter.fromValue(qualityFilter);
    }

    /**
     * <p>
     * A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces aren't
     * indexed. If you specify <code>AUTO</code>, Amazon Rekognition chooses the quality bar. If you specify
     * <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>, filtering removes all faces that don’t meet the
     * chosen quality bar. The default value is <code>AUTO</code>. The quality bar is based on a variety of common use
     * cases. Low-quality detections can occur for a number of reasons. Some examples are an object that's misidentified
     * as a face, a face that's too blurry, or a face with a pose that's too extreme to use. If you specify
     * <code>NONE</code>, no filtering is performed.
     * </p>
     * <p>
     * To use quality filtering, the collection you are using must be associated with version 3 of the face model or
     * higher.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #qualityFilter}
     * will return {@link QualityFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #qualityFilterAsString}.
     * </p>
     * 
     * @return A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces
     *         aren't indexed. If you specify <code>AUTO</code>, Amazon Rekognition chooses the quality bar. If you
     *         specify <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>, filtering removes all faces that
     *         don’t meet the chosen quality bar. The default value is <code>AUTO</code>. The quality bar is based on a
     *         variety of common use cases. Low-quality detections can occur for a number of reasons. Some examples are
     *         an object that's misidentified as a face, a face that's too blurry, or a face with a pose that's too
     *         extreme to use. If you specify <code>NONE</code>, no filtering is performed. </p>
     *         <p>
     *         To use quality filtering, the collection you are using must be associated with version 3 of the face
     *         model or higher.
     * @see QualityFilter
     */
    public final String qualityFilterAsString() {
        return qualityFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(collectionId());
        hashCode = 31 * hashCode + Objects.hashCode(image());
        hashCode = 31 * hashCode + Objects.hashCode(externalImageId());
        hashCode = 31 * hashCode + Objects.hashCode(hasDetectionAttributes() ? detectionAttributesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxFaces());
        hashCode = 31 * hashCode + Objects.hashCode(qualityFilterAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexFacesRequest)) {
            return false;
        }
        IndexFacesRequest other = (IndexFacesRequest) obj;
        return Objects.equals(collectionId(), other.collectionId()) && Objects.equals(image(), other.image())
                && Objects.equals(externalImageId(), other.externalImageId())
                && hasDetectionAttributes() == other.hasDetectionAttributes()
                && Objects.equals(detectionAttributesAsStrings(), other.detectionAttributesAsStrings())
                && Objects.equals(maxFaces(), other.maxFaces())
                && Objects.equals(qualityFilterAsString(), other.qualityFilterAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IndexFacesRequest").add("CollectionId", collectionId()).add("Image", image())
                .add("ExternalImageId", externalImageId())
                .add("DetectionAttributes", hasDetectionAttributes() ? detectionAttributesAsStrings() : null)
                .add("MaxFaces", maxFaces()).add("QualityFilter", qualityFilterAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CollectionId":
            return Optional.ofNullable(clazz.cast(collectionId()));
        case "Image":
            return Optional.ofNullable(clazz.cast(image()));
        case "ExternalImageId":
            return Optional.ofNullable(clazz.cast(externalImageId()));
        case "DetectionAttributes":
            return Optional.ofNullable(clazz.cast(detectionAttributesAsStrings()));
        case "MaxFaces":
            return Optional.ofNullable(clazz.cast(maxFaces()));
        case "QualityFilter":
            return Optional.ofNullable(clazz.cast(qualityFilterAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IndexFacesRequest, T> g) {
        return obj -> g.apply((IndexFacesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionRequest.Builder, SdkPojo, CopyableBuilder<Builder, IndexFacesRequest> {
        /**
         * <p>
         * The ID of an existing collection to which you want to add the faces that are detected in the input images.
         * </p>
         * 
         * @param collectionId
         *        The ID of an existing collection to which you want to add the faces that are detected in the input
         *        images.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionId(String collectionId);

        /**
         * <p>
         * The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition
         * operations, passing base64-encoded image bytes isn't supported.
         * </p>
         * <p>
         * If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes
         * passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition
         * developer guide.
         * </p>
         * 
         * @param image
         *        The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon
         *        Rekognition operations, passing base64-encoded image bytes isn't supported. </p>
         *        <p>
         *        If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image
         *        bytes passed using the <code>Bytes</code> field. For more information, see Images in the Amazon
         *        Rekognition developer guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(Image image);

        /**
         * <p>
         * The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition
         * operations, passing base64-encoded image bytes isn't supported.
         * </p>
         * <p>
         * If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes
         * passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition
         * developer guide.
         * </p>
         * This is a convenience that creates an instance of the {@link Image.Builder} avoiding the need to create one
         * manually via {@link Image#builder()}.
         *
         * When the {@link Consumer} completes, {@link Image.Builder#build()} is called immediately and its result is
         * passed to {@link #image(Image)}.
         * 
         * @param image
         *        a consumer that will call methods on {@link Image.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #image(Image)
         */
        default Builder image(Consumer<Image.Builder> image) {
            return image(Image.builder().applyMutation(image).build());
        }

        /**
         * <p>
         * The ID you want to assign to all the faces detected in the image.
         * </p>
         * 
         * @param externalImageId
         *        The ID you want to assign to all the faces detected in the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalImageId(String externalImageId);

        /**
         * <p>
         * An array of facial attributes that you want to be returned. This can be the default list of attributes or all
         * attributes. If you don't specify a value for <code>Attributes</code> or if you specify
         * <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes: <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code>, and <code>Landmarks</code>. If you
         * provide <code>["ALL"]</code>, all facial attributes are returned, but the operation takes longer to complete.
         * </p>
         * <p>
         * If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to determine
         * which attributes to return (in this case, all attributes).
         * </p>
         * 
         * @param detectionAttributes
         *        An array of facial attributes that you want to be returned. This can be the default list of attributes
         *        or all attributes. If you don't specify a value for <code>Attributes</code> or if you specify
         *        <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes:
         *        <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code>, and
         *        <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all facial attributes are returned, but
         *        the operation takes longer to complete.</p>
         *        <p>
         *        If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to
         *        determine which attributes to return (in this case, all attributes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectionAttributesWithStrings(Collection<String> detectionAttributes);

        /**
         * <p>
         * An array of facial attributes that you want to be returned. This can be the default list of attributes or all
         * attributes. If you don't specify a value for <code>Attributes</code> or if you specify
         * <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes: <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code>, and <code>Landmarks</code>. If you
         * provide <code>["ALL"]</code>, all facial attributes are returned, but the operation takes longer to complete.
         * </p>
         * <p>
         * If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to determine
         * which attributes to return (in this case, all attributes).
         * </p>
         * 
         * @param detectionAttributes
         *        An array of facial attributes that you want to be returned. This can be the default list of attributes
         *        or all attributes. If you don't specify a value for <code>Attributes</code> or if you specify
         *        <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes:
         *        <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code>, and
         *        <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all facial attributes are returned, but
         *        the operation takes longer to complete.</p>
         *        <p>
         *        If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to
         *        determine which attributes to return (in this case, all attributes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectionAttributesWithStrings(String... detectionAttributes);

        /**
         * <p>
         * An array of facial attributes that you want to be returned. This can be the default list of attributes or all
         * attributes. If you don't specify a value for <code>Attributes</code> or if you specify
         * <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes: <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code>, and <code>Landmarks</code>. If you
         * provide <code>["ALL"]</code>, all facial attributes are returned, but the operation takes longer to complete.
         * </p>
         * <p>
         * If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to determine
         * which attributes to return (in this case, all attributes).
         * </p>
         * 
         * @param detectionAttributes
         *        An array of facial attributes that you want to be returned. This can be the default list of attributes
         *        or all attributes. If you don't specify a value for <code>Attributes</code> or if you specify
         *        <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes:
         *        <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code>, and
         *        <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all facial attributes are returned, but
         *        the operation takes longer to complete.</p>
         *        <p>
         *        If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to
         *        determine which attributes to return (in this case, all attributes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectionAttributes(Collection<Attribute> detectionAttributes);

        /**
         * <p>
         * An array of facial attributes that you want to be returned. This can be the default list of attributes or all
         * attributes. If you don't specify a value for <code>Attributes</code> or if you specify
         * <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes: <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code>, and <code>Landmarks</code>. If you
         * provide <code>["ALL"]</code>, all facial attributes are returned, but the operation takes longer to complete.
         * </p>
         * <p>
         * If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to determine
         * which attributes to return (in this case, all attributes).
         * </p>
         * 
         * @param detectionAttributes
         *        An array of facial attributes that you want to be returned. This can be the default list of attributes
         *        or all attributes. If you don't specify a value for <code>Attributes</code> or if you specify
         *        <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes:
         *        <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code>, and
         *        <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all facial attributes are returned, but
         *        the operation takes longer to complete.</p>
         *        <p>
         *        If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to
         *        determine which attributes to return (in this case, all attributes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectionAttributes(Attribute... detectionAttributes);

        /**
         * <p>
         * The maximum number of faces to index. The value of <code>MaxFaces</code> must be greater than or equal to 1.
         * <code>IndexFaces</code> returns no more than 100 detected faces in an image, even if you specify a larger
         * value for <code>MaxFaces</code>.
         * </p>
         * <p>
         * If <code>IndexFaces</code> detects more faces than the value of <code>MaxFaces</code>, the faces with the
         * lowest quality are filtered out first. If there are still more faces than the value of <code>MaxFaces</code>,
         * the faces with the smallest bounding boxes are filtered out (up to the number that's needed to satisfy the
         * value of <code>MaxFaces</code>). Information about the unindexed faces is available in the
         * <code>UnindexedFaces</code> array.
         * </p>
         * <p>
         * The faces that are returned by <code>IndexFaces</code> are sorted by the largest face bounding box size to
         * the smallest size, in descending order.
         * </p>
         * <p>
         * <code>MaxFaces</code> can be used with a collection associated with any version of the face model.
         * </p>
         * 
         * @param maxFaces
         *        The maximum number of faces to index. The value of <code>MaxFaces</code> must be greater than or equal
         *        to 1. <code>IndexFaces</code> returns no more than 100 detected faces in an image, even if you specify
         *        a larger value for <code>MaxFaces</code>.</p>
         *        <p>
         *        If <code>IndexFaces</code> detects more faces than the value of <code>MaxFaces</code>, the faces with
         *        the lowest quality are filtered out first. If there are still more faces than the value of
         *        <code>MaxFaces</code>, the faces with the smallest bounding boxes are filtered out (up to the number
         *        that's needed to satisfy the value of <code>MaxFaces</code>). Information about the unindexed faces is
         *        available in the <code>UnindexedFaces</code> array.
         *        </p>
         *        <p>
         *        The faces that are returned by <code>IndexFaces</code> are sorted by the largest face bounding box
         *        size to the smallest size, in descending order.
         *        </p>
         *        <p>
         *        <code>MaxFaces</code> can be used with a collection associated with any version of the face model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxFaces(Integer maxFaces);

        /**
         * <p>
         * A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces aren't
         * indexed. If you specify <code>AUTO</code>, Amazon Rekognition chooses the quality bar. If you specify
         * <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>, filtering removes all faces that don’t meet the
         * chosen quality bar. The default value is <code>AUTO</code>. The quality bar is based on a variety of common
         * use cases. Low-quality detections can occur for a number of reasons. Some examples are an object that's
         * misidentified as a face, a face that's too blurry, or a face with a pose that's too extreme to use. If you
         * specify <code>NONE</code>, no filtering is performed.
         * </p>
         * <p>
         * To use quality filtering, the collection you are using must be associated with version 3 of the face model or
         * higher.
         * </p>
         * 
         * @param qualityFilter
         *        A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces
         *        aren't indexed. If you specify <code>AUTO</code>, Amazon Rekognition chooses the quality bar. If you
         *        specify <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>, filtering removes all faces that
         *        don’t meet the chosen quality bar. The default value is <code>AUTO</code>. The quality bar is based on
         *        a variety of common use cases. Low-quality detections can occur for a number of reasons. Some examples
         *        are an object that's misidentified as a face, a face that's too blurry, or a face with a pose that's
         *        too extreme to use. If you specify <code>NONE</code>, no filtering is performed. </p>
         *        <p>
         *        To use quality filtering, the collection you are using must be associated with version 3 of the face
         *        model or higher.
         * @see QualityFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QualityFilter
         */
        Builder qualityFilter(String qualityFilter);

        /**
         * <p>
         * A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces aren't
         * indexed. If you specify <code>AUTO</code>, Amazon Rekognition chooses the quality bar. If you specify
         * <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>, filtering removes all faces that don’t meet the
         * chosen quality bar. The default value is <code>AUTO</code>. The quality bar is based on a variety of common
         * use cases. Low-quality detections can occur for a number of reasons. Some examples are an object that's
         * misidentified as a face, a face that's too blurry, or a face with a pose that's too extreme to use. If you
         * specify <code>NONE</code>, no filtering is performed.
         * </p>
         * <p>
         * To use quality filtering, the collection you are using must be associated with version 3 of the face model or
         * higher.
         * </p>
         * 
         * @param qualityFilter
         *        A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces
         *        aren't indexed. If you specify <code>AUTO</code>, Amazon Rekognition chooses the quality bar. If you
         *        specify <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>, filtering removes all faces that
         *        don’t meet the chosen quality bar. The default value is <code>AUTO</code>. The quality bar is based on
         *        a variety of common use cases. Low-quality detections can occur for a number of reasons. Some examples
         *        are an object that's misidentified as a face, a face that's too blurry, or a face with a pose that's
         *        too extreme to use. If you specify <code>NONE</code>, no filtering is performed. </p>
         *        <p>
         *        To use quality filtering, the collection you are using must be associated with version 3 of the face
         *        model or higher.
         * @see QualityFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QualityFilter
         */
        Builder qualityFilter(QualityFilter qualityFilter);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private String collectionId;

        private Image image;

        private String externalImageId;

        private List<String> detectionAttributes = DefaultSdkAutoConstructList.getInstance();

        private Integer maxFaces;

        private String qualityFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(IndexFacesRequest model) {
            super(model);
            collectionId(model.collectionId);
            image(model.image);
            externalImageId(model.externalImageId);
            detectionAttributesWithStrings(model.detectionAttributes);
            maxFaces(model.maxFaces);
            qualityFilter(model.qualityFilter);
        }

        public final String getCollectionId() {
            return collectionId;
        }

        public final void setCollectionId(String collectionId) {
            this.collectionId = collectionId;
        }

        @Override
        @Transient
        public final Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public final Image.Builder getImage() {
            return image != null ? image.toBuilder() : null;
        }

        public final void setImage(Image.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        @Override
        @Transient
        public final Builder image(Image image) {
            this.image = image;
            return this;
        }

        public final String getExternalImageId() {
            return externalImageId;
        }

        public final void setExternalImageId(String externalImageId) {
            this.externalImageId = externalImageId;
        }

        @Override
        @Transient
        public final Builder externalImageId(String externalImageId) {
            this.externalImageId = externalImageId;
            return this;
        }

        public final Collection<String> getDetectionAttributes() {
            if (detectionAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return detectionAttributes;
        }

        public final void setDetectionAttributes(Collection<String> detectionAttributes) {
            this.detectionAttributes = AttributesCopier.copy(detectionAttributes);
        }

        @Override
        @Transient
        public final Builder detectionAttributesWithStrings(Collection<String> detectionAttributes) {
            this.detectionAttributes = AttributesCopier.copy(detectionAttributes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder detectionAttributesWithStrings(String... detectionAttributes) {
            detectionAttributesWithStrings(Arrays.asList(detectionAttributes));
            return this;
        }

        @Override
        @Transient
        public final Builder detectionAttributes(Collection<Attribute> detectionAttributes) {
            this.detectionAttributes = AttributesCopier.copyEnumToString(detectionAttributes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder detectionAttributes(Attribute... detectionAttributes) {
            detectionAttributes(Arrays.asList(detectionAttributes));
            return this;
        }

        public final Integer getMaxFaces() {
            return maxFaces;
        }

        public final void setMaxFaces(Integer maxFaces) {
            this.maxFaces = maxFaces;
        }

        @Override
        @Transient
        public final Builder maxFaces(Integer maxFaces) {
            this.maxFaces = maxFaces;
            return this;
        }

        public final String getQualityFilter() {
            return qualityFilter;
        }

        public final void setQualityFilter(String qualityFilter) {
            this.qualityFilter = qualityFilter;
        }

        @Override
        @Transient
        public final Builder qualityFilter(String qualityFilter) {
            this.qualityFilter = qualityFilter;
            return this;
        }

        @Override
        @Transient
        public final Builder qualityFilter(QualityFilter qualityFilter) {
            this.qualityFilter(qualityFilter == null ? null : qualityFilter.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public IndexFacesRequest build() {
            return new IndexFacesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
