/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A person detected by a call to <a>DetectProtectiveEquipment</a>. The API returns all persons detected in the input
 * image in an array of <code>ProtectiveEquipmentPerson</code> objects.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProtectiveEquipmentPerson implements SdkPojo, Serializable,
        ToCopyableBuilder<ProtectiveEquipmentPerson.Builder, ProtectiveEquipmentPerson> {
    private static final SdkField<List<ProtectiveEquipmentBodyPart>> BODY_PARTS_FIELD = SdkField
            .<List<ProtectiveEquipmentBodyPart>> builder(MarshallingType.LIST)
            .memberName("BodyParts")
            .getter(getter(ProtectiveEquipmentPerson::bodyParts))
            .setter(setter(Builder::bodyParts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BodyParts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProtectiveEquipmentBodyPart> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProtectiveEquipmentBodyPart::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<BoundingBox> BOUNDING_BOX_FIELD = SdkField.<BoundingBox> builder(MarshallingType.SDK_POJO)
            .memberName("BoundingBox").getter(getter(ProtectiveEquipmentPerson::boundingBox))
            .setter(setter(Builder::boundingBox)).constructor(BoundingBox::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoundingBox").build()).build();

    private static final SdkField<Float> CONFIDENCE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("Confidence").getter(getter(ProtectiveEquipmentPerson::confidence)).setter(setter(Builder::confidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()).build();

    private static final SdkField<Integer> ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Id")
            .getter(getter(ProtectiveEquipmentPerson::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BODY_PARTS_FIELD,
            BOUNDING_BOX_FIELD, CONFIDENCE_FIELD, ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ProtectiveEquipmentBodyPart> bodyParts;

    private final BoundingBox boundingBox;

    private final Float confidence;

    private final Integer id;

    private ProtectiveEquipmentPerson(BuilderImpl builder) {
        this.bodyParts = builder.bodyParts;
        this.boundingBox = builder.boundingBox;
        this.confidence = builder.confidence;
        this.id = builder.id;
    }

    /**
     * Returns true if the BodyParts property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasBodyParts() {
        return bodyParts != null && !(bodyParts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of body parts detected on a person's body (including body parts without PPE).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBodyParts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of body parts detected on a person's body (including body parts without PPE).
     */
    public final List<ProtectiveEquipmentBodyPart> bodyParts() {
        return bodyParts;
    }

    /**
     * <p>
     * A bounding box around the detected person.
     * </p>
     * 
     * @return A bounding box around the detected person.
     */
    public final BoundingBox boundingBox() {
        return boundingBox;
    }

    /**
     * <p>
     * The confidence that Amazon Rekognition has that the bounding box contains a person.
     * </p>
     * 
     * @return The confidence that Amazon Rekognition has that the bounding box contains a person.
     */
    public final Float confidence() {
        return confidence;
    }

    /**
     * <p>
     * The identifier for the detected person. The identifier is only unique for a single call to
     * <code>DetectProtectiveEquipment</code>.
     * </p>
     * 
     * @return The identifier for the detected person. The identifier is only unique for a single call to
     *         <code>DetectProtectiveEquipment</code>.
     */
    public final Integer id() {
        return id;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasBodyParts() ? bodyParts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(boundingBox());
        hashCode = 31 * hashCode + Objects.hashCode(confidence());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectiveEquipmentPerson)) {
            return false;
        }
        ProtectiveEquipmentPerson other = (ProtectiveEquipmentPerson) obj;
        return hasBodyParts() == other.hasBodyParts() && Objects.equals(bodyParts(), other.bodyParts())
                && Objects.equals(boundingBox(), other.boundingBox()) && Objects.equals(confidence(), other.confidence())
                && Objects.equals(id(), other.id());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProtectiveEquipmentPerson").add("BodyParts", hasBodyParts() ? bodyParts() : null)
                .add("BoundingBox", boundingBox()).add("Confidence", confidence()).add("Id", id()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BodyParts":
            return Optional.ofNullable(clazz.cast(bodyParts()));
        case "BoundingBox":
            return Optional.ofNullable(clazz.cast(boundingBox()));
        case "Confidence":
            return Optional.ofNullable(clazz.cast(confidence()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProtectiveEquipmentPerson, T> g) {
        return obj -> g.apply((ProtectiveEquipmentPerson) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProtectiveEquipmentPerson> {
        /**
         * <p>
         * An array of body parts detected on a person's body (including body parts without PPE).
         * </p>
         * 
         * @param bodyParts
         *        An array of body parts detected on a person's body (including body parts without PPE).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bodyParts(Collection<ProtectiveEquipmentBodyPart> bodyParts);

        /**
         * <p>
         * An array of body parts detected on a person's body (including body parts without PPE).
         * </p>
         * 
         * @param bodyParts
         *        An array of body parts detected on a person's body (including body parts without PPE).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bodyParts(ProtectiveEquipmentBodyPart... bodyParts);

        /**
         * <p>
         * An array of body parts detected on a person's body (including body parts without PPE).
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProtectiveEquipmentBodyPart>.Builder}
         * avoiding the need to create one manually via {@link List<ProtectiveEquipmentBodyPart>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProtectiveEquipmentBodyPart>.Builder#build()} is called
         * immediately and its result is passed to {@link #bodyParts(List<ProtectiveEquipmentBodyPart>)}.
         * 
         * @param bodyParts
         *        a consumer that will call methods on {@link List<ProtectiveEquipmentBodyPart>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bodyParts(List<ProtectiveEquipmentBodyPart>)
         */
        Builder bodyParts(Consumer<ProtectiveEquipmentBodyPart.Builder>... bodyParts);

        /**
         * <p>
         * A bounding box around the detected person.
         * </p>
         * 
         * @param boundingBox
         *        A bounding box around the detected person.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder boundingBox(BoundingBox boundingBox);

        /**
         * <p>
         * A bounding box around the detected person.
         * </p>
         * This is a convenience that creates an instance of the {@link BoundingBox.Builder} avoiding the need to create
         * one manually via {@link BoundingBox#builder()}.
         *
         * When the {@link Consumer} completes, {@link BoundingBox.Builder#build()} is called immediately and its result
         * is passed to {@link #boundingBox(BoundingBox)}.
         * 
         * @param boundingBox
         *        a consumer that will call methods on {@link BoundingBox.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #boundingBox(BoundingBox)
         */
        default Builder boundingBox(Consumer<BoundingBox.Builder> boundingBox) {
            return boundingBox(BoundingBox.builder().applyMutation(boundingBox).build());
        }

        /**
         * <p>
         * The confidence that Amazon Rekognition has that the bounding box contains a person.
         * </p>
         * 
         * @param confidence
         *        The confidence that Amazon Rekognition has that the bounding box contains a person.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Float confidence);

        /**
         * <p>
         * The identifier for the detected person. The identifier is only unique for a single call to
         * <code>DetectProtectiveEquipment</code>.
         * </p>
         * 
         * @param id
         *        The identifier for the detected person. The identifier is only unique for a single call to
         *        <code>DetectProtectiveEquipment</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(Integer id);
    }

    static final class BuilderImpl implements Builder {
        private List<ProtectiveEquipmentBodyPart> bodyParts = DefaultSdkAutoConstructList.getInstance();

        private BoundingBox boundingBox;

        private Float confidence;

        private Integer id;

        private BuilderImpl() {
        }

        private BuilderImpl(ProtectiveEquipmentPerson model) {
            bodyParts(model.bodyParts);
            boundingBox(model.boundingBox);
            confidence(model.confidence);
            id(model.id);
        }

        public final List<ProtectiveEquipmentBodyPart.Builder> getBodyParts() {
            List<ProtectiveEquipmentBodyPart.Builder> result = BodyPartsCopier.copyToBuilder(this.bodyParts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBodyParts(Collection<ProtectiveEquipmentBodyPart.BuilderImpl> bodyParts) {
            this.bodyParts = BodyPartsCopier.copyFromBuilder(bodyParts);
        }

        @Override
        @Transient
        public final Builder bodyParts(Collection<ProtectiveEquipmentBodyPart> bodyParts) {
            this.bodyParts = BodyPartsCopier.copy(bodyParts);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder bodyParts(ProtectiveEquipmentBodyPart... bodyParts) {
            bodyParts(Arrays.asList(bodyParts));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder bodyParts(Consumer<ProtectiveEquipmentBodyPart.Builder>... bodyParts) {
            bodyParts(Stream.of(bodyParts).map(c -> ProtectiveEquipmentBodyPart.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final BoundingBox.Builder getBoundingBox() {
            return boundingBox != null ? boundingBox.toBuilder() : null;
        }

        public final void setBoundingBox(BoundingBox.BuilderImpl boundingBox) {
            this.boundingBox = boundingBox != null ? boundingBox.build() : null;
        }

        @Override
        @Transient
        public final Builder boundingBox(BoundingBox boundingBox) {
            this.boundingBox = boundingBox;
            return this;
        }

        public final Float getConfidence() {
            return confidence;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        @Transient
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final Integer getId() {
            return id;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(Integer id) {
            this.id = id;
            return this;
        }

        @Override
        public ProtectiveEquipmentPerson build() {
            return new ProtectiveEquipmentPerson(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
