/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filters for the technical segments returned by <a>GetSegmentDetection</a>. For more information, see
 * <a>StartSegmentDetectionFilters</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartTechnicalCueDetectionFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<StartTechnicalCueDetectionFilter.Builder, StartTechnicalCueDetectionFilter> {
    private static final SdkField<Float> MIN_SEGMENT_CONFIDENCE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("MinSegmentConfidence").getter(getter(StartTechnicalCueDetectionFilter::minSegmentConfidence))
            .setter(setter(Builder::minSegmentConfidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinSegmentConfidence").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_SEGMENT_CONFIDENCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Float minSegmentConfidence;

    private StartTechnicalCueDetectionFilter(BuilderImpl builder) {
        this.minSegmentConfidence = builder.minSegmentConfidence;
    }

    /**
     * <p>
     * Specifies the minimum confidence that Amazon Rekognition Video must have in order to return a detected segment.
     * Confidence represents how certain Amazon Rekognition is that a segment is correctly identified. 0 is the lowest
     * confidence. 100 is the highest confidence. Amazon Rekognition Video doesn't return any segments with a confidence
     * level lower than this specified value.
     * </p>
     * <p>
     * If you don't specify <code>MinSegmentConfidence</code>, <code>GetSegmentDetection</code> returns segments with
     * confidence values greater than or equal to 50 percent.
     * </p>
     * 
     * @return Specifies the minimum confidence that Amazon Rekognition Video must have in order to return a detected
     *         segment. Confidence represents how certain Amazon Rekognition is that a segment is correctly identified.
     *         0 is the lowest confidence. 100 is the highest confidence. Amazon Rekognition Video doesn't return any
     *         segments with a confidence level lower than this specified value.</p>
     *         <p>
     *         If you don't specify <code>MinSegmentConfidence</code>, <code>GetSegmentDetection</code> returns segments
     *         with confidence values greater than or equal to 50 percent.
     */
    public final Float minSegmentConfidence() {
        return minSegmentConfidence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minSegmentConfidence());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTechnicalCueDetectionFilter)) {
            return false;
        }
        StartTechnicalCueDetectionFilter other = (StartTechnicalCueDetectionFilter) obj;
        return Objects.equals(minSegmentConfidence(), other.minSegmentConfidence());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartTechnicalCueDetectionFilter").add("MinSegmentConfidence", minSegmentConfidence()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MinSegmentConfidence":
            return Optional.ofNullable(clazz.cast(minSegmentConfidence()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartTechnicalCueDetectionFilter, T> g) {
        return obj -> g.apply((StartTechnicalCueDetectionFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StartTechnicalCueDetectionFilter> {
        /**
         * <p>
         * Specifies the minimum confidence that Amazon Rekognition Video must have in order to return a detected
         * segment. Confidence represents how certain Amazon Rekognition is that a segment is correctly identified. 0 is
         * the lowest confidence. 100 is the highest confidence. Amazon Rekognition Video doesn't return any segments
         * with a confidence level lower than this specified value.
         * </p>
         * <p>
         * If you don't specify <code>MinSegmentConfidence</code>, <code>GetSegmentDetection</code> returns segments
         * with confidence values greater than or equal to 50 percent.
         * </p>
         * 
         * @param minSegmentConfidence
         *        Specifies the minimum confidence that Amazon Rekognition Video must have in order to return a detected
         *        segment. Confidence represents how certain Amazon Rekognition is that a segment is correctly
         *        identified. 0 is the lowest confidence. 100 is the highest confidence. Amazon Rekognition Video
         *        doesn't return any segments with a confidence level lower than this specified value.</p>
         *        <p>
         *        If you don't specify <code>MinSegmentConfidence</code>, <code>GetSegmentDetection</code> returns
         *        segments with confidence values greater than or equal to 50 percent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minSegmentConfidence(Float minSegmentConfidence);
    }

    static final class BuilderImpl implements Builder {
        private Float minSegmentConfidence;

        private BuilderImpl() {
        }

        private BuilderImpl(StartTechnicalCueDetectionFilter model) {
            minSegmentConfidence(model.minSegmentConfidence);
        }

        public final Float getMinSegmentConfidence() {
            return minSegmentConfidence;
        }

        public final void setMinSegmentConfidence(Float minSegmentConfidence) {
            this.minSegmentConfidence = minSegmentConfidence;
        }

        @Override
        @Transient
        public final Builder minSegmentConfidence(Float minSegmentConfidence) {
            this.minSegmentConfidence = minSegmentConfidence;
            return this;
        }

        @Override
        public StartTechnicalCueDetectionFilter build() {
            return new StartTechnicalCueDetectionFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
