/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Set of optional parameters that let you set the criteria text must meet to be included in your response.
 * <code>WordFilter</code> looks at a word's height, width and minimum confidence. <code>RegionOfInterest</code> lets
 * you set a specific region of the screen to look for text in.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartTextDetectionFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<StartTextDetectionFilters.Builder, StartTextDetectionFilters> {
    private static final SdkField<DetectionFilter> WORD_FILTER_FIELD = SdkField
            .<DetectionFilter> builder(MarshallingType.SDK_POJO).memberName("WordFilter")
            .getter(getter(StartTextDetectionFilters::wordFilter)).setter(setter(Builder::wordFilter))
            .constructor(DetectionFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WordFilter").build()).build();

    private static final SdkField<List<RegionOfInterest>> REGIONS_OF_INTEREST_FIELD = SdkField
            .<List<RegionOfInterest>> builder(MarshallingType.LIST)
            .memberName("RegionsOfInterest")
            .getter(getter(StartTextDetectionFilters::regionsOfInterest))
            .setter(setter(Builder::regionsOfInterest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionsOfInterest").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RegionOfInterest> builder(MarshallingType.SDK_POJO)
                                            .constructor(RegionOfInterest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORD_FILTER_FIELD,
            REGIONS_OF_INTEREST_FIELD));

    private static final long serialVersionUID = 1L;

    private final DetectionFilter wordFilter;

    private final List<RegionOfInterest> regionsOfInterest;

    private StartTextDetectionFilters(BuilderImpl builder) {
        this.wordFilter = builder.wordFilter;
        this.regionsOfInterest = builder.regionsOfInterest;
    }

    /**
     * <p>
     * Filters focusing on qualities of the text, such as confidence or size.
     * </p>
     * 
     * @return Filters focusing on qualities of the text, such as confidence or size.
     */
    public final DetectionFilter wordFilter() {
        return wordFilter;
    }

    /**
     * Returns true if the RegionsOfInterest property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasRegionsOfInterest() {
        return regionsOfInterest != null && !(regionsOfInterest instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter focusing on a certain area of the frame. Uses a <code>BoundingBox</code> object to set the region of the
     * screen.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRegionsOfInterest()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Filter focusing on a certain area of the frame. Uses a <code>BoundingBox</code> object to set the region
     *         of the screen.
     */
    public final List<RegionOfInterest> regionsOfInterest() {
        return regionsOfInterest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(wordFilter());
        hashCode = 31 * hashCode + Objects.hashCode(hasRegionsOfInterest() ? regionsOfInterest() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTextDetectionFilters)) {
            return false;
        }
        StartTextDetectionFilters other = (StartTextDetectionFilters) obj;
        return Objects.equals(wordFilter(), other.wordFilter()) && hasRegionsOfInterest() == other.hasRegionsOfInterest()
                && Objects.equals(regionsOfInterest(), other.regionsOfInterest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartTextDetectionFilters").add("WordFilter", wordFilter())
                .add("RegionsOfInterest", hasRegionsOfInterest() ? regionsOfInterest() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WordFilter":
            return Optional.ofNullable(clazz.cast(wordFilter()));
        case "RegionsOfInterest":
            return Optional.ofNullable(clazz.cast(regionsOfInterest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartTextDetectionFilters, T> g) {
        return obj -> g.apply((StartTextDetectionFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StartTextDetectionFilters> {
        /**
         * <p>
         * Filters focusing on qualities of the text, such as confidence or size.
         * </p>
         * 
         * @param wordFilter
         *        Filters focusing on qualities of the text, such as confidence or size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wordFilter(DetectionFilter wordFilter);

        /**
         * <p>
         * Filters focusing on qualities of the text, such as confidence or size.
         * </p>
         * This is a convenience that creates an instance of the {@link DetectionFilter.Builder} avoiding the need to
         * create one manually via {@link DetectionFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link DetectionFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #wordFilter(DetectionFilter)}.
         * 
         * @param wordFilter
         *        a consumer that will call methods on {@link DetectionFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #wordFilter(DetectionFilter)
         */
        default Builder wordFilter(Consumer<DetectionFilter.Builder> wordFilter) {
            return wordFilter(DetectionFilter.builder().applyMutation(wordFilter).build());
        }

        /**
         * <p>
         * Filter focusing on a certain area of the frame. Uses a <code>BoundingBox</code> object to set the region of
         * the screen.
         * </p>
         * 
         * @param regionsOfInterest
         *        Filter focusing on a certain area of the frame. Uses a <code>BoundingBox</code> object to set the
         *        region of the screen.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionsOfInterest(Collection<RegionOfInterest> regionsOfInterest);

        /**
         * <p>
         * Filter focusing on a certain area of the frame. Uses a <code>BoundingBox</code> object to set the region of
         * the screen.
         * </p>
         * 
         * @param regionsOfInterest
         *        Filter focusing on a certain area of the frame. Uses a <code>BoundingBox</code> object to set the
         *        region of the screen.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionsOfInterest(RegionOfInterest... regionsOfInterest);

        /**
         * <p>
         * Filter focusing on a certain area of the frame. Uses a <code>BoundingBox</code> object to set the region of
         * the screen.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RegionOfInterest>.Builder} avoiding the
         * need to create one manually via {@link List<RegionOfInterest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RegionOfInterest>.Builder#build()} is called immediately and
         * its result is passed to {@link #regionsOfInterest(List<RegionOfInterest>)}.
         * 
         * @param regionsOfInterest
         *        a consumer that will call methods on {@link List<RegionOfInterest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #regionsOfInterest(List<RegionOfInterest>)
         */
        Builder regionsOfInterest(Consumer<RegionOfInterest.Builder>... regionsOfInterest);
    }

    static final class BuilderImpl implements Builder {
        private DetectionFilter wordFilter;

        private List<RegionOfInterest> regionsOfInterest = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartTextDetectionFilters model) {
            wordFilter(model.wordFilter);
            regionsOfInterest(model.regionsOfInterest);
        }

        public final DetectionFilter.Builder getWordFilter() {
            return wordFilter != null ? wordFilter.toBuilder() : null;
        }

        public final void setWordFilter(DetectionFilter.BuilderImpl wordFilter) {
            this.wordFilter = wordFilter != null ? wordFilter.build() : null;
        }

        @Override
        @Transient
        public final Builder wordFilter(DetectionFilter wordFilter) {
            this.wordFilter = wordFilter;
            return this;
        }

        public final List<RegionOfInterest.Builder> getRegionsOfInterest() {
            List<RegionOfInterest.Builder> result = RegionsOfInterestCopier.copyToBuilder(this.regionsOfInterest);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegionsOfInterest(Collection<RegionOfInterest.BuilderImpl> regionsOfInterest) {
            this.regionsOfInterest = RegionsOfInterestCopier.copyFromBuilder(regionsOfInterest);
        }

        @Override
        @Transient
        public final Builder regionsOfInterest(Collection<RegionOfInterest> regionsOfInterest) {
            this.regionsOfInterest = RegionsOfInterestCopier.copy(regionsOfInterest);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder regionsOfInterest(RegionOfInterest... regionsOfInterest) {
            regionsOfInterest(Arrays.asList(regionsOfInterest));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder regionsOfInterest(Consumer<RegionOfInterest.Builder>... regionsOfInterest) {
            regionsOfInterest(Stream.of(regionsOfInterest).map(c -> RegionOfInterest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public StartTextDetectionFilters build() {
            return new StartTextDetectionFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
