/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a recognized celebrity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CelebrityDetail implements SdkPojo, Serializable, ToCopyableBuilder<CelebrityDetail.Builder, CelebrityDetail> {
    private static final SdkField<List<String>> URLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Urls")
            .getter(getter(CelebrityDetail::urls))
            .setter(setter(Builder::urls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Urls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CelebrityDetail::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(CelebrityDetail::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Float> CONFIDENCE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("Confidence").getter(getter(CelebrityDetail::confidence)).setter(setter(Builder::confidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()).build();

    private static final SdkField<BoundingBox> BOUNDING_BOX_FIELD = SdkField.<BoundingBox> builder(MarshallingType.SDK_POJO)
            .memberName("BoundingBox").getter(getter(CelebrityDetail::boundingBox)).setter(setter(Builder::boundingBox))
            .constructor(BoundingBox::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoundingBox").build()).build();

    private static final SdkField<FaceDetail> FACE_FIELD = SdkField.<FaceDetail> builder(MarshallingType.SDK_POJO)
            .memberName("Face").getter(getter(CelebrityDetail::face)).setter(setter(Builder::face))
            .constructor(FaceDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Face").build()).build();

    private static final SdkField<KnownGender> KNOWN_GENDER_FIELD = SdkField.<KnownGender> builder(MarshallingType.SDK_POJO)
            .memberName("KnownGender").getter(getter(CelebrityDetail::knownGender)).setter(setter(Builder::knownGender))
            .constructor(KnownGender::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KnownGender").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URLS_FIELD, NAME_FIELD,
            ID_FIELD, CONFIDENCE_FIELD, BOUNDING_BOX_FIELD, FACE_FIELD, KNOWN_GENDER_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> urls;

    private final String name;

    private final String id;

    private final Float confidence;

    private final BoundingBox boundingBox;

    private final FaceDetail face;

    private final KnownGender knownGender;

    private CelebrityDetail(BuilderImpl builder) {
        this.urls = builder.urls;
        this.name = builder.name;
        this.id = builder.id;
        this.confidence = builder.confidence;
        this.boundingBox = builder.boundingBox;
        this.face = builder.face;
        this.knownGender = builder.knownGender;
    }

    /**
     * For responses, this returns true if the service returned a value for the Urls property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasUrls() {
        return urls != null && !(urls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of URLs pointing to additional celebrity information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUrls} method.
     * </p>
     * 
     * @return An array of URLs pointing to additional celebrity information.
     */
    public final List<String> urls() {
        return urls;
    }

    /**
     * <p>
     * The name of the celebrity.
     * </p>
     * 
     * @return The name of the celebrity.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The unique identifier for the celebrity.
     * </p>
     * 
     * @return The unique identifier for the celebrity.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The confidence, in percentage, that Amazon Rekognition has that the recognized face is the celebrity.
     * </p>
     * 
     * @return The confidence, in percentage, that Amazon Rekognition has that the recognized face is the celebrity.
     */
    public final Float confidence() {
        return confidence;
    }

    /**
     * <p>
     * Bounding box around the body of a celebrity.
     * </p>
     * 
     * @return Bounding box around the body of a celebrity.
     */
    public final BoundingBox boundingBox() {
        return boundingBox;
    }

    /**
     * <p>
     * Face details for the recognized celebrity.
     * </p>
     * 
     * @return Face details for the recognized celebrity.
     */
    public final FaceDetail face() {
        return face;
    }

    /**
     * <p>
     * Retrieves the known gender for the celebrity.
     * </p>
     * 
     * @return Retrieves the known gender for the celebrity.
     */
    public final KnownGender knownGender() {
        return knownGender;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasUrls() ? urls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(confidence());
        hashCode = 31 * hashCode + Objects.hashCode(boundingBox());
        hashCode = 31 * hashCode + Objects.hashCode(face());
        hashCode = 31 * hashCode + Objects.hashCode(knownGender());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CelebrityDetail)) {
            return false;
        }
        CelebrityDetail other = (CelebrityDetail) obj;
        return hasUrls() == other.hasUrls() && Objects.equals(urls(), other.urls()) && Objects.equals(name(), other.name())
                && Objects.equals(id(), other.id()) && Objects.equals(confidence(), other.confidence())
                && Objects.equals(boundingBox(), other.boundingBox()) && Objects.equals(face(), other.face())
                && Objects.equals(knownGender(), other.knownGender());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CelebrityDetail").add("Urls", hasUrls() ? urls() : null).add("Name", name()).add("Id", id())
                .add("Confidence", confidence()).add("BoundingBox", boundingBox()).add("Face", face())
                .add("KnownGender", knownGender()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Urls":
            return Optional.ofNullable(clazz.cast(urls()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Confidence":
            return Optional.ofNullable(clazz.cast(confidence()));
        case "BoundingBox":
            return Optional.ofNullable(clazz.cast(boundingBox()));
        case "Face":
            return Optional.ofNullable(clazz.cast(face()));
        case "KnownGender":
            return Optional.ofNullable(clazz.cast(knownGender()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CelebrityDetail, T> g) {
        return obj -> g.apply((CelebrityDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CelebrityDetail> {
        /**
         * <p>
         * An array of URLs pointing to additional celebrity information.
         * </p>
         * 
         * @param urls
         *        An array of URLs pointing to additional celebrity information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder urls(Collection<String> urls);

        /**
         * <p>
         * An array of URLs pointing to additional celebrity information.
         * </p>
         * 
         * @param urls
         *        An array of URLs pointing to additional celebrity information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder urls(String... urls);

        /**
         * <p>
         * The name of the celebrity.
         * </p>
         * 
         * @param name
         *        The name of the celebrity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The unique identifier for the celebrity.
         * </p>
         * 
         * @param id
         *        The unique identifier for the celebrity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The confidence, in percentage, that Amazon Rekognition has that the recognized face is the celebrity.
         * </p>
         * 
         * @param confidence
         *        The confidence, in percentage, that Amazon Rekognition has that the recognized face is the celebrity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Float confidence);

        /**
         * <p>
         * Bounding box around the body of a celebrity.
         * </p>
         * 
         * @param boundingBox
         *        Bounding box around the body of a celebrity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder boundingBox(BoundingBox boundingBox);

        /**
         * <p>
         * Bounding box around the body of a celebrity.
         * </p>
         * This is a convenience that creates an instance of the {@link BoundingBox.Builder} avoiding the need to create
         * one manually via {@link BoundingBox#builder()}.
         *
         * When the {@link Consumer} completes, {@link BoundingBox.Builder#build()} is called immediately and its result
         * is passed to {@link #boundingBox(BoundingBox)}.
         * 
         * @param boundingBox
         *        a consumer that will call methods on {@link BoundingBox.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #boundingBox(BoundingBox)
         */
        default Builder boundingBox(Consumer<BoundingBox.Builder> boundingBox) {
            return boundingBox(BoundingBox.builder().applyMutation(boundingBox).build());
        }

        /**
         * <p>
         * Face details for the recognized celebrity.
         * </p>
         * 
         * @param face
         *        Face details for the recognized celebrity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder face(FaceDetail face);

        /**
         * <p>
         * Face details for the recognized celebrity.
         * </p>
         * This is a convenience that creates an instance of the {@link FaceDetail.Builder} avoiding the need to create
         * one manually via {@link FaceDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link FaceDetail.Builder#build()} is called immediately and its result
         * is passed to {@link #face(FaceDetail)}.
         * 
         * @param face
         *        a consumer that will call methods on {@link FaceDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #face(FaceDetail)
         */
        default Builder face(Consumer<FaceDetail.Builder> face) {
            return face(FaceDetail.builder().applyMutation(face).build());
        }

        /**
         * <p>
         * Retrieves the known gender for the celebrity.
         * </p>
         * 
         * @param knownGender
         *        Retrieves the known gender for the celebrity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knownGender(KnownGender knownGender);

        /**
         * <p>
         * Retrieves the known gender for the celebrity.
         * </p>
         * This is a convenience that creates an instance of the {@link KnownGender.Builder} avoiding the need to create
         * one manually via {@link KnownGender#builder()}.
         *
         * When the {@link Consumer} completes, {@link KnownGender.Builder#build()} is called immediately and its result
         * is passed to {@link #knownGender(KnownGender)}.
         * 
         * @param knownGender
         *        a consumer that will call methods on {@link KnownGender.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #knownGender(KnownGender)
         */
        default Builder knownGender(Consumer<KnownGender.Builder> knownGender) {
            return knownGender(KnownGender.builder().applyMutation(knownGender).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> urls = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private String id;

        private Float confidence;

        private BoundingBox boundingBox;

        private FaceDetail face;

        private KnownGender knownGender;

        private BuilderImpl() {
        }

        private BuilderImpl(CelebrityDetail model) {
            urls(model.urls);
            name(model.name);
            id(model.id);
            confidence(model.confidence);
            boundingBox(model.boundingBox);
            face(model.face);
            knownGender(model.knownGender);
        }

        public final Collection<String> getUrls() {
            if (urls instanceof SdkAutoConstructList) {
                return null;
            }
            return urls;
        }

        public final void setUrls(Collection<String> urls) {
            this.urls = UrlsCopier.copy(urls);
        }

        @Override
        @Transient
        public final Builder urls(Collection<String> urls) {
            this.urls = UrlsCopier.copy(urls);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder urls(String... urls) {
            urls(Arrays.asList(urls));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Float getConfidence() {
            return confidence;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        @Transient
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final BoundingBox.Builder getBoundingBox() {
            return boundingBox != null ? boundingBox.toBuilder() : null;
        }

        public final void setBoundingBox(BoundingBox.BuilderImpl boundingBox) {
            this.boundingBox = boundingBox != null ? boundingBox.build() : null;
        }

        @Override
        @Transient
        public final Builder boundingBox(BoundingBox boundingBox) {
            this.boundingBox = boundingBox;
            return this;
        }

        public final FaceDetail.Builder getFace() {
            return face != null ? face.toBuilder() : null;
        }

        public final void setFace(FaceDetail.BuilderImpl face) {
            this.face = face != null ? face.build() : null;
        }

        @Override
        @Transient
        public final Builder face(FaceDetail face) {
            this.face = face;
            return this;
        }

        public final KnownGender.Builder getKnownGender() {
            return knownGender != null ? knownGender.toBuilder() : null;
        }

        public final void setKnownGender(KnownGender.BuilderImpl knownGender) {
            this.knownGender = knownGender != null ? knownGender.build() : null;
        }

        @Override
        @Transient
        public final Builder knownGender(KnownGender knownGender) {
            this.knownGender = knownGender;
            return this;
        }

        @Override
        public CelebrityDetail build() {
            return new CelebrityDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
