/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies face image brightness and sharpness.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageQuality implements SdkPojo, Serializable, ToCopyableBuilder<ImageQuality.Builder, ImageQuality> {
    private static final SdkField<Float> BRIGHTNESS_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("Brightness").getter(getter(ImageQuality::brightness)).setter(setter(Builder::brightness))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Brightness").build()).build();

    private static final SdkField<Float> SHARPNESS_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("Sharpness").getter(getter(ImageQuality::sharpness)).setter(setter(Builder::sharpness))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sharpness").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRIGHTNESS_FIELD,
            SHARPNESS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Float brightness;

    private final Float sharpness;

    private ImageQuality(BuilderImpl builder) {
        this.brightness = builder.brightness;
        this.sharpness = builder.sharpness;
    }

    /**
     * <p>
     * Value representing brightness of the face. The service returns a value between 0 and 100 (inclusive). A higher
     * value indicates a brighter face image.
     * </p>
     * 
     * @return Value representing brightness of the face. The service returns a value between 0 and 100 (inclusive). A
     *         higher value indicates a brighter face image.
     */
    public final Float brightness() {
        return brightness;
    }

    /**
     * <p>
     * Value representing sharpness of the face. The service returns a value between 0 and 100 (inclusive). A higher
     * value indicates a sharper face image.
     * </p>
     * 
     * @return Value representing sharpness of the face. The service returns a value between 0 and 100 (inclusive). A
     *         higher value indicates a sharper face image.
     */
    public final Float sharpness() {
        return sharpness;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(brightness());
        hashCode = 31 * hashCode + Objects.hashCode(sharpness());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageQuality)) {
            return false;
        }
        ImageQuality other = (ImageQuality) obj;
        return Objects.equals(brightness(), other.brightness()) && Objects.equals(sharpness(), other.sharpness());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImageQuality").add("Brightness", brightness()).add("Sharpness", sharpness()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Brightness":
            return Optional.ofNullable(clazz.cast(brightness()));
        case "Sharpness":
            return Optional.ofNullable(clazz.cast(sharpness()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImageQuality, T> g) {
        return obj -> g.apply((ImageQuality) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageQuality> {
        /**
         * <p>
         * Value representing brightness of the face. The service returns a value between 0 and 100 (inclusive). A
         * higher value indicates a brighter face image.
         * </p>
         * 
         * @param brightness
         *        Value representing brightness of the face. The service returns a value between 0 and 100 (inclusive).
         *        A higher value indicates a brighter face image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brightness(Float brightness);

        /**
         * <p>
         * Value representing sharpness of the face. The service returns a value between 0 and 100 (inclusive). A higher
         * value indicates a sharper face image.
         * </p>
         * 
         * @param sharpness
         *        Value representing sharpness of the face. The service returns a value between 0 and 100 (inclusive). A
         *        higher value indicates a sharper face image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharpness(Float sharpness);
    }

    static final class BuilderImpl implements Builder {
        private Float brightness;

        private Float sharpness;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageQuality model) {
            brightness(model.brightness);
            sharpness(model.sharpness);
        }

        public final Float getBrightness() {
            return brightness;
        }

        public final void setBrightness(Float brightness) {
            this.brightness = brightness;
        }

        @Override
        @Transient
        public final Builder brightness(Float brightness) {
            this.brightness = brightness;
            return this;
        }

        public final Float getSharpness() {
            return sharpness;
        }

        public final void setSharpness(Float sharpness) {
            this.sharpness = sharpness;
        }

        @Override
        @Transient
        public final Builder sharpness(Float sharpness) {
            this.sharpness = sharpness;
            return this;
        }

        @Override
        public ImageQuality build() {
            return new ImageQuality(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
