/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartProjectVersionRequest extends RekognitionRequest implements
        ToCopyableBuilder<StartProjectVersionRequest.Builder, StartProjectVersionRequest> {
    private static final SdkField<String> PROJECT_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectVersionArn").getter(getter(StartProjectVersionRequest::projectVersionArn))
            .setter(setter(Builder::projectVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectVersionArn").build()).build();

    private static final SdkField<Integer> MIN_INFERENCE_UNITS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinInferenceUnits").getter(getter(StartProjectVersionRequest::minInferenceUnits))
            .setter(setter(Builder::minInferenceUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinInferenceUnits").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_VERSION_ARN_FIELD,
            MIN_INFERENCE_UNITS_FIELD));

    private final String projectVersionArn;

    private final Integer minInferenceUnits;

    private StartProjectVersionRequest(BuilderImpl builder) {
        super(builder);
        this.projectVersionArn = builder.projectVersionArn;
        this.minInferenceUnits = builder.minInferenceUnits;
    }

    /**
     * <p>
     * The Amazon Resource Name(ARN) of the model version that you want to start.
     * </p>
     * 
     * @return The Amazon Resource Name(ARN) of the model version that you want to start.
     */
    public final String projectVersionArn() {
        return projectVersionArn;
    }

    /**
     * <p>
     * The minimum number of inference units to use. A single inference unit represents 1 hour of processing and can
     * support up to 5 Transaction Pers Second (TPS). Use a higher number to increase the TPS throughput of your model.
     * You are charged for the number of inference units that you use.
     * </p>
     * 
     * @return The minimum number of inference units to use. A single inference unit represents 1 hour of processing and
     *         can support up to 5 Transaction Pers Second (TPS). Use a higher number to increase the TPS throughput of
     *         your model. You are charged for the number of inference units that you use.
     */
    public final Integer minInferenceUnits() {
        return minInferenceUnits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(minInferenceUnits());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartProjectVersionRequest)) {
            return false;
        }
        StartProjectVersionRequest other = (StartProjectVersionRequest) obj;
        return Objects.equals(projectVersionArn(), other.projectVersionArn())
                && Objects.equals(minInferenceUnits(), other.minInferenceUnits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartProjectVersionRequest").add("ProjectVersionArn", projectVersionArn())
                .add("MinInferenceUnits", minInferenceUnits()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProjectVersionArn":
            return Optional.ofNullable(clazz.cast(projectVersionArn()));
        case "MinInferenceUnits":
            return Optional.ofNullable(clazz.cast(minInferenceUnits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartProjectVersionRequest, T> g) {
        return obj -> g.apply((StartProjectVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartProjectVersionRequest> {
        /**
         * <p>
         * The Amazon Resource Name(ARN) of the model version that you want to start.
         * </p>
         * 
         * @param projectVersionArn
         *        The Amazon Resource Name(ARN) of the model version that you want to start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectVersionArn(String projectVersionArn);

        /**
         * <p>
         * The minimum number of inference units to use. A single inference unit represents 1 hour of processing and can
         * support up to 5 Transaction Pers Second (TPS). Use a higher number to increase the TPS throughput of your
         * model. You are charged for the number of inference units that you use.
         * </p>
         * 
         * @param minInferenceUnits
         *        The minimum number of inference units to use. A single inference unit represents 1 hour of processing
         *        and can support up to 5 Transaction Pers Second (TPS). Use a higher number to increase the TPS
         *        throughput of your model. You are charged for the number of inference units that you use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minInferenceUnits(Integer minInferenceUnits);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private String projectVersionArn;

        private Integer minInferenceUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(StartProjectVersionRequest model) {
            super(model);
            projectVersionArn(model.projectVersionArn);
            minInferenceUnits(model.minInferenceUnits);
        }

        public final String getProjectVersionArn() {
            return projectVersionArn;
        }

        public final void setProjectVersionArn(String projectVersionArn) {
            this.projectVersionArn = projectVersionArn;
        }

        @Override
        @Transient
        public final Builder projectVersionArn(String projectVersionArn) {
            this.projectVersionArn = projectVersionArn;
            return this;
        }

        public final Integer getMinInferenceUnits() {
            return minInferenceUnits;
        }

        public final void setMinInferenceUnits(Integer minInferenceUnits) {
            this.minInferenceUnits = minInferenceUnits;
        }

        @Override
        @Transient
        public final Builder minInferenceUnits(Integer minInferenceUnits) {
            this.minInferenceUnits = minInferenceUnits;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartProjectVersionRequest build() {
            return new StartProjectVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
