/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a single type of inappropriate, unwanted, or offensive content found in an image or video.
 * Each type of moderated content has a label within a hierarchical taxonomy. For more information, see Content
 * moderation in the Amazon Rekognition Developer Guide.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModerationLabel implements SdkPojo, Serializable, ToCopyableBuilder<ModerationLabel.Builder, ModerationLabel> {
    private static final SdkField<Float> CONFIDENCE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("Confidence").getter(getter(ModerationLabel::confidence)).setter(setter(Builder::confidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ModerationLabel::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> PARENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParentName").getter(getter(ModerationLabel::parentName)).setter(setter(Builder::parentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIDENCE_FIELD, NAME_FIELD,
            PARENT_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Float confidence;

    private final String name;

    private final String parentName;

    private ModerationLabel(BuilderImpl builder) {
        this.confidence = builder.confidence;
        this.name = builder.name;
        this.parentName = builder.parentName;
    }

    /**
     * <p>
     * Specifies the confidence that Amazon Rekognition has that the label has been correctly identified.
     * </p>
     * <p>
     * If you don't specify the <code>MinConfidence</code> parameter in the call to <code>DetectModerationLabels</code>,
     * the operation returns labels with a confidence value greater than or equal to 50 percent.
     * </p>
     * 
     * @return Specifies the confidence that Amazon Rekognition has that the label has been correctly identified.</p>
     *         <p>
     *         If you don't specify the <code>MinConfidence</code> parameter in the call to
     *         <code>DetectModerationLabels</code>, the operation returns labels with a confidence value greater than or
     *         equal to 50 percent.
     */
    public final Float confidence() {
        return confidence;
    }

    /**
     * <p>
     * The label name for the type of unsafe content detected in the image.
     * </p>
     * 
     * @return The label name for the type of unsafe content detected in the image.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The name for the parent label. Labels at the top level of the hierarchy have the parent label <code>""</code>.
     * </p>
     * 
     * @return The name for the parent label. Labels at the top level of the hierarchy have the parent label
     *         <code>""</code>.
     */
    public final String parentName() {
        return parentName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(confidence());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(parentName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModerationLabel)) {
            return false;
        }
        ModerationLabel other = (ModerationLabel) obj;
        return Objects.equals(confidence(), other.confidence()) && Objects.equals(name(), other.name())
                && Objects.equals(parentName(), other.parentName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModerationLabel").add("Confidence", confidence()).add("Name", name())
                .add("ParentName", parentName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Confidence":
            return Optional.ofNullable(clazz.cast(confidence()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ParentName":
            return Optional.ofNullable(clazz.cast(parentName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModerationLabel, T> g) {
        return obj -> g.apply((ModerationLabel) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModerationLabel> {
        /**
         * <p>
         * Specifies the confidence that Amazon Rekognition has that the label has been correctly identified.
         * </p>
         * <p>
         * If you don't specify the <code>MinConfidence</code> parameter in the call to
         * <code>DetectModerationLabels</code>, the operation returns labels with a confidence value greater than or
         * equal to 50 percent.
         * </p>
         * 
         * @param confidence
         *        Specifies the confidence that Amazon Rekognition has that the label has been correctly identified.</p>
         *        <p>
         *        If you don't specify the <code>MinConfidence</code> parameter in the call to
         *        <code>DetectModerationLabels</code>, the operation returns labels with a confidence value greater than
         *        or equal to 50 percent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Float confidence);

        /**
         * <p>
         * The label name for the type of unsafe content detected in the image.
         * </p>
         * 
         * @param name
         *        The label name for the type of unsafe content detected in the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name for the parent label. Labels at the top level of the hierarchy have the parent label <code>""</code>
         * .
         * </p>
         * 
         * @param parentName
         *        The name for the parent label. Labels at the top level of the hierarchy have the parent label
         *        <code>""</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentName(String parentName);
    }

    static final class BuilderImpl implements Builder {
        private Float confidence;

        private String name;

        private String parentName;

        private BuilderImpl() {
        }

        private BuilderImpl(ModerationLabel model) {
            confidence(model.confidence);
            name(model.name);
            parentName(model.parentName);
        }

        public final Float getConfidence() {
            return confidence;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        @Transient
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getParentName() {
            return parentName;
        }

        public final void setParentName(String parentName) {
            this.parentName = parentName;
        }

        @Override
        @Transient
        public final Builder parentName(String parentName) {
            this.parentName = parentName;
            return this;
        }

        @Override
        public ModerationLabel build() {
            return new ModerationLabel(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
