/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStreamProcessorsResponse extends RekognitionResponse implements
        ToCopyableBuilder<ListStreamProcessorsResponse.Builder, ListStreamProcessorsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListStreamProcessorsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<StreamProcessor>> STREAM_PROCESSORS_FIELD = SdkField
            .<List<StreamProcessor>> builder(MarshallingType.LIST)
            .memberName("StreamProcessors")
            .getter(getter(ListStreamProcessorsResponse::streamProcessors))
            .setter(setter(Builder::streamProcessors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamProcessors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StreamProcessor> builder(MarshallingType.SDK_POJO)
                                            .constructor(StreamProcessor::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            STREAM_PROCESSORS_FIELD));

    private final String nextToken;

    private final List<StreamProcessor> streamProcessors;

    private ListStreamProcessorsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.streamProcessors = builder.streamProcessors;
    }

    /**
     * <p>
     * If the response is truncated, Amazon Rekognition Video returns this token that you can use in the subsequent
     * request to retrieve the next set of stream processors.
     * </p>
     * 
     * @return If the response is truncated, Amazon Rekognition Video returns this token that you can use in the
     *         subsequent request to retrieve the next set of stream processors.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the StreamProcessors property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasStreamProcessors() {
        return streamProcessors != null && !(streamProcessors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of stream processors that you have created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStreamProcessors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of stream processors that you have created.
     */
    public final List<StreamProcessor> streamProcessors() {
        return streamProcessors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasStreamProcessors() ? streamProcessors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamProcessorsResponse)) {
            return false;
        }
        ListStreamProcessorsResponse other = (ListStreamProcessorsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasStreamProcessors() == other.hasStreamProcessors()
                && Objects.equals(streamProcessors(), other.streamProcessors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListStreamProcessorsResponse").add("NextToken", nextToken())
                .add("StreamProcessors", hasStreamProcessors() ? streamProcessors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "StreamProcessors":
            return Optional.ofNullable(clazz.cast(streamProcessors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStreamProcessorsResponse, T> g) {
        return obj -> g.apply((ListStreamProcessorsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListStreamProcessorsResponse> {
        /**
         * <p>
         * If the response is truncated, Amazon Rekognition Video returns this token that you can use in the subsequent
         * request to retrieve the next set of stream processors.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon Rekognition Video returns this token that you can use in the
         *        subsequent request to retrieve the next set of stream processors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * List of stream processors that you have created.
         * </p>
         * 
         * @param streamProcessors
         *        List of stream processors that you have created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamProcessors(Collection<StreamProcessor> streamProcessors);

        /**
         * <p>
         * List of stream processors that you have created.
         * </p>
         * 
         * @param streamProcessors
         *        List of stream processors that you have created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamProcessors(StreamProcessor... streamProcessors);

        /**
         * <p>
         * List of stream processors that you have created.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StreamProcessor>.Builder} avoiding the need
         * to create one manually via {@link List<StreamProcessor>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StreamProcessor>.Builder#build()} is called immediately and
         * its result is passed to {@link #streamProcessors(List<StreamProcessor>)}.
         * 
         * @param streamProcessors
         *        a consumer that will call methods on {@link List<StreamProcessor>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamProcessors(List<StreamProcessor>)
         */
        Builder streamProcessors(Consumer<StreamProcessor.Builder>... streamProcessors);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<StreamProcessor> streamProcessors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamProcessorsResponse model) {
            super(model);
            nextToken(model.nextToken);
            streamProcessors(model.streamProcessors);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<StreamProcessor.Builder> getStreamProcessors() {
            List<StreamProcessor.Builder> result = StreamProcessorListCopier.copyToBuilder(this.streamProcessors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStreamProcessors(Collection<StreamProcessor.BuilderImpl> streamProcessors) {
            this.streamProcessors = StreamProcessorListCopier.copyFromBuilder(streamProcessors);
        }

        @Override
        @Transient
        public final Builder streamProcessors(Collection<StreamProcessor> streamProcessors) {
            this.streamProcessors = StreamProcessorListCopier.copy(streamProcessors);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder streamProcessors(StreamProcessor... streamProcessors) {
            streamProcessors(Arrays.asList(streamProcessors));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder streamProcessors(Consumer<StreamProcessor.Builder>... streamProcessors) {
            streamProcessors(Stream.of(streamProcessors).map(c -> StreamProcessor.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListStreamProcessorsResponse build() {
            return new ListStreamProcessorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
