/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The source that Amazon Rekognition Custom Labels uses to create a dataset. To use an Amazon Sagemaker format manifest
 * file, specify the S3 bucket location in the <code>GroundTruthManifest</code> field. The S3 bucket must be in your AWS
 * account. To create a copy of an existing dataset, specify the Amazon Resource Name (ARN) of an existing dataset in
 * <code>DatasetArn</code>.
 * </p>
 * <p>
 * You need to specify a value for <code>DatasetArn</code> or <code>GroundTruthManifest</code>, but not both. if you
 * supply both values, or if you don't specify any values, an InvalidParameterException exception occurs.
 * </p>
 * <p>
 * For more information, see <a>CreateDataset</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasetSource implements SdkPojo, Serializable, ToCopyableBuilder<DatasetSource.Builder, DatasetSource> {
    private static final SdkField<GroundTruthManifest> GROUND_TRUTH_MANIFEST_FIELD = SdkField
            .<GroundTruthManifest> builder(MarshallingType.SDK_POJO).memberName("GroundTruthManifest")
            .getter(getter(DatasetSource::groundTruthManifest)).setter(setter(Builder::groundTruthManifest))
            .constructor(GroundTruthManifest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroundTruthManifest").build())
            .build();

    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetArn").getter(getter(DatasetSource::datasetArn)).setter(setter(Builder::datasetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUND_TRUTH_MANIFEST_FIELD,
            DATASET_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final GroundTruthManifest groundTruthManifest;

    private final String datasetArn;

    private DatasetSource(BuilderImpl builder) {
        this.groundTruthManifest = builder.groundTruthManifest;
        this.datasetArn = builder.datasetArn;
    }

    /**
     * Returns the value of the GroundTruthManifest property for this object.
     * 
     * @return The value of the GroundTruthManifest property for this object.
     */
    public final GroundTruthManifest groundTruthManifest() {
        return groundTruthManifest;
    }

    /**
     * <p>
     * The ARN of an Amazon Rekognition Custom Labels dataset that you want to copy.
     * </p>
     * 
     * @return The ARN of an Amazon Rekognition Custom Labels dataset that you want to copy.
     */
    public final String datasetArn() {
        return datasetArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groundTruthManifest());
        hashCode = 31 * hashCode + Objects.hashCode(datasetArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetSource)) {
            return false;
        }
        DatasetSource other = (DatasetSource) obj;
        return Objects.equals(groundTruthManifest(), other.groundTruthManifest())
                && Objects.equals(datasetArn(), other.datasetArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatasetSource").add("GroundTruthManifest", groundTruthManifest())
                .add("DatasetArn", datasetArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroundTruthManifest":
            return Optional.ofNullable(clazz.cast(groundTruthManifest()));
        case "DatasetArn":
            return Optional.ofNullable(clazz.cast(datasetArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatasetSource, T> g) {
        return obj -> g.apply((DatasetSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasetSource> {
        /**
         * Sets the value of the GroundTruthManifest property for this object.
         *
         * @param groundTruthManifest
         *        The new value for the GroundTruthManifest property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groundTruthManifest(GroundTruthManifest groundTruthManifest);

        /**
         * Sets the value of the GroundTruthManifest property for this object.
         *
         * This is a convenience method that creates an instance of the {@link GroundTruthManifest.Builder} avoiding the
         * need to create one manually via {@link GroundTruthManifest#builder()}.
         *
         * When the {@link Consumer} completes, {@link GroundTruthManifest.Builder#build()} is called immediately and
         * its result is passed to {@link #groundTruthManifest(GroundTruthManifest)}.
         * 
         * @param groundTruthManifest
         *        a consumer that will call methods on {@link GroundTruthManifest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groundTruthManifest(GroundTruthManifest)
         */
        default Builder groundTruthManifest(Consumer<GroundTruthManifest.Builder> groundTruthManifest) {
            return groundTruthManifest(GroundTruthManifest.builder().applyMutation(groundTruthManifest).build());
        }

        /**
         * <p>
         * The ARN of an Amazon Rekognition Custom Labels dataset that you want to copy.
         * </p>
         * 
         * @param datasetArn
         *        The ARN of an Amazon Rekognition Custom Labels dataset that you want to copy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetArn(String datasetArn);
    }

    static final class BuilderImpl implements Builder {
        private GroundTruthManifest groundTruthManifest;

        private String datasetArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetSource model) {
            groundTruthManifest(model.groundTruthManifest);
            datasetArn(model.datasetArn);
        }

        public final GroundTruthManifest.Builder getGroundTruthManifest() {
            return groundTruthManifest != null ? groundTruthManifest.toBuilder() : null;
        }

        public final void setGroundTruthManifest(GroundTruthManifest.BuilderImpl groundTruthManifest) {
            this.groundTruthManifest = groundTruthManifest != null ? groundTruthManifest.build() : null;
        }

        @Override
        public final Builder groundTruthManifest(GroundTruthManifest groundTruthManifest) {
            this.groundTruthManifest = groundTruthManifest;
            return this;
        }

        public final String getDatasetArn() {
            return datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        @Override
        public DatasetSource build() {
            return new DatasetSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
