/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.ProjectDescription;
import software.amazon.awssdk.services.rekognition.model.ProjectDescriptionsCopier;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeProjectsResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, DescribeProjectsResponse> {
    private static final SdkField<List<ProjectDescription>> PROJECT_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProjectDescriptions").getter(DescribeProjectsResponse.getter(DescribeProjectsResponse::projectDescriptions)).setter(DescribeProjectsResponse.setter(Builder::projectDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectDescriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProjectDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeProjectsResponse.getter(DescribeProjectsResponse::nextToken)).setter(DescribeProjectsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_DESCRIPTIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ProjectDescription> projectDescriptions;
    private final String nextToken;

    private DescribeProjectsResponse(BuilderImpl builder) {
        super(builder);
        this.projectDescriptions = builder.projectDescriptions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasProjectDescriptions() {
        return this.projectDescriptions != null && !(this.projectDescriptions instanceof SdkAutoConstructList);
    }

    public final List<ProjectDescription> projectDescriptions() {
        return this.projectDescriptions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProjectDescriptions() ? this.projectDescriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProjectsResponse)) {
            return false;
        }
        DescribeProjectsResponse other = (DescribeProjectsResponse)((Object)obj);
        return this.hasProjectDescriptions() == other.hasProjectDescriptions() && Objects.equals(this.projectDescriptions(), other.projectDescriptions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeProjectsResponse").add("ProjectDescriptions", this.hasProjectDescriptions() ? this.projectDescriptions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProjectDescriptions": {
                return Optional.ofNullable(clazz.cast(this.projectDescriptions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProjectsResponse, T> g) {
        return obj -> g.apply((DescribeProjectsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private List<ProjectDescription> projectDescriptions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProjectsResponse model) {
            super(model);
            this.projectDescriptions(model.projectDescriptions);
            this.nextToken(model.nextToken);
        }

        public final List<ProjectDescription.Builder> getProjectDescriptions() {
            List<ProjectDescription.Builder> result = ProjectDescriptionsCopier.copyToBuilder(this.projectDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProjectDescriptions(Collection<ProjectDescription.BuilderImpl> projectDescriptions) {
            this.projectDescriptions = ProjectDescriptionsCopier.copyFromBuilder(projectDescriptions);
        }

        @Override
        public final Builder projectDescriptions(Collection<ProjectDescription> projectDescriptions) {
            this.projectDescriptions = ProjectDescriptionsCopier.copy(projectDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectDescriptions(ProjectDescription ... projectDescriptions) {
            this.projectDescriptions(Arrays.asList(projectDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectDescriptions(Consumer<ProjectDescription.Builder> ... projectDescriptions) {
            this.projectDescriptions(Stream.of(projectDescriptions).map(c -> (ProjectDescription)((ProjectDescription.Builder)ProjectDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeProjectsResponse build() {
            return new DescribeProjectsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeProjectsResponse> {
        public Builder projectDescriptions(Collection<ProjectDescription> var1);

        public Builder projectDescriptions(ProjectDescription ... var1);

        public Builder projectDescriptions(Consumer<ProjectDescription.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

