/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides face metadata for target image faces that are analyzed by <code>CompareFaces</code> and
 * <code>RecognizeCelebrities</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComparedFace implements SdkPojo, Serializable, ToCopyableBuilder<ComparedFace.Builder, ComparedFace> {
    private static final SdkField<BoundingBox> BOUNDING_BOX_FIELD = SdkField.<BoundingBox> builder(MarshallingType.SDK_POJO)
            .memberName("BoundingBox").getter(getter(ComparedFace::boundingBox)).setter(setter(Builder::boundingBox))
            .constructor(BoundingBox::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoundingBox").build()).build();

    private static final SdkField<Float> CONFIDENCE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("Confidence").getter(getter(ComparedFace::confidence)).setter(setter(Builder::confidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()).build();

    private static final SdkField<List<Landmark>> LANDMARKS_FIELD = SdkField
            .<List<Landmark>> builder(MarshallingType.LIST)
            .memberName("Landmarks")
            .getter(getter(ComparedFace::landmarks))
            .setter(setter(Builder::landmarks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Landmarks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Landmark> builder(MarshallingType.SDK_POJO)
                                            .constructor(Landmark::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Pose> POSE_FIELD = SdkField.<Pose> builder(MarshallingType.SDK_POJO).memberName("Pose")
            .getter(getter(ComparedFace::pose)).setter(setter(Builder::pose)).constructor(Pose::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pose").build()).build();

    private static final SdkField<ImageQuality> QUALITY_FIELD = SdkField.<ImageQuality> builder(MarshallingType.SDK_POJO)
            .memberName("Quality").getter(getter(ComparedFace::quality)).setter(setter(Builder::quality))
            .constructor(ImageQuality::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quality").build()).build();

    private static final SdkField<List<Emotion>> EMOTIONS_FIELD = SdkField
            .<List<Emotion>> builder(MarshallingType.LIST)
            .memberName("Emotions")
            .getter(getter(ComparedFace::emotions))
            .setter(setter(Builder::emotions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Emotions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Emotion> builder(MarshallingType.SDK_POJO)
                                            .constructor(Emotion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Smile> SMILE_FIELD = SdkField.<Smile> builder(MarshallingType.SDK_POJO).memberName("Smile")
            .getter(getter(ComparedFace::smile)).setter(setter(Builder::smile)).constructor(Smile::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Smile").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOUNDING_BOX_FIELD,
            CONFIDENCE_FIELD, LANDMARKS_FIELD, POSE_FIELD, QUALITY_FIELD, EMOTIONS_FIELD, SMILE_FIELD));

    private static final long serialVersionUID = 1L;

    private final BoundingBox boundingBox;

    private final Float confidence;

    private final List<Landmark> landmarks;

    private final Pose pose;

    private final ImageQuality quality;

    private final List<Emotion> emotions;

    private final Smile smile;

    private ComparedFace(BuilderImpl builder) {
        this.boundingBox = builder.boundingBox;
        this.confidence = builder.confidence;
        this.landmarks = builder.landmarks;
        this.pose = builder.pose;
        this.quality = builder.quality;
        this.emotions = builder.emotions;
        this.smile = builder.smile;
    }

    /**
     * <p>
     * Bounding box of the face.
     * </p>
     * 
     * @return Bounding box of the face.
     */
    public final BoundingBox boundingBox() {
        return boundingBox;
    }

    /**
     * <p>
     * Level of confidence that what the bounding box contains is a face.
     * </p>
     * 
     * @return Level of confidence that what the bounding box contains is a face.
     */
    public final Float confidence() {
        return confidence;
    }

    /**
     * For responses, this returns true if the service returned a value for the Landmarks property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLandmarks() {
        return landmarks != null && !(landmarks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of facial landmarks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLandmarks} method.
     * </p>
     * 
     * @return An array of facial landmarks.
     */
    public final List<Landmark> landmarks() {
        return landmarks;
    }

    /**
     * <p>
     * Indicates the pose of the face as determined by its pitch, roll, and yaw.
     * </p>
     * 
     * @return Indicates the pose of the face as determined by its pitch, roll, and yaw.
     */
    public final Pose pose() {
        return pose;
    }

    /**
     * <p>
     * Identifies face image brightness and sharpness.
     * </p>
     * 
     * @return Identifies face image brightness and sharpness.
     */
    public final ImageQuality quality() {
        return quality;
    }

    /**
     * For responses, this returns true if the service returned a value for the Emotions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEmotions() {
        return emotions != null && !(emotions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The emotions that appear to be expressed on the face, and the confidence level in the determination. Valid values
     * include "Happy", "Sad", "Angry", "Confused", "Disgusted", "Surprised", "Calm", "Unknown", and "Fear".
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEmotions} method.
     * </p>
     * 
     * @return The emotions that appear to be expressed on the face, and the confidence level in the determination.
     *         Valid values include "Happy", "Sad", "Angry", "Confused", "Disgusted", "Surprised", "Calm", "Unknown",
     *         and "Fear".
     */
    public final List<Emotion> emotions() {
        return emotions;
    }

    /**
     * <p>
     * Indicates whether or not the face is smiling, and the confidence level in the determination.
     * </p>
     * 
     * @return Indicates whether or not the face is smiling, and the confidence level in the determination.
     */
    public final Smile smile() {
        return smile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(boundingBox());
        hashCode = 31 * hashCode + Objects.hashCode(confidence());
        hashCode = 31 * hashCode + Objects.hashCode(hasLandmarks() ? landmarks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(pose());
        hashCode = 31 * hashCode + Objects.hashCode(quality());
        hashCode = 31 * hashCode + Objects.hashCode(hasEmotions() ? emotions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(smile());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComparedFace)) {
            return false;
        }
        ComparedFace other = (ComparedFace) obj;
        return Objects.equals(boundingBox(), other.boundingBox()) && Objects.equals(confidence(), other.confidence())
                && hasLandmarks() == other.hasLandmarks() && Objects.equals(landmarks(), other.landmarks())
                && Objects.equals(pose(), other.pose()) && Objects.equals(quality(), other.quality())
                && hasEmotions() == other.hasEmotions() && Objects.equals(emotions(), other.emotions())
                && Objects.equals(smile(), other.smile());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComparedFace").add("BoundingBox", boundingBox()).add("Confidence", confidence())
                .add("Landmarks", hasLandmarks() ? landmarks() : null).add("Pose", pose()).add("Quality", quality())
                .add("Emotions", hasEmotions() ? emotions() : null).add("Smile", smile()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BoundingBox":
            return Optional.ofNullable(clazz.cast(boundingBox()));
        case "Confidence":
            return Optional.ofNullable(clazz.cast(confidence()));
        case "Landmarks":
            return Optional.ofNullable(clazz.cast(landmarks()));
        case "Pose":
            return Optional.ofNullable(clazz.cast(pose()));
        case "Quality":
            return Optional.ofNullable(clazz.cast(quality()));
        case "Emotions":
            return Optional.ofNullable(clazz.cast(emotions()));
        case "Smile":
            return Optional.ofNullable(clazz.cast(smile()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComparedFace, T> g) {
        return obj -> g.apply((ComparedFace) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComparedFace> {
        /**
         * <p>
         * Bounding box of the face.
         * </p>
         * 
         * @param boundingBox
         *        Bounding box of the face.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder boundingBox(BoundingBox boundingBox);

        /**
         * <p>
         * Bounding box of the face.
         * </p>
         * This is a convenience method that creates an instance of the {@link BoundingBox.Builder} avoiding the need to
         * create one manually via {@link BoundingBox#builder()}.
         *
         * When the {@link Consumer} completes, {@link BoundingBox.Builder#build()} is called immediately and its result
         * is passed to {@link #boundingBox(BoundingBox)}.
         * 
         * @param boundingBox
         *        a consumer that will call methods on {@link BoundingBox.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #boundingBox(BoundingBox)
         */
        default Builder boundingBox(Consumer<BoundingBox.Builder> boundingBox) {
            return boundingBox(BoundingBox.builder().applyMutation(boundingBox).build());
        }

        /**
         * <p>
         * Level of confidence that what the bounding box contains is a face.
         * </p>
         * 
         * @param confidence
         *        Level of confidence that what the bounding box contains is a face.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Float confidence);

        /**
         * <p>
         * An array of facial landmarks.
         * </p>
         * 
         * @param landmarks
         *        An array of facial landmarks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder landmarks(Collection<Landmark> landmarks);

        /**
         * <p>
         * An array of facial landmarks.
         * </p>
         * 
         * @param landmarks
         *        An array of facial landmarks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder landmarks(Landmark... landmarks);

        /**
         * <p>
         * An array of facial landmarks.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Landmark>.Builder} avoiding the need
         * to create one manually via {@link List<Landmark>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Landmark>.Builder#build()} is called immediately and its
         * result is passed to {@link #landmarks(List<Landmark>)}.
         * 
         * @param landmarks
         *        a consumer that will call methods on {@link List<Landmark>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #landmarks(List<Landmark>)
         */
        Builder landmarks(Consumer<Landmark.Builder>... landmarks);

        /**
         * <p>
         * Indicates the pose of the face as determined by its pitch, roll, and yaw.
         * </p>
         * 
         * @param pose
         *        Indicates the pose of the face as determined by its pitch, roll, and yaw.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pose(Pose pose);

        /**
         * <p>
         * Indicates the pose of the face as determined by its pitch, roll, and yaw.
         * </p>
         * This is a convenience method that creates an instance of the {@link Pose.Builder} avoiding the need to create
         * one manually via {@link Pose#builder()}.
         *
         * When the {@link Consumer} completes, {@link Pose.Builder#build()} is called immediately and its result is
         * passed to {@link #pose(Pose)}.
         * 
         * @param pose
         *        a consumer that will call methods on {@link Pose.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pose(Pose)
         */
        default Builder pose(Consumer<Pose.Builder> pose) {
            return pose(Pose.builder().applyMutation(pose).build());
        }

        /**
         * <p>
         * Identifies face image brightness and sharpness.
         * </p>
         * 
         * @param quality
         *        Identifies face image brightness and sharpness.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quality(ImageQuality quality);

        /**
         * <p>
         * Identifies face image brightness and sharpness.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageQuality.Builder} avoiding the need
         * to create one manually via {@link ImageQuality#builder()}.
         *
         * When the {@link Consumer} completes, {@link ImageQuality.Builder#build()} is called immediately and its
         * result is passed to {@link #quality(ImageQuality)}.
         * 
         * @param quality
         *        a consumer that will call methods on {@link ImageQuality.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #quality(ImageQuality)
         */
        default Builder quality(Consumer<ImageQuality.Builder> quality) {
            return quality(ImageQuality.builder().applyMutation(quality).build());
        }

        /**
         * <p>
         * The emotions that appear to be expressed on the face, and the confidence level in the determination. Valid
         * values include "Happy", "Sad", "Angry", "Confused", "Disgusted", "Surprised", "Calm", "Unknown", and "Fear".
         * </p>
         * 
         * @param emotions
         *        The emotions that appear to be expressed on the face, and the confidence level in the determination.
         *        Valid values include "Happy", "Sad", "Angry", "Confused", "Disgusted", "Surprised", "Calm", "Unknown",
         *        and "Fear".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emotions(Collection<Emotion> emotions);

        /**
         * <p>
         * The emotions that appear to be expressed on the face, and the confidence level in the determination. Valid
         * values include "Happy", "Sad", "Angry", "Confused", "Disgusted", "Surprised", "Calm", "Unknown", and "Fear".
         * </p>
         * 
         * @param emotions
         *        The emotions that appear to be expressed on the face, and the confidence level in the determination.
         *        Valid values include "Happy", "Sad", "Angry", "Confused", "Disgusted", "Surprised", "Calm", "Unknown",
         *        and "Fear".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emotions(Emotion... emotions);

        /**
         * <p>
         * The emotions that appear to be expressed on the face, and the confidence level in the determination. Valid
         * values include "Happy", "Sad", "Angry", "Confused", "Disgusted", "Surprised", "Calm", "Unknown", and "Fear".
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Emotion>.Builder} avoiding the need
         * to create one manually via {@link List<Emotion>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Emotion>.Builder#build()} is called immediately and its
         * result is passed to {@link #emotions(List<Emotion>)}.
         * 
         * @param emotions
         *        a consumer that will call methods on {@link List<Emotion>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emotions(List<Emotion>)
         */
        Builder emotions(Consumer<Emotion.Builder>... emotions);

        /**
         * <p>
         * Indicates whether or not the face is smiling, and the confidence level in the determination.
         * </p>
         * 
         * @param smile
         *        Indicates whether or not the face is smiling, and the confidence level in the determination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smile(Smile smile);

        /**
         * <p>
         * Indicates whether or not the face is smiling, and the confidence level in the determination.
         * </p>
         * This is a convenience method that creates an instance of the {@link Smile.Builder} avoiding the need to
         * create one manually via {@link Smile#builder()}.
         *
         * When the {@link Consumer} completes, {@link Smile.Builder#build()} is called immediately and its result is
         * passed to {@link #smile(Smile)}.
         * 
         * @param smile
         *        a consumer that will call methods on {@link Smile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #smile(Smile)
         */
        default Builder smile(Consumer<Smile.Builder> smile) {
            return smile(Smile.builder().applyMutation(smile).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BoundingBox boundingBox;

        private Float confidence;

        private List<Landmark> landmarks = DefaultSdkAutoConstructList.getInstance();

        private Pose pose;

        private ImageQuality quality;

        private List<Emotion> emotions = DefaultSdkAutoConstructList.getInstance();

        private Smile smile;

        private BuilderImpl() {
        }

        private BuilderImpl(ComparedFace model) {
            boundingBox(model.boundingBox);
            confidence(model.confidence);
            landmarks(model.landmarks);
            pose(model.pose);
            quality(model.quality);
            emotions(model.emotions);
            smile(model.smile);
        }

        public final BoundingBox.Builder getBoundingBox() {
            return boundingBox != null ? boundingBox.toBuilder() : null;
        }

        public final void setBoundingBox(BoundingBox.BuilderImpl boundingBox) {
            this.boundingBox = boundingBox != null ? boundingBox.build() : null;
        }

        @Override
        public final Builder boundingBox(BoundingBox boundingBox) {
            this.boundingBox = boundingBox;
            return this;
        }

        public final Float getConfidence() {
            return confidence;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final List<Landmark.Builder> getLandmarks() {
            List<Landmark.Builder> result = LandmarksCopier.copyToBuilder(this.landmarks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLandmarks(Collection<Landmark.BuilderImpl> landmarks) {
            this.landmarks = LandmarksCopier.copyFromBuilder(landmarks);
        }

        @Override
        public final Builder landmarks(Collection<Landmark> landmarks) {
            this.landmarks = LandmarksCopier.copy(landmarks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder landmarks(Landmark... landmarks) {
            landmarks(Arrays.asList(landmarks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder landmarks(Consumer<Landmark.Builder>... landmarks) {
            landmarks(Stream.of(landmarks).map(c -> Landmark.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Pose.Builder getPose() {
            return pose != null ? pose.toBuilder() : null;
        }

        public final void setPose(Pose.BuilderImpl pose) {
            this.pose = pose != null ? pose.build() : null;
        }

        @Override
        public final Builder pose(Pose pose) {
            this.pose = pose;
            return this;
        }

        public final ImageQuality.Builder getQuality() {
            return quality != null ? quality.toBuilder() : null;
        }

        public final void setQuality(ImageQuality.BuilderImpl quality) {
            this.quality = quality != null ? quality.build() : null;
        }

        @Override
        public final Builder quality(ImageQuality quality) {
            this.quality = quality;
            return this;
        }

        public final List<Emotion.Builder> getEmotions() {
            List<Emotion.Builder> result = EmotionsCopier.copyToBuilder(this.emotions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEmotions(Collection<Emotion.BuilderImpl> emotions) {
            this.emotions = EmotionsCopier.copyFromBuilder(emotions);
        }

        @Override
        public final Builder emotions(Collection<Emotion> emotions) {
            this.emotions = EmotionsCopier.copy(emotions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emotions(Emotion... emotions) {
            emotions(Arrays.asList(emotions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emotions(Consumer<Emotion.Builder>... emotions) {
            emotions(Stream.of(emotions).map(c -> Emotion.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Smile.Builder getSmile() {
            return smile != null ? smile.toBuilder() : null;
        }

        public final void setSmile(Smile.BuilderImpl smile) {
            this.smile = smile != null ? smile.build() : null;
        }

        @Override
        public final Builder smile(Smile smile) {
            this.smile = smile;
            return this;
        }

        @Override
        public ComparedFace build() {
            return new ComparedFace(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
