/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Assets are the images that you use to train and evaluate a model version. Assets can also contain validation
 * information that you use to debug a failed model training.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Asset implements SdkPojo, Serializable, ToCopyableBuilder<Asset.Builder, Asset> {
    private static final SdkField<GroundTruthManifest> GROUND_TRUTH_MANIFEST_FIELD = SdkField
            .<GroundTruthManifest> builder(MarshallingType.SDK_POJO).memberName("GroundTruthManifest")
            .getter(getter(Asset::groundTruthManifest)).setter(setter(Builder::groundTruthManifest))
            .constructor(GroundTruthManifest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroundTruthManifest").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUND_TRUTH_MANIFEST_FIELD));

    private static final long serialVersionUID = 1L;

    private final GroundTruthManifest groundTruthManifest;

    private Asset(BuilderImpl builder) {
        this.groundTruthManifest = builder.groundTruthManifest;
    }

    /**
     * Returns the value of the GroundTruthManifest property for this object.
     * 
     * @return The value of the GroundTruthManifest property for this object.
     */
    public final GroundTruthManifest groundTruthManifest() {
        return groundTruthManifest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groundTruthManifest());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Asset)) {
            return false;
        }
        Asset other = (Asset) obj;
        return Objects.equals(groundTruthManifest(), other.groundTruthManifest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Asset").add("GroundTruthManifest", groundTruthManifest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroundTruthManifest":
            return Optional.ofNullable(clazz.cast(groundTruthManifest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Asset, T> g) {
        return obj -> g.apply((Asset) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Asset> {
        /**
         * Sets the value of the GroundTruthManifest property for this object.
         *
         * @param groundTruthManifest
         *        The new value for the GroundTruthManifest property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groundTruthManifest(GroundTruthManifest groundTruthManifest);

        /**
         * Sets the value of the GroundTruthManifest property for this object.
         *
         * This is a convenience that creates an instance of the {@link GroundTruthManifest.Builder} avoiding the need
         * to create one manually via {@link GroundTruthManifest#builder()}.
         *
         * When the {@link Consumer} completes, {@link GroundTruthManifest.Builder#build()} is called immediately and
         * its result is passed to {@link #groundTruthManifest(GroundTruthManifest)}.
         * 
         * @param groundTruthManifest
         *        a consumer that will call methods on {@link GroundTruthManifest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groundTruthManifest(GroundTruthManifest)
         */
        default Builder groundTruthManifest(Consumer<GroundTruthManifest.Builder> groundTruthManifest) {
            return groundTruthManifest(GroundTruthManifest.builder().applyMutation(groundTruthManifest).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GroundTruthManifest groundTruthManifest;

        private BuilderImpl() {
        }

        private BuilderImpl(Asset model) {
            groundTruthManifest(model.groundTruthManifest);
        }

        public final GroundTruthManifest.Builder getGroundTruthManifest() {
            return groundTruthManifest != null ? groundTruthManifest.toBuilder() : null;
        }

        public final void setGroundTruthManifest(GroundTruthManifest.BuilderImpl groundTruthManifest) {
            this.groundTruthManifest = groundTruthManifest != null ? groundTruthManifest.build() : null;
        }

        @Override
        @Transient
        public final Builder groundTruthManifest(GroundTruthManifest groundTruthManifest) {
            this.groundTruthManifest = groundTruthManifest;
            return this;
        }

        @Override
        public Asset build() {
            return new Asset(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
