/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a face in a target image that matches the source image face analyzed by
 * <code>CompareFaces</code>. The <code>Face</code> property contains the bounding box of the face in the target image.
 * The <code>Similarity</code> property is the confidence that the source image face matches the face in the bounding
 * box.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CompareFacesMatch implements SdkPojo, Serializable,
        ToCopyableBuilder<CompareFacesMatch.Builder, CompareFacesMatch> {
    private static final SdkField<Float> SIMILARITY_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("Similarity").getter(getter(CompareFacesMatch::similarity)).setter(setter(Builder::similarity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Similarity").build()).build();

    private static final SdkField<ComparedFace> FACE_FIELD = SdkField.<ComparedFace> builder(MarshallingType.SDK_POJO)
            .memberName("Face").getter(getter(CompareFacesMatch::face)).setter(setter(Builder::face))
            .constructor(ComparedFace::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Face").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIMILARITY_FIELD, FACE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Float similarity;

    private final ComparedFace face;

    private CompareFacesMatch(BuilderImpl builder) {
        this.similarity = builder.similarity;
        this.face = builder.face;
    }

    /**
     * <p>
     * Level of confidence that the faces match.
     * </p>
     * 
     * @return Level of confidence that the faces match.
     */
    public final Float similarity() {
        return similarity;
    }

    /**
     * <p>
     * Provides face metadata (bounding box and confidence that the bounding box actually contains a face).
     * </p>
     * 
     * @return Provides face metadata (bounding box and confidence that the bounding box actually contains a face).
     */
    public final ComparedFace face() {
        return face;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(similarity());
        hashCode = 31 * hashCode + Objects.hashCode(face());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompareFacesMatch)) {
            return false;
        }
        CompareFacesMatch other = (CompareFacesMatch) obj;
        return Objects.equals(similarity(), other.similarity()) && Objects.equals(face(), other.face());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CompareFacesMatch").add("Similarity", similarity()).add("Face", face()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Similarity":
            return Optional.ofNullable(clazz.cast(similarity()));
        case "Face":
            return Optional.ofNullable(clazz.cast(face()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CompareFacesMatch, T> g) {
        return obj -> g.apply((CompareFacesMatch) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CompareFacesMatch> {
        /**
         * <p>
         * Level of confidence that the faces match.
         * </p>
         * 
         * @param similarity
         *        Level of confidence that the faces match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder similarity(Float similarity);

        /**
         * <p>
         * Provides face metadata (bounding box and confidence that the bounding box actually contains a face).
         * </p>
         * 
         * @param face
         *        Provides face metadata (bounding box and confidence that the bounding box actually contains a face).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder face(ComparedFace face);

        /**
         * <p>
         * Provides face metadata (bounding box and confidence that the bounding box actually contains a face).
         * </p>
         * This is a convenience method that creates an instance of the {@link ComparedFace.Builder} avoiding the need
         * to create one manually via {@link ComparedFace#builder()}.
         *
         * When the {@link Consumer} completes, {@link ComparedFace.Builder#build()} is called immediately and its
         * result is passed to {@link #face(ComparedFace)}.
         * 
         * @param face
         *        a consumer that will call methods on {@link ComparedFace.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #face(ComparedFace)
         */
        default Builder face(Consumer<ComparedFace.Builder> face) {
            return face(ComparedFace.builder().applyMutation(face).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Float similarity;

        private ComparedFace face;

        private BuilderImpl() {
        }

        private BuilderImpl(CompareFacesMatch model) {
            similarity(model.similarity);
            face(model.face);
        }

        public final Float getSimilarity() {
            return similarity;
        }

        public final void setSimilarity(Float similarity) {
            this.similarity = similarity;
        }

        @Override
        public final Builder similarity(Float similarity) {
            this.similarity = similarity;
            return this;
        }

        public final ComparedFace.Builder getFace() {
            return face != null ? face.toBuilder() : null;
        }

        public final void setFace(ComparedFace.BuilderImpl face) {
            this.face = face != null ? face.build() : null;
        }

        @Override
        public final Builder face(ComparedFace face) {
            this.face = face;
            return this;
        }

        @Override
        public CompareFacesMatch build() {
            return new CompareFacesMatch(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
