/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStreamProcessorResponse extends RekognitionResponse implements
        ToCopyableBuilder<DescribeStreamProcessorResponse.Builder, DescribeStreamProcessorResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribeStreamProcessorResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STREAM_PROCESSOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamProcessorArn").getter(getter(DescribeStreamProcessorResponse::streamProcessorArn))
            .setter(setter(Builder::streamProcessorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamProcessorArn").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeStreamProcessorResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(DescribeStreamProcessorResponse::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimestamp").getter(getter(DescribeStreamProcessorResponse::creationTimestamp))
            .setter(setter(Builder::creationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdateTimestamp").getter(getter(DescribeStreamProcessorResponse::lastUpdateTimestamp))
            .setter(setter(Builder::lastUpdateTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTimestamp").build())
            .build();

    private static final SdkField<StreamProcessorInput> INPUT_FIELD = SdkField
            .<StreamProcessorInput> builder(MarshallingType.SDK_POJO).memberName("Input")
            .getter(getter(DescribeStreamProcessorResponse::input)).setter(setter(Builder::input))
            .constructor(StreamProcessorInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Input").build()).build();

    private static final SdkField<StreamProcessorOutput> OUTPUT_FIELD = SdkField
            .<StreamProcessorOutput> builder(MarshallingType.SDK_POJO).memberName("Output")
            .getter(getter(DescribeStreamProcessorResponse::output)).setter(setter(Builder::output))
            .constructor(StreamProcessorOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Output").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DescribeStreamProcessorResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<StreamProcessorSettings> SETTINGS_FIELD = SdkField
            .<StreamProcessorSettings> builder(MarshallingType.SDK_POJO).memberName("Settings")
            .getter(getter(DescribeStreamProcessorResponse::settings)).setter(setter(Builder::settings))
            .constructor(StreamProcessorSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()).build();

    private static final SdkField<StreamProcessorNotificationChannel> NOTIFICATION_CHANNEL_FIELD = SdkField
            .<StreamProcessorNotificationChannel> builder(MarshallingType.SDK_POJO).memberName("NotificationChannel")
            .getter(getter(DescribeStreamProcessorResponse::notificationChannel)).setter(setter(Builder::notificationChannel))
            .constructor(StreamProcessorNotificationChannel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationChannel").build())
            .build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(DescribeStreamProcessorResponse::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<List<RegionOfInterest>> REGIONS_OF_INTEREST_FIELD = SdkField
            .<List<RegionOfInterest>> builder(MarshallingType.LIST)
            .memberName("RegionsOfInterest")
            .getter(getter(DescribeStreamProcessorResponse::regionsOfInterest))
            .setter(setter(Builder::regionsOfInterest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionsOfInterest").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RegionOfInterest> builder(MarshallingType.SDK_POJO)
                                            .constructor(RegionOfInterest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<StreamProcessorDataSharingPreference> DATA_SHARING_PREFERENCE_FIELD = SdkField
            .<StreamProcessorDataSharingPreference> builder(MarshallingType.SDK_POJO).memberName("DataSharingPreference")
            .getter(getter(DescribeStreamProcessorResponse::dataSharingPreference))
            .setter(setter(Builder::dataSharingPreference)).constructor(StreamProcessorDataSharingPreference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSharingPreference").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            STREAM_PROCESSOR_ARN_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, CREATION_TIMESTAMP_FIELD,
            LAST_UPDATE_TIMESTAMP_FIELD, INPUT_FIELD, OUTPUT_FIELD, ROLE_ARN_FIELD, SETTINGS_FIELD, NOTIFICATION_CHANNEL_FIELD,
            KMS_KEY_ID_FIELD, REGIONS_OF_INTEREST_FIELD, DATA_SHARING_PREFERENCE_FIELD));

    private final String name;

    private final String streamProcessorArn;

    private final String status;

    private final String statusMessage;

    private final Instant creationTimestamp;

    private final Instant lastUpdateTimestamp;

    private final StreamProcessorInput input;

    private final StreamProcessorOutput output;

    private final String roleArn;

    private final StreamProcessorSettings settings;

    private final StreamProcessorNotificationChannel notificationChannel;

    private final String kmsKeyId;

    private final List<RegionOfInterest> regionsOfInterest;

    private final StreamProcessorDataSharingPreference dataSharingPreference;

    private DescribeStreamProcessorResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.streamProcessorArn = builder.streamProcessorArn;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.creationTimestamp = builder.creationTimestamp;
        this.lastUpdateTimestamp = builder.lastUpdateTimestamp;
        this.input = builder.input;
        this.output = builder.output;
        this.roleArn = builder.roleArn;
        this.settings = builder.settings;
        this.notificationChannel = builder.notificationChannel;
        this.kmsKeyId = builder.kmsKeyId;
        this.regionsOfInterest = builder.regionsOfInterest;
        this.dataSharingPreference = builder.dataSharingPreference;
    }

    /**
     * <p>
     * Name of the stream processor.
     * </p>
     * 
     * @return Name of the stream processor.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * ARN of the stream processor.
     * </p>
     * 
     * @return ARN of the stream processor.
     */
    public final String streamProcessorArn() {
        return streamProcessorArn;
    }

    /**
     * <p>
     * Current status of the stream processor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StreamProcessorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Current status of the stream processor.
     * @see StreamProcessorStatus
     */
    public final StreamProcessorStatus status() {
        return StreamProcessorStatus.fromValue(status);
    }

    /**
     * <p>
     * Current status of the stream processor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StreamProcessorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Current status of the stream processor.
     * @see StreamProcessorStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Detailed status message about the stream processor.
     * </p>
     * 
     * @return Detailed status message about the stream processor.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * Date and time the stream processor was created
     * </p>
     * 
     * @return Date and time the stream processor was created
     */
    public final Instant creationTimestamp() {
        return creationTimestamp;
    }

    /**
     * <p>
     * The time, in Unix format, the stream processor was last updated. For example, when the stream processor moves
     * from a running state to a failed state, or when the user starts or stops the stream processor.
     * </p>
     * 
     * @return The time, in Unix format, the stream processor was last updated. For example, when the stream processor
     *         moves from a running state to a failed state, or when the user starts or stops the stream processor.
     */
    public final Instant lastUpdateTimestamp() {
        return lastUpdateTimestamp;
    }

    /**
     * <p>
     * Kinesis video stream that provides the source streaming video.
     * </p>
     * 
     * @return Kinesis video stream that provides the source streaming video.
     */
    public final StreamProcessorInput input() {
        return input;
    }

    /**
     * <p>
     * Kinesis data stream to which Amazon Rekognition Video puts the analysis results.
     * </p>
     * 
     * @return Kinesis data stream to which Amazon Rekognition Video puts the analysis results.
     */
    public final StreamProcessorOutput output() {
        return output;
    }

    /**
     * <p>
     * ARN of the IAM role that allows access to the stream processor.
     * </p>
     * 
     * @return ARN of the IAM role that allows access to the stream processor.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Input parameters used in a streaming video analyzed by a stream processor. You can use <code>FaceSearch</code> to
     * recognize faces in a streaming video, or you can use <code>ConnectedHome</code> to detect labels.
     * </p>
     * 
     * @return Input parameters used in a streaming video analyzed by a stream processor. You can use
     *         <code>FaceSearch</code> to recognize faces in a streaming video, or you can use
     *         <code>ConnectedHome</code> to detect labels.
     */
    public final StreamProcessorSettings settings() {
        return settings;
    }

    /**
     * Returns the value of the NotificationChannel property for this object.
     * 
     * @return The value of the NotificationChannel property for this object.
     */
    public final StreamProcessorNotificationChannel notificationChannel() {
        return notificationChannel;
    }

    /**
     * <p>
     * The identifier for your AWS Key Management Service key (AWS KMS key). This is an optional parameter for label
     * detection stream processors.
     * </p>
     * 
     * @return The identifier for your AWS Key Management Service key (AWS KMS key). This is an optional parameter for
     *         label detection stream processors.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * For responses, this returns true if the service returned a value for the RegionsOfInterest property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRegionsOfInterest() {
        return regionsOfInterest != null && !(regionsOfInterest instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies locations in the frames where Amazon Rekognition checks for objects or people. This is an optional
     * parameter for label detection stream processors.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegionsOfInterest} method.
     * </p>
     * 
     * @return Specifies locations in the frames where Amazon Rekognition checks for objects or people. This is an
     *         optional parameter for label detection stream processors.
     */
    public final List<RegionOfInterest> regionsOfInterest() {
        return regionsOfInterest;
    }

    /**
     * <p>
     * Shows whether you are sharing data with Rekognition to improve model performance. You can choose this option at
     * the account level or on a per-stream basis. Note that if you opt out at the account level this setting is ignored
     * on individual streams.
     * </p>
     * 
     * @return Shows whether you are sharing data with Rekognition to improve model performance. You can choose this
     *         option at the account level or on a per-stream basis. Note that if you opt out at the account level this
     *         setting is ignored on individual streams.
     */
    public final StreamProcessorDataSharingPreference dataSharingPreference() {
        return dataSharingPreference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(streamProcessorArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(output());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(settings());
        hashCode = 31 * hashCode + Objects.hashCode(notificationChannel());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasRegionsOfInterest() ? regionsOfInterest() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dataSharingPreference());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStreamProcessorResponse)) {
            return false;
        }
        DescribeStreamProcessorResponse other = (DescribeStreamProcessorResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(streamProcessorArn(), other.streamProcessorArn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(creationTimestamp(), other.creationTimestamp())
                && Objects.equals(lastUpdateTimestamp(), other.lastUpdateTimestamp()) && Objects.equals(input(), other.input())
                && Objects.equals(output(), other.output()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(settings(), other.settings())
                && Objects.equals(notificationChannel(), other.notificationChannel())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && hasRegionsOfInterest() == other.hasRegionsOfInterest()
                && Objects.equals(regionsOfInterest(), other.regionsOfInterest())
                && Objects.equals(dataSharingPreference(), other.dataSharingPreference());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeStreamProcessorResponse").add("Name", name())
                .add("StreamProcessorArn", streamProcessorArn()).add("Status", statusAsString())
                .add("StatusMessage", statusMessage()).add("CreationTimestamp", creationTimestamp())
                .add("LastUpdateTimestamp", lastUpdateTimestamp()).add("Input", input()).add("Output", output())
                .add("RoleArn", roleArn()).add("Settings", settings()).add("NotificationChannel", notificationChannel())
                .add("KmsKeyId", kmsKeyId()).add("RegionsOfInterest", hasRegionsOfInterest() ? regionsOfInterest() : null)
                .add("DataSharingPreference", dataSharingPreference()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "StreamProcessorArn":
            return Optional.ofNullable(clazz.cast(streamProcessorArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "CreationTimestamp":
            return Optional.ofNullable(clazz.cast(creationTimestamp()));
        case "LastUpdateTimestamp":
            return Optional.ofNullable(clazz.cast(lastUpdateTimestamp()));
        case "Input":
            return Optional.ofNullable(clazz.cast(input()));
        case "Output":
            return Optional.ofNullable(clazz.cast(output()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Settings":
            return Optional.ofNullable(clazz.cast(settings()));
        case "NotificationChannel":
            return Optional.ofNullable(clazz.cast(notificationChannel()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "RegionsOfInterest":
            return Optional.ofNullable(clazz.cast(regionsOfInterest()));
        case "DataSharingPreference":
            return Optional.ofNullable(clazz.cast(dataSharingPreference()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStreamProcessorResponse, T> g) {
        return obj -> g.apply((DescribeStreamProcessorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeStreamProcessorResponse> {
        /**
         * <p>
         * Name of the stream processor.
         * </p>
         * 
         * @param name
         *        Name of the stream processor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * ARN of the stream processor.
         * </p>
         * 
         * @param streamProcessorArn
         *        ARN of the stream processor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamProcessorArn(String streamProcessorArn);

        /**
         * <p>
         * Current status of the stream processor.
         * </p>
         * 
         * @param status
         *        Current status of the stream processor.
         * @see StreamProcessorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamProcessorStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Current status of the stream processor.
         * </p>
         * 
         * @param status
         *        Current status of the stream processor.
         * @see StreamProcessorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamProcessorStatus
         */
        Builder status(StreamProcessorStatus status);

        /**
         * <p>
         * Detailed status message about the stream processor.
         * </p>
         * 
         * @param statusMessage
         *        Detailed status message about the stream processor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * Date and time the stream processor was created
         * </p>
         * 
         * @param creationTimestamp
         *        Date and time the stream processor was created
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimestamp(Instant creationTimestamp);

        /**
         * <p>
         * The time, in Unix format, the stream processor was last updated. For example, when the stream processor moves
         * from a running state to a failed state, or when the user starts or stops the stream processor.
         * </p>
         * 
         * @param lastUpdateTimestamp
         *        The time, in Unix format, the stream processor was last updated. For example, when the stream
         *        processor moves from a running state to a failed state, or when the user starts or stops the stream
         *        processor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTimestamp(Instant lastUpdateTimestamp);

        /**
         * <p>
         * Kinesis video stream that provides the source streaming video.
         * </p>
         * 
         * @param input
         *        Kinesis video stream that provides the source streaming video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(StreamProcessorInput input);

        /**
         * <p>
         * Kinesis video stream that provides the source streaming video.
         * </p>
         * This is a convenience method that creates an instance of the {@link StreamProcessorInput.Builder} avoiding
         * the need to create one manually via {@link StreamProcessorInput#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamProcessorInput.Builder#build()} is called immediately and
         * its result is passed to {@link #input(StreamProcessorInput)}.
         * 
         * @param input
         *        a consumer that will call methods on {@link StreamProcessorInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #input(StreamProcessorInput)
         */
        default Builder input(Consumer<StreamProcessorInput.Builder> input) {
            return input(StreamProcessorInput.builder().applyMutation(input).build());
        }

        /**
         * <p>
         * Kinesis data stream to which Amazon Rekognition Video puts the analysis results.
         * </p>
         * 
         * @param output
         *        Kinesis data stream to which Amazon Rekognition Video puts the analysis results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder output(StreamProcessorOutput output);

        /**
         * <p>
         * Kinesis data stream to which Amazon Rekognition Video puts the analysis results.
         * </p>
         * This is a convenience method that creates an instance of the {@link StreamProcessorOutput.Builder} avoiding
         * the need to create one manually via {@link StreamProcessorOutput#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamProcessorOutput.Builder#build()} is called immediately and
         * its result is passed to {@link #output(StreamProcessorOutput)}.
         * 
         * @param output
         *        a consumer that will call methods on {@link StreamProcessorOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #output(StreamProcessorOutput)
         */
        default Builder output(Consumer<StreamProcessorOutput.Builder> output) {
            return output(StreamProcessorOutput.builder().applyMutation(output).build());
        }

        /**
         * <p>
         * ARN of the IAM role that allows access to the stream processor.
         * </p>
         * 
         * @param roleArn
         *        ARN of the IAM role that allows access to the stream processor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Input parameters used in a streaming video analyzed by a stream processor. You can use
         * <code>FaceSearch</code> to recognize faces in a streaming video, or you can use <code>ConnectedHome</code> to
         * detect labels.
         * </p>
         * 
         * @param settings
         *        Input parameters used in a streaming video analyzed by a stream processor. You can use
         *        <code>FaceSearch</code> to recognize faces in a streaming video, or you can use
         *        <code>ConnectedHome</code> to detect labels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(StreamProcessorSettings settings);

        /**
         * <p>
         * Input parameters used in a streaming video analyzed by a stream processor. You can use
         * <code>FaceSearch</code> to recognize faces in a streaming video, or you can use <code>ConnectedHome</code> to
         * detect labels.
         * </p>
         * This is a convenience method that creates an instance of the {@link StreamProcessorSettings.Builder} avoiding
         * the need to create one manually via {@link StreamProcessorSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamProcessorSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #settings(StreamProcessorSettings)}.
         * 
         * @param settings
         *        a consumer that will call methods on {@link StreamProcessorSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #settings(StreamProcessorSettings)
         */
        default Builder settings(Consumer<StreamProcessorSettings.Builder> settings) {
            return settings(StreamProcessorSettings.builder().applyMutation(settings).build());
        }

        /**
         * Sets the value of the NotificationChannel property for this object.
         *
         * @param notificationChannel
         *        The new value for the NotificationChannel property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationChannel(StreamProcessorNotificationChannel notificationChannel);

        /**
         * Sets the value of the NotificationChannel property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link StreamProcessorNotificationChannel.Builder} avoiding the need to create one manually via
         * {@link StreamProcessorNotificationChannel#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamProcessorNotificationChannel.Builder#build()} is called
         * immediately and its result is passed to {@link #notificationChannel(StreamProcessorNotificationChannel)}.
         * 
         * @param notificationChannel
         *        a consumer that will call methods on {@link StreamProcessorNotificationChannel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notificationChannel(StreamProcessorNotificationChannel)
         */
        default Builder notificationChannel(Consumer<StreamProcessorNotificationChannel.Builder> notificationChannel) {
            return notificationChannel(StreamProcessorNotificationChannel.builder().applyMutation(notificationChannel).build());
        }

        /**
         * <p>
         * The identifier for your AWS Key Management Service key (AWS KMS key). This is an optional parameter for label
         * detection stream processors.
         * </p>
         * 
         * @param kmsKeyId
         *        The identifier for your AWS Key Management Service key (AWS KMS key). This is an optional parameter
         *        for label detection stream processors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * Specifies locations in the frames where Amazon Rekognition checks for objects or people. This is an optional
         * parameter for label detection stream processors.
         * </p>
         * 
         * @param regionsOfInterest
         *        Specifies locations in the frames where Amazon Rekognition checks for objects or people. This is an
         *        optional parameter for label detection stream processors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionsOfInterest(Collection<RegionOfInterest> regionsOfInterest);

        /**
         * <p>
         * Specifies locations in the frames where Amazon Rekognition checks for objects or people. This is an optional
         * parameter for label detection stream processors.
         * </p>
         * 
         * @param regionsOfInterest
         *        Specifies locations in the frames where Amazon Rekognition checks for objects or people. This is an
         *        optional parameter for label detection stream processors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionsOfInterest(RegionOfInterest... regionsOfInterest);

        /**
         * <p>
         * Specifies locations in the frames where Amazon Rekognition checks for objects or people. This is an optional
         * parameter for label detection stream processors.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<RegionOfInterest>.Builder} avoiding
         * the need to create one manually via {@link List<RegionOfInterest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RegionOfInterest>.Builder#build()} is called immediately and
         * its result is passed to {@link #regionsOfInterest(List<RegionOfInterest>)}.
         * 
         * @param regionsOfInterest
         *        a consumer that will call methods on {@link List<RegionOfInterest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #regionsOfInterest(List<RegionOfInterest>)
         */
        Builder regionsOfInterest(Consumer<RegionOfInterest.Builder>... regionsOfInterest);

        /**
         * <p>
         * Shows whether you are sharing data with Rekognition to improve model performance. You can choose this option
         * at the account level or on a per-stream basis. Note that if you opt out at the account level this setting is
         * ignored on individual streams.
         * </p>
         * 
         * @param dataSharingPreference
         *        Shows whether you are sharing data with Rekognition to improve model performance. You can choose this
         *        option at the account level or on a per-stream basis. Note that if you opt out at the account level
         *        this setting is ignored on individual streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSharingPreference(StreamProcessorDataSharingPreference dataSharingPreference);

        /**
         * <p>
         * Shows whether you are sharing data with Rekognition to improve model performance. You can choose this option
         * at the account level or on a per-stream basis. Note that if you opt out at the account level this setting is
         * ignored on individual streams.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link StreamProcessorDataSharingPreference.Builder} avoiding the need to create one manually via
         * {@link StreamProcessorDataSharingPreference#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamProcessorDataSharingPreference.Builder#build()} is called
         * immediately and its result is passed to {@link #dataSharingPreference(StreamProcessorDataSharingPreference)}.
         * 
         * @param dataSharingPreference
         *        a consumer that will call methods on {@link StreamProcessorDataSharingPreference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSharingPreference(StreamProcessorDataSharingPreference)
         */
        default Builder dataSharingPreference(Consumer<StreamProcessorDataSharingPreference.Builder> dataSharingPreference) {
            return dataSharingPreference(StreamProcessorDataSharingPreference.builder().applyMutation(dataSharingPreference)
                    .build());
        }
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private String name;

        private String streamProcessorArn;

        private String status;

        private String statusMessage;

        private Instant creationTimestamp;

        private Instant lastUpdateTimestamp;

        private StreamProcessorInput input;

        private StreamProcessorOutput output;

        private String roleArn;

        private StreamProcessorSettings settings;

        private StreamProcessorNotificationChannel notificationChannel;

        private String kmsKeyId;

        private List<RegionOfInterest> regionsOfInterest = DefaultSdkAutoConstructList.getInstance();

        private StreamProcessorDataSharingPreference dataSharingPreference;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStreamProcessorResponse model) {
            super(model);
            name(model.name);
            streamProcessorArn(model.streamProcessorArn);
            status(model.status);
            statusMessage(model.statusMessage);
            creationTimestamp(model.creationTimestamp);
            lastUpdateTimestamp(model.lastUpdateTimestamp);
            input(model.input);
            output(model.output);
            roleArn(model.roleArn);
            settings(model.settings);
            notificationChannel(model.notificationChannel);
            kmsKeyId(model.kmsKeyId);
            regionsOfInterest(model.regionsOfInterest);
            dataSharingPreference(model.dataSharingPreference);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStreamProcessorArn() {
            return streamProcessorArn;
        }

        public final void setStreamProcessorArn(String streamProcessorArn) {
            this.streamProcessorArn = streamProcessorArn;
        }

        @Override
        public final Builder streamProcessorArn(String streamProcessorArn) {
            this.streamProcessorArn = streamProcessorArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StreamProcessorStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getCreationTimestamp() {
            return creationTimestamp;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final Instant getLastUpdateTimestamp() {
            return lastUpdateTimestamp;
        }

        public final void setLastUpdateTimestamp(Instant lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
        }

        @Override
        public final Builder lastUpdateTimestamp(Instant lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
            return this;
        }

        public final StreamProcessorInput.Builder getInput() {
            return input != null ? input.toBuilder() : null;
        }

        public final void setInput(StreamProcessorInput.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        @Override
        public final Builder input(StreamProcessorInput input) {
            this.input = input;
            return this;
        }

        public final StreamProcessorOutput.Builder getOutput() {
            return output != null ? output.toBuilder() : null;
        }

        public final void setOutput(StreamProcessorOutput.BuilderImpl output) {
            this.output = output != null ? output.build() : null;
        }

        @Override
        public final Builder output(StreamProcessorOutput output) {
            this.output = output;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final StreamProcessorSettings.Builder getSettings() {
            return settings != null ? settings.toBuilder() : null;
        }

        public final void setSettings(StreamProcessorSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(StreamProcessorSettings settings) {
            this.settings = settings;
            return this;
        }

        public final StreamProcessorNotificationChannel.Builder getNotificationChannel() {
            return notificationChannel != null ? notificationChannel.toBuilder() : null;
        }

        public final void setNotificationChannel(StreamProcessorNotificationChannel.BuilderImpl notificationChannel) {
            this.notificationChannel = notificationChannel != null ? notificationChannel.build() : null;
        }

        @Override
        public final Builder notificationChannel(StreamProcessorNotificationChannel notificationChannel) {
            this.notificationChannel = notificationChannel;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final List<RegionOfInterest.Builder> getRegionsOfInterest() {
            List<RegionOfInterest.Builder> result = RegionsOfInterestCopier.copyToBuilder(this.regionsOfInterest);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegionsOfInterest(Collection<RegionOfInterest.BuilderImpl> regionsOfInterest) {
            this.regionsOfInterest = RegionsOfInterestCopier.copyFromBuilder(regionsOfInterest);
        }

        @Override
        public final Builder regionsOfInterest(Collection<RegionOfInterest> regionsOfInterest) {
            this.regionsOfInterest = RegionsOfInterestCopier.copy(regionsOfInterest);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionsOfInterest(RegionOfInterest... regionsOfInterest) {
            regionsOfInterest(Arrays.asList(regionsOfInterest));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionsOfInterest(Consumer<RegionOfInterest.Builder>... regionsOfInterest) {
            regionsOfInterest(Stream.of(regionsOfInterest).map(c -> RegionOfInterest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final StreamProcessorDataSharingPreference.Builder getDataSharingPreference() {
            return dataSharingPreference != null ? dataSharingPreference.toBuilder() : null;
        }

        public final void setDataSharingPreference(StreamProcessorDataSharingPreference.BuilderImpl dataSharingPreference) {
            this.dataSharingPreference = dataSharingPreference != null ? dataSharingPreference.build() : null;
        }

        @Override
        public final Builder dataSharingPreference(StreamProcessorDataSharingPreference dataSharingPreference) {
            this.dataSharingPreference = dataSharingPreference;
            return this;
        }

        @Override
        public DescribeStreamProcessorResponse build() {
            return new DescribeStreamProcessorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
