/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.BoundingBox;
import software.amazon.awssdk.services.rekognition.model.ImageQuality;
import software.amazon.awssdk.services.rekognition.model.Landmark;
import software.amazon.awssdk.services.rekognition.model.LandmarksCopier;
import software.amazon.awssdk.services.rekognition.model.Pose;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComparedFace
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComparedFace> {
    private static final SdkField<BoundingBox> BOUNDING_BOX_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BoundingBox").getter(ComparedFace.getter(ComparedFace::boundingBox)).setter(ComparedFace.setter(Builder::boundingBox)).constructor(BoundingBox::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BoundingBox").build()}).build();
    private static final SdkField<Float> CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Confidence").getter(ComparedFace.getter(ComparedFace::confidence)).setter(ComparedFace.setter(Builder::confidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()}).build();
    private static final SdkField<List<Landmark>> LANDMARKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Landmarks").getter(ComparedFace.getter(ComparedFace::landmarks)).setter(ComparedFace.setter(Builder::landmarks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Landmarks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Landmark::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Pose> POSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Pose").getter(ComparedFace.getter(ComparedFace::pose)).setter(ComparedFace.setter(Builder::pose)).constructor(Pose::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pose").build()}).build();
    private static final SdkField<ImageQuality> QUALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Quality").getter(ComparedFace.getter(ComparedFace::quality)).setter(ComparedFace.setter(Builder::quality)).constructor(ImageQuality::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quality").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOUNDING_BOX_FIELD, CONFIDENCE_FIELD, LANDMARKS_FIELD, POSE_FIELD, QUALITY_FIELD));
    private static final long serialVersionUID = 1L;
    private final BoundingBox boundingBox;
    private final Float confidence;
    private final List<Landmark> landmarks;
    private final Pose pose;
    private final ImageQuality quality;

    private ComparedFace(BuilderImpl builder) {
        this.boundingBox = builder.boundingBox;
        this.confidence = builder.confidence;
        this.landmarks = builder.landmarks;
        this.pose = builder.pose;
        this.quality = builder.quality;
    }

    public final BoundingBox boundingBox() {
        return this.boundingBox;
    }

    public final Float confidence() {
        return this.confidence;
    }

    public final boolean hasLandmarks() {
        return this.landmarks != null && !(this.landmarks instanceof SdkAutoConstructList);
    }

    public final List<Landmark> landmarks() {
        return this.landmarks;
    }

    public final Pose pose() {
        return this.pose;
    }

    public final ImageQuality quality() {
        return this.quality;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.boundingBox());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLandmarks() ? this.landmarks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.pose());
        hashCode = 31 * hashCode + Objects.hashCode(this.quality());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComparedFace)) {
            return false;
        }
        ComparedFace other = (ComparedFace)obj;
        return Objects.equals(this.boundingBox(), other.boundingBox()) && Objects.equals(this.confidence(), other.confidence()) && this.hasLandmarks() == other.hasLandmarks() && Objects.equals(this.landmarks(), other.landmarks()) && Objects.equals(this.pose(), other.pose()) && Objects.equals(this.quality(), other.quality());
    }

    public final String toString() {
        return ToString.builder((String)"ComparedFace").add("BoundingBox", (Object)this.boundingBox()).add("Confidence", (Object)this.confidence()).add("Landmarks", this.hasLandmarks() ? this.landmarks() : null).add("Pose", (Object)this.pose()).add("Quality", (Object)this.quality()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BoundingBox": {
                return Optional.ofNullable(clazz.cast(this.boundingBox()));
            }
            case "Confidence": {
                return Optional.ofNullable(clazz.cast(this.confidence()));
            }
            case "Landmarks": {
                return Optional.ofNullable(clazz.cast(this.landmarks()));
            }
            case "Pose": {
                return Optional.ofNullable(clazz.cast(this.pose()));
            }
            case "Quality": {
                return Optional.ofNullable(clazz.cast(this.quality()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComparedFace, T> g) {
        return obj -> g.apply((ComparedFace)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private BoundingBox boundingBox;
        private Float confidence;
        private List<Landmark> landmarks = DefaultSdkAutoConstructList.getInstance();
        private Pose pose;
        private ImageQuality quality;

        private BuilderImpl() {
        }

        private BuilderImpl(ComparedFace model) {
            this.boundingBox(model.boundingBox);
            this.confidence(model.confidence);
            this.landmarks(model.landmarks);
            this.pose(model.pose);
            this.quality(model.quality);
        }

        public final BoundingBox.Builder getBoundingBox() {
            return this.boundingBox != null ? this.boundingBox.toBuilder() : null;
        }

        public final void setBoundingBox(BoundingBox.BuilderImpl boundingBox) {
            this.boundingBox = boundingBox != null ? boundingBox.build() : null;
        }

        @Override
        @Transient
        public final Builder boundingBox(BoundingBox boundingBox) {
            this.boundingBox = boundingBox;
            return this;
        }

        public final Float getConfidence() {
            return this.confidence;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        @Transient
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final List<Landmark.Builder> getLandmarks() {
            List<Landmark.Builder> result = LandmarksCopier.copyToBuilder(this.landmarks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLandmarks(Collection<Landmark.BuilderImpl> landmarks) {
            this.landmarks = LandmarksCopier.copyFromBuilder(landmarks);
        }

        @Override
        @Transient
        public final Builder landmarks(Collection<Landmark> landmarks) {
            this.landmarks = LandmarksCopier.copy(landmarks);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder landmarks(Landmark ... landmarks) {
            this.landmarks(Arrays.asList(landmarks));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder landmarks(Consumer<Landmark.Builder> ... landmarks) {
            this.landmarks(Stream.of(landmarks).map(c -> (Landmark)((Landmark.Builder)Landmark.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Pose.Builder getPose() {
            return this.pose != null ? this.pose.toBuilder() : null;
        }

        public final void setPose(Pose.BuilderImpl pose) {
            this.pose = pose != null ? pose.build() : null;
        }

        @Override
        @Transient
        public final Builder pose(Pose pose) {
            this.pose = pose;
            return this;
        }

        public final ImageQuality.Builder getQuality() {
            return this.quality != null ? this.quality.toBuilder() : null;
        }

        public final void setQuality(ImageQuality.BuilderImpl quality) {
            this.quality = quality != null ? quality.build() : null;
        }

        @Override
        @Transient
        public final Builder quality(ImageQuality quality) {
            this.quality = quality;
            return this;
        }

        public ComparedFace build() {
            return new ComparedFace(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComparedFace> {
        public Builder boundingBox(BoundingBox var1);

        default public Builder boundingBox(Consumer<BoundingBox.Builder> boundingBox) {
            return this.boundingBox((BoundingBox)((BoundingBox.Builder)BoundingBox.builder().applyMutation(boundingBox)).build());
        }

        public Builder confidence(Float var1);

        public Builder landmarks(Collection<Landmark> var1);

        public Builder landmarks(Landmark ... var1);

        public Builder landmarks(Consumer<Landmark.Builder> ... var1);

        public Builder pose(Pose var1);

        default public Builder pose(Consumer<Pose.Builder> pose) {
            return this.pose((Pose)((Pose.Builder)Pose.builder().applyMutation(pose)).build());
        }

        public Builder quality(ImageQuality var1);

        default public Builder quality(Consumer<ImageQuality.Builder> quality) {
            return this.quality((ImageQuality)((ImageQuality.Builder)ImageQuality.builder().applyMutation(quality)).build());
        }
    }
}

