/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a face detected in a video analysis request and the time the face was detected in the video.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FaceDetection implements SdkPojo, Serializable, ToCopyableBuilder<FaceDetection.Builder, FaceDetection> {
    private static final SdkField<Long> TIMESTAMP_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Timestamp")
            .getter(getter(FaceDetection::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final SdkField<FaceDetail> FACE_FIELD = SdkField.<FaceDetail> builder(MarshallingType.SDK_POJO)
            .memberName("Face").getter(getter(FaceDetection::face)).setter(setter(Builder::face))
            .constructor(FaceDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Face").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD, FACE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long timestamp;

    private final FaceDetail face;

    private FaceDetection(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.face = builder.face;
    }

    /**
     * <p>
     * Time, in milliseconds from the start of the video, that the face was detected.
     * </p>
     * 
     * @return Time, in milliseconds from the start of the video, that the face was detected.
     */
    public final Long timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The face properties for the detected face.
     * </p>
     * 
     * @return The face properties for the detected face.
     */
    public final FaceDetail face() {
        return face;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(face());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FaceDetection)) {
            return false;
        }
        FaceDetection other = (FaceDetection) obj;
        return Objects.equals(timestamp(), other.timestamp()) && Objects.equals(face(), other.face());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FaceDetection").add("Timestamp", timestamp()).add("Face", face()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "Face":
            return Optional.ofNullable(clazz.cast(face()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FaceDetection, T> g) {
        return obj -> g.apply((FaceDetection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FaceDetection> {
        /**
         * <p>
         * Time, in milliseconds from the start of the video, that the face was detected.
         * </p>
         * 
         * @param timestamp
         *        Time, in milliseconds from the start of the video, that the face was detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Long timestamp);

        /**
         * <p>
         * The face properties for the detected face.
         * </p>
         * 
         * @param face
         *        The face properties for the detected face.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder face(FaceDetail face);

        /**
         * <p>
         * The face properties for the detected face.
         * </p>
         * This is a convenience method that creates an instance of the {@link FaceDetail.Builder} avoiding the need to
         * create one manually via {@link FaceDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link FaceDetail.Builder#build()} is called immediately and its result
         * is passed to {@link #face(FaceDetail)}.
         * 
         * @param face
         *        a consumer that will call methods on {@link FaceDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #face(FaceDetail)
         */
        default Builder face(Consumer<FaceDetail.Builder> face) {
            return face(FaceDetail.builder().applyMutation(face).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Long timestamp;

        private FaceDetail face;

        private BuilderImpl() {
        }

        private BuilderImpl(FaceDetection model) {
            timestamp(model.timestamp);
            face(model.face);
        }

        public final Long getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final FaceDetail.Builder getFace() {
            return face != null ? face.toBuilder() : null;
        }

        public final void setFace(FaceDetail.BuilderImpl face) {
            this.face = face != null ? face.build() : null;
        }

        @Override
        public final Builder face(FaceDetail face) {
            this.face = face;
            return this;
        }

        @Override
        public FaceDetection build() {
            return new FaceDetection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
