/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a celebrity recognized by the <a>RecognizeCelebrities</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Celebrity implements SdkPojo, Serializable, ToCopyableBuilder<Celebrity.Builder, Celebrity> {
    private static final SdkField<List<String>> URLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Urls")
            .getter(getter(Celebrity::urls))
            .setter(setter(Builder::urls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Urls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Celebrity::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(Celebrity::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<ComparedFace> FACE_FIELD = SdkField.<ComparedFace> builder(MarshallingType.SDK_POJO)
            .memberName("Face").getter(getter(Celebrity::face)).setter(setter(Builder::face)).constructor(ComparedFace::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Face").build()).build();

    private static final SdkField<Float> MATCH_CONFIDENCE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("MatchConfidence").getter(getter(Celebrity::matchConfidence)).setter(setter(Builder::matchConfidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchConfidence").build()).build();

    private static final SdkField<KnownGender> KNOWN_GENDER_FIELD = SdkField.<KnownGender> builder(MarshallingType.SDK_POJO)
            .memberName("KnownGender").getter(getter(Celebrity::knownGender)).setter(setter(Builder::knownGender))
            .constructor(KnownGender::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KnownGender").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URLS_FIELD, NAME_FIELD,
            ID_FIELD, FACE_FIELD, MATCH_CONFIDENCE_FIELD, KNOWN_GENDER_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> urls;

    private final String name;

    private final String id;

    private final ComparedFace face;

    private final Float matchConfidence;

    private final KnownGender knownGender;

    private Celebrity(BuilderImpl builder) {
        this.urls = builder.urls;
        this.name = builder.name;
        this.id = builder.id;
        this.face = builder.face;
        this.matchConfidence = builder.matchConfidence;
        this.knownGender = builder.knownGender;
    }

    /**
     * For responses, this returns true if the service returned a value for the Urls property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasUrls() {
        return urls != null && !(urls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of URLs pointing to additional information about the celebrity. If there is no additional information
     * about the celebrity, this list is empty.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUrls} method.
     * </p>
     * 
     * @return An array of URLs pointing to additional information about the celebrity. If there is no additional
     *         information about the celebrity, this list is empty.
     */
    public final List<String> urls() {
        return urls;
    }

    /**
     * <p>
     * The name of the celebrity.
     * </p>
     * 
     * @return The name of the celebrity.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A unique identifier for the celebrity.
     * </p>
     * 
     * @return A unique identifier for the celebrity.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Provides information about the celebrity's face, such as its location on the image.
     * </p>
     * 
     * @return Provides information about the celebrity's face, such as its location on the image.
     */
    public final ComparedFace face() {
        return face;
    }

    /**
     * <p>
     * The confidence, in percentage, that Amazon Rekognition has that the recognized face is the celebrity.
     * </p>
     * 
     * @return The confidence, in percentage, that Amazon Rekognition has that the recognized face is the celebrity.
     */
    public final Float matchConfidence() {
        return matchConfidence;
    }

    /**
     * Returns the value of the KnownGender property for this object.
     * 
     * @return The value of the KnownGender property for this object.
     */
    public final KnownGender knownGender() {
        return knownGender;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasUrls() ? urls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(face());
        hashCode = 31 * hashCode + Objects.hashCode(matchConfidence());
        hashCode = 31 * hashCode + Objects.hashCode(knownGender());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Celebrity)) {
            return false;
        }
        Celebrity other = (Celebrity) obj;
        return hasUrls() == other.hasUrls() && Objects.equals(urls(), other.urls()) && Objects.equals(name(), other.name())
                && Objects.equals(id(), other.id()) && Objects.equals(face(), other.face())
                && Objects.equals(matchConfidence(), other.matchConfidence())
                && Objects.equals(knownGender(), other.knownGender());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Celebrity").add("Urls", hasUrls() ? urls() : null).add("Name", name()).add("Id", id())
                .add("Face", face()).add("MatchConfidence", matchConfidence()).add("KnownGender", knownGender()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Urls":
            return Optional.ofNullable(clazz.cast(urls()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Face":
            return Optional.ofNullable(clazz.cast(face()));
        case "MatchConfidence":
            return Optional.ofNullable(clazz.cast(matchConfidence()));
        case "KnownGender":
            return Optional.ofNullable(clazz.cast(knownGender()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Celebrity, T> g) {
        return obj -> g.apply((Celebrity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Celebrity> {
        /**
         * <p>
         * An array of URLs pointing to additional information about the celebrity. If there is no additional
         * information about the celebrity, this list is empty.
         * </p>
         * 
         * @param urls
         *        An array of URLs pointing to additional information about the celebrity. If there is no additional
         *        information about the celebrity, this list is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder urls(Collection<String> urls);

        /**
         * <p>
         * An array of URLs pointing to additional information about the celebrity. If there is no additional
         * information about the celebrity, this list is empty.
         * </p>
         * 
         * @param urls
         *        An array of URLs pointing to additional information about the celebrity. If there is no additional
         *        information about the celebrity, this list is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder urls(String... urls);

        /**
         * <p>
         * The name of the celebrity.
         * </p>
         * 
         * @param name
         *        The name of the celebrity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A unique identifier for the celebrity.
         * </p>
         * 
         * @param id
         *        A unique identifier for the celebrity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Provides information about the celebrity's face, such as its location on the image.
         * </p>
         * 
         * @param face
         *        Provides information about the celebrity's face, such as its location on the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder face(ComparedFace face);

        /**
         * <p>
         * Provides information about the celebrity's face, such as its location on the image.
         * </p>
         * This is a convenience that creates an instance of the {@link ComparedFace.Builder} avoiding the need to
         * create one manually via {@link ComparedFace#builder()}.
         *
         * When the {@link Consumer} completes, {@link ComparedFace.Builder#build()} is called immediately and its
         * result is passed to {@link #face(ComparedFace)}.
         * 
         * @param face
         *        a consumer that will call methods on {@link ComparedFace.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #face(ComparedFace)
         */
        default Builder face(Consumer<ComparedFace.Builder> face) {
            return face(ComparedFace.builder().applyMutation(face).build());
        }

        /**
         * <p>
         * The confidence, in percentage, that Amazon Rekognition has that the recognized face is the celebrity.
         * </p>
         * 
         * @param matchConfidence
         *        The confidence, in percentage, that Amazon Rekognition has that the recognized face is the celebrity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchConfidence(Float matchConfidence);

        /**
         * Sets the value of the KnownGender property for this object.
         *
         * @param knownGender
         *        The new value for the KnownGender property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knownGender(KnownGender knownGender);

        /**
         * Sets the value of the KnownGender property for this object.
         *
         * This is a convenience that creates an instance of the {@link KnownGender.Builder} avoiding the need to create
         * one manually via {@link KnownGender#builder()}.
         *
         * When the {@link Consumer} completes, {@link KnownGender.Builder#build()} is called immediately and its result
         * is passed to {@link #knownGender(KnownGender)}.
         * 
         * @param knownGender
         *        a consumer that will call methods on {@link KnownGender.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #knownGender(KnownGender)
         */
        default Builder knownGender(Consumer<KnownGender.Builder> knownGender) {
            return knownGender(KnownGender.builder().applyMutation(knownGender).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> urls = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private String id;

        private ComparedFace face;

        private Float matchConfidence;

        private KnownGender knownGender;

        private BuilderImpl() {
        }

        private BuilderImpl(Celebrity model) {
            urls(model.urls);
            name(model.name);
            id(model.id);
            face(model.face);
            matchConfidence(model.matchConfidence);
            knownGender(model.knownGender);
        }

        public final Collection<String> getUrls() {
            if (urls instanceof SdkAutoConstructList) {
                return null;
            }
            return urls;
        }

        public final void setUrls(Collection<String> urls) {
            this.urls = UrlsCopier.copy(urls);
        }

        @Override
        @Transient
        public final Builder urls(Collection<String> urls) {
            this.urls = UrlsCopier.copy(urls);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder urls(String... urls) {
            urls(Arrays.asList(urls));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final ComparedFace.Builder getFace() {
            return face != null ? face.toBuilder() : null;
        }

        public final void setFace(ComparedFace.BuilderImpl face) {
            this.face = face != null ? face.build() : null;
        }

        @Override
        @Transient
        public final Builder face(ComparedFace face) {
            this.face = face;
            return this;
        }

        public final Float getMatchConfidence() {
            return matchConfidence;
        }

        public final void setMatchConfidence(Float matchConfidence) {
            this.matchConfidence = matchConfidence;
        }

        @Override
        @Transient
        public final Builder matchConfidence(Float matchConfidence) {
            this.matchConfidence = matchConfidence;
            return this;
        }

        public final KnownGender.Builder getKnownGender() {
            return knownGender != null ? knownGender.toBuilder() : null;
        }

        public final void setKnownGender(KnownGender.BuilderImpl knownGender) {
            this.knownGender = knownGender != null ? knownGender.build() : null;
        }

        @Override
        @Transient
        public final Builder knownGender(KnownGender knownGender) {
            this.knownGender = knownGender;
            return this;
        }

        @Override
        public Celebrity build() {
            return new Celebrity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
