/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateProjectVersionRequest extends RekognitionRequest implements
        ToCopyableBuilder<CreateProjectVersionRequest.Builder, CreateProjectVersionRequest> {
    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectArn").getter(getter(CreateProjectVersionRequest::projectArn)).setter(setter(Builder::projectArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectArn").build()).build();

    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionName").getter(getter(CreateProjectVersionRequest::versionName))
            .setter(setter(Builder::versionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionName").build()).build();

    private static final SdkField<OutputConfig> OUTPUT_CONFIG_FIELD = SdkField.<OutputConfig> builder(MarshallingType.SDK_POJO)
            .memberName("OutputConfig").getter(getter(CreateProjectVersionRequest::outputConfig))
            .setter(setter(Builder::outputConfig)).constructor(OutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()).build();

    private static final SdkField<TrainingData> TRAINING_DATA_FIELD = SdkField.<TrainingData> builder(MarshallingType.SDK_POJO)
            .memberName("TrainingData").getter(getter(CreateProjectVersionRequest::trainingData))
            .setter(setter(Builder::trainingData)).constructor(TrainingData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingData").build()).build();

    private static final SdkField<TestingData> TESTING_DATA_FIELD = SdkField.<TestingData> builder(MarshallingType.SDK_POJO)
            .memberName("TestingData").getter(getter(CreateProjectVersionRequest::testingData))
            .setter(setter(Builder::testingData)).constructor(TestingData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TestingData").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateProjectVersionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(CreateProjectVersionRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ARN_FIELD,
            VERSION_NAME_FIELD, OUTPUT_CONFIG_FIELD, TRAINING_DATA_FIELD, TESTING_DATA_FIELD, TAGS_FIELD, KMS_KEY_ID_FIELD));

    private final String projectArn;

    private final String versionName;

    private final OutputConfig outputConfig;

    private final TrainingData trainingData;

    private final TestingData testingData;

    private final Map<String, String> tags;

    private final String kmsKeyId;

    private CreateProjectVersionRequest(BuilderImpl builder) {
        super(builder);
        this.projectArn = builder.projectArn;
        this.versionName = builder.versionName;
        this.outputConfig = builder.outputConfig;
        this.trainingData = builder.trainingData;
        this.testingData = builder.testingData;
        this.tags = builder.tags;
        this.kmsKeyId = builder.kmsKeyId;
    }

    /**
     * <p>
     * The ARN of the Amazon Rekognition Custom Labels project that manages the model that you want to train.
     * </p>
     * 
     * @return The ARN of the Amazon Rekognition Custom Labels project that manages the model that you want to train.
     */
    public final String projectArn() {
        return projectArn;
    }

    /**
     * <p>
     * A name for the version of the model. This value must be unique.
     * </p>
     * 
     * @return A name for the version of the model. This value must be unique.
     */
    public final String versionName() {
        return versionName;
    }

    /**
     * <p>
     * The Amazon S3 bucket location to store the results of training. The S3 bucket can be in any AWS account as long
     * as the caller has <code>s3:PutObject</code> permissions on the S3 bucket.
     * </p>
     * 
     * @return The Amazon S3 bucket location to store the results of training. The S3 bucket can be in any AWS account
     *         as long as the caller has <code>s3:PutObject</code> permissions on the S3 bucket.
     */
    public final OutputConfig outputConfig() {
        return outputConfig;
    }

    /**
     * <p>
     * The dataset to use for training.
     * </p>
     * 
     * @return The dataset to use for training.
     */
    public final TrainingData trainingData() {
        return trainingData;
    }

    /**
     * <p>
     * The dataset to use for testing.
     * </p>
     * 
     * @return The dataset to use for testing.
     */
    public final TestingData testingData() {
        return testingData;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A set of tags (key-value pairs) that you want to attach to the model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A set of tags (key-value pairs) that you want to attach to the model.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The identifier for your AWS Key Management Service (AWS KMS) customer master key (CMK). You can supply the Amazon
     * Resource Name (ARN) of your CMK, the ID of your CMK, an alias for your CMK, or an alias ARN. The key is used to
     * encrypt training and test images copied into the service for model training. Your source images are unaffected.
     * The key is also used to encrypt training results and manifest files written to the output Amazon S3 bucket (
     * <code>OutputConfig</code>).
     * </p>
     * <p>
     * If you choose to use your own CMK, you need the following permissions on the CMK.
     * </p>
     * <ul>
     * <li>
     * <p>
     * kms:CreateGrant
     * </p>
     * </li>
     * <li>
     * <p>
     * kms:DescribeKey
     * </p>
     * </li>
     * <li>
     * <p>
     * kms:GenerateDataKey
     * </p>
     * </li>
     * <li>
     * <p>
     * kms:Decrypt
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you don't specify a value for <code>KmsKeyId</code>, images copied into the service are encrypted using a key
     * that AWS owns and manages.
     * </p>
     * 
     * @return The identifier for your AWS Key Management Service (AWS KMS) customer master key (CMK). You can supply
     *         the Amazon Resource Name (ARN) of your CMK, the ID of your CMK, an alias for your CMK, or an alias ARN.
     *         The key is used to encrypt training and test images copied into the service for model training. Your
     *         source images are unaffected. The key is also used to encrypt training results and manifest files written
     *         to the output Amazon S3 bucket (<code>OutputConfig</code>).</p>
     *         <p>
     *         If you choose to use your own CMK, you need the following permissions on the CMK.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         kms:CreateGrant
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         kms:DescribeKey
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         kms:GenerateDataKey
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         kms:Decrypt
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you don't specify a value for <code>KmsKeyId</code>, images copied into the service are encrypted
     *         using a key that AWS owns and manages.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(versionName());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(trainingData());
        hashCode = 31 * hashCode + Objects.hashCode(testingData());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProjectVersionRequest)) {
            return false;
        }
        CreateProjectVersionRequest other = (CreateProjectVersionRequest) obj;
        return Objects.equals(projectArn(), other.projectArn()) && Objects.equals(versionName(), other.versionName())
                && Objects.equals(outputConfig(), other.outputConfig()) && Objects.equals(trainingData(), other.trainingData())
                && Objects.equals(testingData(), other.testingData()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(kmsKeyId(), other.kmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateProjectVersionRequest").add("ProjectArn", projectArn()).add("VersionName", versionName())
                .add("OutputConfig", outputConfig()).add("TrainingData", trainingData()).add("TestingData", testingData())
                .add("Tags", hasTags() ? tags() : null).add("KmsKeyId", kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProjectArn":
            return Optional.ofNullable(clazz.cast(projectArn()));
        case "VersionName":
            return Optional.ofNullable(clazz.cast(versionName()));
        case "OutputConfig":
            return Optional.ofNullable(clazz.cast(outputConfig()));
        case "TrainingData":
            return Optional.ofNullable(clazz.cast(trainingData()));
        case "TestingData":
            return Optional.ofNullable(clazz.cast(testingData()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateProjectVersionRequest, T> g) {
        return obj -> g.apply((CreateProjectVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateProjectVersionRequest> {
        /**
         * <p>
         * The ARN of the Amazon Rekognition Custom Labels project that manages the model that you want to train.
         * </p>
         * 
         * @param projectArn
         *        The ARN of the Amazon Rekognition Custom Labels project that manages the model that you want to train.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectArn(String projectArn);

        /**
         * <p>
         * A name for the version of the model. This value must be unique.
         * </p>
         * 
         * @param versionName
         *        A name for the version of the model. This value must be unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionName(String versionName);

        /**
         * <p>
         * The Amazon S3 bucket location to store the results of training. The S3 bucket can be in any AWS account as
         * long as the caller has <code>s3:PutObject</code> permissions on the S3 bucket.
         * </p>
         * 
         * @param outputConfig
         *        The Amazon S3 bucket location to store the results of training. The S3 bucket can be in any AWS
         *        account as long as the caller has <code>s3:PutObject</code> permissions on the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfig(OutputConfig outputConfig);

        /**
         * <p>
         * The Amazon S3 bucket location to store the results of training. The S3 bucket can be in any AWS account as
         * long as the caller has <code>s3:PutObject</code> permissions on the S3 bucket.
         * </p>
         * This is a convenience that creates an instance of the {@link OutputConfig.Builder} avoiding the need to
         * create one manually via {@link OutputConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link OutputConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #outputConfig(OutputConfig)}.
         * 
         * @param outputConfig
         *        a consumer that will call methods on {@link OutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfig(OutputConfig)
         */
        default Builder outputConfig(Consumer<OutputConfig.Builder> outputConfig) {
            return outputConfig(OutputConfig.builder().applyMutation(outputConfig).build());
        }

        /**
         * <p>
         * The dataset to use for training.
         * </p>
         * 
         * @param trainingData
         *        The dataset to use for training.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingData(TrainingData trainingData);

        /**
         * <p>
         * The dataset to use for training.
         * </p>
         * This is a convenience that creates an instance of the {@link TrainingData.Builder} avoiding the need to
         * create one manually via {@link TrainingData#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrainingData.Builder#build()} is called immediately and its
         * result is passed to {@link #trainingData(TrainingData)}.
         * 
         * @param trainingData
         *        a consumer that will call methods on {@link TrainingData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainingData(TrainingData)
         */
        default Builder trainingData(Consumer<TrainingData.Builder> trainingData) {
            return trainingData(TrainingData.builder().applyMutation(trainingData).build());
        }

        /**
         * <p>
         * The dataset to use for testing.
         * </p>
         * 
         * @param testingData
         *        The dataset to use for testing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testingData(TestingData testingData);

        /**
         * <p>
         * The dataset to use for testing.
         * </p>
         * This is a convenience that creates an instance of the {@link TestingData.Builder} avoiding the need to create
         * one manually via {@link TestingData#builder()}.
         *
         * When the {@link Consumer} completes, {@link TestingData.Builder#build()} is called immediately and its result
         * is passed to {@link #testingData(TestingData)}.
         * 
         * @param testingData
         *        a consumer that will call methods on {@link TestingData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #testingData(TestingData)
         */
        default Builder testingData(Consumer<TestingData.Builder> testingData) {
            return testingData(TestingData.builder().applyMutation(testingData).build());
        }

        /**
         * <p>
         * A set of tags (key-value pairs) that you want to attach to the model.
         * </p>
         * 
         * @param tags
         *        A set of tags (key-value pairs) that you want to attach to the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The identifier for your AWS Key Management Service (AWS KMS) customer master key (CMK). You can supply the
         * Amazon Resource Name (ARN) of your CMK, the ID of your CMK, an alias for your CMK, or an alias ARN. The key
         * is used to encrypt training and test images copied into the service for model training. Your source images
         * are unaffected. The key is also used to encrypt training results and manifest files written to the output
         * Amazon S3 bucket (<code>OutputConfig</code>).
         * </p>
         * <p>
         * If you choose to use your own CMK, you need the following permissions on the CMK.
         * </p>
         * <ul>
         * <li>
         * <p>
         * kms:CreateGrant
         * </p>
         * </li>
         * <li>
         * <p>
         * kms:DescribeKey
         * </p>
         * </li>
         * <li>
         * <p>
         * kms:GenerateDataKey
         * </p>
         * </li>
         * <li>
         * <p>
         * kms:Decrypt
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you don't specify a value for <code>KmsKeyId</code>, images copied into the service are encrypted using a
         * key that AWS owns and manages.
         * </p>
         * 
         * @param kmsKeyId
         *        The identifier for your AWS Key Management Service (AWS KMS) customer master key (CMK). You can supply
         *        the Amazon Resource Name (ARN) of your CMK, the ID of your CMK, an alias for your CMK, or an alias
         *        ARN. The key is used to encrypt training and test images copied into the service for model training.
         *        Your source images are unaffected. The key is also used to encrypt training results and manifest files
         *        written to the output Amazon S3 bucket (<code>OutputConfig</code>).</p>
         *        <p>
         *        If you choose to use your own CMK, you need the following permissions on the CMK.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        kms:CreateGrant
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        kms:DescribeKey
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        kms:GenerateDataKey
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        kms:Decrypt
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you don't specify a value for <code>KmsKeyId</code>, images copied into the service are encrypted
         *        using a key that AWS owns and manages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private String projectArn;

        private String versionName;

        private OutputConfig outputConfig;

        private TrainingData trainingData;

        private TestingData testingData;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProjectVersionRequest model) {
            super(model);
            projectArn(model.projectArn);
            versionName(model.versionName);
            outputConfig(model.outputConfig);
            trainingData(model.trainingData);
            testingData(model.testingData);
            tags(model.tags);
            kmsKeyId(model.kmsKeyId);
        }

        public final String getProjectArn() {
            return projectArn;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        @Override
        @Transient
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final String getVersionName() {
            return versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        @Transient
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final OutputConfig.Builder getOutputConfig() {
            return outputConfig != null ? outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(OutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder outputConfig(OutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final TrainingData.Builder getTrainingData() {
            return trainingData != null ? trainingData.toBuilder() : null;
        }

        public final void setTrainingData(TrainingData.BuilderImpl trainingData) {
            this.trainingData = trainingData != null ? trainingData.build() : null;
        }

        @Override
        @Transient
        public final Builder trainingData(TrainingData trainingData) {
            this.trainingData = trainingData;
            return this;
        }

        public final TestingData.Builder getTestingData() {
            return testingData != null ? testingData.toBuilder() : null;
        }

        public final void setTestingData(TestingData.BuilderImpl testingData) {
            this.testingData = testingData != null ? testingData.build() : null;
        }

        @Override
        @Transient
        public final Builder testingData(TestingData testingData) {
            this.testingData = testingData;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        @Transient
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProjectVersionRequest build() {
            return new CreateProjectVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
