/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCollectionResponse extends RekognitionResponse implements
        ToCopyableBuilder<DescribeCollectionResponse.Builder, DescribeCollectionResponse> {
    private static final SdkField<Long> FACE_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("FaceCount")
            .getter(getter(DescribeCollectionResponse::faceCount)).setter(setter(Builder::faceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceCount").build()).build();

    private static final SdkField<String> FACE_MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FaceModelVersion").getter(getter(DescribeCollectionResponse::faceModelVersion))
            .setter(setter(Builder::faceModelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceModelVersion").build()).build();

    private static final SdkField<String> COLLECTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CollectionARN").getter(getter(DescribeCollectionResponse::collectionARN))
            .setter(setter(Builder::collectionARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionARN").build()).build();

    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimestamp").getter(getter(DescribeCollectionResponse::creationTimestamp))
            .setter(setter(Builder::creationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FACE_COUNT_FIELD,
            FACE_MODEL_VERSION_FIELD, COLLECTION_ARN_FIELD, CREATION_TIMESTAMP_FIELD));

    private final Long faceCount;

    private final String faceModelVersion;

    private final String collectionARN;

    private final Instant creationTimestamp;

    private DescribeCollectionResponse(BuilderImpl builder) {
        super(builder);
        this.faceCount = builder.faceCount;
        this.faceModelVersion = builder.faceModelVersion;
        this.collectionARN = builder.collectionARN;
        this.creationTimestamp = builder.creationTimestamp;
    }

    /**
     * <p>
     * The number of faces that are indexed into the collection. To index faces into a collection, use
     * <a>IndexFaces</a>.
     * </p>
     * 
     * @return The number of faces that are indexed into the collection. To index faces into a collection, use
     *         <a>IndexFaces</a>.
     */
    public final Long faceCount() {
        return faceCount;
    }

    /**
     * <p>
     * The version of the face model that's used by the collection for face detection.
     * </p>
     * <p>
     * For more information, see Model Versioning in the Amazon Rekognition Developer Guide.
     * </p>
     * 
     * @return The version of the face model that's used by the collection for face detection.</p>
     *         <p>
     *         For more information, see Model Versioning in the Amazon Rekognition Developer Guide.
     */
    public final String faceModelVersion() {
        return faceModelVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the collection.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the collection.
     */
    public final String collectionARN() {
        return collectionARN;
    }

    /**
     * <p>
     * The number of milliseconds since the Unix epoch time until the creation of the collection. The Unix epoch time is
     * 00:00:00 Coordinated Universal Time (UTC), Thursday, 1 January 1970.
     * </p>
     * 
     * @return The number of milliseconds since the Unix epoch time until the creation of the collection. The Unix epoch
     *         time is 00:00:00 Coordinated Universal Time (UTC), Thursday, 1 January 1970.
     */
    public final Instant creationTimestamp() {
        return creationTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(faceCount());
        hashCode = 31 * hashCode + Objects.hashCode(faceModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(collectionARN());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCollectionResponse)) {
            return false;
        }
        DescribeCollectionResponse other = (DescribeCollectionResponse) obj;
        return Objects.equals(faceCount(), other.faceCount()) && Objects.equals(faceModelVersion(), other.faceModelVersion())
                && Objects.equals(collectionARN(), other.collectionARN())
                && Objects.equals(creationTimestamp(), other.creationTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCollectionResponse").add("FaceCount", faceCount())
                .add("FaceModelVersion", faceModelVersion()).add("CollectionARN", collectionARN())
                .add("CreationTimestamp", creationTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FaceCount":
            return Optional.ofNullable(clazz.cast(faceCount()));
        case "FaceModelVersion":
            return Optional.ofNullable(clazz.cast(faceModelVersion()));
        case "CollectionARN":
            return Optional.ofNullable(clazz.cast(collectionARN()));
        case "CreationTimestamp":
            return Optional.ofNullable(clazz.cast(creationTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCollectionResponse, T> g) {
        return obj -> g.apply((DescribeCollectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeCollectionResponse> {
        /**
         * <p>
         * The number of faces that are indexed into the collection. To index faces into a collection, use
         * <a>IndexFaces</a>.
         * </p>
         * 
         * @param faceCount
         *        The number of faces that are indexed into the collection. To index faces into a collection, use
         *        <a>IndexFaces</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceCount(Long faceCount);

        /**
         * <p>
         * The version of the face model that's used by the collection for face detection.
         * </p>
         * <p>
         * For more information, see Model Versioning in the Amazon Rekognition Developer Guide.
         * </p>
         * 
         * @param faceModelVersion
         *        The version of the face model that's used by the collection for face detection.</p>
         *        <p>
         *        For more information, see Model Versioning in the Amazon Rekognition Developer Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceModelVersion(String faceModelVersion);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the collection.
         * </p>
         * 
         * @param collectionARN
         *        The Amazon Resource Name (ARN) of the collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionARN(String collectionARN);

        /**
         * <p>
         * The number of milliseconds since the Unix epoch time until the creation of the collection. The Unix epoch
         * time is 00:00:00 Coordinated Universal Time (UTC), Thursday, 1 January 1970.
         * </p>
         * 
         * @param creationTimestamp
         *        The number of milliseconds since the Unix epoch time until the creation of the collection. The Unix
         *        epoch time is 00:00:00 Coordinated Universal Time (UTC), Thursday, 1 January 1970.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimestamp(Instant creationTimestamp);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private Long faceCount;

        private String faceModelVersion;

        private String collectionARN;

        private Instant creationTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCollectionResponse model) {
            super(model);
            faceCount(model.faceCount);
            faceModelVersion(model.faceModelVersion);
            collectionARN(model.collectionARN);
            creationTimestamp(model.creationTimestamp);
        }

        public final Long getFaceCount() {
            return faceCount;
        }

        public final void setFaceCount(Long faceCount) {
            this.faceCount = faceCount;
        }

        @Override
        @Transient
        public final Builder faceCount(Long faceCount) {
            this.faceCount = faceCount;
            return this;
        }

        public final String getFaceModelVersion() {
            return faceModelVersion;
        }

        public final void setFaceModelVersion(String faceModelVersion) {
            this.faceModelVersion = faceModelVersion;
        }

        @Override
        @Transient
        public final Builder faceModelVersion(String faceModelVersion) {
            this.faceModelVersion = faceModelVersion;
            return this;
        }

        public final String getCollectionARN() {
            return collectionARN;
        }

        public final void setCollectionARN(String collectionARN) {
            this.collectionARN = collectionARN;
        }

        @Override
        @Transient
        public final Builder collectionARN(String collectionARN) {
            this.collectionARN = collectionARN;
            return this;
        }

        public final Instant getCreationTimestamp() {
            return creationTimestamp;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        @Transient
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        @Override
        public DescribeCollectionResponse build() {
            return new DescribeCollectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
