/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates whether or not the face has a mustache, and the confidence level in the determination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Mustache implements SdkPojo, Serializable, ToCopyableBuilder<Mustache.Builder, Mustache> {
    private static final SdkField<Boolean> VALUE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("Value")
            .getter(getter(Mustache::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<Float> CONFIDENCE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("Confidence").getter(getter(Mustache::confidence)).setter(setter(Builder::confidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(VALUE_FIELD, CONFIDENCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean value;

    private final Float confidence;

    private Mustache(BuilderImpl builder) {
        this.value = builder.value;
        this.confidence = builder.confidence;
    }

    /**
     * <p>
     * Boolean value that indicates whether the face has mustache or not.
     * </p>
     * 
     * @return Boolean value that indicates whether the face has mustache or not.
     */
    public final Boolean value() {
        return value;
    }

    /**
     * <p>
     * Level of confidence in the determination.
     * </p>
     * 
     * @return Level of confidence in the determination.
     */
    public final Float confidence() {
        return confidence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(confidence());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Mustache)) {
            return false;
        }
        Mustache other = (Mustache) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(confidence(), other.confidence());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Mustache").add("Value", value()).add("Confidence", confidence()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "Confidence":
            return Optional.ofNullable(clazz.cast(confidence()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Mustache, T> g) {
        return obj -> g.apply((Mustache) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Mustache> {
        /**
         * <p>
         * Boolean value that indicates whether the face has mustache or not.
         * </p>
         * 
         * @param value
         *        Boolean value that indicates whether the face has mustache or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Boolean value);

        /**
         * <p>
         * Level of confidence in the determination.
         * </p>
         * 
         * @param confidence
         *        Level of confidence in the determination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Float confidence);
    }

    static final class BuilderImpl implements Builder {
        private Boolean value;

        private Float confidence;

        private BuilderImpl() {
        }

        private BuilderImpl(Mustache model) {
            value(model.value);
            confidence(model.confidence);
        }

        public final Boolean getValue() {
            return value;
        }

        public final void setValue(Boolean value) {
            this.value = value;
        }

        @Override
        @Transient
        public final Builder value(Boolean value) {
            this.value = value;
            return this;
        }

        public final Float getConfidence() {
            return confidence;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        @Transient
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        @Override
        public Mustache build() {
            return new Mustache(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
