/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Shows the results of the human in the loop evaluation. If there is no HumanLoopArn, the input did not trigger human
 * review.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HumanLoopActivationOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<HumanLoopActivationOutput.Builder, HumanLoopActivationOutput> {
    private static final SdkField<String> HUMAN_LOOP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HumanLoopArn").getter(getter(HumanLoopActivationOutput::humanLoopArn))
            .setter(setter(Builder::humanLoopArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopArn").build()).build();

    private static final SdkField<List<String>> HUMAN_LOOP_ACTIVATION_REASONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("HumanLoopActivationReasons")
            .getter(getter(HumanLoopActivationOutput::humanLoopActivationReasons))
            .setter(setter(Builder::humanLoopActivationReasons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopActivationReasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> HUMAN_LOOP_ACTIVATION_CONDITIONS_EVALUATION_RESULTS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HumanLoopActivationConditionsEvaluationResults")
            .getter(getter(HumanLoopActivationOutput::humanLoopActivationConditionsEvaluationResults))
            .setter(setter(Builder::humanLoopActivationConditionsEvaluationResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("HumanLoopActivationConditionsEvaluationResults").build(), JsonValueTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUMAN_LOOP_ARN_FIELD,
            HUMAN_LOOP_ACTIVATION_REASONS_FIELD, HUMAN_LOOP_ACTIVATION_CONDITIONS_EVALUATION_RESULTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String humanLoopArn;

    private final List<String> humanLoopActivationReasons;

    private final String humanLoopActivationConditionsEvaluationResults;

    private HumanLoopActivationOutput(BuilderImpl builder) {
        this.humanLoopArn = builder.humanLoopArn;
        this.humanLoopActivationReasons = builder.humanLoopActivationReasons;
        this.humanLoopActivationConditionsEvaluationResults = builder.humanLoopActivationConditionsEvaluationResults;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the HumanLoop created.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the HumanLoop created.
     */
    public final String humanLoopArn() {
        return humanLoopArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the HumanLoopActivationReasons property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasHumanLoopActivationReasons() {
        return humanLoopActivationReasons != null && !(humanLoopActivationReasons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Shows if and why human review was needed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHumanLoopActivationReasons} method.
     * </p>
     * 
     * @return Shows if and why human review was needed.
     */
    public final List<String> humanLoopActivationReasons() {
        return humanLoopActivationReasons;
    }

    /**
     * <p>
     * Shows the result of condition evaluations, including those conditions which activated a human review.
     * </p>
     * 
     * @return Shows the result of condition evaluations, including those conditions which activated a human review.
     */
    public final String humanLoopActivationConditionsEvaluationResults() {
        return humanLoopActivationConditionsEvaluationResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(humanLoopArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasHumanLoopActivationReasons() ? humanLoopActivationReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(humanLoopActivationConditionsEvaluationResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HumanLoopActivationOutput)) {
            return false;
        }
        HumanLoopActivationOutput other = (HumanLoopActivationOutput) obj;
        return Objects.equals(humanLoopArn(), other.humanLoopArn())
                && hasHumanLoopActivationReasons() == other.hasHumanLoopActivationReasons()
                && Objects.equals(humanLoopActivationReasons(), other.humanLoopActivationReasons())
                && Objects.equals(humanLoopActivationConditionsEvaluationResults(),
                        other.humanLoopActivationConditionsEvaluationResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HumanLoopActivationOutput").add("HumanLoopArn", humanLoopArn())
                .add("HumanLoopActivationReasons", hasHumanLoopActivationReasons() ? humanLoopActivationReasons() : null)
                .add("HumanLoopActivationConditionsEvaluationResults", humanLoopActivationConditionsEvaluationResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HumanLoopArn":
            return Optional.ofNullable(clazz.cast(humanLoopArn()));
        case "HumanLoopActivationReasons":
            return Optional.ofNullable(clazz.cast(humanLoopActivationReasons()));
        case "HumanLoopActivationConditionsEvaluationResults":
            return Optional.ofNullable(clazz.cast(humanLoopActivationConditionsEvaluationResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HumanLoopActivationOutput, T> g) {
        return obj -> g.apply((HumanLoopActivationOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HumanLoopActivationOutput> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the HumanLoop created.
         * </p>
         * 
         * @param humanLoopArn
         *        The Amazon Resource Name (ARN) of the HumanLoop created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanLoopArn(String humanLoopArn);

        /**
         * <p>
         * Shows if and why human review was needed.
         * </p>
         * 
         * @param humanLoopActivationReasons
         *        Shows if and why human review was needed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanLoopActivationReasons(Collection<String> humanLoopActivationReasons);

        /**
         * <p>
         * Shows if and why human review was needed.
         * </p>
         * 
         * @param humanLoopActivationReasons
         *        Shows if and why human review was needed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanLoopActivationReasons(String... humanLoopActivationReasons);

        /**
         * <p>
         * Shows the result of condition evaluations, including those conditions which activated a human review.
         * </p>
         * 
         * @param humanLoopActivationConditionsEvaluationResults
         *        Shows the result of condition evaluations, including those conditions which activated a human review.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanLoopActivationConditionsEvaluationResults(String humanLoopActivationConditionsEvaluationResults);
    }

    static final class BuilderImpl implements Builder {
        private String humanLoopArn;

        private List<String> humanLoopActivationReasons = DefaultSdkAutoConstructList.getInstance();

        private String humanLoopActivationConditionsEvaluationResults;

        private BuilderImpl() {
        }

        private BuilderImpl(HumanLoopActivationOutput model) {
            humanLoopArn(model.humanLoopArn);
            humanLoopActivationReasons(model.humanLoopActivationReasons);
            humanLoopActivationConditionsEvaluationResults(model.humanLoopActivationConditionsEvaluationResults);
        }

        public final String getHumanLoopArn() {
            return humanLoopArn;
        }

        public final void setHumanLoopArn(String humanLoopArn) {
            this.humanLoopArn = humanLoopArn;
        }

        @Override
        @Transient
        public final Builder humanLoopArn(String humanLoopArn) {
            this.humanLoopArn = humanLoopArn;
            return this;
        }

        public final Collection<String> getHumanLoopActivationReasons() {
            if (humanLoopActivationReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return humanLoopActivationReasons;
        }

        public final void setHumanLoopActivationReasons(Collection<String> humanLoopActivationReasons) {
            this.humanLoopActivationReasons = HumanLoopActivationReasonsCopier.copy(humanLoopActivationReasons);
        }

        @Override
        @Transient
        public final Builder humanLoopActivationReasons(Collection<String> humanLoopActivationReasons) {
            this.humanLoopActivationReasons = HumanLoopActivationReasonsCopier.copy(humanLoopActivationReasons);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder humanLoopActivationReasons(String... humanLoopActivationReasons) {
            humanLoopActivationReasons(Arrays.asList(humanLoopActivationReasons));
            return this;
        }

        public final String getHumanLoopActivationConditionsEvaluationResults() {
            return humanLoopActivationConditionsEvaluationResults;
        }

        public final void setHumanLoopActivationConditionsEvaluationResults(String humanLoopActivationConditionsEvaluationResults) {
            this.humanLoopActivationConditionsEvaluationResults = humanLoopActivationConditionsEvaluationResults;
        }

        @Override
        @Transient
        public final Builder humanLoopActivationConditionsEvaluationResults(String humanLoopActivationConditionsEvaluationResults) {
            this.humanLoopActivationConditionsEvaluationResults = humanLoopActivationConditionsEvaluationResults;
            return this;
        }

        @Override
        public HumanLoopActivationOutput build() {
            return new HumanLoopActivationOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
