/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPersonTrackingResponse extends RekognitionResponse implements
        ToCopyableBuilder<GetPersonTrackingResponse.Builder, GetPersonTrackingResponse> {
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobStatus").getter(getter(GetPersonTrackingResponse::jobStatusAsString))
            .setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(GetPersonTrackingResponse::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<VideoMetadata> VIDEO_METADATA_FIELD = SdkField
            .<VideoMetadata> builder(MarshallingType.SDK_POJO).memberName("VideoMetadata")
            .getter(getter(GetPersonTrackingResponse::videoMetadata)).setter(setter(Builder::videoMetadata))
            .constructor(VideoMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VideoMetadata").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetPersonTrackingResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<PersonDetection>> PERSONS_FIELD = SdkField
            .<List<PersonDetection>> builder(MarshallingType.LIST)
            .memberName("Persons")
            .getter(getter(GetPersonTrackingResponse::persons))
            .setter(setter(Builder::persons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Persons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PersonDetection> builder(MarshallingType.SDK_POJO)
                                            .constructor(PersonDetection::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_STATUS_FIELD,
            STATUS_MESSAGE_FIELD, VIDEO_METADATA_FIELD, NEXT_TOKEN_FIELD, PERSONS_FIELD));

    private final String jobStatus;

    private final String statusMessage;

    private final VideoMetadata videoMetadata;

    private final String nextToken;

    private final List<PersonDetection> persons;

    private GetPersonTrackingResponse(BuilderImpl builder) {
        super(builder);
        this.jobStatus = builder.jobStatus;
        this.statusMessage = builder.statusMessage;
        this.videoMetadata = builder.videoMetadata;
        this.nextToken = builder.nextToken;
        this.persons = builder.persons;
    }

    /**
     * <p>
     * The current status of the person tracking job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link VideoJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The current status of the person tracking job.
     * @see VideoJobStatus
     */
    public final VideoJobStatus jobStatus() {
        return VideoJobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * The current status of the person tracking job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link VideoJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The current status of the person tracking job.
     * @see VideoJobStatus
     */
    public final String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * If the job fails, <code>StatusMessage</code> provides a descriptive error message.
     * </p>
     * 
     * @return If the job fails, <code>StatusMessage</code> provides a descriptive error message.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * Information about a video that Amazon Rekognition Video analyzed. <code>Videometadata</code> is returned in every
     * page of paginated responses from a Amazon Rekognition Video operation.
     * </p>
     * 
     * @return Information about a video that Amazon Rekognition Video analyzed. <code>Videometadata</code> is returned
     *         in every page of paginated responses from a Amazon Rekognition Video operation.
     */
    public final VideoMetadata videoMetadata() {
        return videoMetadata;
    }

    /**
     * <p>
     * If the response is truncated, Amazon Rekognition Video returns this token that you can use in the subsequent
     * request to retrieve the next set of persons.
     * </p>
     * 
     * @return If the response is truncated, Amazon Rekognition Video returns this token that you can use in the
     *         subsequent request to retrieve the next set of persons.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Persons property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPersons() {
        return persons != null && !(persons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of the persons detected in the video and the time(s) their path was tracked throughout the video. An
     * array element will exist for each time a person's path is tracked.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPersons} method.
     * </p>
     * 
     * @return An array of the persons detected in the video and the time(s) their path was tracked throughout the
     *         video. An array element will exist for each time a person's path is tracked.
     */
    public final List<PersonDetection> persons() {
        return persons;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(videoMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasPersons() ? persons() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPersonTrackingResponse)) {
            return false;
        }
        GetPersonTrackingResponse other = (GetPersonTrackingResponse) obj;
        return Objects.equals(jobStatusAsString(), other.jobStatusAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(videoMetadata(), other.videoMetadata()) && Objects.equals(nextToken(), other.nextToken())
                && hasPersons() == other.hasPersons() && Objects.equals(persons(), other.persons());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPersonTrackingResponse").add("JobStatus", jobStatusAsString())
                .add("StatusMessage", statusMessage()).add("VideoMetadata", videoMetadata()).add("NextToken", nextToken())
                .add("Persons", hasPersons() ? persons() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "VideoMetadata":
            return Optional.ofNullable(clazz.cast(videoMetadata()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Persons":
            return Optional.ofNullable(clazz.cast(persons()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPersonTrackingResponse, T> g) {
        return obj -> g.apply((GetPersonTrackingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetPersonTrackingResponse> {
        /**
         * <p>
         * The current status of the person tracking job.
         * </p>
         * 
         * @param jobStatus
         *        The current status of the person tracking job.
         * @see VideoJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoJobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * The current status of the person tracking job.
         * </p>
         * 
         * @param jobStatus
         *        The current status of the person tracking job.
         * @see VideoJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoJobStatus
         */
        Builder jobStatus(VideoJobStatus jobStatus);

        /**
         * <p>
         * If the job fails, <code>StatusMessage</code> provides a descriptive error message.
         * </p>
         * 
         * @param statusMessage
         *        If the job fails, <code>StatusMessage</code> provides a descriptive error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * Information about a video that Amazon Rekognition Video analyzed. <code>Videometadata</code> is returned in
         * every page of paginated responses from a Amazon Rekognition Video operation.
         * </p>
         * 
         * @param videoMetadata
         *        Information about a video that Amazon Rekognition Video analyzed. <code>Videometadata</code> is
         *        returned in every page of paginated responses from a Amazon Rekognition Video operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoMetadata(VideoMetadata videoMetadata);

        /**
         * <p>
         * Information about a video that Amazon Rekognition Video analyzed. <code>Videometadata</code> is returned in
         * every page of paginated responses from a Amazon Rekognition Video operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link VideoMetadata.Builder} avoiding the need
         * to create one manually via {@link VideoMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VideoMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #videoMetadata(VideoMetadata)}.
         * 
         * @param videoMetadata
         *        a consumer that will call methods on {@link VideoMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #videoMetadata(VideoMetadata)
         */
        default Builder videoMetadata(Consumer<VideoMetadata.Builder> videoMetadata) {
            return videoMetadata(VideoMetadata.builder().applyMutation(videoMetadata).build());
        }

        /**
         * <p>
         * If the response is truncated, Amazon Rekognition Video returns this token that you can use in the subsequent
         * request to retrieve the next set of persons.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon Rekognition Video returns this token that you can use in the
         *        subsequent request to retrieve the next set of persons.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of the persons detected in the video and the time(s) their path was tracked throughout the video. An
         * array element will exist for each time a person's path is tracked.
         * </p>
         * 
         * @param persons
         *        An array of the persons detected in the video and the time(s) their path was tracked throughout the
         *        video. An array element will exist for each time a person's path is tracked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder persons(Collection<PersonDetection> persons);

        /**
         * <p>
         * An array of the persons detected in the video and the time(s) their path was tracked throughout the video. An
         * array element will exist for each time a person's path is tracked.
         * </p>
         * 
         * @param persons
         *        An array of the persons detected in the video and the time(s) their path was tracked throughout the
         *        video. An array element will exist for each time a person's path is tracked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder persons(PersonDetection... persons);

        /**
         * <p>
         * An array of the persons detected in the video and the time(s) their path was tracked throughout the video. An
         * array element will exist for each time a person's path is tracked.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rekognition.model.PersonDetection.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.rekognition.model.PersonDetection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rekognition.model.PersonDetection.Builder#build()} is called
         * immediately and its result is passed to {@link #persons(List<PersonDetection>)}.
         * 
         * @param persons
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rekognition.model.PersonDetection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #persons(java.util.Collection<PersonDetection>)
         */
        Builder persons(Consumer<PersonDetection.Builder>... persons);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private String jobStatus;

        private String statusMessage;

        private VideoMetadata videoMetadata;

        private String nextToken;

        private List<PersonDetection> persons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetPersonTrackingResponse model) {
            super(model);
            jobStatus(model.jobStatus);
            statusMessage(model.statusMessage);
            videoMetadata(model.videoMetadata);
            nextToken(model.nextToken);
            persons(model.persons);
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(VideoJobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final VideoMetadata.Builder getVideoMetadata() {
            return videoMetadata != null ? videoMetadata.toBuilder() : null;
        }

        public final void setVideoMetadata(VideoMetadata.BuilderImpl videoMetadata) {
            this.videoMetadata = videoMetadata != null ? videoMetadata.build() : null;
        }

        @Override
        public final Builder videoMetadata(VideoMetadata videoMetadata) {
            this.videoMetadata = videoMetadata;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<PersonDetection.Builder> getPersons() {
            List<PersonDetection.Builder> result = PersonDetectionsCopier.copyToBuilder(this.persons);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPersons(Collection<PersonDetection.BuilderImpl> persons) {
            this.persons = PersonDetectionsCopier.copyFromBuilder(persons);
        }

        @Override
        public final Builder persons(Collection<PersonDetection> persons) {
            this.persons = PersonDetectionsCopier.copy(persons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder persons(PersonDetection... persons) {
            persons(Arrays.asList(persons));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder persons(Consumer<PersonDetection.Builder>... persons) {
            persons(Stream.of(persons).map(c -> PersonDetection.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetPersonTrackingResponse build() {
            return new GetPersonTrackingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
