/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings for the DetectLabels request. Settings can include filters for both GENERAL_LABELS and IMAGE_PROPERTIES.
 * GENERAL_LABELS filters can be inclusive or exclusive and applied to individual labels or label categories.
 * IMAGE_PROPERTIES filters allow specification of a maximum number of dominant colors.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectLabelsSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<DetectLabelsSettings.Builder, DetectLabelsSettings> {
    private static final SdkField<GeneralLabelsSettings> GENERAL_LABELS_FIELD = SdkField
            .<GeneralLabelsSettings> builder(MarshallingType.SDK_POJO).memberName("GeneralLabels")
            .getter(getter(DetectLabelsSettings::generalLabels)).setter(setter(Builder::generalLabels))
            .constructor(GeneralLabelsSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneralLabels").build()).build();

    private static final SdkField<DetectLabelsImagePropertiesSettings> IMAGE_PROPERTIES_FIELD = SdkField
            .<DetectLabelsImagePropertiesSettings> builder(MarshallingType.SDK_POJO).memberName("ImageProperties")
            .getter(getter(DetectLabelsSettings::imageProperties)).setter(setter(Builder::imageProperties))
            .constructor(DetectLabelsImagePropertiesSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageProperties").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GENERAL_LABELS_FIELD,
            IMAGE_PROPERTIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final GeneralLabelsSettings generalLabels;

    private final DetectLabelsImagePropertiesSettings imageProperties;

    private DetectLabelsSettings(BuilderImpl builder) {
        this.generalLabels = builder.generalLabels;
        this.imageProperties = builder.imageProperties;
    }

    /**
     * <p>
     * Contains the specified filters for GENERAL_LABELS.
     * </p>
     * 
     * @return Contains the specified filters for GENERAL_LABELS.
     */
    public final GeneralLabelsSettings generalLabels() {
        return generalLabels;
    }

    /**
     * <p>
     * Contains the chosen number of maximum dominant colors in an image.
     * </p>
     * 
     * @return Contains the chosen number of maximum dominant colors in an image.
     */
    public final DetectLabelsImagePropertiesSettings imageProperties() {
        return imageProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(generalLabels());
        hashCode = 31 * hashCode + Objects.hashCode(imageProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectLabelsSettings)) {
            return false;
        }
        DetectLabelsSettings other = (DetectLabelsSettings) obj;
        return Objects.equals(generalLabels(), other.generalLabels())
                && Objects.equals(imageProperties(), other.imageProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectLabelsSettings").add("GeneralLabels", generalLabels())
                .add("ImageProperties", imageProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GeneralLabels":
            return Optional.ofNullable(clazz.cast(generalLabels()));
        case "ImageProperties":
            return Optional.ofNullable(clazz.cast(imageProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectLabelsSettings, T> g) {
        return obj -> g.apply((DetectLabelsSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DetectLabelsSettings> {
        /**
         * <p>
         * Contains the specified filters for GENERAL_LABELS.
         * </p>
         * 
         * @param generalLabels
         *        Contains the specified filters for GENERAL_LABELS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generalLabels(GeneralLabelsSettings generalLabels);

        /**
         * <p>
         * Contains the specified filters for GENERAL_LABELS.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeneralLabelsSettings.Builder} avoiding
         * the need to create one manually via {@link GeneralLabelsSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeneralLabelsSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #generalLabels(GeneralLabelsSettings)}.
         * 
         * @param generalLabels
         *        a consumer that will call methods on {@link GeneralLabelsSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #generalLabels(GeneralLabelsSettings)
         */
        default Builder generalLabels(Consumer<GeneralLabelsSettings.Builder> generalLabels) {
            return generalLabels(GeneralLabelsSettings.builder().applyMutation(generalLabels).build());
        }

        /**
         * <p>
         * Contains the chosen number of maximum dominant colors in an image.
         * </p>
         * 
         * @param imageProperties
         *        Contains the chosen number of maximum dominant colors in an image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageProperties(DetectLabelsImagePropertiesSettings imageProperties);

        /**
         * <p>
         * Contains the chosen number of maximum dominant colors in an image.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DetectLabelsImagePropertiesSettings.Builder} avoiding the need to create one manually via
         * {@link DetectLabelsImagePropertiesSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DetectLabelsImagePropertiesSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #imageProperties(DetectLabelsImagePropertiesSettings)}.
         * 
         * @param imageProperties
         *        a consumer that will call methods on {@link DetectLabelsImagePropertiesSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageProperties(DetectLabelsImagePropertiesSettings)
         */
        default Builder imageProperties(Consumer<DetectLabelsImagePropertiesSettings.Builder> imageProperties) {
            return imageProperties(DetectLabelsImagePropertiesSettings.builder().applyMutation(imageProperties).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GeneralLabelsSettings generalLabels;

        private DetectLabelsImagePropertiesSettings imageProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectLabelsSettings model) {
            generalLabels(model.generalLabels);
            imageProperties(model.imageProperties);
        }

        public final GeneralLabelsSettings.Builder getGeneralLabels() {
            return generalLabels != null ? generalLabels.toBuilder() : null;
        }

        public final void setGeneralLabels(GeneralLabelsSettings.BuilderImpl generalLabels) {
            this.generalLabels = generalLabels != null ? generalLabels.build() : null;
        }

        @Override
        public final Builder generalLabels(GeneralLabelsSettings generalLabels) {
            this.generalLabels = generalLabels;
            return this;
        }

        public final DetectLabelsImagePropertiesSettings.Builder getImageProperties() {
            return imageProperties != null ? imageProperties.toBuilder() : null;
        }

        public final void setImageProperties(DetectLabelsImagePropertiesSettings.BuilderImpl imageProperties) {
            this.imageProperties = imageProperties != null ? imageProperties.build() : null;
        }

        @Override
        public final Builder imageProperties(DetectLabelsImagePropertiesSettings imageProperties) {
            this.imageProperties = imageProperties;
            return this;
        }

        @Override
        public DetectLabelsSettings build() {
            return new DetectLabelsSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
