/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeProjectsResponse extends RekognitionResponse implements
        ToCopyableBuilder<DescribeProjectsResponse.Builder, DescribeProjectsResponse> {
    private static final SdkField<List<ProjectDescription>> PROJECT_DESCRIPTIONS_FIELD = SdkField
            .<List<ProjectDescription>> builder(MarshallingType.LIST)
            .memberName("ProjectDescriptions")
            .getter(getter(DescribeProjectsResponse::projectDescriptions))
            .setter(setter(Builder::projectDescriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectDescriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProjectDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProjectDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeProjectsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_DESCRIPTIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ProjectDescription> projectDescriptions;

    private final String nextToken;

    private DescribeProjectsResponse(BuilderImpl builder) {
        super(builder);
        this.projectDescriptions = builder.projectDescriptions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProjectDescriptions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProjectDescriptions() {
        return projectDescriptions != null && !(projectDescriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of project descriptions. The list is sorted by the date and time the projects are created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProjectDescriptions} method.
     * </p>
     * 
     * @return A list of project descriptions. The list is sorted by the date and time the projects are created.
     */
    public final List<ProjectDescription> projectDescriptions() {
        return projectDescriptions;
    }

    /**
     * <p>
     * If the previous response was incomplete (because there is more results to retrieve), Amazon Rekognition Custom
     * Labels returns a pagination token in the response. You can use this pagination token to retrieve the next set of
     * results.
     * </p>
     * 
     * @return If the previous response was incomplete (because there is more results to retrieve), Amazon Rekognition
     *         Custom Labels returns a pagination token in the response. You can use this pagination token to retrieve
     *         the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasProjectDescriptions() ? projectDescriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProjectsResponse)) {
            return false;
        }
        DescribeProjectsResponse other = (DescribeProjectsResponse) obj;
        return hasProjectDescriptions() == other.hasProjectDescriptions()
                && Objects.equals(projectDescriptions(), other.projectDescriptions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeProjectsResponse")
                .add("ProjectDescriptions", hasProjectDescriptions() ? projectDescriptions() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProjectDescriptions":
            return Optional.ofNullable(clazz.cast(projectDescriptions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProjectsResponse, T> g) {
        return obj -> g.apply((DescribeProjectsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeProjectsResponse> {
        /**
         * <p>
         * A list of project descriptions. The list is sorted by the date and time the projects are created.
         * </p>
         * 
         * @param projectDescriptions
         *        A list of project descriptions. The list is sorted by the date and time the projects are created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectDescriptions(Collection<ProjectDescription> projectDescriptions);

        /**
         * <p>
         * A list of project descriptions. The list is sorted by the date and time the projects are created.
         * </p>
         * 
         * @param projectDescriptions
         *        A list of project descriptions. The list is sorted by the date and time the projects are created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectDescriptions(ProjectDescription... projectDescriptions);

        /**
         * <p>
         * A list of project descriptions. The list is sorted by the date and time the projects are created.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rekognition.model.ProjectDescription.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.rekognition.model.ProjectDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rekognition.model.ProjectDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #projectDescriptions(List<ProjectDescription>)}.
         * 
         * @param projectDescriptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rekognition.model.ProjectDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #projectDescriptions(java.util.Collection<ProjectDescription>)
         */
        Builder projectDescriptions(Consumer<ProjectDescription.Builder>... projectDescriptions);

        /**
         * <p>
         * If the previous response was incomplete (because there is more results to retrieve), Amazon Rekognition
         * Custom Labels returns a pagination token in the response. You can use this pagination token to retrieve the
         * next set of results.
         * </p>
         * 
         * @param nextToken
         *        If the previous response was incomplete (because there is more results to retrieve), Amazon
         *        Rekognition Custom Labels returns a pagination token in the response. You can use this pagination
         *        token to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private List<ProjectDescription> projectDescriptions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProjectsResponse model) {
            super(model);
            projectDescriptions(model.projectDescriptions);
            nextToken(model.nextToken);
        }

        public final List<ProjectDescription.Builder> getProjectDescriptions() {
            List<ProjectDescription.Builder> result = ProjectDescriptionsCopier.copyToBuilder(this.projectDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProjectDescriptions(Collection<ProjectDescription.BuilderImpl> projectDescriptions) {
            this.projectDescriptions = ProjectDescriptionsCopier.copyFromBuilder(projectDescriptions);
        }

        @Override
        public final Builder projectDescriptions(Collection<ProjectDescription> projectDescriptions) {
            this.projectDescriptions = ProjectDescriptionsCopier.copy(projectDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectDescriptions(ProjectDescription... projectDescriptions) {
            projectDescriptions(Arrays.asList(projectDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectDescriptions(Consumer<ProjectDescription.Builder>... projectDescriptions) {
            projectDescriptions(Stream.of(projectDescriptions).map(c -> ProjectDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeProjectsResponse build() {
            return new DescribeProjectsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
