/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.GroundTruthManifest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatasetSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatasetSource> {
    private static final SdkField<GroundTruthManifest> GROUND_TRUTH_MANIFEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GroundTruthManifest").getter(DatasetSource.getter(DatasetSource::groundTruthManifest)).setter(DatasetSource.setter(Builder::groundTruthManifest)).constructor(GroundTruthManifest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroundTruthManifest").build()}).build();
    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetArn").getter(DatasetSource.getter(DatasetSource::datasetArn)).setter(DatasetSource.setter(Builder::datasetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUND_TRUTH_MANIFEST_FIELD, DATASET_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final GroundTruthManifest groundTruthManifest;
    private final String datasetArn;

    private DatasetSource(BuilderImpl builder) {
        this.groundTruthManifest = builder.groundTruthManifest;
        this.datasetArn = builder.datasetArn;
    }

    public final GroundTruthManifest groundTruthManifest() {
        return this.groundTruthManifest;
    }

    public final String datasetArn() {
        return this.datasetArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groundTruthManifest());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetSource)) {
            return false;
        }
        DatasetSource other = (DatasetSource)obj;
        return Objects.equals(this.groundTruthManifest(), other.groundTruthManifest()) && Objects.equals(this.datasetArn(), other.datasetArn());
    }

    public final String toString() {
        return ToString.builder((String)"DatasetSource").add("GroundTruthManifest", (Object)this.groundTruthManifest()).add("DatasetArn", (Object)this.datasetArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroundTruthManifest": {
                return Optional.ofNullable(clazz.cast(this.groundTruthManifest()));
            }
            case "DatasetArn": {
                return Optional.ofNullable(clazz.cast(this.datasetArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatasetSource, T> g) {
        return obj -> g.apply((DatasetSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private GroundTruthManifest groundTruthManifest;
        private String datasetArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetSource model) {
            this.groundTruthManifest(model.groundTruthManifest);
            this.datasetArn(model.datasetArn);
        }

        public final GroundTruthManifest.Builder getGroundTruthManifest() {
            return this.groundTruthManifest != null ? this.groundTruthManifest.toBuilder() : null;
        }

        public final void setGroundTruthManifest(GroundTruthManifest.BuilderImpl groundTruthManifest) {
            this.groundTruthManifest = groundTruthManifest != null ? groundTruthManifest.build() : null;
        }

        @Override
        public final Builder groundTruthManifest(GroundTruthManifest groundTruthManifest) {
            this.groundTruthManifest = groundTruthManifest;
            return this;
        }

        public final String getDatasetArn() {
            return this.datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public DatasetSource build() {
            return new DatasetSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatasetSource> {
        public Builder groundTruthManifest(GroundTruthManifest var1);

        default public Builder groundTruthManifest(Consumer<GroundTruthManifest.Builder> groundTruthManifest) {
            return this.groundTruthManifest((GroundTruthManifest)((GroundTruthManifest.Builder)GroundTruthManifest.builder().applyMutation(groundTruthManifest)).build());
        }

        public Builder datasetArn(String var1);
    }
}

