/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDatasetRequest extends RekognitionRequest implements
        ToCopyableBuilder<CreateDatasetRequest.Builder, CreateDatasetRequest> {
    private static final SdkField<DatasetSource> DATASET_SOURCE_FIELD = SdkField
            .<DatasetSource> builder(MarshallingType.SDK_POJO).memberName("DatasetSource")
            .getter(getter(CreateDatasetRequest::datasetSource)).setter(setter(Builder::datasetSource))
            .constructor(DatasetSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetSource").build()).build();

    private static final SdkField<String> DATASET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetType").getter(getter(CreateDatasetRequest::datasetTypeAsString))
            .setter(setter(Builder::datasetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetType").build()).build();

    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectArn").getter(getter(CreateDatasetRequest::projectArn)).setter(setter(Builder::projectArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_SOURCE_FIELD,
            DATASET_TYPE_FIELD, PROJECT_ARN_FIELD));

    private final DatasetSource datasetSource;

    private final String datasetType;

    private final String projectArn;

    private CreateDatasetRequest(BuilderImpl builder) {
        super(builder);
        this.datasetSource = builder.datasetSource;
        this.datasetType = builder.datasetType;
        this.projectArn = builder.projectArn;
    }

    /**
     * <p>
     * The source files for the dataset. You can specify the ARN of an existing dataset or specify the Amazon S3 bucket
     * location of an Amazon Sagemaker format manifest file. If you don't specify <code>datasetSource</code>, an empty
     * dataset is created. To add labeled images to the dataset, You can use the console or call
     * <a>UpdateDatasetEntries</a>.
     * </p>
     * 
     * @return The source files for the dataset. You can specify the ARN of an existing dataset or specify the Amazon S3
     *         bucket location of an Amazon Sagemaker format manifest file. If you don't specify
     *         <code>datasetSource</code>, an empty dataset is created. To add labeled images to the dataset, You can
     *         use the console or call <a>UpdateDatasetEntries</a>.
     */
    public final DatasetSource datasetSource() {
        return datasetSource;
    }

    /**
     * <p>
     * The type of the dataset. Specify <code>TRAIN</code> to create a training dataset. Specify <code>TEST</code> to
     * create a test dataset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #datasetType} will
     * return {@link DatasetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #datasetTypeAsString}.
     * </p>
     * 
     * @return The type of the dataset. Specify <code>TRAIN</code> to create a training dataset. Specify
     *         <code>TEST</code> to create a test dataset.
     * @see DatasetType
     */
    public final DatasetType datasetType() {
        return DatasetType.fromValue(datasetType);
    }

    /**
     * <p>
     * The type of the dataset. Specify <code>TRAIN</code> to create a training dataset. Specify <code>TEST</code> to
     * create a test dataset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #datasetType} will
     * return {@link DatasetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #datasetTypeAsString}.
     * </p>
     * 
     * @return The type of the dataset. Specify <code>TRAIN</code> to create a training dataset. Specify
     *         <code>TEST</code> to create a test dataset.
     * @see DatasetType
     */
    public final String datasetTypeAsString() {
        return datasetType;
    }

    /**
     * <p>
     * The ARN of the Amazon Rekognition Custom Labels project to which you want to asssign the dataset.
     * </p>
     * 
     * @return The ARN of the Amazon Rekognition Custom Labels project to which you want to asssign the dataset.
     */
    public final String projectArn() {
        return projectArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datasetSource());
        hashCode = 31 * hashCode + Objects.hashCode(datasetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(projectArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDatasetRequest)) {
            return false;
        }
        CreateDatasetRequest other = (CreateDatasetRequest) obj;
        return Objects.equals(datasetSource(), other.datasetSource())
                && Objects.equals(datasetTypeAsString(), other.datasetTypeAsString())
                && Objects.equals(projectArn(), other.projectArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDatasetRequest").add("DatasetSource", datasetSource())
                .add("DatasetType", datasetTypeAsString()).add("ProjectArn", projectArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatasetSource":
            return Optional.ofNullable(clazz.cast(datasetSource()));
        case "DatasetType":
            return Optional.ofNullable(clazz.cast(datasetTypeAsString()));
        case "ProjectArn":
            return Optional.ofNullable(clazz.cast(projectArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDatasetRequest, T> g) {
        return obj -> g.apply((CreateDatasetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDatasetRequest> {
        /**
         * <p>
         * The source files for the dataset. You can specify the ARN of an existing dataset or specify the Amazon S3
         * bucket location of an Amazon Sagemaker format manifest file. If you don't specify <code>datasetSource</code>,
         * an empty dataset is created. To add labeled images to the dataset, You can use the console or call
         * <a>UpdateDatasetEntries</a>.
         * </p>
         * 
         * @param datasetSource
         *        The source files for the dataset. You can specify the ARN of an existing dataset or specify the Amazon
         *        S3 bucket location of an Amazon Sagemaker format manifest file. If you don't specify
         *        <code>datasetSource</code>, an empty dataset is created. To add labeled images to the dataset, You can
         *        use the console or call <a>UpdateDatasetEntries</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetSource(DatasetSource datasetSource);

        /**
         * <p>
         * The source files for the dataset. You can specify the ARN of an existing dataset or specify the Amazon S3
         * bucket location of an Amazon Sagemaker format manifest file. If you don't specify <code>datasetSource</code>,
         * an empty dataset is created. To add labeled images to the dataset, You can use the console or call
         * <a>UpdateDatasetEntries</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link DatasetSource.Builder} avoiding the need
         * to create one manually via {@link DatasetSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatasetSource.Builder#build()} is called immediately and its
         * result is passed to {@link #datasetSource(DatasetSource)}.
         * 
         * @param datasetSource
         *        a consumer that will call methods on {@link DatasetSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datasetSource(DatasetSource)
         */
        default Builder datasetSource(Consumer<DatasetSource.Builder> datasetSource) {
            return datasetSource(DatasetSource.builder().applyMutation(datasetSource).build());
        }

        /**
         * <p>
         * The type of the dataset. Specify <code>TRAIN</code> to create a training dataset. Specify <code>TEST</code>
         * to create a test dataset.
         * </p>
         * 
         * @param datasetType
         *        The type of the dataset. Specify <code>TRAIN</code> to create a training dataset. Specify
         *        <code>TEST</code> to create a test dataset.
         * @see DatasetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetType
         */
        Builder datasetType(String datasetType);

        /**
         * <p>
         * The type of the dataset. Specify <code>TRAIN</code> to create a training dataset. Specify <code>TEST</code>
         * to create a test dataset.
         * </p>
         * 
         * @param datasetType
         *        The type of the dataset. Specify <code>TRAIN</code> to create a training dataset. Specify
         *        <code>TEST</code> to create a test dataset.
         * @see DatasetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetType
         */
        Builder datasetType(DatasetType datasetType);

        /**
         * <p>
         * The ARN of the Amazon Rekognition Custom Labels project to which you want to asssign the dataset.
         * </p>
         * 
         * @param projectArn
         *        The ARN of the Amazon Rekognition Custom Labels project to which you want to asssign the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectArn(String projectArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private DatasetSource datasetSource;

        private String datasetType;

        private String projectArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDatasetRequest model) {
            super(model);
            datasetSource(model.datasetSource);
            datasetType(model.datasetType);
            projectArn(model.projectArn);
        }

        public final DatasetSource.Builder getDatasetSource() {
            return datasetSource != null ? datasetSource.toBuilder() : null;
        }

        public final void setDatasetSource(DatasetSource.BuilderImpl datasetSource) {
            this.datasetSource = datasetSource != null ? datasetSource.build() : null;
        }

        @Override
        public final Builder datasetSource(DatasetSource datasetSource) {
            this.datasetSource = datasetSource;
            return this;
        }

        public final String getDatasetType() {
            return datasetType;
        }

        public final void setDatasetType(String datasetType) {
            this.datasetType = datasetType;
        }

        @Override
        public final Builder datasetType(String datasetType) {
            this.datasetType = datasetType;
            return this;
        }

        @Override
        public final Builder datasetType(DatasetType datasetType) {
            this.datasetType(datasetType == null ? null : datasetType.toString());
            return this;
        }

        public final String getProjectArn() {
            return projectArn;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDatasetRequest build() {
            return new CreateDatasetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
