/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The dataset used for testing. Optionally, if <code>AutoCreate</code> is set, Amazon Rekognition Custom Labels uses
 * the training dataset to create a test dataset with a temporary split of the training dataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestingData implements SdkPojo, Serializable, ToCopyableBuilder<TestingData.Builder, TestingData> {
    private static final SdkField<List<Asset>> ASSETS_FIELD = SdkField
            .<List<Asset>> builder(MarshallingType.LIST)
            .memberName("Assets")
            .getter(getter(TestingData::assets))
            .setter(setter(Builder::assets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Assets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Asset> builder(MarshallingType.SDK_POJO)
                                            .constructor(Asset::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> AUTO_CREATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoCreate").getter(getter(TestingData::autoCreate)).setter(setter(Builder::autoCreate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoCreate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSETS_FIELD,
            AUTO_CREATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Asset> assets;

    private final Boolean autoCreate;

    private TestingData(BuilderImpl builder) {
        this.assets = builder.assets;
        this.autoCreate = builder.autoCreate;
    }

    /**
     * For responses, this returns true if the service returned a value for the Assets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAssets() {
        return assets != null && !(assets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The assets used for testing.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssets} method.
     * </p>
     * 
     * @return The assets used for testing.
     */
    public final List<Asset> assets() {
        return assets;
    }

    /**
     * <p>
     * If specified, Amazon Rekognition Custom Labels temporarily splits the training dataset (80%) to create a test
     * dataset (20%) for the training job. After training completes, the test dataset is not stored and the training
     * dataset reverts to its previous size.
     * </p>
     * 
     * @return If specified, Amazon Rekognition Custom Labels temporarily splits the training dataset (80%) to create a
     *         test dataset (20%) for the training job. After training completes, the test dataset is not stored and the
     *         training dataset reverts to its previous size.
     */
    public final Boolean autoCreate() {
        return autoCreate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAssets() ? assets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(autoCreate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestingData)) {
            return false;
        }
        TestingData other = (TestingData) obj;
        return hasAssets() == other.hasAssets() && Objects.equals(assets(), other.assets())
                && Objects.equals(autoCreate(), other.autoCreate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestingData").add("Assets", hasAssets() ? assets() : null).add("AutoCreate", autoCreate())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Assets":
            return Optional.ofNullable(clazz.cast(assets()));
        case "AutoCreate":
            return Optional.ofNullable(clazz.cast(autoCreate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestingData, T> g) {
        return obj -> g.apply((TestingData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TestingData> {
        /**
         * <p>
         * The assets used for testing.
         * </p>
         * 
         * @param assets
         *        The assets used for testing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assets(Collection<Asset> assets);

        /**
         * <p>
         * The assets used for testing.
         * </p>
         * 
         * @param assets
         *        The assets used for testing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assets(Asset... assets);

        /**
         * <p>
         * The assets used for testing.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rekognition.model.Asset.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.rekognition.model.Asset#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rekognition.model.Asset.Builder#build()} is called immediately and its
         * result is passed to {@link #assets(List<Asset>)}.
         * 
         * @param assets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rekognition.model.Asset.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assets(java.util.Collection<Asset>)
         */
        Builder assets(Consumer<Asset.Builder>... assets);

        /**
         * <p>
         * If specified, Amazon Rekognition Custom Labels temporarily splits the training dataset (80%) to create a test
         * dataset (20%) for the training job. After training completes, the test dataset is not stored and the training
         * dataset reverts to its previous size.
         * </p>
         * 
         * @param autoCreate
         *        If specified, Amazon Rekognition Custom Labels temporarily splits the training dataset (80%) to create
         *        a test dataset (20%) for the training job. After training completes, the test dataset is not stored
         *        and the training dataset reverts to its previous size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoCreate(Boolean autoCreate);
    }

    static final class BuilderImpl implements Builder {
        private List<Asset> assets = DefaultSdkAutoConstructList.getInstance();

        private Boolean autoCreate;

        private BuilderImpl() {
        }

        private BuilderImpl(TestingData model) {
            assets(model.assets);
            autoCreate(model.autoCreate);
        }

        public final List<Asset.Builder> getAssets() {
            List<Asset.Builder> result = AssetsCopier.copyToBuilder(this.assets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssets(Collection<Asset.BuilderImpl> assets) {
            this.assets = AssetsCopier.copyFromBuilder(assets);
        }

        @Override
        public final Builder assets(Collection<Asset> assets) {
            this.assets = AssetsCopier.copy(assets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assets(Asset... assets) {
            assets(Arrays.asList(assets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assets(Consumer<Asset.Builder>... assets) {
            assets(Stream.of(assets).map(c -> Asset.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getAutoCreate() {
            return autoCreate;
        }

        public final void setAutoCreate(Boolean autoCreate) {
            this.autoCreate = autoCreate;
        }

        @Override
        public final Builder autoCreate(Boolean autoCreate) {
            this.autoCreate = autoCreate;
            return this;
        }

        @Override
        public TestingData build() {
            return new TestingData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
