/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFaceLivenessSessionResultsResponse extends RekognitionResponse implements
        ToCopyableBuilder<GetFaceLivenessSessionResultsResponse.Builder, GetFaceLivenessSessionResultsResponse> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SessionId").getter(getter(GetFaceLivenessSessionResultsResponse::sessionId))
            .setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetFaceLivenessSessionResultsResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Float> CONFIDENCE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("Confidence").getter(getter(GetFaceLivenessSessionResultsResponse::confidence))
            .setter(setter(Builder::confidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()).build();

    private static final SdkField<AuditImage> REFERENCE_IMAGE_FIELD = SdkField.<AuditImage> builder(MarshallingType.SDK_POJO)
            .memberName("ReferenceImage").getter(getter(GetFaceLivenessSessionResultsResponse::referenceImage))
            .setter(setter(Builder::referenceImage)).constructor(AuditImage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceImage").build()).build();

    private static final SdkField<List<AuditImage>> AUDIT_IMAGES_FIELD = SdkField
            .<List<AuditImage>> builder(MarshallingType.LIST)
            .memberName("AuditImages")
            .getter(getter(GetFaceLivenessSessionResultsResponse::auditImages))
            .setter(setter(Builder::auditImages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditImages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AuditImage> builder(MarshallingType.SDK_POJO)
                                            .constructor(AuditImage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ID_FIELD,
            STATUS_FIELD, CONFIDENCE_FIELD, REFERENCE_IMAGE_FIELD, AUDIT_IMAGES_FIELD));

    private final String sessionId;

    private final String status;

    private final Float confidence;

    private final AuditImage referenceImage;

    private final List<AuditImage> auditImages;

    private GetFaceLivenessSessionResultsResponse(BuilderImpl builder) {
        super(builder);
        this.sessionId = builder.sessionId;
        this.status = builder.status;
        this.confidence = builder.confidence;
        this.referenceImage = builder.referenceImage;
        this.auditImages = builder.auditImages;
    }

    /**
     * <p>
     * The sessionId for which this request was called.
     * </p>
     * 
     * @return The sessionId for which this request was called.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * Represents a status corresponding to the state of the session. Possible statuses are: CREATED, IN_PROGRESS,
     * SUCCEEDED, FAILED, EXPIRED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LivenessSessionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Represents a status corresponding to the state of the session. Possible statuses are: CREATED,
     *         IN_PROGRESS, SUCCEEDED, FAILED, EXPIRED.
     * @see LivenessSessionStatus
     */
    public final LivenessSessionStatus status() {
        return LivenessSessionStatus.fromValue(status);
    }

    /**
     * <p>
     * Represents a status corresponding to the state of the session. Possible statuses are: CREATED, IN_PROGRESS,
     * SUCCEEDED, FAILED, EXPIRED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LivenessSessionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Represents a status corresponding to the state of the session. Possible statuses are: CREATED,
     *         IN_PROGRESS, SUCCEEDED, FAILED, EXPIRED.
     * @see LivenessSessionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Probabalistic confidence score for if the person in the given video was live, represented as a float value
     * between 0 to 100.
     * </p>
     * 
     * @return Probabalistic confidence score for if the person in the given video was live, represented as a float
     *         value between 0 to 100.
     */
    public final Float confidence() {
        return confidence;
    }

    /**
     * <p>
     * A high-quality image from the Face Liveness video that can be used for face comparison or search. It includes a
     * bounding box of the face and the Base64-encoded bytes that return an image. If the CreateFaceLivenessSession
     * request included an OutputConfig argument, the image will be uploaded to an S3Object specified in the output
     * configuration. In case the reference image is not returned, it's recommended to retry the Liveness check.
     * </p>
     * 
     * @return A high-quality image from the Face Liveness video that can be used for face comparison or search. It
     *         includes a bounding box of the face and the Base64-encoded bytes that return an image. If the
     *         CreateFaceLivenessSession request included an OutputConfig argument, the image will be uploaded to an
     *         S3Object specified in the output configuration. In case the reference image is not returned, it's
     *         recommended to retry the Liveness check.
     */
    public final AuditImage referenceImage() {
        return referenceImage;
    }

    /**
     * For responses, this returns true if the service returned a value for the AuditImages property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAuditImages() {
        return auditImages != null && !(auditImages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of images from the Face Liveness video that can be used for audit purposes. It includes a bounding box of
     * the face and the Base64-encoded bytes that return an image. If the CreateFaceLivenessSession request included an
     * OutputConfig argument, the image will be uploaded to an S3Object specified in the output configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuditImages} method.
     * </p>
     * 
     * @return A set of images from the Face Liveness video that can be used for audit purposes. It includes a bounding
     *         box of the face and the Base64-encoded bytes that return an image. If the CreateFaceLivenessSession
     *         request included an OutputConfig argument, the image will be uploaded to an S3Object specified in the
     *         output configuration.
     */
    public final List<AuditImage> auditImages() {
        return auditImages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(confidence());
        hashCode = 31 * hashCode + Objects.hashCode(referenceImage());
        hashCode = 31 * hashCode + Objects.hashCode(hasAuditImages() ? auditImages() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFaceLivenessSessionResultsResponse)) {
            return false;
        }
        GetFaceLivenessSessionResultsResponse other = (GetFaceLivenessSessionResultsResponse) obj;
        return Objects.equals(sessionId(), other.sessionId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(confidence(), other.confidence()) && Objects.equals(referenceImage(), other.referenceImage())
                && hasAuditImages() == other.hasAuditImages() && Objects.equals(auditImages(), other.auditImages());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFaceLivenessSessionResultsResponse").add("SessionId", sessionId())
                .add("Status", statusAsString()).add("Confidence", confidence()).add("ReferenceImage", referenceImage())
                .add("AuditImages", hasAuditImages() ? auditImages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Confidence":
            return Optional.ofNullable(clazz.cast(confidence()));
        case "ReferenceImage":
            return Optional.ofNullable(clazz.cast(referenceImage()));
        case "AuditImages":
            return Optional.ofNullable(clazz.cast(auditImages()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFaceLivenessSessionResultsResponse, T> g) {
        return obj -> g.apply((GetFaceLivenessSessionResultsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetFaceLivenessSessionResultsResponse> {
        /**
         * <p>
         * The sessionId for which this request was called.
         * </p>
         * 
         * @param sessionId
         *        The sessionId for which this request was called.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * Represents a status corresponding to the state of the session. Possible statuses are: CREATED, IN_PROGRESS,
         * SUCCEEDED, FAILED, EXPIRED.
         * </p>
         * 
         * @param status
         *        Represents a status corresponding to the state of the session. Possible statuses are: CREATED,
         *        IN_PROGRESS, SUCCEEDED, FAILED, EXPIRED.
         * @see LivenessSessionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LivenessSessionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Represents a status corresponding to the state of the session. Possible statuses are: CREATED, IN_PROGRESS,
         * SUCCEEDED, FAILED, EXPIRED.
         * </p>
         * 
         * @param status
         *        Represents a status corresponding to the state of the session. Possible statuses are: CREATED,
         *        IN_PROGRESS, SUCCEEDED, FAILED, EXPIRED.
         * @see LivenessSessionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LivenessSessionStatus
         */
        Builder status(LivenessSessionStatus status);

        /**
         * <p>
         * Probabalistic confidence score for if the person in the given video was live, represented as a float value
         * between 0 to 100.
         * </p>
         * 
         * @param confidence
         *        Probabalistic confidence score for if the person in the given video was live, represented as a float
         *        value between 0 to 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Float confidence);

        /**
         * <p>
         * A high-quality image from the Face Liveness video that can be used for face comparison or search. It includes
         * a bounding box of the face and the Base64-encoded bytes that return an image. If the
         * CreateFaceLivenessSession request included an OutputConfig argument, the image will be uploaded to an
         * S3Object specified in the output configuration. In case the reference image is not returned, it's recommended
         * to retry the Liveness check.
         * </p>
         * 
         * @param referenceImage
         *        A high-quality image from the Face Liveness video that can be used for face comparison or search. It
         *        includes a bounding box of the face and the Base64-encoded bytes that return an image. If the
         *        CreateFaceLivenessSession request included an OutputConfig argument, the image will be uploaded to an
         *        S3Object specified in the output configuration. In case the reference image is not returned, it's
         *        recommended to retry the Liveness check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceImage(AuditImage referenceImage);

        /**
         * <p>
         * A high-quality image from the Face Liveness video that can be used for face comparison or search. It includes
         * a bounding box of the face and the Base64-encoded bytes that return an image. If the
         * CreateFaceLivenessSession request included an OutputConfig argument, the image will be uploaded to an
         * S3Object specified in the output configuration. In case the reference image is not returned, it's recommended
         * to retry the Liveness check.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuditImage.Builder} avoiding the need to
         * create one manually via {@link AuditImage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AuditImage.Builder#build()} is called immediately and its result
         * is passed to {@link #referenceImage(AuditImage)}.
         * 
         * @param referenceImage
         *        a consumer that will call methods on {@link AuditImage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #referenceImage(AuditImage)
         */
        default Builder referenceImage(Consumer<AuditImage.Builder> referenceImage) {
            return referenceImage(AuditImage.builder().applyMutation(referenceImage).build());
        }

        /**
         * <p>
         * A set of images from the Face Liveness video that can be used for audit purposes. It includes a bounding box
         * of the face and the Base64-encoded bytes that return an image. If the CreateFaceLivenessSession request
         * included an OutputConfig argument, the image will be uploaded to an S3Object specified in the output
         * configuration.
         * </p>
         * 
         * @param auditImages
         *        A set of images from the Face Liveness video that can be used for audit purposes. It includes a
         *        bounding box of the face and the Base64-encoded bytes that return an image. If the
         *        CreateFaceLivenessSession request included an OutputConfig argument, the image will be uploaded to an
         *        S3Object specified in the output configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditImages(Collection<AuditImage> auditImages);

        /**
         * <p>
         * A set of images from the Face Liveness video that can be used for audit purposes. It includes a bounding box
         * of the face and the Base64-encoded bytes that return an image. If the CreateFaceLivenessSession request
         * included an OutputConfig argument, the image will be uploaded to an S3Object specified in the output
         * configuration.
         * </p>
         * 
         * @param auditImages
         *        A set of images from the Face Liveness video that can be used for audit purposes. It includes a
         *        bounding box of the face and the Base64-encoded bytes that return an image. If the
         *        CreateFaceLivenessSession request included an OutputConfig argument, the image will be uploaded to an
         *        S3Object specified in the output configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditImages(AuditImage... auditImages);

        /**
         * <p>
         * A set of images from the Face Liveness video that can be used for audit purposes. It includes a bounding box
         * of the face and the Base64-encoded bytes that return an image. If the CreateFaceLivenessSession request
         * included an OutputConfig argument, the image will be uploaded to an S3Object specified in the output
         * configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rekognition.model.AuditImage.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.rekognition.model.AuditImage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rekognition.model.AuditImage.Builder#build()} is called immediately
         * and its result is passed to {@link #auditImages(List<AuditImage>)}.
         * 
         * @param auditImages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rekognition.model.AuditImage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #auditImages(java.util.Collection<AuditImage>)
         */
        Builder auditImages(Consumer<AuditImage.Builder>... auditImages);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private String sessionId;

        private String status;

        private Float confidence;

        private AuditImage referenceImage;

        private List<AuditImage> auditImages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetFaceLivenessSessionResultsResponse model) {
            super(model);
            sessionId(model.sessionId);
            status(model.status);
            confidence(model.confidence);
            referenceImage(model.referenceImage);
            auditImages(model.auditImages);
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LivenessSessionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Float getConfidence() {
            return confidence;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final AuditImage.Builder getReferenceImage() {
            return referenceImage != null ? referenceImage.toBuilder() : null;
        }

        public final void setReferenceImage(AuditImage.BuilderImpl referenceImage) {
            this.referenceImage = referenceImage != null ? referenceImage.build() : null;
        }

        @Override
        public final Builder referenceImage(AuditImage referenceImage) {
            this.referenceImage = referenceImage;
            return this;
        }

        public final List<AuditImage.Builder> getAuditImages() {
            List<AuditImage.Builder> result = AuditImagesCopier.copyToBuilder(this.auditImages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAuditImages(Collection<AuditImage.BuilderImpl> auditImages) {
            this.auditImages = AuditImagesCopier.copyFromBuilder(auditImages);
        }

        @Override
        public final Builder auditImages(Collection<AuditImage> auditImages) {
            this.auditImages = AuditImagesCopier.copy(auditImages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auditImages(AuditImage... auditImages) {
            auditImages(Arrays.asList(auditImages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auditImages(Consumer<AuditImage.Builder>... auditImages) {
            auditImages(Stream.of(auditImages).map(c -> AuditImage.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetFaceLivenessSessionResultsResponse build() {
            return new GetFaceLivenessSessionResultsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
