/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.rekognition.internal.RekognitionServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.rekognition.model.AccessDeniedException;
import software.amazon.awssdk.services.rekognition.model.AssociateFacesRequest;
import software.amazon.awssdk.services.rekognition.model.AssociateFacesResponse;
import software.amazon.awssdk.services.rekognition.model.CompareFacesRequest;
import software.amazon.awssdk.services.rekognition.model.CompareFacesResponse;
import software.amazon.awssdk.services.rekognition.model.ConflictException;
import software.amazon.awssdk.services.rekognition.model.CopyProjectVersionRequest;
import software.amazon.awssdk.services.rekognition.model.CopyProjectVersionResponse;
import software.amazon.awssdk.services.rekognition.model.CreateCollectionRequest;
import software.amazon.awssdk.services.rekognition.model.CreateCollectionResponse;
import software.amazon.awssdk.services.rekognition.model.CreateDatasetRequest;
import software.amazon.awssdk.services.rekognition.model.CreateDatasetResponse;
import software.amazon.awssdk.services.rekognition.model.CreateFaceLivenessSessionRequest;
import software.amazon.awssdk.services.rekognition.model.CreateFaceLivenessSessionResponse;
import software.amazon.awssdk.services.rekognition.model.CreateProjectRequest;
import software.amazon.awssdk.services.rekognition.model.CreateProjectResponse;
import software.amazon.awssdk.services.rekognition.model.CreateProjectVersionRequest;
import software.amazon.awssdk.services.rekognition.model.CreateProjectVersionResponse;
import software.amazon.awssdk.services.rekognition.model.CreateStreamProcessorRequest;
import software.amazon.awssdk.services.rekognition.model.CreateStreamProcessorResponse;
import software.amazon.awssdk.services.rekognition.model.CreateUserRequest;
import software.amazon.awssdk.services.rekognition.model.CreateUserResponse;
import software.amazon.awssdk.services.rekognition.model.DeleteCollectionRequest;
import software.amazon.awssdk.services.rekognition.model.DeleteCollectionResponse;
import software.amazon.awssdk.services.rekognition.model.DeleteDatasetRequest;
import software.amazon.awssdk.services.rekognition.model.DeleteDatasetResponse;
import software.amazon.awssdk.services.rekognition.model.DeleteFacesRequest;
import software.amazon.awssdk.services.rekognition.model.DeleteFacesResponse;
import software.amazon.awssdk.services.rekognition.model.DeleteProjectPolicyRequest;
import software.amazon.awssdk.services.rekognition.model.DeleteProjectPolicyResponse;
import software.amazon.awssdk.services.rekognition.model.DeleteProjectRequest;
import software.amazon.awssdk.services.rekognition.model.DeleteProjectResponse;
import software.amazon.awssdk.services.rekognition.model.DeleteProjectVersionRequest;
import software.amazon.awssdk.services.rekognition.model.DeleteProjectVersionResponse;
import software.amazon.awssdk.services.rekognition.model.DeleteStreamProcessorRequest;
import software.amazon.awssdk.services.rekognition.model.DeleteStreamProcessorResponse;
import software.amazon.awssdk.services.rekognition.model.DeleteUserRequest;
import software.amazon.awssdk.services.rekognition.model.DeleteUserResponse;
import software.amazon.awssdk.services.rekognition.model.DescribeCollectionRequest;
import software.amazon.awssdk.services.rekognition.model.DescribeCollectionResponse;
import software.amazon.awssdk.services.rekognition.model.DescribeDatasetRequest;
import software.amazon.awssdk.services.rekognition.model.DescribeDatasetResponse;
import software.amazon.awssdk.services.rekognition.model.DescribeProjectVersionsRequest;
import software.amazon.awssdk.services.rekognition.model.DescribeProjectVersionsResponse;
import software.amazon.awssdk.services.rekognition.model.DescribeProjectsRequest;
import software.amazon.awssdk.services.rekognition.model.DescribeProjectsResponse;
import software.amazon.awssdk.services.rekognition.model.DescribeStreamProcessorRequest;
import software.amazon.awssdk.services.rekognition.model.DescribeStreamProcessorResponse;
import software.amazon.awssdk.services.rekognition.model.DetectCustomLabelsRequest;
import software.amazon.awssdk.services.rekognition.model.DetectCustomLabelsResponse;
import software.amazon.awssdk.services.rekognition.model.DetectFacesRequest;
import software.amazon.awssdk.services.rekognition.model.DetectFacesResponse;
import software.amazon.awssdk.services.rekognition.model.DetectLabelsRequest;
import software.amazon.awssdk.services.rekognition.model.DetectLabelsResponse;
import software.amazon.awssdk.services.rekognition.model.DetectModerationLabelsRequest;
import software.amazon.awssdk.services.rekognition.model.DetectModerationLabelsResponse;
import software.amazon.awssdk.services.rekognition.model.DetectProtectiveEquipmentRequest;
import software.amazon.awssdk.services.rekognition.model.DetectProtectiveEquipmentResponse;
import software.amazon.awssdk.services.rekognition.model.DetectTextRequest;
import software.amazon.awssdk.services.rekognition.model.DetectTextResponse;
import software.amazon.awssdk.services.rekognition.model.DisassociateFacesRequest;
import software.amazon.awssdk.services.rekognition.model.DisassociateFacesResponse;
import software.amazon.awssdk.services.rekognition.model.DistributeDatasetEntriesRequest;
import software.amazon.awssdk.services.rekognition.model.DistributeDatasetEntriesResponse;
import software.amazon.awssdk.services.rekognition.model.GetCelebrityInfoRequest;
import software.amazon.awssdk.services.rekognition.model.GetCelebrityInfoResponse;
import software.amazon.awssdk.services.rekognition.model.GetCelebrityRecognitionRequest;
import software.amazon.awssdk.services.rekognition.model.GetCelebrityRecognitionResponse;
import software.amazon.awssdk.services.rekognition.model.GetContentModerationRequest;
import software.amazon.awssdk.services.rekognition.model.GetContentModerationResponse;
import software.amazon.awssdk.services.rekognition.model.GetFaceDetectionRequest;
import software.amazon.awssdk.services.rekognition.model.GetFaceDetectionResponse;
import software.amazon.awssdk.services.rekognition.model.GetFaceLivenessSessionResultsRequest;
import software.amazon.awssdk.services.rekognition.model.GetFaceLivenessSessionResultsResponse;
import software.amazon.awssdk.services.rekognition.model.GetFaceSearchRequest;
import software.amazon.awssdk.services.rekognition.model.GetFaceSearchResponse;
import software.amazon.awssdk.services.rekognition.model.GetLabelDetectionRequest;
import software.amazon.awssdk.services.rekognition.model.GetLabelDetectionResponse;
import software.amazon.awssdk.services.rekognition.model.GetMediaAnalysisJobRequest;
import software.amazon.awssdk.services.rekognition.model.GetMediaAnalysisJobResponse;
import software.amazon.awssdk.services.rekognition.model.GetPersonTrackingRequest;
import software.amazon.awssdk.services.rekognition.model.GetPersonTrackingResponse;
import software.amazon.awssdk.services.rekognition.model.GetSegmentDetectionRequest;
import software.amazon.awssdk.services.rekognition.model.GetSegmentDetectionResponse;
import software.amazon.awssdk.services.rekognition.model.GetTextDetectionRequest;
import software.amazon.awssdk.services.rekognition.model.GetTextDetectionResponse;
import software.amazon.awssdk.services.rekognition.model.HumanLoopQuotaExceededException;
import software.amazon.awssdk.services.rekognition.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.rekognition.model.ImageTooLargeException;
import software.amazon.awssdk.services.rekognition.model.IndexFacesRequest;
import software.amazon.awssdk.services.rekognition.model.IndexFacesResponse;
import software.amazon.awssdk.services.rekognition.model.InternalServerErrorException;
import software.amazon.awssdk.services.rekognition.model.InvalidImageFormatException;
import software.amazon.awssdk.services.rekognition.model.InvalidManifestException;
import software.amazon.awssdk.services.rekognition.model.InvalidPaginationTokenException;
import software.amazon.awssdk.services.rekognition.model.InvalidParameterException;
import software.amazon.awssdk.services.rekognition.model.InvalidPolicyRevisionIdException;
import software.amazon.awssdk.services.rekognition.model.InvalidS3ObjectException;
import software.amazon.awssdk.services.rekognition.model.LimitExceededException;
import software.amazon.awssdk.services.rekognition.model.ListCollectionsRequest;
import software.amazon.awssdk.services.rekognition.model.ListCollectionsResponse;
import software.amazon.awssdk.services.rekognition.model.ListDatasetEntriesRequest;
import software.amazon.awssdk.services.rekognition.model.ListDatasetEntriesResponse;
import software.amazon.awssdk.services.rekognition.model.ListDatasetLabelsRequest;
import software.amazon.awssdk.services.rekognition.model.ListDatasetLabelsResponse;
import software.amazon.awssdk.services.rekognition.model.ListFacesRequest;
import software.amazon.awssdk.services.rekognition.model.ListFacesResponse;
import software.amazon.awssdk.services.rekognition.model.ListMediaAnalysisJobsRequest;
import software.amazon.awssdk.services.rekognition.model.ListMediaAnalysisJobsResponse;
import software.amazon.awssdk.services.rekognition.model.ListProjectPoliciesRequest;
import software.amazon.awssdk.services.rekognition.model.ListProjectPoliciesResponse;
import software.amazon.awssdk.services.rekognition.model.ListStreamProcessorsRequest;
import software.amazon.awssdk.services.rekognition.model.ListStreamProcessorsResponse;
import software.amazon.awssdk.services.rekognition.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.rekognition.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.rekognition.model.ListUsersRequest;
import software.amazon.awssdk.services.rekognition.model.ListUsersResponse;
import software.amazon.awssdk.services.rekognition.model.MalformedPolicyDocumentException;
import software.amazon.awssdk.services.rekognition.model.ProvisionedThroughputExceededException;
import software.amazon.awssdk.services.rekognition.model.PutProjectPolicyRequest;
import software.amazon.awssdk.services.rekognition.model.PutProjectPolicyResponse;
import software.amazon.awssdk.services.rekognition.model.RecognizeCelebritiesRequest;
import software.amazon.awssdk.services.rekognition.model.RecognizeCelebritiesResponse;
import software.amazon.awssdk.services.rekognition.model.RekognitionException;
import software.amazon.awssdk.services.rekognition.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.rekognition.model.ResourceInUseException;
import software.amazon.awssdk.services.rekognition.model.ResourceNotFoundException;
import software.amazon.awssdk.services.rekognition.model.ResourceNotReadyException;
import software.amazon.awssdk.services.rekognition.model.SearchFacesByImageRequest;
import software.amazon.awssdk.services.rekognition.model.SearchFacesByImageResponse;
import software.amazon.awssdk.services.rekognition.model.SearchFacesRequest;
import software.amazon.awssdk.services.rekognition.model.SearchFacesResponse;
import software.amazon.awssdk.services.rekognition.model.SearchUsersByImageRequest;
import software.amazon.awssdk.services.rekognition.model.SearchUsersByImageResponse;
import software.amazon.awssdk.services.rekognition.model.SearchUsersRequest;
import software.amazon.awssdk.services.rekognition.model.SearchUsersResponse;
import software.amazon.awssdk.services.rekognition.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.rekognition.model.SessionNotFoundException;
import software.amazon.awssdk.services.rekognition.model.StartCelebrityRecognitionRequest;
import software.amazon.awssdk.services.rekognition.model.StartCelebrityRecognitionResponse;
import software.amazon.awssdk.services.rekognition.model.StartContentModerationRequest;
import software.amazon.awssdk.services.rekognition.model.StartContentModerationResponse;
import software.amazon.awssdk.services.rekognition.model.StartFaceDetectionRequest;
import software.amazon.awssdk.services.rekognition.model.StartFaceDetectionResponse;
import software.amazon.awssdk.services.rekognition.model.StartFaceSearchRequest;
import software.amazon.awssdk.services.rekognition.model.StartFaceSearchResponse;
import software.amazon.awssdk.services.rekognition.model.StartLabelDetectionRequest;
import software.amazon.awssdk.services.rekognition.model.StartLabelDetectionResponse;
import software.amazon.awssdk.services.rekognition.model.StartMediaAnalysisJobRequest;
import software.amazon.awssdk.services.rekognition.model.StartMediaAnalysisJobResponse;
import software.amazon.awssdk.services.rekognition.model.StartPersonTrackingRequest;
import software.amazon.awssdk.services.rekognition.model.StartPersonTrackingResponse;
import software.amazon.awssdk.services.rekognition.model.StartProjectVersionRequest;
import software.amazon.awssdk.services.rekognition.model.StartProjectVersionResponse;
import software.amazon.awssdk.services.rekognition.model.StartSegmentDetectionRequest;
import software.amazon.awssdk.services.rekognition.model.StartSegmentDetectionResponse;
import software.amazon.awssdk.services.rekognition.model.StartStreamProcessorRequest;
import software.amazon.awssdk.services.rekognition.model.StartStreamProcessorResponse;
import software.amazon.awssdk.services.rekognition.model.StartTextDetectionRequest;
import software.amazon.awssdk.services.rekognition.model.StartTextDetectionResponse;
import software.amazon.awssdk.services.rekognition.model.StopProjectVersionRequest;
import software.amazon.awssdk.services.rekognition.model.StopProjectVersionResponse;
import software.amazon.awssdk.services.rekognition.model.StopStreamProcessorRequest;
import software.amazon.awssdk.services.rekognition.model.StopStreamProcessorResponse;
import software.amazon.awssdk.services.rekognition.model.TagResourceRequest;
import software.amazon.awssdk.services.rekognition.model.TagResourceResponse;
import software.amazon.awssdk.services.rekognition.model.ThrottlingException;
import software.amazon.awssdk.services.rekognition.model.UntagResourceRequest;
import software.amazon.awssdk.services.rekognition.model.UntagResourceResponse;
import software.amazon.awssdk.services.rekognition.model.UpdateDatasetEntriesRequest;
import software.amazon.awssdk.services.rekognition.model.UpdateDatasetEntriesResponse;
import software.amazon.awssdk.services.rekognition.model.UpdateStreamProcessorRequest;
import software.amazon.awssdk.services.rekognition.model.UpdateStreamProcessorResponse;
import software.amazon.awssdk.services.rekognition.model.VideoTooLargeException;
import software.amazon.awssdk.services.rekognition.transform.AssociateFacesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.CompareFacesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.CopyProjectVersionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.CreateCollectionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.CreateDatasetRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.CreateFaceLivenessSessionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.CreateProjectRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.CreateProjectVersionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.CreateStreamProcessorRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.CreateUserRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DeleteCollectionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DeleteDatasetRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DeleteFacesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DeleteProjectPolicyRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DeleteProjectRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DeleteProjectVersionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DeleteStreamProcessorRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DeleteUserRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DescribeCollectionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DescribeDatasetRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DescribeProjectVersionsRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DescribeProjectsRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DescribeStreamProcessorRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DetectCustomLabelsRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DetectFacesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DetectLabelsRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DetectModerationLabelsRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DetectProtectiveEquipmentRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DetectTextRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DisassociateFacesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.DistributeDatasetEntriesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetCelebrityInfoRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetCelebrityRecognitionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetContentModerationRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetFaceDetectionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetFaceLivenessSessionResultsRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetFaceSearchRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetLabelDetectionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetMediaAnalysisJobRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetPersonTrackingRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetSegmentDetectionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.GetTextDetectionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.IndexFacesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.ListCollectionsRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.ListDatasetEntriesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.ListDatasetLabelsRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.ListFacesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.ListMediaAnalysisJobsRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.ListProjectPoliciesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.ListStreamProcessorsRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.ListUsersRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.PutProjectPolicyRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.RecognizeCelebritiesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.SearchFacesByImageRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.SearchFacesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.SearchUsersByImageRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.SearchUsersRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartCelebrityRecognitionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartContentModerationRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartFaceDetectionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartFaceSearchRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartLabelDetectionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartMediaAnalysisJobRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartPersonTrackingRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartProjectVersionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartSegmentDetectionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartStreamProcessorRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StartTextDetectionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StopProjectVersionRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.StopStreamProcessorRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.UpdateDatasetEntriesRequestMarshaller;
import software.amazon.awssdk.services.rekognition.transform.UpdateStreamProcessorRequestMarshaller;
import software.amazon.awssdk.services.rekognition.waiters.RekognitionAsyncWaiter;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link RekognitionAsyncClient}.
 *
 * @see RekognitionAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultRekognitionAsyncClient implements RekognitionAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultRekognitionAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final ScheduledExecutorService executorService;

    protected DefaultRekognitionAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
        this.executorService = clientConfiguration.option(SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
    }

    /**
     * <p>
     * Associates one or more faces with an existing UserID. Takes an array of <code>FaceIds</code>. Each
     * <code>FaceId</code> that are present in the <code>FaceIds</code> list is associated with the provided UserID. The
     * maximum number of total <code>FaceIds</code> per UserID is 100.
     * </p>
     * <p>
     * The <code>UserMatchThreshold</code> parameter specifies the minimum user match confidence required for the face
     * to be associated with a UserID that has at least one <code>FaceID</code> already associated. This ensures that
     * the <code>FaceIds</code> are associated with the right UserID. The value ranges from 0-100 and default value is
     * 75.
     * </p>
     * <p>
     * If successful, an array of <code>AssociatedFace</code> objects containing the associated <code>FaceIds</code> is
     * returned. If a given face is already associated with the given <code>UserID</code>, it will be ignored and will
     * not be returned in the response. If a given face is already associated to a different <code>UserID</code>, isn't
     * found in the collection, doesn’t meet the <code>UserMatchThreshold</code>, or there are already 100 faces
     * associated with the <code>UserID</code>, it will be returned as part of an array of
     * <code>UnsuccessfulFaceAssociations.</code>
     * </p>
     * <p>
     * The <code>UserStatus</code> reflects the status of an operation which updates a UserID representation with a list
     * of given faces. The <code>UserStatus</code> can be:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ACTIVE - All associations or disassociations of FaceID(s) for a UserID are complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * CREATED - A UserID has been created, but has no FaceID(s) associated with it.
     * </p>
     * </li>
     * <li>
     * <p>
     * UPDATING - A UserID is being updated and there are current associations or disassociations of FaceID(s) taking
     * place.
     * </p>
     * </li>
     * </ul>
     *
     * @param associateFacesRequest
     * @return A Java Future containing the result of the AssociateFaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>IdempotentParameterMismatchException A <code>ClientRequestToken</code> input parameter was reused
     *         with an operation, but at least one of the other input parameters is different from the previous call to
     *         the operation.</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>ConflictException A User with the same Id already exists within the collection, or the update or
     *         deletion of the User caused an inconsistent state. **</li>
     *         <li>ServiceQuotaExceededException
     *         <p>
     *         The size of the collection exceeds the allowed limit. For more information, see Guidelines and quotas in
     *         Amazon Rekognition in the Amazon Rekognition Developer Guide.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.AssociateFaces
     */
    @Override
    public CompletableFuture<AssociateFacesResponse> associateFaces(AssociateFacesRequest associateFacesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateFacesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateFacesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateFaces");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateFacesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateFacesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateFacesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateFacesRequest, AssociateFacesResponse>()
                            .withOperationName("AssociateFaces").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateFacesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateFacesRequest));
            CompletableFuture<AssociateFacesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Compares a face in the <i>source</i> input image with each of the 100 largest faces detected in the <i>target</i>
     * input image.
     * </p>
     * <p>
     * If the source image contains multiple faces, the service detects the largest face and compares it with each face
     * detected in the target image.
     * </p>
     * <note>
     * <p>
     * CompareFaces uses machine learning algorithms, which are probabilistic. A false negative is an incorrect
     * prediction that a face in the target image has a low similarity confidence score when compared to the face in the
     * source image. To reduce the probability of false negatives, we recommend that you compare the target image
     * against multiple source images. If you plan to use <code>CompareFaces</code> to make a decision that impacts an
     * individual's rights, privacy, or access to services, we recommend that you pass the result to a human for review
     * and further validation before taking action.
     * </p>
     * </note>
     * <p>
     * You pass the input and target images either as base64-encoded image bytes or as references to images in an Amazon
     * S3 bucket. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes isn't supported. The
     * image must be formatted as a PNG or JPEG file.
     * </p>
     * <p>
     * In response, the operation returns an array of face matches ordered by similarity score in descending order. For
     * each face match, the response provides a bounding box of the face, facial landmarks, pose details (pitch, roll,
     * and yaw), quality (brightness and sharpness), and confidence value (indicating the level of confidence that the
     * bounding box contains a face). The response also provides a similarity score, which indicates how closely the
     * faces match.
     * </p>
     * <note>
     * <p>
     * By default, only faces with a similarity score of greater than or equal to 80% are returned in the response. You
     * can change this value by specifying the <code>SimilarityThreshold</code> parameter.
     * </p>
     * </note>
     * <p>
     * <code>CompareFaces</code> also returns an array of faces that don't match the source image. For each face, it
     * returns a bounding box, confidence value, landmarks, pose details, and quality. The response also returns
     * information about the face in the source image, including the bounding box of the face and confidence value.
     * </p>
     * <p>
     * The <code>QualityFilter</code> input parameter allows you to filter out detected faces that don’t meet a required
     * quality bar. The quality bar is based on a variety of common use cases. Use <code>QualityFilter</code> to set the
     * quality bar by specifying <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>. If you do not want to
     * filter detected faces, specify <code>NONE</code>. The default value is <code>NONE</code>.
     * </p>
     * <p>
     * If the image doesn't contain Exif metadata, <code>CompareFaces</code> returns orientation information for the
     * source and target images. Use these values to display the images with the correct image orientation.
     * </p>
     * <p>
     * If no faces are detected in the source or target images, <code>CompareFaces</code> returns an
     * <code>InvalidParameterException</code> error.
     * </p>
     * <note>
     * <p>
     * This is a stateless API operation. That is, data returned by this operation doesn't persist.
     * </p>
     * </note>
     * <p>
     * For an example, see Comparing Faces in Images in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:CompareFaces</code> action.
     * </p>
     *
     * @param compareFacesRequest
     * @return A Java Future containing the result of the CompareFaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>ImageTooLargeException The input image size exceeds the allowed limit. If you are calling
     *         DetectProtectiveEquipment, the image size or resolution exceeds the allowed limit. For more information,
     *         see Guidelines and quotas in Amazon Rekognition in the Amazon Rekognition Developer Guide.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidImageFormatException The provided image format is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.CompareFaces
     */
    @Override
    public CompletableFuture<CompareFacesResponse> compareFaces(CompareFacesRequest compareFacesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(compareFacesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, compareFacesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CompareFaces");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CompareFacesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CompareFacesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CompareFacesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CompareFacesRequest, CompareFacesResponse>()
                            .withOperationName("CompareFaces").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CompareFacesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(compareFacesRequest));
            CompletableFuture<CompareFacesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation applies only to Amazon Rekognition Custom Labels.
     * </p>
     * </note>
     * <p>
     * Copies a version of an Amazon Rekognition Custom Labels model from a source project to a destination project. The
     * source and destination projects can be in different AWS accounts but must be in the same AWS Region. You can't
     * copy a model to another AWS service.
     * </p>
     * <p>
     * To copy a model version to a different AWS account, you need to create a resource-based policy known as a
     * <i>project policy</i>. You attach the project policy to the source project by calling <a>PutProjectPolicy</a>.
     * The project policy gives permission to copy the model version from a trusting AWS account to a trusted account.
     * </p>
     * <p>
     * For more information creating and attaching a project policy, see Attaching a project policy (SDK) in the
     * <i>Amazon Rekognition Custom Labels Developer Guide</i>.
     * </p>
     * <p>
     * If you are copying a model version to a project in the same AWS account, you don't need to create a project
     * policy.
     * </p>
     * <note>
     * <p>
     * Copying project versions is supported only for Custom Labels models.
     * </p>
     * <p>
     * To copy a model, the destination project, source project, and source model version must already exist.
     * </p>
     * </note>
     * <p>
     * Copying a model version takes a while to complete. To get the current status, call <a>DescribeProjectVersions</a>
     * and check the value of <code>Status</code> in the <a>ProjectVersionDescription</a> object. The copy operation has
     * finished when the value of <code>Status</code> is <code>COPYING_COMPLETED</code>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:CopyProjectVersion</code> action.
     * </p>
     *
     * @param copyProjectVersionRequest
     * @return A Java Future containing the result of the CopyProjectVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>LimitExceededException An Amazon Rekognition service limit was exceeded. For example, if you start
     *         too many jobs concurrently, subsequent calls to start operations (ex: <code>StartLabelDetection</code>)
     *         will raise a <code>LimitExceededException</code> exception (HTTP status code: 400) until the number of
     *         concurrently running jobs is below the Amazon Rekognition service limit.</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ServiceQuotaExceededException
     *         <p>
     *         The size of the collection exceeds the allowed limit. For more information, see Guidelines and quotas in
     *         Amazon Rekognition in the Amazon Rekognition Developer Guide.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceInUseException The specified resource is already being used.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.CopyProjectVersion
     */
    @Override
    public CompletableFuture<CopyProjectVersionResponse> copyProjectVersion(CopyProjectVersionRequest copyProjectVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(copyProjectVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, copyProjectVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CopyProjectVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CopyProjectVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CopyProjectVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CopyProjectVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CopyProjectVersionRequest, CopyProjectVersionResponse>()
                            .withOperationName("CopyProjectVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CopyProjectVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(copyProjectVersionRequest));
            CompletableFuture<CopyProjectVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a collection in an AWS Region. You can add faces to the collection using the <a>IndexFaces</a> operation.
     * </p>
     * <p>
     * For example, you might create collections, one for each of your application users. A user can then index faces
     * using the <code>IndexFaces</code> operation and persist results in a specific collection. Then, a user can search
     * the collection for faces in the user-specific container.
     * </p>
     * <p>
     * When you create a collection, it is associated with the latest version of the face model version.
     * </p>
     * <note>
     * <p>
     * Collection names are case-sensitive.
     * </p>
     * </note>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:CreateCollection</code> action. If you want
     * to tag your collection, you also require permission to perform the <code>rekognition:TagResource</code>
     * operation.
     * </p>
     *
     * @param createCollectionRequest
     * @return A Java Future containing the result of the CreateCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceAlreadyExistsException A resource with the specified ID already exists.</li>
     *         <li>ServiceQuotaExceededException
     *         <p>
     *         The size of the collection exceeds the allowed limit. For more information, see Guidelines and quotas in
     *         Amazon Rekognition in the Amazon Rekognition Developer Guide.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.CreateCollection
     */
    @Override
    public CompletableFuture<CreateCollectionResponse> createCollection(CreateCollectionRequest createCollectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCollectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCollectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCollection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateCollectionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateCollectionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateCollectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCollectionRequest, CreateCollectionResponse>()
                            .withOperationName("CreateCollection").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateCollectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createCollectionRequest));
            CompletableFuture<CreateCollectionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation applies only to Amazon Rekognition Custom Labels.
     * </p>
     * </note>
     * <p>
     * Creates a new Amazon Rekognition Custom Labels dataset. You can create a dataset by using an Amazon Sagemaker
     * format manifest file or by copying an existing Amazon Rekognition Custom Labels dataset.
     * </p>
     * <p>
     * To create a training dataset for a project, specify <code>TRAIN</code> for the value of <code>DatasetType</code>.
     * To create the test dataset for a project, specify <code>TEST</code> for the value of <code>DatasetType</code>.
     * </p>
     * <p>
     * The response from <code>CreateDataset</code> is the Amazon Resource Name (ARN) for the dataset. Creating a
     * dataset takes a while to complete. Use <a>DescribeDataset</a> to check the current status. The dataset created
     * successfully if the value of <code>Status</code> is <code>CREATE_COMPLETE</code>.
     * </p>
     * <p>
     * To check if any non-terminal errors occurred, call <a>ListDatasetEntries</a> and check for the presence of
     * <code>errors</code> lists in the JSON Lines.
     * </p>
     * <p>
     * Dataset creation fails if a terminal error occurs (<code>Status</code> = <code>CREATE_FAILED</code>). Currently,
     * you can't access the terminal error information.
     * </p>
     * <p>
     * For more information, see Creating dataset in the <i>Amazon Rekognition Custom Labels Developer Guide</i>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:CreateDataset</code> action. If you want to
     * copy an existing dataset, you also require permission to perform the <code>rekognition:ListDatasetEntries</code>
     * action.
     * </p>
     *
     * @param createDatasetRequest
     * @return A Java Future containing the result of the CreateDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>LimitExceededException An Amazon Rekognition service limit was exceeded. For example, if you start
     *         too many jobs concurrently, subsequent calls to start operations (ex: <code>StartLabelDetection</code>)
     *         will raise a <code>LimitExceededException</code> exception (HTTP status code: 400) until the number of
     *         concurrently running jobs is below the Amazon Rekognition service limit.</li>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>ResourceAlreadyExistsException A resource with the specified ID already exists.</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.CreateDataset
     */
    @Override
    public CompletableFuture<CreateDatasetResponse> createDataset(CreateDatasetRequest createDatasetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDatasetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDatasetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDataset");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDatasetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateDatasetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDatasetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDatasetRequest, CreateDatasetResponse>()
                            .withOperationName("CreateDataset").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateDatasetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDatasetRequest));
            CompletableFuture<CreateDatasetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This API operation initiates a Face Liveness session. It returns a <code>SessionId</code>, which you can use to
     * start streaming Face Liveness video and get the results for a Face Liveness session.
     * </p>
     * <p>
     * You can use the <code>OutputConfig</code> option in the Settings parameter to provide an Amazon S3 bucket
     * location. The Amazon S3 bucket stores reference images and audit images. If no Amazon S3 bucket is defined, raw
     * bytes are sent instead.
     * </p>
     * <p>
     * You can use <code>AuditImagesLimit</code> to limit the number of audit images returned when
     * <code>GetFaceLivenessSessionResults</code> is called. This number is between 0 and 4. By default, it is set to 0.
     * The limit is best effort and based on the duration of the selfie-video.
     * </p>
     *
     * @param createFaceLivenessSessionRequest
     * @return A Java Future containing the result of the CreateFaceLivenessSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.CreateFaceLivenessSession
     */
    @Override
    public CompletableFuture<CreateFaceLivenessSessionResponse> createFaceLivenessSession(
            CreateFaceLivenessSessionRequest createFaceLivenessSessionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFaceLivenessSessionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFaceLivenessSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFaceLivenessSession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateFaceLivenessSessionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateFaceLivenessSessionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateFaceLivenessSessionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFaceLivenessSessionRequest, CreateFaceLivenessSessionResponse>()
                            .withOperationName("CreateFaceLivenessSession").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateFaceLivenessSessionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createFaceLivenessSessionRequest));
            CompletableFuture<CreateFaceLivenessSessionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new Amazon Rekognition project. A project is a group of resources (datasets, model versions) that you
     * use to create and manage a Amazon Rekognition Custom Labels Model or custom adapter. You can specify a feature to
     * create the project with, if no feature is specified then Custom Labels is used by default. For adapters, you can
     * also choose whether or not to have the project auto update by using the AutoUpdate argument. This operation
     * requires permissions to perform the <code>rekognition:CreateProject</code> action.
     * </p>
     *
     * @param createProjectRequest
     * @return A Java Future containing the result of the CreateProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException The specified resource is already being used.</li>
     *         <li>LimitExceededException An Amazon Rekognition service limit was exceeded. For example, if you start
     *         too many jobs concurrently, subsequent calls to start operations (ex: <code>StartLabelDetection</code>)
     *         will raise a <code>LimitExceededException</code> exception (HTTP status code: 400) until the number of
     *         concurrently running jobs is below the Amazon Rekognition service limit.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.CreateProject
     */
    @Override
    public CompletableFuture<CreateProjectResponse> createProject(CreateProjectRequest createProjectRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createProjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createProjectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateProject");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateProjectResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateProjectResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateProjectResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateProjectRequest, CreateProjectResponse>()
                            .withOperationName("CreateProject").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateProjectRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createProjectRequest));
            CompletableFuture<CreateProjectResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new version of Amazon Rekognition project (like a Custom Labels model or a custom adapter) and begins
     * training. Models and adapters are managed as part of a Rekognition project. The response from
     * <code>CreateProjectVersion</code> is an Amazon Resource Name (ARN) for the project version.
     * </p>
     * <p>
     * The FeatureConfig operation argument allows you to configure specific model or adapter settings. You can provide
     * a description to the project version by using the VersionDescription argment. Training can take a while to
     * complete. You can get the current status by calling <a>DescribeProjectVersions</a>. Training completed
     * successfully if the value of the <code>Status</code> field is <code>TRAINING_COMPLETED</code>. Once training has
     * successfully completed, call <a>DescribeProjectVersions</a> to get the training results and evaluate the model.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:CreateProjectVersion</code> action.
     * </p>
     * <note>
     * <p>
     * <i>The following applies only to projects with Amazon Rekognition Custom Labels as the chosen feature:</i>
     * </p>
     * <p>
     * You can train a model in a project that doesn't have associated datasets by specifying manifest files in the
     * <code>TrainingData</code> and <code>TestingData</code> fields.
     * </p>
     * <p>
     * If you open the console after training a model with manifest files, Amazon Rekognition Custom Labels creates the
     * datasets for you using the most recent manifest files. You can no longer train a model version for the project by
     * specifying manifest files.
     * </p>
     * <p>
     * Instead of training with a project without associated datasets, we recommend that you use the manifest files to
     * create training and test datasets for the project.
     * </p>
     * </note>
     * <p/>
     *
     * @param createProjectVersionRequest
     * @return A Java Future containing the result of the CreateProjectVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException The specified resource is already being used.</li> <li>
     *         ResourceNotFoundException The resource specified in the request cannot be found.</li> <li>
     *         LimitExceededException An Amazon Rekognition service limit was exceeded. For example, if you start too
     *         many jobs concurrently, subsequent calls to start operations (ex: <code>StartLabelDetection</code>) will
     *         raise a <code>LimitExceededException</code> exception (HTTP status code: 400) until the number of
     *         concurrently running jobs is below the Amazon Rekognition service limit.</li> <li>
     *         InvalidParameterException Input parameter violated a constraint. Validate your parameter before calling
     *         the API operation again.</li> <li>AccessDeniedException You are not authorized to perform the action.
     *         </li> <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call
     *         again.</li> <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try
     *         your call again.</li> <li>ProvisionedThroughputExceededException The number of requests exceeded your
     *         throughput limit. If you want to increase this limit, contact Amazon Rekognition.</li> <li>
     *         ServiceQuotaExceededException
     *         <p>
     *         The size of the collection exceeds the allowed limit. For more information, see Guidelines and quotas in
     *         Amazon Rekognition in the Amazon Rekognition Developer Guide.</li> <li>SdkException Base class for all
     *         exceptions that can be thrown by the SDK (both service and client). Can be used for catch all scenarios.
     *         </li> <li>SdkClientException If any client side error occurs such as an IO related failure, failure to
     *         get credentials, etc.</li> <li>RekognitionException Base class for all service exceptions. Unknown
     *         exceptions will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.CreateProjectVersion
     */
    @Override
    public CompletableFuture<CreateProjectVersionResponse> createProjectVersion(
            CreateProjectVersionRequest createProjectVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createProjectVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createProjectVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateProjectVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateProjectVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateProjectVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateProjectVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateProjectVersionRequest, CreateProjectVersionResponse>()
                            .withOperationName("CreateProjectVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateProjectVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createProjectVersionRequest));
            CompletableFuture<CreateProjectVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Amazon Rekognition stream processor that you can use to detect and recognize faces or to detect labels
     * in a streaming video.
     * </p>
     * <p>
     * Amazon Rekognition Video is a consumer of live video from Amazon Kinesis Video Streams. There are two different
     * settings for stream processors in Amazon Rekognition: detecting faces and detecting labels.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you are creating a stream processor for detecting faces, you provide as input a Kinesis video stream (
     * <code>Input</code>) and a Kinesis data stream (<code>Output</code>) stream for receiving the output. You must use
     * the <code>FaceSearch</code> option in <code>Settings</code>, specifying the collection that contains the faces
     * you want to recognize. After you have finished analyzing a streaming video, use <a>StopStreamProcessor</a> to
     * stop processing.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you are creating a stream processor to detect labels, you provide as input a Kinesis video stream (
     * <code>Input</code>), Amazon S3 bucket information (<code>Output</code>), and an Amazon SNS topic ARN (
     * <code>NotificationChannel</code>). You can also provide a KMS key ID to encrypt the data sent to your Amazon S3
     * bucket. You specify what you want to detect by using the <code>ConnectedHome</code> option in settings, and
     * selecting one of the following: <code>PERSON</code>, <code>PET</code>, <code>PACKAGE</code>, <code>ALL</code> You
     * can also specify where in the frame you want Amazon Rekognition to monitor with <code>RegionsOfInterest</code>.
     * When you run the <a>StartStreamProcessor</a> operation on a label detection stream processor, you input start and
     * stop information to determine the length of the processing time.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use <code>Name</code> to assign an identifier for the stream processor. You use <code>Name</code> to manage the
     * stream processor. For example, you can start processing the source video by calling <a>StartStreamProcessor</a>
     * with the <code>Name</code> field.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:CreateStreamProcessor</code> action. If you
     * want to tag your stream processor, you also require permission to perform the
     * <code>rekognition:TagResource</code> operation.
     * </p>
     *
     * @param createStreamProcessorRequest
     * @return A Java Future containing the result of the CreateStreamProcessor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>LimitExceededException An Amazon Rekognition service limit was exceeded. For example, if you start
     *         too many jobs concurrently, subsequent calls to start operations (ex: <code>StartLabelDetection</code>)
     *         will raise a <code>LimitExceededException</code> exception (HTTP status code: 400) until the number of
     *         concurrently running jobs is below the Amazon Rekognition service limit.</li>
     *         <li>ResourceInUseException The specified resource is already being used.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ServiceQuotaExceededException
     *         <p>
     *         The size of the collection exceeds the allowed limit. For more information, see Guidelines and quotas in
     *         Amazon Rekognition in the Amazon Rekognition Developer Guide.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.CreateStreamProcessor
     */
    @Override
    public CompletableFuture<CreateStreamProcessorResponse> createStreamProcessor(
            CreateStreamProcessorRequest createStreamProcessorRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createStreamProcessorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createStreamProcessorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStreamProcessor");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateStreamProcessorResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateStreamProcessorResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateStreamProcessorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateStreamProcessorRequest, CreateStreamProcessorResponse>()
                            .withOperationName("CreateStreamProcessor").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateStreamProcessorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createStreamProcessorRequest));
            CompletableFuture<CreateStreamProcessorResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new User within a collection specified by <code>CollectionId</code>. Takes <code>UserId</code> as a
     * parameter, which is a user provided ID which should be unique within the collection. The provided
     * <code>UserId</code> will alias the system generated UUID to make the <code>UserId</code> more user friendly.
     * </p>
     * <p>
     * Uses a <code>ClientToken</code>, an idempotency token that ensures a call to <code>CreateUser</code> completes
     * only once. If the value is not supplied, the AWS SDK generates an idempotency token for the requests. This
     * prevents retries after a network error results from making multiple <code>CreateUser</code> calls.
     * </p>
     *
     * @param createUserRequest
     * @return A Java Future containing the result of the CreateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ConflictException A User with the same Id already exists within the collection, or the update or
     *         deletion of the User caused an inconsistent state. **</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>ServiceQuotaExceededException
     *         <p>
     *         The size of the collection exceeds the allowed limit. For more information, see Guidelines and quotas in
     *         Amazon Rekognition in the Amazon Rekognition Developer Guide.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>IdempotentParameterMismatchException A <code>ClientRequestToken</code> input parameter was reused
     *         with an operation, but at least one of the other input parameters is different from the previous call to
     *         the operation.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.CreateUser
     */
    @Override
    public CompletableFuture<CreateUserResponse> createUser(CreateUserRequest createUserRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateUserRequest, CreateUserResponse>().withOperationName("CreateUser")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createUserRequest));
            CompletableFuture<CreateUserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified collection. Note that this operation removes all faces in the collection. For an example,
     * see <a href="https://docs.aws.amazon.com/rekognition/latest/dg/delete-collection-procedure.html">Deleting a
     * collection</a>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:DeleteCollection</code> action.
     * </p>
     *
     * @param deleteCollectionRequest
     * @return A Java Future containing the result of the DeleteCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DeleteCollection
     */
    @Override
    public CompletableFuture<DeleteCollectionResponse> deleteCollection(DeleteCollectionRequest deleteCollectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCollectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCollectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCollection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteCollectionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteCollectionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteCollectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCollectionRequest, DeleteCollectionResponse>()
                            .withOperationName("DeleteCollection").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteCollectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteCollectionRequest));
            CompletableFuture<DeleteCollectionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation applies only to Amazon Rekognition Custom Labels.
     * </p>
     * </note>
     * <p>
     * Deletes an existing Amazon Rekognition Custom Labels dataset. Deleting a dataset might take while. Use
     * <a>DescribeDataset</a> to check the current status. The dataset is still deleting if the value of
     * <code>Status</code> is <code>DELETE_IN_PROGRESS</code>. If you try to access the dataset after it is deleted, you
     * get a <code>ResourceNotFoundException</code> exception.
     * </p>
     * <p>
     * You can't delete a dataset while it is creating (<code>Status</code> = <code>CREATE_IN_PROGRESS</code>) or if the
     * dataset is updating (<code>Status</code> = <code>UPDATE_IN_PROGRESS</code>).
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:DeleteDataset</code> action.
     * </p>
     *
     * @param deleteDatasetRequest
     * @return A Java Future containing the result of the DeleteDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>LimitExceededException An Amazon Rekognition service limit was exceeded. For example, if you start
     *         too many jobs concurrently, subsequent calls to start operations (ex: <code>StartLabelDetection</code>)
     *         will raise a <code>LimitExceededException</code> exception (HTTP status code: 400) until the number of
     *         concurrently running jobs is below the Amazon Rekognition service limit.</li>
     *         <li>ResourceInUseException The specified resource is already being used.</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DeleteDataset
     */
    @Override
    public CompletableFuture<DeleteDatasetResponse> deleteDataset(DeleteDatasetRequest deleteDatasetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDatasetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDatasetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDataset");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDatasetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteDatasetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDatasetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDatasetRequest, DeleteDatasetResponse>()
                            .withOperationName("DeleteDataset").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteDatasetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteDatasetRequest));
            CompletableFuture<DeleteDatasetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes faces from a collection. You specify a collection ID and an array of face IDs to remove from the
     * collection.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:DeleteFaces</code> action.
     * </p>
     *
     * @param deleteFacesRequest
     * @return A Java Future containing the result of the DeleteFaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DeleteFaces
     */
    @Override
    public CompletableFuture<DeleteFacesResponse> deleteFaces(DeleteFacesRequest deleteFacesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFacesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFacesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFaces");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteFacesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteFacesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteFacesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFacesRequest, DeleteFacesResponse>()
                            .withOperationName("DeleteFaces").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteFacesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteFacesRequest));
            CompletableFuture<DeleteFacesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a Amazon Rekognition project. To delete a project you must first delete all models or adapters associated
     * with the project. To delete a model or adapter, see <a>DeleteProjectVersion</a>.
     * </p>
     * <p>
     * <code>DeleteProject</code> is an asynchronous operation. To check if the project is deleted, call
     * <a>DescribeProjects</a>. The project is deleted when the project no longer appears in the response. Be aware that
     * deleting a given project will also delete any <code>ProjectPolicies</code> associated with that project.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:DeleteProject</code> action.
     * </p>
     *
     * @param deleteProjectRequest
     * @return A Java Future containing the result of the DeleteProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException The specified resource is already being used.</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DeleteProject
     */
    @Override
    public CompletableFuture<DeleteProjectResponse> deleteProject(DeleteProjectRequest deleteProjectRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteProjectRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteProjectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteProject");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteProjectResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteProjectResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteProjectResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteProjectRequest, DeleteProjectResponse>()
                            .withOperationName("DeleteProject").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteProjectRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteProjectRequest));
            CompletableFuture<DeleteProjectResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation applies only to Amazon Rekognition Custom Labels.
     * </p>
     * </note>
     * <p>
     * Deletes an existing project policy.
     * </p>
     * <p>
     * To get a list of project policies attached to a project, call <a>ListProjectPolicies</a>. To attach a project
     * policy to a project, call <a>PutProjectPolicy</a>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:DeleteProjectPolicy</code> action.
     * </p>
     *
     * @param deleteProjectPolicyRequest
     * @return A Java Future containing the result of the DeleteProjectPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidPolicyRevisionIdException The supplied revision id for the project policy is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DeleteProjectPolicy
     */
    @Override
    public CompletableFuture<DeleteProjectPolicyResponse> deleteProjectPolicy(
            DeleteProjectPolicyRequest deleteProjectPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteProjectPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteProjectPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteProjectPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteProjectPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteProjectPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteProjectPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteProjectPolicyRequest, DeleteProjectPolicyResponse>()
                            .withOperationName("DeleteProjectPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteProjectPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteProjectPolicyRequest));
            CompletableFuture<DeleteProjectPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a Rekognition project model or project version, like a Amazon Rekognition Custom Labels model or a custom
     * adapter.
     * </p>
     * <p>
     * You can't delete a project version if it is running or if it is training. To check the status of a project
     * version, use the Status field returned from <a>DescribeProjectVersions</a>. To stop a project version call
     * <a>StopProjectVersion</a>. If the project version is training, wait until it finishes.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:DeleteProjectVersion</code> action.
     * </p>
     *
     * @param deleteProjectVersionRequest
     * @return A Java Future containing the result of the DeleteProjectVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>ResourceInUseException The specified resource is already being used.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DeleteProjectVersion
     */
    @Override
    public CompletableFuture<DeleteProjectVersionResponse> deleteProjectVersion(
            DeleteProjectVersionRequest deleteProjectVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteProjectVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteProjectVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteProjectVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteProjectVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteProjectVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteProjectVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteProjectVersionRequest, DeleteProjectVersionResponse>()
                            .withOperationName("DeleteProjectVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteProjectVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteProjectVersionRequest));
            CompletableFuture<DeleteProjectVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the stream processor identified by <code>Name</code>. You assign the value for <code>Name</code> when you
     * create the stream processor with <a>CreateStreamProcessor</a>. You might not be able to use the same name for a
     * stream processor for a few seconds after calling <code>DeleteStreamProcessor</code>.
     * </p>
     *
     * @param deleteStreamProcessorRequest
     * @return A Java Future containing the result of the DeleteStreamProcessor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>ResourceInUseException The specified resource is already being used.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DeleteStreamProcessor
     */
    @Override
    public CompletableFuture<DeleteStreamProcessorResponse> deleteStreamProcessor(
            DeleteStreamProcessorRequest deleteStreamProcessorRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteStreamProcessorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteStreamProcessorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteStreamProcessor");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteStreamProcessorResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteStreamProcessorResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteStreamProcessorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteStreamProcessorRequest, DeleteStreamProcessorResponse>()
                            .withOperationName("DeleteStreamProcessor").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteStreamProcessorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteStreamProcessorRequest));
            CompletableFuture<DeleteStreamProcessorResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified UserID within the collection. Faces that are associated with the UserID are disassociated
     * from the UserID before deleting the specified UserID. If the specified <code>Collection</code> or
     * <code>UserID</code> is already deleted or not found, a <code>ResourceNotFoundException</code> will be thrown. If
     * the action is successful with a 200 response, an empty HTTP body is returned.
     * </p>
     *
     * @param deleteUserRequest
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ConflictException A User with the same Id already exists within the collection, or the update or
     *         deletion of the User caused an inconsistent state. **</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>IdempotentParameterMismatchException A <code>ClientRequestToken</code> input parameter was reused
     *         with an operation, but at least one of the other input parameters is different from the previous call to
     *         the operation.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DeleteUser
     */
    @Override
    public CompletableFuture<DeleteUserResponse> deleteUser(DeleteUserRequest deleteUserRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteUserRequest, DeleteUserResponse>().withOperationName("DeleteUser")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteUserRequest));
            CompletableFuture<DeleteUserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the specified collection. You can use <code>DescribeCollection</code> to get information, such as the
     * number of faces indexed into a collection and the version of the model used by the collection for face detection.
     * </p>
     * <p>
     * For more information, see Describing a Collection in the Amazon Rekognition Developer Guide.
     * </p>
     *
     * @param describeCollectionRequest
     * @return A Java Future containing the result of the DescribeCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DescribeCollection
     */
    @Override
    public CompletableFuture<DescribeCollectionResponse> describeCollection(DescribeCollectionRequest describeCollectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeCollectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCollectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCollection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeCollectionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeCollectionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeCollectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeCollectionRequest, DescribeCollectionResponse>()
                            .withOperationName("DescribeCollection").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeCollectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeCollectionRequest));
            CompletableFuture<DescribeCollectionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation applies only to Amazon Rekognition Custom Labels.
     * </p>
     * </note>
     * <p>
     * Describes an Amazon Rekognition Custom Labels dataset. You can get information such as the current status of a
     * dataset and statistics about the images and labels in a dataset.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:DescribeDataset</code> action.
     * </p>
     *
     * @param describeDatasetRequest
     * @return A Java Future containing the result of the DescribeDataset operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DescribeDataset
     */
    @Override
    public CompletableFuture<DescribeDatasetResponse> describeDataset(DescribeDatasetRequest describeDatasetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDatasetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDatasetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDataset");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDatasetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDatasetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeDatasetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDatasetRequest, DescribeDatasetResponse>()
                            .withOperationName("DescribeDataset").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeDatasetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDatasetRequest));
            CompletableFuture<DescribeDatasetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists and describes the versions of an Amazon Rekognition project. You can specify up to 10 model or adapter
     * versions in <code>ProjectVersionArns</code>. If you don't specify a value, descriptions for all model/adapter
     * versions in the project are returned.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:DescribeProjectVersions</code> action.
     * </p>
     *
     * @param describeProjectVersionsRequest
     * @return A Java Future containing the result of the DescribeProjectVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DescribeProjectVersions
     */
    @Override
    public CompletableFuture<DescribeProjectVersionsResponse> describeProjectVersions(
            DescribeProjectVersionsRequest describeProjectVersionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeProjectVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeProjectVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeProjectVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeProjectVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeProjectVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeProjectVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeProjectVersionsRequest, DescribeProjectVersionsResponse>()
                            .withOperationName("DescribeProjectVersions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeProjectVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeProjectVersionsRequest));
            CompletableFuture<DescribeProjectVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about your Rekognition projects.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:DescribeProjects</code> action.
     * </p>
     *
     * @param describeProjectsRequest
     * @return A Java Future containing the result of the DescribeProjects operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DescribeProjects
     */
    @Override
    public CompletableFuture<DescribeProjectsResponse> describeProjects(DescribeProjectsRequest describeProjectsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeProjectsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeProjectsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeProjects");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeProjectsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeProjectsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeProjectsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeProjectsRequest, DescribeProjectsResponse>()
                            .withOperationName("DescribeProjects").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeProjectsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeProjectsRequest));
            CompletableFuture<DescribeProjectsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides information about a stream processor created by <a>CreateStreamProcessor</a>. You can get information
     * about the input and output streams, the input parameters for the face recognition being performed, and the
     * current status of the stream processor.
     * </p>
     *
     * @param describeStreamProcessorRequest
     * @return A Java Future containing the result of the DescribeStreamProcessor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DescribeStreamProcessor
     */
    @Override
    public CompletableFuture<DescribeStreamProcessorResponse> describeStreamProcessor(
            DescribeStreamProcessorRequest describeStreamProcessorRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeStreamProcessorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeStreamProcessorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeStreamProcessor");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeStreamProcessorResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeStreamProcessorResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeStreamProcessorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeStreamProcessorRequest, DescribeStreamProcessorResponse>()
                            .withOperationName("DescribeStreamProcessor").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeStreamProcessorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeStreamProcessorRequest));
            CompletableFuture<DescribeStreamProcessorResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation applies only to Amazon Rekognition Custom Labels.
     * </p>
     * </note>
     * <p>
     * Detects custom labels in a supplied image by using an Amazon Rekognition Custom Labels model.
     * </p>
     * <p>
     * You specify which version of a model version to use by using the <code>ProjectVersionArn</code> input parameter.
     * </p>
     * <p>
     * You pass the input image as base64-encoded image bytes or as a reference to an image in an Amazon S3 bucket. If
     * you use the AWS CLI to call Amazon Rekognition operations, passing image bytes is not supported. The image must
     * be either a PNG or JPEG formatted file.
     * </p>
     * <p>
     * For each object that the model version detects on an image, the API returns a (<code>CustomLabel</code>) object
     * in an array (<code>CustomLabels</code>). Each <code>CustomLabel</code> object provides the label name (
     * <code>Name</code>), the level of confidence that the image contains the object (<code>Confidence</code>), and
     * object location information, if it exists, for the label on the image (<code>Geometry</code>). Note that for the
     * <code>DetectCustomLabelsLabels</code> operation, <code>Polygons</code> are not returned in the
     * <code>Geometry</code> section of the response.
     * </p>
     * <p>
     * To filter labels that are returned, specify a value for <code>MinConfidence</code>.
     * <code>DetectCustomLabelsLabels</code> only returns labels with a confidence that's higher than the specified
     * value. The value of <code>MinConfidence</code> maps to the assumed threshold values created during training. For
     * more information, see <i>Assumed threshold</i> in the Amazon Rekognition Custom Labels Developer Guide. Amazon
     * Rekognition Custom Labels metrics expresses an assumed threshold as a floating point value between 0-1. The range
     * of <code>MinConfidence</code> normalizes the threshold value to a percentage value (0-100). Confidence responses
     * from <code>DetectCustomLabels</code> are also returned as a percentage. You can use <code>MinConfidence</code> to
     * change the precision and recall or your model. For more information, see <i>Analyzing an image</i> in the Amazon
     * Rekognition Custom Labels Developer Guide.
     * </p>
     * <p>
     * If you don't specify a value for <code>MinConfidence</code>, <code>DetectCustomLabels</code> returns labels based
     * on the assumed threshold of each label.
     * </p>
     * <p>
     * This is a stateless API operation. That is, the operation does not persist any data.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:DetectCustomLabels</code> action.
     * </p>
     * <p>
     * For more information, see <i>Analyzing an image</i> in the Amazon Rekognition Custom Labels Developer Guide.
     * </p>
     *
     * @param detectCustomLabelsRequest
     * @return A Java Future containing the result of the DetectCustomLabels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>ResourceNotReadyException The requested resource isn't ready. For example, this exception occurs when
     *         you call <code>DetectCustomLabels</code> with a model version that isn't deployed.</li>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ImageTooLargeException The input image size exceeds the allowed limit. If you are calling
     *         DetectProtectiveEquipment, the image size or resolution exceeds the allowed limit. For more information,
     *         see Guidelines and quotas in Amazon Rekognition in the Amazon Rekognition Developer Guide.</li>
     *         <li>LimitExceededException An Amazon Rekognition service limit was exceeded. For example, if you start
     *         too many jobs concurrently, subsequent calls to start operations (ex: <code>StartLabelDetection</code>)
     *         will raise a <code>LimitExceededException</code> exception (HTTP status code: 400) until the number of
     *         concurrently running jobs is below the Amazon Rekognition service limit.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidImageFormatException The provided image format is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DetectCustomLabels
     */
    @Override
    public CompletableFuture<DetectCustomLabelsResponse> detectCustomLabels(DetectCustomLabelsRequest detectCustomLabelsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(detectCustomLabelsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detectCustomLabelsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetectCustomLabels");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DetectCustomLabelsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DetectCustomLabelsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DetectCustomLabelsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetectCustomLabelsRequest, DetectCustomLabelsResponse>()
                            .withOperationName("DetectCustomLabels").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DetectCustomLabelsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(detectCustomLabelsRequest));
            CompletableFuture<DetectCustomLabelsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Detects faces within an image that is provided as input.
     * </p>
     * <p>
     * <code>DetectFaces</code> detects the 100 largest faces in the image. For each face detected, the operation
     * returns face details. These details include a bounding box of the face, a confidence value (that the bounding box
     * contains a face), and a fixed set of attributes such as facial landmarks (for example, coordinates of eye and
     * mouth), pose, presence of facial occlusion, and so on.
     * </p>
     * <p>
     * The face-detection algorithm is most effective on frontal faces. For non-frontal or obscured faces, the algorithm
     * might not detect the faces or might detect faces with lower confidence.
     * </p>
     * <p>
     * You pass the input image either as base64-encoded image bytes or as a reference to an image in an Amazon S3
     * bucket. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes is not supported. The
     * image must be either a PNG or JPEG formatted file.
     * </p>
     * <note>
     * <p>
     * This is a stateless API operation. That is, the operation does not persist any data.
     * </p>
     * </note>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:DetectFaces</code> action.
     * </p>
     *
     * @param detectFacesRequest
     * @return A Java Future containing the result of the DetectFaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ImageTooLargeException The input image size exceeds the allowed limit. If you are calling
     *         DetectProtectiveEquipment, the image size or resolution exceeds the allowed limit. For more information,
     *         see Guidelines and quotas in Amazon Rekognition in the Amazon Rekognition Developer Guide.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidImageFormatException The provided image format is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DetectFaces
     */
    @Override
    public CompletableFuture<DetectFacesResponse> detectFaces(DetectFacesRequest detectFacesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(detectFacesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detectFacesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetectFaces");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DetectFacesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DetectFacesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DetectFacesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetectFacesRequest, DetectFacesResponse>()
                            .withOperationName("DetectFaces").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DetectFacesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(detectFacesRequest));
            CompletableFuture<DetectFacesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Detects instances of real-world entities within an image (JPEG or PNG) provided as input. This includes objects
     * like flower, tree, and table; events like wedding, graduation, and birthday party; and concepts like landscape,
     * evening, and nature.
     * </p>
     * <p>
     * For an example, see Analyzing images stored in an Amazon S3 bucket in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * You pass the input image as base64-encoded image bytes or as a reference to an image in an Amazon S3 bucket. If
     * you use the AWS CLI to call Amazon Rekognition operations, passing image bytes is not supported. The image must
     * be either a PNG or JPEG formatted file.
     * </p>
     * <p>
     * <b>Optional Parameters</b>
     * </p>
     * <p>
     * You can specify one or both of the <code>GENERAL_LABELS</code> and <code>IMAGE_PROPERTIES</code> feature types
     * when calling the DetectLabels API. Including <code>GENERAL_LABELS</code> will ensure the response includes the
     * labels detected in the input image, while including <code>IMAGE_PROPERTIES </code>will ensure the response
     * includes information about the image quality and color.
     * </p>
     * <p>
     * When using <code>GENERAL_LABELS</code> and/or <code>IMAGE_PROPERTIES</code> you can provide filtering criteria to
     * the Settings parameter. You can filter with sets of individual labels or with label categories. You can specify
     * inclusive filters, exclusive filters, or a combination of inclusive and exclusive filters. For more information
     * on filtering see <a
     * href="https://docs.aws.amazon.com/rekognition/latest/dg/labels-detect-labels-image.html">Detecting Labels in an
     * Image</a>.
     * </p>
     * <p>
     * When getting labels, you can specify <code>MinConfidence</code> to control the confidence threshold for the
     * labels returned. The default is 55%. You can also add the <code>MaxLabels</code> parameter to limit the number of
     * labels returned. The default and upper limit is 1000 labels. These arguments are only valid when supplying
     * GENERAL_LABELS as a feature type.
     * </p>
     * <p>
     * <b>Response Elements</b>
     * </p>
     * <p>
     * For each object, scene, and concept the API returns one or more labels. The API returns the following types of
     * information about labels:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Name - The name of the detected label.
     * </p>
     * </li>
     * <li>
     * <p>
     * Confidence - The level of confidence in the label assigned to a detected object.
     * </p>
     * </li>
     * <li>
     * <p>
     * Parents - The ancestor labels for a detected label. DetectLabels returns a hierarchical taxonomy of detected
     * labels. For example, a detected car might be assigned the label car. The label car has two parent labels: Vehicle
     * (its parent) and Transportation (its grandparent). The response includes the all ancestors for a label, where
     * every ancestor is a unique label. In the previous example, Car, Vehicle, and Transportation are returned as
     * unique labels in the response.
     * </p>
     * </li>
     * <li>
     * <p>
     * Aliases - Possible Aliases for the label.
     * </p>
     * </li>
     * <li>
     * <p>
     * Categories - The label categories that the detected label belongs to.
     * </p>
     * </li>
     * <li>
     * <p>
     * BoundingBox — Bounding boxes are described for all instances of detected common object labels, returned in an
     * array of Instance objects. An Instance object contains a BoundingBox object, describing the location of the label
     * on the input image. It also includes the confidence for the accuracy of the detected bounding box.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The API returns the following information regarding the image, as part of the ImageProperties structure:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Quality - Information about the Sharpness, Brightness, and Contrast of the input image, scored between 0 to 100.
     * Image quality is returned for the entire image, as well as the background and the foreground.
     * </p>
     * </li>
     * <li>
     * <p>
     * Dominant Color - An array of the dominant colors in the image.
     * </p>
     * </li>
     * <li>
     * <p>
     * Foreground - Information about the sharpness, brightness, and dominant colors of the input image’s foreground.
     * </p>
     * </li>
     * <li>
     * <p>
     * Background - Information about the sharpness, brightness, and dominant colors of the input image’s background.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The list of returned labels will include at least one label for every detected object, along with information
     * about that label. In the following example, suppose the input image has a lighthouse, the sea, and a rock. The
     * response includes all three labels, one for each object, as well as the confidence in the label:
     * </p>
     * <p>
     * <code>{Name: lighthouse, Confidence: 98.4629}</code>
     * </p>
     * <p>
     * <code>{Name: rock,Confidence: 79.2097}</code>
     * </p>
     * <p>
     * <code> {Name: sea,Confidence: 75.061}</code>
     * </p>
     * <p>
     * The list of labels can include multiple labels for the same object. For example, if the input image shows a
     * flower (for example, a tulip), the operation might return the following three labels.
     * </p>
     * <p>
     * <code>{Name: flower,Confidence: 99.0562}</code>
     * </p>
     * <p>
     * <code>{Name: plant,Confidence: 99.0562}</code>
     * </p>
     * <p>
     * <code>{Name: tulip,Confidence: 99.0562}</code>
     * </p>
     * <p>
     * In this example, the detection algorithm more precisely identifies the flower as a tulip.
     * </p>
     * <note>
     * <p>
     * If the object detected is a person, the operation doesn't provide the same facial details that the
     * <a>DetectFaces</a> operation provides.
     * </p>
     * </note>
     * <p>
     * This is a stateless API operation that doesn't return any data.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:DetectLabels</code> action.
     * </p>
     *
     * @param detectLabelsRequest
     * @return A Java Future containing the result of the DetectLabels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ImageTooLargeException The input image size exceeds the allowed limit. If you are calling
     *         DetectProtectiveEquipment, the image size or resolution exceeds the allowed limit. For more information,
     *         see Guidelines and quotas in Amazon Rekognition in the Amazon Rekognition Developer Guide.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidImageFormatException The provided image format is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DetectLabels
     */
    @Override
    public CompletableFuture<DetectLabelsResponse> detectLabels(DetectLabelsRequest detectLabelsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(detectLabelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detectLabelsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetectLabels");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DetectLabelsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DetectLabelsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DetectLabelsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetectLabelsRequest, DetectLabelsResponse>()
                            .withOperationName("DetectLabels").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DetectLabelsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(detectLabelsRequest));
            CompletableFuture<DetectLabelsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Detects unsafe content in a specified JPEG or PNG format image. Use <code>DetectModerationLabels</code> to
     * moderate images depending on your requirements. For example, you might want to filter images that contain nudity,
     * but not images containing suggestive content.
     * </p>
     * <p>
     * To filter images, use the labels returned by <code>DetectModerationLabels</code> to determine which types of
     * content are appropriate.
     * </p>
     * <p>
     * For information about moderation labels, see Detecting Unsafe Content in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * You pass the input image either as base64-encoded image bytes or as a reference to an image in an Amazon S3
     * bucket. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes is not supported. The
     * image must be either a PNG or JPEG formatted file.
     * </p>
     * <p>
     * You can specify an adapter to use when retrieving label predictions by providing a <code>ProjectVersionArn</code>
     * to the <code>ProjectVersion</code> argument.
     * </p>
     *
     * @param detectModerationLabelsRequest
     * @return A Java Future containing the result of the DetectModerationLabels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ImageTooLargeException The input image size exceeds the allowed limit. If you are calling
     *         DetectProtectiveEquipment, the image size or resolution exceeds the allowed limit. For more information,
     *         see Guidelines and quotas in Amazon Rekognition in the Amazon Rekognition Developer Guide.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidImageFormatException The provided image format is not supported.</li>
     *         <li>HumanLoopQuotaExceededException The number of in-progress human reviews you have has exceeded the
     *         number allowed.</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>ResourceNotReadyException The requested resource isn't ready. For example, this exception occurs when
     *         you call <code>DetectCustomLabels</code> with a model version that isn't deployed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DetectModerationLabels
     */
    @Override
    public CompletableFuture<DetectModerationLabelsResponse> detectModerationLabels(
            DetectModerationLabelsRequest detectModerationLabelsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(detectModerationLabelsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detectModerationLabelsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetectModerationLabels");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DetectModerationLabelsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DetectModerationLabelsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DetectModerationLabelsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetectModerationLabelsRequest, DetectModerationLabelsResponse>()
                            .withOperationName("DetectModerationLabels").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DetectModerationLabelsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(detectModerationLabelsRequest));
            CompletableFuture<DetectModerationLabelsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Detects Personal Protective Equipment (PPE) worn by people detected in an image. Amazon Rekognition can detect
     * the following types of PPE.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Face cover
     * </p>
     * </li>
     * <li>
     * <p>
     * Hand cover
     * </p>
     * </li>
     * <li>
     * <p>
     * Head cover
     * </p>
     * </li>
     * </ul>
     * <p>
     * You pass the input image as base64-encoded image bytes or as a reference to an image in an Amazon S3 bucket. The
     * image must be either a PNG or JPG formatted file.
     * </p>
     * <p>
     * <code>DetectProtectiveEquipment</code> detects PPE worn by up to 15 persons detected in an image.
     * </p>
     * <p>
     * For each person detected in the image the API returns an array of body parts (face, head, left-hand, right-hand).
     * For each body part, an array of detected items of PPE is returned, including an indicator of whether or not the
     * PPE covers the body part. The API returns the confidence it has in each detection (person, PPE, body part and
     * body part coverage). It also returns a bounding box (<a>BoundingBox</a>) for each detected person and each
     * detected item of PPE.
     * </p>
     * <p>
     * You can optionally request a summary of detected PPE items with the <code>SummarizationAttributes</code> input
     * parameter. The summary provides the following information.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The persons detected as wearing all of the types of PPE that you specify.
     * </p>
     * </li>
     * <li>
     * <p>
     * The persons detected as not wearing all of the types PPE that you specify.
     * </p>
     * </li>
     * <li>
     * <p>
     * The persons detected where PPE adornment could not be determined.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This is a stateless API operation. That is, the operation does not persist any data.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:DetectProtectiveEquipment</code> action.
     * </p>
     *
     * @param detectProtectiveEquipmentRequest
     * @return A Java Future containing the result of the DetectProtectiveEquipment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ImageTooLargeException The input image size exceeds the allowed limit. If you are calling
     *         DetectProtectiveEquipment, the image size or resolution exceeds the allowed limit. For more information,
     *         see Guidelines and quotas in Amazon Rekognition in the Amazon Rekognition Developer Guide.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidImageFormatException The provided image format is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DetectProtectiveEquipment
     */
    @Override
    public CompletableFuture<DetectProtectiveEquipmentResponse> detectProtectiveEquipment(
            DetectProtectiveEquipmentRequest detectProtectiveEquipmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(detectProtectiveEquipmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detectProtectiveEquipmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetectProtectiveEquipment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DetectProtectiveEquipmentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DetectProtectiveEquipmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DetectProtectiveEquipmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetectProtectiveEquipmentRequest, DetectProtectiveEquipmentResponse>()
                            .withOperationName("DetectProtectiveEquipment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DetectProtectiveEquipmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(detectProtectiveEquipmentRequest));
            CompletableFuture<DetectProtectiveEquipmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Detects text in the input image and converts it into machine-readable text.
     * </p>
     * <p>
     * Pass the input image as base64-encoded image bytes or as a reference to an image in an Amazon S3 bucket. If you
     * use the AWS CLI to call Amazon Rekognition operations, you must pass it as a reference to an image in an Amazon
     * S3 bucket. For the AWS CLI, passing image bytes is not supported. The image must be either a .png or .jpeg
     * formatted file.
     * </p>
     * <p>
     * The <code>DetectText</code> operation returns text in an array of <a>TextDetection</a> elements,
     * <code>TextDetections</code>. Each <code>TextDetection</code> element provides information about a single word or
     * line of text that was detected in the image.
     * </p>
     * <p>
     * A word is one or more script characters that are not separated by spaces. <code>DetectText</code> can detect up
     * to 100 words in an image.
     * </p>
     * <p>
     * A line is a string of equally spaced words. A line isn't necessarily a complete sentence. For example, a driver's
     * license number is detected as a line. A line ends when there is no aligned text after it. Also, a line ends when
     * there is a large gap between words, relative to the length of the words. This means, depending on the gap between
     * words, Amazon Rekognition may detect multiple lines in text aligned in the same direction. Periods don't
     * represent the end of a line. If a sentence spans multiple lines, the <code>DetectText</code> operation returns
     * multiple lines.
     * </p>
     * <p>
     * To determine whether a <code>TextDetection</code> element is a line of text or a word, use the
     * <code>TextDetection</code> object <code>Type</code> field.
     * </p>
     * <p>
     * To be detected, text must be within +/- 90 degrees orientation of the horizontal axis.
     * </p>
     * <p>
     * For more information, see Detecting text in the Amazon Rekognition Developer Guide.
     * </p>
     *
     * @param detectTextRequest
     * @return A Java Future containing the result of the DetectText operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ImageTooLargeException The input image size exceeds the allowed limit. If you are calling
     *         DetectProtectiveEquipment, the image size or resolution exceeds the allowed limit. For more information,
     *         see Guidelines and quotas in Amazon Rekognition in the Amazon Rekognition Developer Guide.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidImageFormatException The provided image format is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DetectText
     */
    @Override
    public CompletableFuture<DetectTextResponse> detectText(DetectTextRequest detectTextRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(detectTextRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detectTextRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetectText");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DetectTextResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DetectTextResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DetectTextResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetectTextRequest, DetectTextResponse>().withOperationName("DetectText")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DetectTextRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(detectTextRequest));
            CompletableFuture<DetectTextResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the association between a <code>Face</code> supplied in an array of <code>FaceIds</code> and the User. If
     * the User is not present already, then a <code>ResourceNotFound</code> exception is thrown. If successful, an
     * array of faces that are disassociated from the User is returned. If a given face is already disassociated from
     * the given UserID, it will be ignored and not be returned in the response. If a given face is already associated
     * with a different User or not found in the collection it will be returned as part of
     * <code>UnsuccessfulDisassociations</code>. You can remove 1 - 100 face IDs from a user at one time.
     * </p>
     *
     * @param disassociateFacesRequest
     * @return A Java Future containing the result of the DisassociateFaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>IdempotentParameterMismatchException A <code>ClientRequestToken</code> input parameter was reused
     *         with an operation, but at least one of the other input parameters is different from the previous call to
     *         the operation.</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>ConflictException A User with the same Id already exists within the collection, or the update or
     *         deletion of the User caused an inconsistent state. **</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DisassociateFaces
     */
    @Override
    public CompletableFuture<DisassociateFacesResponse> disassociateFaces(DisassociateFacesRequest disassociateFacesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateFacesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateFacesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateFaces");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateFacesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateFacesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateFacesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateFacesRequest, DisassociateFacesResponse>()
                            .withOperationName("DisassociateFaces").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisassociateFacesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disassociateFacesRequest));
            CompletableFuture<DisassociateFacesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation applies only to Amazon Rekognition Custom Labels.
     * </p>
     * </note>
     * <p>
     * Distributes the entries (images) in a training dataset across the training dataset and the test dataset for a
     * project. <code>DistributeDatasetEntries</code> moves 20% of the training dataset images to the test dataset. An
     * entry is a JSON Line that describes an image.
     * </p>
     * <p>
     * You supply the Amazon Resource Names (ARN) of a project's training dataset and test dataset. The training dataset
     * must contain the images that you want to split. The test dataset must be empty. The datasets must belong to the
     * same project. To create training and test datasets for a project, call <a>CreateDataset</a>.
     * </p>
     * <p>
     * Distributing a dataset takes a while to complete. To check the status call <code>DescribeDataset</code>. The
     * operation is complete when the <code>Status</code> field for the training dataset and the test dataset is
     * <code>UPDATE_COMPLETE</code>. If the dataset split fails, the value of <code>Status</code> is
     * <code>UPDATE_FAILED</code>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:DistributeDatasetEntries</code> action.
     * </p>
     *
     * @param distributeDatasetEntriesRequest
     * @return A Java Future containing the result of the DistributeDatasetEntries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotReadyException The requested resource isn't ready. For example, this exception occurs when
     *         you call <code>DetectCustomLabels</code> with a model version that isn't deployed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.DistributeDatasetEntries
     */
    @Override
    public CompletableFuture<DistributeDatasetEntriesResponse> distributeDatasetEntries(
            DistributeDatasetEntriesRequest distributeDatasetEntriesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(distributeDatasetEntriesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, distributeDatasetEntriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DistributeDatasetEntries");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DistributeDatasetEntriesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DistributeDatasetEntriesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DistributeDatasetEntriesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DistributeDatasetEntriesRequest, DistributeDatasetEntriesResponse>()
                            .withOperationName("DistributeDatasetEntries").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DistributeDatasetEntriesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(distributeDatasetEntriesRequest));
            CompletableFuture<DistributeDatasetEntriesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the name and additional information about a celebrity based on their Amazon Rekognition ID. The additional
     * information is returned as an array of URLs. If there is no additional information about the celebrity, this list
     * is empty.
     * </p>
     * <p>
     * For more information, see Getting information about a celebrity in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:GetCelebrityInfo</code> action.
     * </p>
     *
     * @param getCelebrityInfoRequest
     * @return A Java Future containing the result of the GetCelebrityInfo operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.GetCelebrityInfo
     */
    @Override
    public CompletableFuture<GetCelebrityInfoResponse> getCelebrityInfo(GetCelebrityInfoRequest getCelebrityInfoRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCelebrityInfoRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCelebrityInfoRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCelebrityInfo");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCelebrityInfoResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCelebrityInfoResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCelebrityInfoResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCelebrityInfoRequest, GetCelebrityInfoResponse>()
                            .withOperationName("GetCelebrityInfo").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetCelebrityInfoRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCelebrityInfoRequest));
            CompletableFuture<GetCelebrityInfoResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the celebrity recognition results for a Amazon Rekognition Video analysis started by
     * <a>StartCelebrityRecognition</a>.
     * </p>
     * <p>
     * Celebrity recognition in a video is an asynchronous operation. Analysis is started by a call to
     * <a>StartCelebrityRecognition</a> which returns a job identifier (<code>JobId</code>).
     * </p>
     * <p>
     * When the celebrity recognition operation finishes, Amazon Rekognition Video publishes a completion status to the
     * Amazon Simple Notification Service topic registered in the initial call to <code>StartCelebrityRecognition</code>
     * . To get the results of the celebrity recognition analysis, first check that the status value published to the
     * Amazon SNS topic is <code>SUCCEEDED</code>. If so, call <code>GetCelebrityDetection</code> and pass the job
     * identifier (<code>JobId</code>) from the initial call to <code>StartCelebrityDetection</code>.
     * </p>
     * <p>
     * For more information, see Working With Stored Videos in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * <code>GetCelebrityRecognition</code> returns detected celebrities and the time(s) they are detected in an array (
     * <code>Celebrities</code>) of <a>CelebrityRecognition</a> objects. Each <code>CelebrityRecognition</code> contains
     * information about the celebrity in a <a>CelebrityDetail</a> object and the time, <code>Timestamp</code>, the
     * celebrity was detected. This <a>CelebrityDetail</a> object stores information about the detected celebrity's face
     * attributes, a face bounding box, known gender, the celebrity's name, and a confidence estimate.
     * </p>
     * <note>
     * <p>
     * <code>GetCelebrityRecognition</code> only returns the default facial attributes (<code>BoundingBox</code>,
     * <code>Confidence</code>, <code>Landmarks</code>, <code>Pose</code>, and <code>Quality</code>). The
     * <code>BoundingBox</code> field only applies to the detected face instance. The other facial attributes listed in
     * the <code>Face</code> object of the following response syntax are not returned. For more information, see
     * FaceDetail in the Amazon Rekognition Developer Guide.
     * </p>
     * </note>
     * <p>
     * By default, the <code>Celebrities</code> array is sorted by time (milliseconds from the start of the video). You
     * can also sort the array by celebrity by specifying the value <code>ID</code> in the <code>SortBy</code> input
     * parameter.
     * </p>
     * <p>
     * The <code>CelebrityDetail</code> object includes the celebrity identifer and additional information urls. If you
     * don't store the additional information urls, you can get them later by calling <a>GetCelebrityInfo</a> with the
     * celebrity identifer.
     * </p>
     * <p>
     * No information is returned for faces not recognized as celebrities.
     * </p>
     * <p>
     * Use MaxResults parameter to limit the number of labels returned. If there are more results than specified in
     * <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a pagination
     * token for getting the next set of results. To get the next page of results, call
     * <code>GetCelebrityDetection</code> and populate the <code>NextToken</code> request parameter with the token value
     * returned from the previous call to <code>GetCelebrityRecognition</code>.
     * </p>
     *
     * @param getCelebrityRecognitionRequest
     * @return A Java Future containing the result of the GetCelebrityRecognition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.GetCelebrityRecognition
     */
    @Override
    public CompletableFuture<GetCelebrityRecognitionResponse> getCelebrityRecognition(
            GetCelebrityRecognitionRequest getCelebrityRecognitionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCelebrityRecognitionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCelebrityRecognitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCelebrityRecognition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCelebrityRecognitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCelebrityRecognitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCelebrityRecognitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCelebrityRecognitionRequest, GetCelebrityRecognitionResponse>()
                            .withOperationName("GetCelebrityRecognition").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetCelebrityRecognitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCelebrityRecognitionRequest));
            CompletableFuture<GetCelebrityRecognitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the inappropriate, unwanted, or offensive content analysis results for a Amazon Rekognition Video analysis
     * started by <a>StartContentModeration</a>. For a list of moderation labels in Amazon Rekognition, see <a
     * href="https://docs.aws.amazon.com/rekognition/latest/dg/moderation.html#moderation-api">Using the image and video
     * moderation APIs</a>.
     * </p>
     * <p>
     * Amazon Rekognition Video inappropriate or offensive content detection in a stored video is an asynchronous
     * operation. You start analysis by calling <a>StartContentModeration</a> which returns a job identifier (
     * <code>JobId</code>). When analysis finishes, Amazon Rekognition Video publishes a completion status to the Amazon
     * Simple Notification Service topic registered in the initial call to <code>StartContentModeration</code>. To get
     * the results of the content analysis, first check that the status value published to the Amazon SNS topic is
     * <code>SUCCEEDED</code>. If so, call <code>GetContentModeration</code> and pass the job identifier (
     * <code>JobId</code>) from the initial call to <code>StartContentModeration</code>.
     * </p>
     * <p>
     * For more information, see Working with Stored Videos in the Amazon Rekognition Devlopers Guide.
     * </p>
     * <p>
     * <code>GetContentModeration</code> returns detected inappropriate, unwanted, or offensive content moderation
     * labels, and the time they are detected, in an array, <code>ModerationLabels</code>, of
     * <a>ContentModerationDetection</a> objects.
     * </p>
     * <p>
     * By default, the moderated labels are returned sorted by time, in milliseconds from the start of the video. You
     * can also sort them by moderated label by specifying <code>NAME</code> for the <code>SortBy</code> input
     * parameter.
     * </p>
     * <p>
     * Since video analysis can return a large number of results, use the <code>MaxResults</code> parameter to limit the
     * number of labels returned in a single call to <code>GetContentModeration</code>. If there are more results than
     * specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a
     * pagination token for getting the next set of results. To get the next page of results, call
     * <code>GetContentModeration</code> and populate the <code>NextToken</code> request parameter with the value of
     * <code>NextToken</code> returned from the previous call to <code>GetContentModeration</code>.
     * </p>
     * <p>
     * For more information, see moderating content in the Amazon Rekognition Developer Guide.
     * </p>
     *
     * @param getContentModerationRequest
     * @return A Java Future containing the result of the GetContentModeration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.GetContentModeration
     */
    @Override
    public CompletableFuture<GetContentModerationResponse> getContentModeration(
            GetContentModerationRequest getContentModerationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getContentModerationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getContentModerationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetContentModeration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetContentModerationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetContentModerationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetContentModerationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetContentModerationRequest, GetContentModerationResponse>()
                            .withOperationName("GetContentModeration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetContentModerationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getContentModerationRequest));
            CompletableFuture<GetContentModerationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets face detection results for a Amazon Rekognition Video analysis started by <a>StartFaceDetection</a>.
     * </p>
     * <p>
     * Face detection with Amazon Rekognition Video is an asynchronous operation. You start face detection by calling
     * <a>StartFaceDetection</a> which returns a job identifier (<code>JobId</code>). When the face detection operation
     * finishes, Amazon Rekognition Video publishes a completion status to the Amazon Simple Notification Service topic
     * registered in the initial call to <code>StartFaceDetection</code>. To get the results of the face detection
     * operation, first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so,
     * call <a>GetFaceDetection</a> and pass the job identifier (<code>JobId</code>) from the initial call to
     * <code>StartFaceDetection</code>.
     * </p>
     * <p>
     * <code>GetFaceDetection</code> returns an array of detected faces (<code>Faces</code>) sorted by the time the
     * faces were detected.
     * </p>
     * <p>
     * Use MaxResults parameter to limit the number of labels returned. If there are more results than specified in
     * <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a pagination
     * token for getting the next set of results. To get the next page of results, call <code>GetFaceDetection</code>
     * and populate the <code>NextToken</code> request parameter with the token value returned from the previous call to
     * <code>GetFaceDetection</code>.
     * </p>
     * <p>
     * Note that for the <code>GetFaceDetection</code> operation, the returned values for <code>FaceOccluded</code> and
     * <code>EyeDirection</code> will always be "null".
     * </p>
     *
     * @param getFaceDetectionRequest
     * @return A Java Future containing the result of the GetFaceDetection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.GetFaceDetection
     */
    @Override
    public CompletableFuture<GetFaceDetectionResponse> getFaceDetection(GetFaceDetectionRequest getFaceDetectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getFaceDetectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getFaceDetectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFaceDetection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetFaceDetectionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetFaceDetectionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetFaceDetectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetFaceDetectionRequest, GetFaceDetectionResponse>()
                            .withOperationName("GetFaceDetection").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetFaceDetectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getFaceDetectionRequest));
            CompletableFuture<GetFaceDetectionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the results of a specific Face Liveness session. It requires the <code>sessionId</code> as input, which
     * was created using <code>CreateFaceLivenessSession</code>. Returns the corresponding Face Liveness confidence
     * score, a reference image that includes a face bounding box, and audit images that also contain face bounding
     * boxes. The Face Liveness confidence score ranges from 0 to 100.
     * </p>
     * <p>
     * The number of audit images returned by <code>GetFaceLivenessSessionResults</code> is defined by the
     * <code>AuditImagesLimit</code> paramater when calling <code>CreateFaceLivenessSession</code>. Reference images are
     * always returned when possible.
     * </p>
     *
     * @param getFaceLivenessSessionResultsRequest
     * @return A Java Future containing the result of the GetFaceLivenessSessionResults operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>SessionNotFoundException Occurs when a given sessionId is not found.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.GetFaceLivenessSessionResults
     */
    @Override
    public CompletableFuture<GetFaceLivenessSessionResultsResponse> getFaceLivenessSessionResults(
            GetFaceLivenessSessionResultsRequest getFaceLivenessSessionResultsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getFaceLivenessSessionResultsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getFaceLivenessSessionResultsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFaceLivenessSessionResults");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetFaceLivenessSessionResultsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetFaceLivenessSessionResultsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetFaceLivenessSessionResultsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetFaceLivenessSessionResultsRequest, GetFaceLivenessSessionResultsResponse>()
                            .withOperationName("GetFaceLivenessSessionResults").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetFaceLivenessSessionResultsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getFaceLivenessSessionResultsRequest));
            CompletableFuture<GetFaceLivenessSessionResultsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the face search results for Amazon Rekognition Video face search started by <a>StartFaceSearch</a>. The
     * search returns faces in a collection that match the faces of persons detected in a video. It also includes the
     * time(s) that faces are matched in the video.
     * </p>
     * <p>
     * Face search in a video is an asynchronous operation. You start face search by calling to <a>StartFaceSearch</a>
     * which returns a job identifier (<code>JobId</code>). When the search operation finishes, Amazon Rekognition Video
     * publishes a completion status to the Amazon Simple Notification Service topic registered in the initial call to
     * <code>StartFaceSearch</code>. To get the search results, first check that the status value published to the
     * Amazon SNS topic is <code>SUCCEEDED</code>. If so, call <code>GetFaceSearch</code> and pass the job identifier (
     * <code>JobId</code>) from the initial call to <code>StartFaceSearch</code>.
     * </p>
     * <p>
     * For more information, see Searching Faces in a Collection in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * The search results are retured in an array, <code>Persons</code>, of <a>PersonMatch</a> objects. Each
     * <code>PersonMatch</code> element contains details about the matching faces in the input collection, person
     * information (facial attributes, bounding boxes, and person identifer) for the matched person, and the time the
     * person was matched in the video.
     * </p>
     * <note>
     * <p>
     * <code>GetFaceSearch</code> only returns the default facial attributes (<code>BoundingBox</code>,
     * <code>Confidence</code>, <code>Landmarks</code>, <code>Pose</code>, and <code>Quality</code>). The other facial
     * attributes listed in the <code>Face</code> object of the following response syntax are not returned. For more
     * information, see FaceDetail in the Amazon Rekognition Developer Guide.
     * </p>
     * </note>
     * <p>
     * By default, the <code>Persons</code> array is sorted by the time, in milliseconds from the start of the video,
     * persons are matched. You can also sort by persons by specifying <code>INDEX</code> for the <code>SORTBY</code>
     * input parameter.
     * </p>
     *
     * @param getFaceSearchRequest
     * @return A Java Future containing the result of the GetFaceSearch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.GetFaceSearch
     */
    @Override
    public CompletableFuture<GetFaceSearchResponse> getFaceSearch(GetFaceSearchRequest getFaceSearchRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getFaceSearchRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getFaceSearchRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFaceSearch");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetFaceSearchResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetFaceSearchResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetFaceSearchResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetFaceSearchRequest, GetFaceSearchResponse>()
                            .withOperationName("GetFaceSearch").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetFaceSearchRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getFaceSearchRequest));
            CompletableFuture<GetFaceSearchResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the label detection results of a Amazon Rekognition Video analysis started by <a>StartLabelDetection</a>.
     * </p>
     * <p>
     * The label detection operation is started by a call to <a>StartLabelDetection</a> which returns a job identifier (
     * <code>JobId</code>). When the label detection operation finishes, Amazon Rekognition publishes a completion
     * status to the Amazon Simple Notification Service topic registered in the initial call to
     * <code>StartlabelDetection</code>.
     * </p>
     * <p>
     * To get the results of the label detection operation, first check that the status value published to the Amazon
     * SNS topic is <code>SUCCEEDED</code>. If so, call <a>GetLabelDetection</a> and pass the job identifier (
     * <code>JobId</code>) from the initial call to <code>StartLabelDetection</code>.
     * </p>
     * <p>
     * <code>GetLabelDetection</code> returns an array of detected labels (<code>Labels</code>) sorted by the time the
     * labels were detected. You can also sort by the label name by specifying <code>NAME</code> for the
     * <code>SortBy</code> input parameter. If there is no <code>NAME</code> specified, the default sort is by
     * timestamp.
     * </p>
     * <p>
     * You can select how results are aggregated by using the <code>AggregateBy</code> input parameter. The default
     * aggregation method is <code>TIMESTAMPS</code>. You can also aggregate by <code>SEGMENTS</code>, which aggregates
     * all instances of labels detected in a given segment.
     * </p>
     * <p>
     * The returned Labels array may include the following attributes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Name - The name of the detected label.
     * </p>
     * </li>
     * <li>
     * <p>
     * Confidence - The level of confidence in the label assigned to a detected object.
     * </p>
     * </li>
     * <li>
     * <p>
     * Parents - The ancestor labels for a detected label. GetLabelDetection returns a hierarchical taxonomy of detected
     * labels. For example, a detected car might be assigned the label car. The label car has two parent labels: Vehicle
     * (its parent) and Transportation (its grandparent). The response includes the all ancestors for a label, where
     * every ancestor is a unique label. In the previous example, Car, Vehicle, and Transportation are returned as
     * unique labels in the response.
     * </p>
     * </li>
     * <li>
     * <p>
     * Aliases - Possible Aliases for the label.
     * </p>
     * </li>
     * <li>
     * <p>
     * Categories - The label categories that the detected label belongs to.
     * </p>
     * </li>
     * <li>
     * <p>
     * BoundingBox — Bounding boxes are described for all instances of detected common object labels, returned in an
     * array of Instance objects. An Instance object contains a BoundingBox object, describing the location of the label
     * on the input image. It also includes the confidence for the accuracy of the detected bounding box.
     * </p>
     * </li>
     * <li>
     * <p>
     * Timestamp - Time, in milliseconds from the start of the video, that the label was detected. For aggregation by
     * <code>SEGMENTS</code>, the <code>StartTimestampMillis</code>, <code>EndTimestampMillis</code>, and
     * <code>DurationMillis</code> structures are what define a segment. Although the “Timestamp” structure is still
     * returned with each label, its value is set to be the same as <code>StartTimestampMillis</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Timestamp and Bounding box information are returned for detected Instances, only if aggregation is done by
     * <code>TIMESTAMPS</code>. If aggregating by <code>SEGMENTS</code>, information about detected instances isn’t
     * returned.
     * </p>
     * <p>
     * The version of the label model used for the detection is also returned.
     * </p>
     * <p>
     * <b>Note <code>DominantColors</code> isn't returned for <code>Instances</code>, although it is shown as part of
     * the response in the sample seen below.</b>
     * </p>
     * <p>
     * Use <code>MaxResults</code> parameter to limit the number of labels returned. If there are more results than
     * specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a
     * pagination token for getting the next set of results. To get the next page of results, call
     * <code>GetlabelDetection</code> and populate the <code>NextToken</code> request parameter with the token value
     * returned from the previous call to <code>GetLabelDetection</code>.
     * </p>
     *
     * @param getLabelDetectionRequest
     * @return A Java Future containing the result of the GetLabelDetection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.GetLabelDetection
     */
    @Override
    public CompletableFuture<GetLabelDetectionResponse> getLabelDetection(GetLabelDetectionRequest getLabelDetectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getLabelDetectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLabelDetectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLabelDetection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetLabelDetectionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetLabelDetectionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetLabelDetectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetLabelDetectionRequest, GetLabelDetectionResponse>()
                            .withOperationName("GetLabelDetection").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetLabelDetectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getLabelDetectionRequest));
            CompletableFuture<GetLabelDetectionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the results for a given media analysis job. Takes a <code>JobId</code> returned by
     * StartMediaAnalysisJob.
     * </p>
     *
     * @param getMediaAnalysisJobRequest
     * @return A Java Future containing the result of the GetMediaAnalysisJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.GetMediaAnalysisJob
     */
    @Override
    public CompletableFuture<GetMediaAnalysisJobResponse> getMediaAnalysisJob(
            GetMediaAnalysisJobRequest getMediaAnalysisJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMediaAnalysisJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMediaAnalysisJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMediaAnalysisJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMediaAnalysisJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetMediaAnalysisJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMediaAnalysisJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMediaAnalysisJobRequest, GetMediaAnalysisJobResponse>()
                            .withOperationName("GetMediaAnalysisJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetMediaAnalysisJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getMediaAnalysisJobRequest));
            CompletableFuture<GetMediaAnalysisJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the path tracking results of a Amazon Rekognition Video analysis started by <a>StartPersonTracking</a>.
     * </p>
     * <p>
     * The person path tracking operation is started by a call to <code>StartPersonTracking</code> which returns a job
     * identifier (<code>JobId</code>). When the operation finishes, Amazon Rekognition Video publishes a completion
     * status to the Amazon Simple Notification Service topic registered in the initial call to
     * <code>StartPersonTracking</code>.
     * </p>
     * <p>
     * To get the results of the person path tracking operation, first check that the status value published to the
     * Amazon SNS topic is <code>SUCCEEDED</code>. If so, call <a>GetPersonTracking</a> and pass the job identifier (
     * <code>JobId</code>) from the initial call to <code>StartPersonTracking</code>.
     * </p>
     * <p>
     * <code>GetPersonTracking</code> returns an array, <code>Persons</code>, of tracked persons and the time(s) their
     * paths were tracked in the video.
     * </p>
     * <note>
     * <p>
     * <code>GetPersonTracking</code> only returns the default facial attributes (<code>BoundingBox</code>,
     * <code>Confidence</code>, <code>Landmarks</code>, <code>Pose</code>, and <code>Quality</code>). The other facial
     * attributes listed in the <code>Face</code> object of the following response syntax are not returned.
     * </p>
     * <p>
     * For more information, see FaceDetail in the Amazon Rekognition Developer Guide.
     * </p>
     * </note>
     * <p>
     * By default, the array is sorted by the time(s) a person's path is tracked in the video. You can sort by tracked
     * persons by specifying <code>INDEX</code> for the <code>SortBy</code> input parameter.
     * </p>
     * <p>
     * Use the <code>MaxResults</code> parameter to limit the number of items returned. If there are more results than
     * specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a
     * pagination token for getting the next set of results. To get the next page of results, call
     * <code>GetPersonTracking</code> and populate the <code>NextToken</code> request parameter with the token value
     * returned from the previous call to <code>GetPersonTracking</code>.
     * </p>
     *
     * @param getPersonTrackingRequest
     * @return A Java Future containing the result of the GetPersonTracking operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.GetPersonTracking
     */
    @Override
    public CompletableFuture<GetPersonTrackingResponse> getPersonTracking(GetPersonTrackingRequest getPersonTrackingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getPersonTrackingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPersonTrackingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPersonTracking");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetPersonTrackingResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetPersonTrackingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetPersonTrackingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetPersonTrackingRequest, GetPersonTrackingResponse>()
                            .withOperationName("GetPersonTracking").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetPersonTrackingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getPersonTrackingRequest));
            CompletableFuture<GetPersonTrackingResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the segment detection results of a Amazon Rekognition Video analysis started by
     * <a>StartSegmentDetection</a>.
     * </p>
     * <p>
     * Segment detection with Amazon Rekognition Video is an asynchronous operation. You start segment detection by
     * calling <a>StartSegmentDetection</a> which returns a job identifier (<code>JobId</code>). When the segment
     * detection operation finishes, Amazon Rekognition publishes a completion status to the Amazon Simple Notification
     * Service topic registered in the initial call to <code>StartSegmentDetection</code>. To get the results of the
     * segment detection operation, first check that the status value published to the Amazon SNS topic is
     * <code>SUCCEEDED</code>. if so, call <code>GetSegmentDetection</code> and pass the job identifier (
     * <code>JobId</code>) from the initial call of <code>StartSegmentDetection</code>.
     * </p>
     * <p>
     * <code>GetSegmentDetection</code> returns detected segments in an array (<code>Segments</code>) of
     * <a>SegmentDetection</a> objects. <code>Segments</code> is sorted by the segment types specified in the
     * <code>SegmentTypes</code> input parameter of <code>StartSegmentDetection</code>. Each element of the array
     * includes the detected segment, the precentage confidence in the acuracy of the detected segment, the type of the
     * segment, and the frame in which the segment was detected.
     * </p>
     * <p>
     * Use <code>SelectedSegmentTypes</code> to find out the type of segment detection requested in the call to
     * <code>StartSegmentDetection</code>.
     * </p>
     * <p>
     * Use the <code>MaxResults</code> parameter to limit the number of segment detections returned. If there are more
     * results than specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response
     * contains a pagination token for getting the next set of results. To get the next page of results, call
     * <code>GetSegmentDetection</code> and populate the <code>NextToken</code> request parameter with the token value
     * returned from the previous call to <code>GetSegmentDetection</code>.
     * </p>
     * <p>
     * For more information, see Detecting video segments in stored video in the Amazon Rekognition Developer Guide.
     * </p>
     *
     * @param getSegmentDetectionRequest
     * @return A Java Future containing the result of the GetSegmentDetection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.GetSegmentDetection
     */
    @Override
    public CompletableFuture<GetSegmentDetectionResponse> getSegmentDetection(
            GetSegmentDetectionRequest getSegmentDetectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSegmentDetectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSegmentDetectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSegmentDetection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSegmentDetectionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetSegmentDetectionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSegmentDetectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSegmentDetectionRequest, GetSegmentDetectionResponse>()
                            .withOperationName("GetSegmentDetection").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSegmentDetectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getSegmentDetectionRequest));
            CompletableFuture<GetSegmentDetectionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the text detection results of a Amazon Rekognition Video analysis started by <a>StartTextDetection</a>.
     * </p>
     * <p>
     * Text detection with Amazon Rekognition Video is an asynchronous operation. You start text detection by calling
     * <a>StartTextDetection</a> which returns a job identifier (<code>JobId</code>) When the text detection operation
     * finishes, Amazon Rekognition publishes a completion status to the Amazon Simple Notification Service topic
     * registered in the initial call to <code>StartTextDetection</code>. To get the results of the text detection
     * operation, first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. if so,
     * call <code>GetTextDetection</code> and pass the job identifier (<code>JobId</code>) from the initial call of
     * <code>StartLabelDetection</code>.
     * </p>
     * <p>
     * <code>GetTextDetection</code> returns an array of detected text (<code>TextDetections</code>) sorted by the time
     * the text was detected, up to 100 words per frame of video.
     * </p>
     * <p>
     * Each element of the array includes the detected text, the precentage confidence in the acuracy of the detected
     * text, the time the text was detected, bounding box information for where the text was located, and unique
     * identifiers for words and their lines.
     * </p>
     * <p>
     * Use MaxResults parameter to limit the number of text detections returned. If there are more results than
     * specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a
     * pagination token for getting the next set of results. To get the next page of results, call
     * <code>GetTextDetection</code> and populate the <code>NextToken</code> request parameter with the token value
     * returned from the previous call to <code>GetTextDetection</code>.
     * </p>
     *
     * @param getTextDetectionRequest
     * @return A Java Future containing the result of the GetTextDetection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.GetTextDetection
     */
    @Override
    public CompletableFuture<GetTextDetectionResponse> getTextDetection(GetTextDetectionRequest getTextDetectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTextDetectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTextDetectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTextDetection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetTextDetectionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetTextDetectionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetTextDetectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetTextDetectionRequest, GetTextDetectionResponse>()
                            .withOperationName("GetTextDetection").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetTextDetectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getTextDetectionRequest));
            CompletableFuture<GetTextDetectionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Detects faces in the input image and adds them to the specified collection.
     * </p>
     * <p>
     * Amazon Rekognition doesn't save the actual faces that are detected. Instead, the underlying detection algorithm
     * first detects the faces in the input image. For each face, the algorithm extracts facial features into a feature
     * vector, and stores it in the backend database. Amazon Rekognition uses feature vectors when it performs face
     * match and search operations using the <a>SearchFaces</a> and <a>SearchFacesByImage</a> operations.
     * </p>
     * <p>
     * For more information, see Adding faces to a collection in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * To get the number of faces in a collection, call <a>DescribeCollection</a>.
     * </p>
     * <p>
     * If you're using version 1.0 of the face detection model, <code>IndexFaces</code> indexes the 15 largest faces in
     * the input image. Later versions of the face detection model index the 100 largest faces in the input image.
     * </p>
     * <p>
     * If you're using version 4 or later of the face model, image orientation information is not returned in the
     * <code>OrientationCorrection</code> field.
     * </p>
     * <p>
     * To determine which version of the model you're using, call <a>DescribeCollection</a> and supply the collection
     * ID. You can also get the model version from the value of <code>FaceModelVersion</code> in the response from
     * <code>IndexFaces</code>
     * </p>
     * <p>
     * For more information, see Model Versioning in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * If you provide the optional <code>ExternalImageId</code> for the input image you provided, Amazon Rekognition
     * associates this ID with all faces that it detects. When you call the <a>ListFaces</a> operation, the response
     * returns the external ID. You can use this external image ID to create a client-side index to associate the faces
     * with each image. You can then use the index to find all faces in an image.
     * </p>
     * <p>
     * You can specify the maximum number of faces to index with the <code>MaxFaces</code> input parameter. This is
     * useful when you want to index the largest faces in an image and don't want to index smaller faces, such as those
     * belonging to people standing in the background.
     * </p>
     * <p>
     * The <code>QualityFilter</code> input parameter allows you to filter out detected faces that don’t meet a required
     * quality bar. The quality bar is based on a variety of common use cases. By default, <code>IndexFaces</code>
     * chooses the quality bar that's used to filter faces. You can also explicitly choose the quality bar. Use
     * <code>QualityFilter</code>, to set the quality bar by specifying <code>LOW</code>, <code>MEDIUM</code>, or
     * <code>HIGH</code>. If you do not want to filter detected faces, specify <code>NONE</code>.
     * </p>
     * <note>
     * <p>
     * To use quality filtering, you need a collection associated with version 3 of the face model or higher. To get the
     * version of the face model associated with a collection, call <a>DescribeCollection</a>.
     * </p>
     * </note>
     * <p>
     * Information about faces detected in an image, but not indexed, is returned in an array of <a>UnindexedFace</a>
     * objects, <code>UnindexedFaces</code>. Faces aren't indexed for reasons such as:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The number of faces detected exceeds the value of the <code>MaxFaces</code> request parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * The face is too small compared to the image dimensions.
     * </p>
     * </li>
     * <li>
     * <p>
     * The face is too blurry.
     * </p>
     * </li>
     * <li>
     * <p>
     * The image is too dark.
     * </p>
     * </li>
     * <li>
     * <p>
     * The face has an extreme pose.
     * </p>
     * </li>
     * <li>
     * <p>
     * The face doesn’t have enough detail to be suitable for face search.
     * </p>
     * </li>
     * </ul>
     * <p>
     * In response, the <code>IndexFaces</code> operation returns an array of metadata for all detected faces,
     * <code>FaceRecords</code>. This includes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The bounding box, <code>BoundingBox</code>, of the detected face.
     * </p>
     * </li>
     * <li>
     * <p>
     * A confidence value, <code>Confidence</code>, which indicates the confidence that the bounding box contains a
     * face.
     * </p>
     * </li>
     * <li>
     * <p>
     * A face ID, <code>FaceId</code>, assigned by the service for each face that's detected and stored.
     * </p>
     * </li>
     * <li>
     * <p>
     * An image ID, <code>ImageId</code>, assigned by the service for the input image.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you request <code>ALL</code> or specific facial attributes (e.g., <code>FACE_OCCLUDED</code>) by using the
     * detectionAttributes parameter, Amazon Rekognition returns detailed facial attributes, such as facial landmarks
     * (for example, location of eye and mouth), facial occlusion, and other facial attributes.
     * </p>
     * <p>
     * If you provide the same image, specify the same collection, and use the same external ID in the
     * <code>IndexFaces</code> operation, Amazon Rekognition doesn't save duplicate face metadata.
     * </p>
     * <p/>
     * <p>
     * The input image is passed either as base64-encoded image bytes, or as a reference to an image in an Amazon S3
     * bucket. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes isn't supported. The
     * image must be formatted as a PNG or JPEG file.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:IndexFaces</code> action.
     * </p>
     *
     * @param indexFacesRequest
     * @return A Java Future containing the result of the IndexFaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ImageTooLargeException The input image size exceeds the allowed limit. If you are calling
     *         DetectProtectiveEquipment, the image size or resolution exceeds the allowed limit. For more information,
     *         see Guidelines and quotas in Amazon Rekognition in the Amazon Rekognition Developer Guide.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>InvalidImageFormatException The provided image format is not supported.</li>
     *         <li>ServiceQuotaExceededException
     *         <p>
     *         The size of the collection exceeds the allowed limit. For more information, see Guidelines and quotas in
     *         Amazon Rekognition in the Amazon Rekognition Developer Guide.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.IndexFaces
     */
    @Override
    public CompletableFuture<IndexFacesResponse> indexFaces(IndexFacesRequest indexFacesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(indexFacesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, indexFacesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "IndexFaces");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<IndexFacesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    IndexFacesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<IndexFacesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<IndexFacesRequest, IndexFacesResponse>().withOperationName("IndexFaces")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new IndexFacesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(indexFacesRequest));
            CompletableFuture<IndexFacesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns list of collection IDs in your account. If the result is truncated, the response also provides a
     * <code>NextToken</code> that you can use in the subsequent request to fetch the next set of collection IDs.
     * </p>
     * <p>
     * For an example, see Listing collections in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:ListCollections</code> action.
     * </p>
     *
     * @param listCollectionsRequest
     * @return A Java Future containing the result of the ListCollections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.ListCollections
     */
    @Override
    public CompletableFuture<ListCollectionsResponse> listCollections(ListCollectionsRequest listCollectionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCollectionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCollectionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCollections");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCollectionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListCollectionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCollectionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCollectionsRequest, ListCollectionsResponse>()
                            .withOperationName("ListCollections").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListCollectionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCollectionsRequest));
            CompletableFuture<ListCollectionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation applies only to Amazon Rekognition Custom Labels.
     * </p>
     * </note>
     * <p>
     * Lists the entries (images) within a dataset. An entry is a JSON Line that contains the information for a single
     * image, including the image location, assigned labels, and object location bounding boxes. For more information,
     * see <a href="https://docs.aws.amazon.com/rekognition/latest/customlabels-dg/md-manifest-files.html">Creating a
     * manifest file</a>.
     * </p>
     * <p>
     * JSON Lines in the response include information about non-terminal errors found in the dataset. Non terminal
     * errors are reported in <code>errors</code> lists within each JSON Line. The same information is reported in the
     * training and testing validation result manifests that Amazon Rekognition Custom Labels creates during model
     * training.
     * </p>
     * <p>
     * You can filter the response in variety of ways, such as choosing which labels to return and returning JSON Lines
     * created after a specific date.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:ListDatasetEntries</code> action.
     * </p>
     *
     * @param listDatasetEntriesRequest
     * @return A Java Future containing the result of the ListDatasetEntries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>ResourceInUseException The specified resource is already being used.</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ResourceNotReadyException The requested resource isn't ready. For example, this exception occurs when
     *         you call <code>DetectCustomLabels</code> with a model version that isn't deployed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.ListDatasetEntries
     */
    @Override
    public CompletableFuture<ListDatasetEntriesResponse> listDatasetEntries(ListDatasetEntriesRequest listDatasetEntriesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDatasetEntriesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDatasetEntriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDatasetEntries");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDatasetEntriesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDatasetEntriesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDatasetEntriesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDatasetEntriesRequest, ListDatasetEntriesResponse>()
                            .withOperationName("ListDatasetEntries").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListDatasetEntriesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDatasetEntriesRequest));
            CompletableFuture<ListDatasetEntriesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation applies only to Amazon Rekognition Custom Labels.
     * </p>
     * </note>
     * <p>
     * Lists the labels in a dataset. Amazon Rekognition Custom Labels uses labels to describe images. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/rekognition/latest/customlabels-dg/md-labeling-images.html">Labeling
     * images</a>.
     * </p>
     * <p>
     * Lists the labels in a dataset. Amazon Rekognition Custom Labels uses labels to describe images. For more
     * information, see Labeling images in the <i>Amazon Rekognition Custom Labels Developer Guide</i>.
     * </p>
     *
     * @param listDatasetLabelsRequest
     * @return A Java Future containing the result of the ListDatasetLabels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>ResourceInUseException The specified resource is already being used.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>ResourceNotReadyException The requested resource isn't ready. For example, this exception occurs when
     *         you call <code>DetectCustomLabels</code> with a model version that isn't deployed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.ListDatasetLabels
     */
    @Override
    public CompletableFuture<ListDatasetLabelsResponse> listDatasetLabels(ListDatasetLabelsRequest listDatasetLabelsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDatasetLabelsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDatasetLabelsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDatasetLabels");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDatasetLabelsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDatasetLabelsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDatasetLabelsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDatasetLabelsRequest, ListDatasetLabelsResponse>()
                            .withOperationName("ListDatasetLabels").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListDatasetLabelsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDatasetLabelsRequest));
            CompletableFuture<ListDatasetLabelsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns metadata for faces in the specified collection. This metadata includes information such as the bounding
     * box coordinates, the confidence (that the bounding box contains a face), and face ID. For an example, see Listing
     * Faces in a Collection in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:ListFaces</code> action.
     * </p>
     *
     * @param listFacesRequest
     * @return A Java Future containing the result of the ListFaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.ListFaces
     */
    @Override
    public CompletableFuture<ListFacesResponse> listFaces(ListFacesRequest listFacesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFacesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFacesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFaces");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFacesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListFacesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListFacesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFacesRequest, ListFacesResponse>().withOperationName("ListFaces")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListFacesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(listFacesRequest));
            CompletableFuture<ListFacesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of media analysis jobs. Results are sorted by <code>CreationTimestamp</code> in descending order.
     * </p>
     *
     * @param listMediaAnalysisJobsRequest
     * @return A Java Future containing the result of the ListMediaAnalysisJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.ListMediaAnalysisJobs
     */
    @Override
    public CompletableFuture<ListMediaAnalysisJobsResponse> listMediaAnalysisJobs(
            ListMediaAnalysisJobsRequest listMediaAnalysisJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMediaAnalysisJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMediaAnalysisJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMediaAnalysisJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMediaAnalysisJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListMediaAnalysisJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListMediaAnalysisJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMediaAnalysisJobsRequest, ListMediaAnalysisJobsResponse>()
                            .withOperationName("ListMediaAnalysisJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListMediaAnalysisJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listMediaAnalysisJobsRequest));
            CompletableFuture<ListMediaAnalysisJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation applies only to Amazon Rekognition Custom Labels.
     * </p>
     * </note>
     * <p>
     * Gets a list of the project policies attached to a project.
     * </p>
     * <p>
     * To attach a project policy to a project, call <a>PutProjectPolicy</a>. To remove a project policy from a project,
     * call <a>DeleteProjectPolicy</a>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:ListProjectPolicies</code> action.
     * </p>
     *
     * @param listProjectPoliciesRequest
     * @return A Java Future containing the result of the ListProjectPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.ListProjectPolicies
     */
    @Override
    public CompletableFuture<ListProjectPoliciesResponse> listProjectPolicies(
            ListProjectPoliciesRequest listProjectPoliciesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listProjectPoliciesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listProjectPoliciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListProjectPolicies");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListProjectPoliciesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListProjectPoliciesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListProjectPoliciesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListProjectPoliciesRequest, ListProjectPoliciesResponse>()
                            .withOperationName("ListProjectPolicies").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListProjectPoliciesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listProjectPoliciesRequest));
            CompletableFuture<ListProjectPoliciesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of stream processors that you have created with <a>CreateStreamProcessor</a>.
     * </p>
     *
     * @param listStreamProcessorsRequest
     * @return A Java Future containing the result of the ListStreamProcessors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.ListStreamProcessors
     */
    @Override
    public CompletableFuture<ListStreamProcessorsResponse> listStreamProcessors(
            ListStreamProcessorsRequest listStreamProcessorsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listStreamProcessorsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStreamProcessorsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStreamProcessors");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListStreamProcessorsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListStreamProcessorsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListStreamProcessorsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListStreamProcessorsRequest, ListStreamProcessorsResponse>()
                            .withOperationName("ListStreamProcessors").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListStreamProcessorsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listStreamProcessorsRequest));
            CompletableFuture<ListStreamProcessorsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of tags in an Amazon Rekognition collection, stream processor, or Custom Labels model.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:ListTagsForResource</code> action.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.ListTagsForResource
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns metadata of the User such as <code>UserID</code> in the specified collection. Anonymous User (to reserve
     * faces without any identity) is not returned as part of this request. The results are sorted by system generated
     * primary key ID. If the response is truncated, <code>NextToken</code> is returned in the response that can be used
     * in the subsequent request to retrieve the next set of identities.
     * </p>
     *
     * @param listUsersRequest
     * @return A Java Future containing the result of the ListUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>InvalidPaginationTokenException Pagination token in the request is not valid.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.ListUsers
     */
    @Override
    public CompletableFuture<ListUsersResponse> listUsers(ListUsersRequest listUsersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listUsersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listUsersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListUsers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListUsersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListUsersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListUsersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListUsersRequest, ListUsersResponse>().withOperationName("ListUsers")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListUsersRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(listUsersRequest));
            CompletableFuture<ListUsersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation applies only to Amazon Rekognition Custom Labels.
     * </p>
     * </note>
     * <p>
     * Attaches a project policy to a Amazon Rekognition Custom Labels project in a trusting AWS account. A project
     * policy specifies that a trusted AWS account can copy a model version from a trusting AWS account to a project in
     * the trusted AWS account. To copy a model version you use the <a>CopyProjectVersion</a> operation. Only applies to
     * Custom Labels projects.
     * </p>
     * <p>
     * For more information about the format of a project policy document, see Attaching a project policy (SDK) in the
     * <i>Amazon Rekognition Custom Labels Developer Guide</i>.
     * </p>
     * <p>
     * The response from <code>PutProjectPolicy</code> is a revision ID for the project policy. You can attach multiple
     * project policies to a project. You can also update an existing project policy by specifying the policy revision
     * ID of the existing policy.
     * </p>
     * <p>
     * To remove a project policy from a project, call <a>DeleteProjectPolicy</a>. To get a list of project policies
     * attached to a project, call <a>ListProjectPolicies</a>.
     * </p>
     * <p>
     * You copy a model version by calling <a>CopyProjectVersion</a>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:PutProjectPolicy</code> action.
     * </p>
     *
     * @param putProjectPolicyRequest
     * @return A Java Future containing the result of the PutProjectPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidPolicyRevisionIdException The supplied revision id for the project policy is invalid.</li>
     *         <li>MalformedPolicyDocumentException The format of the project policy document that you supplied to
     *         <code>PutProjectPolicy</code> is incorrect.</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>ResourceAlreadyExistsException A resource with the specified ID already exists.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ServiceQuotaExceededException
     *         <p>
     *         The size of the collection exceeds the allowed limit. For more information, see Guidelines and quotas in
     *         Amazon Rekognition in the Amazon Rekognition Developer Guide.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>LimitExceededException An Amazon Rekognition service limit was exceeded. For example, if you start
     *         too many jobs concurrently, subsequent calls to start operations (ex: <code>StartLabelDetection</code>)
     *         will raise a <code>LimitExceededException</code> exception (HTTP status code: 400) until the number of
     *         concurrently running jobs is below the Amazon Rekognition service limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.PutProjectPolicy
     */
    @Override
    public CompletableFuture<PutProjectPolicyResponse> putProjectPolicy(PutProjectPolicyRequest putProjectPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putProjectPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putProjectPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutProjectPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutProjectPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutProjectPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutProjectPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutProjectPolicyRequest, PutProjectPolicyResponse>()
                            .withOperationName("PutProjectPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutProjectPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putProjectPolicyRequest));
            CompletableFuture<PutProjectPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns an array of celebrities recognized in the input image. For more information, see Recognizing celebrities
     * in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * <code>RecognizeCelebrities</code> returns the 64 largest faces in the image. It lists the recognized celebrities
     * in the <code>CelebrityFaces</code> array and any unrecognized faces in the <code>UnrecognizedFaces</code> array.
     * <code>RecognizeCelebrities</code> doesn't return celebrities whose faces aren't among the largest 64 faces in the
     * image.
     * </p>
     * <p>
     * For each celebrity recognized, <code>RecognizeCelebrities</code> returns a <code>Celebrity</code> object. The
     * <code>Celebrity</code> object contains the celebrity name, ID, URL links to additional information, match
     * confidence, and a <code>ComparedFace</code> object that you can use to locate the celebrity's face on the image.
     * </p>
     * <p>
     * Amazon Rekognition doesn't retain information about which images a celebrity has been recognized in. Your
     * application must store this information and use the <code>Celebrity</code> ID property as a unique identifier for
     * the celebrity. If you don't store the celebrity name or additional information URLs returned by
     * <code>RecognizeCelebrities</code>, you will need the ID to identify the celebrity in a call to the
     * <a>GetCelebrityInfo</a> operation.
     * </p>
     * <p>
     * You pass the input image either as base64-encoded image bytes or as a reference to an image in an Amazon S3
     * bucket. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes is not supported. The
     * image must be either a PNG or JPEG formatted file.
     * </p>
     * <p>
     * For an example, see Recognizing celebrities in an image in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:RecognizeCelebrities</code> operation.
     * </p>
     *
     * @param recognizeCelebritiesRequest
     * @return A Java Future containing the result of the RecognizeCelebrities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidImageFormatException The provided image format is not supported.</li>
     *         <li>ImageTooLargeException The input image size exceeds the allowed limit. If you are calling
     *         DetectProtectiveEquipment, the image size or resolution exceeds the allowed limit. For more information,
     *         see Guidelines and quotas in Amazon Rekognition in the Amazon Rekognition Developer Guide.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidImageFormatException The provided image format is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.RecognizeCelebrities
     */
    @Override
    public CompletableFuture<RecognizeCelebritiesResponse> recognizeCelebrities(
            RecognizeCelebritiesRequest recognizeCelebritiesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(recognizeCelebritiesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, recognizeCelebritiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RecognizeCelebrities");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RecognizeCelebritiesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RecognizeCelebritiesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RecognizeCelebritiesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RecognizeCelebritiesRequest, RecognizeCelebritiesResponse>()
                            .withOperationName("RecognizeCelebrities").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RecognizeCelebritiesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(recognizeCelebritiesRequest));
            CompletableFuture<RecognizeCelebritiesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * For a given input face ID, searches for matching faces in the collection the face belongs to. You get a face ID
     * when you add a face to the collection using the <a>IndexFaces</a> operation. The operation compares the features
     * of the input face with faces in the specified collection.
     * </p>
     * <note>
     * <p>
     * You can also search faces without indexing faces by using the <code>SearchFacesByImage</code> operation.
     * </p>
     * </note>
     * <p>
     * The operation response returns an array of faces that match, ordered by similarity score with the highest
     * similarity first. More specifically, it is an array of metadata for each face match that is found. Along with the
     * metadata, the response also includes a <code>confidence</code> value for each face match, indicating the
     * confidence that the specific face matches the input face.
     * </p>
     * <p>
     * For an example, see Searching for a face using its face ID in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:SearchFaces</code> action.
     * </p>
     *
     * @param searchFacesRequest
     * @return A Java Future containing the result of the SearchFaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.SearchFaces
     */
    @Override
    public CompletableFuture<SearchFacesResponse> searchFaces(SearchFacesRequest searchFacesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(searchFacesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchFacesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchFaces");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SearchFacesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    SearchFacesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SearchFacesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SearchFacesRequest, SearchFacesResponse>()
                            .withOperationName("SearchFaces").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SearchFacesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(searchFacesRequest));
            CompletableFuture<SearchFacesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * For a given input image, first detects the largest face in the image, and then searches the specified collection
     * for matching faces. The operation compares the features of the input face with faces in the specified collection.
     * </p>
     * <note>
     * <p>
     * To search for all faces in an input image, you might first call the <a>IndexFaces</a> operation, and then use the
     * face IDs returned in subsequent calls to the <a>SearchFaces</a> operation.
     * </p>
     * <p>
     * You can also call the <code>DetectFaces</code> operation and use the bounding boxes in the response to make face
     * crops, which then you can pass in to the <code>SearchFacesByImage</code> operation.
     * </p>
     * </note>
     * <p>
     * You pass the input image either as base64-encoded image bytes or as a reference to an image in an Amazon S3
     * bucket. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes is not supported. The
     * image must be either a PNG or JPEG formatted file.
     * </p>
     * <p>
     * The response returns an array of faces that match, ordered by similarity score with the highest similarity first.
     * More specifically, it is an array of metadata for each face match found. Along with the metadata, the response
     * also includes a <code>similarity</code> indicating how similar the face is to the input face. In the response,
     * the operation also returns the bounding box (and a confidence level that the bounding box contains a face) of the
     * face that Amazon Rekognition used for the input image.
     * </p>
     * <p>
     * If no faces are detected in the input image, <code>SearchFacesByImage</code> returns an
     * <code>InvalidParameterException</code> error.
     * </p>
     * <p>
     * For an example, Searching for a Face Using an Image in the Amazon Rekognition Developer Guide.
     * </p>
     * <p>
     * The <code>QualityFilter</code> input parameter allows you to filter out detected faces that don’t meet a required
     * quality bar. The quality bar is based on a variety of common use cases. Use <code>QualityFilter</code> to set the
     * quality bar for filtering by specifying <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>. If you do
     * not want to filter detected faces, specify <code>NONE</code>. The default value is <code>NONE</code>.
     * </p>
     * <note>
     * <p>
     * To use quality filtering, you need a collection associated with version 3 of the face model or higher. To get the
     * version of the face model associated with a collection, call <a>DescribeCollection</a>.
     * </p>
     * </note>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:SearchFacesByImage</code> action.
     * </p>
     *
     * @param searchFacesByImageRequest
     * @return A Java Future containing the result of the SearchFacesByImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ImageTooLargeException The input image size exceeds the allowed limit. If you are calling
     *         DetectProtectiveEquipment, the image size or resolution exceeds the allowed limit. For more information,
     *         see Guidelines and quotas in Amazon Rekognition in the Amazon Rekognition Developer Guide.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>InvalidImageFormatException The provided image format is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.SearchFacesByImage
     */
    @Override
    public CompletableFuture<SearchFacesByImageResponse> searchFacesByImage(SearchFacesByImageRequest searchFacesByImageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(searchFacesByImageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchFacesByImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchFacesByImage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SearchFacesByImageResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SearchFacesByImageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SearchFacesByImageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SearchFacesByImageRequest, SearchFacesByImageResponse>()
                            .withOperationName("SearchFacesByImage").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SearchFacesByImageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(searchFacesByImageRequest));
            CompletableFuture<SearchFacesByImageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Searches for UserIDs within a collection based on a <code>FaceId</code> or <code>UserId</code>. This API can be
     * used to find the closest UserID (with a highest similarity) to associate a face. The request must be provided
     * with either <code>FaceId</code> or <code>UserId</code>. The operation returns an array of UserID that match the
     * <code>FaceId</code> or <code>UserId</code>, ordered by similarity score with the highest similarity first.
     * </p>
     *
     * @param searchUsersRequest
     * @return A Java Future containing the result of the SearchUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.SearchUsers
     */
    @Override
    public CompletableFuture<SearchUsersResponse> searchUsers(SearchUsersRequest searchUsersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(searchUsersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchUsersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchUsers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SearchUsersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    SearchUsersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SearchUsersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SearchUsersRequest, SearchUsersResponse>()
                            .withOperationName("SearchUsers").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SearchUsersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(searchUsersRequest));
            CompletableFuture<SearchUsersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Searches for UserIDs using a supplied image. It first detects the largest face in the image, and then searches a
     * specified collection for matching UserIDs.
     * </p>
     * <p>
     * The operation returns an array of UserIDs that match the face in the supplied image, ordered by similarity score
     * with the highest similarity first. It also returns a bounding box for the face found in the input image.
     * </p>
     * <p>
     * Information about faces detected in the supplied image, but not used for the search, is returned in an array of
     * <code>UnsearchedFace</code> objects. If no valid face is detected in the image, the response will contain an
     * empty <code>UserMatches</code> list and no <code>SearchedFace</code> object.
     * </p>
     *
     * @param searchUsersByImageRequest
     * @return A Java Future containing the result of the SearchUsersByImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>InvalidImageFormatException The provided image format is not supported.</li>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>ImageTooLargeException The input image size exceeds the allowed limit. If you are calling
     *         DetectProtectiveEquipment, the image size or resolution exceeds the allowed limit. For more information,
     *         see Guidelines and quotas in Amazon Rekognition in the Amazon Rekognition Developer Guide.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.SearchUsersByImage
     */
    @Override
    public CompletableFuture<SearchUsersByImageResponse> searchUsersByImage(SearchUsersByImageRequest searchUsersByImageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(searchUsersByImageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchUsersByImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchUsersByImage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SearchUsersByImageResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SearchUsersByImageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SearchUsersByImageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SearchUsersByImageRequest, SearchUsersByImageResponse>()
                            .withOperationName("SearchUsersByImage").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SearchUsersByImageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(searchUsersByImageRequest));
            CompletableFuture<SearchUsersByImageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts asynchronous recognition of celebrities in a stored video.
     * </p>
     * <p>
     * Amazon Rekognition Video can detect celebrities in a video must be stored in an Amazon S3 bucket. Use
     * <a>Video</a> to specify the bucket name and the filename of the video. <code>StartCelebrityRecognition</code>
     * returns a job identifier (<code>JobId</code>) which you use to get the results of the analysis. When celebrity
     * recognition analysis is finished, Amazon Rekognition Video publishes a completion status to the Amazon Simple
     * Notification Service topic that you specify in <code>NotificationChannel</code>. To get the results of the
     * celebrity recognition analysis, first check that the status value published to the Amazon SNS topic is
     * <code>SUCCEEDED</code>. If so, call <a>GetCelebrityRecognition</a> and pass the job identifier (
     * <code>JobId</code>) from the initial call to <code>StartCelebrityRecognition</code>.
     * </p>
     * <p>
     * For more information, see Recognizing celebrities in the Amazon Rekognition Developer Guide.
     * </p>
     *
     * @param startCelebrityRecognitionRequest
     * @return A Java Future containing the result of the StartCelebrityRecognition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>IdempotentParameterMismatchException A <code>ClientRequestToken</code> input parameter was reused
     *         with an operation, but at least one of the other input parameters is different from the previous call to
     *         the operation.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>VideoTooLargeException The file size or duration of the supplied media is too large. The maximum file
     *         size is 10GB. The maximum duration is 6 hours.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>LimitExceededException An Amazon Rekognition service limit was exceeded. For example, if you start
     *         too many jobs concurrently, subsequent calls to start operations (ex: <code>StartLabelDetection</code>)
     *         will raise a <code>LimitExceededException</code> exception (HTTP status code: 400) until the number of
     *         concurrently running jobs is below the Amazon Rekognition service limit.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.StartCelebrityRecognition
     */
    @Override
    public CompletableFuture<StartCelebrityRecognitionResponse> startCelebrityRecognition(
            StartCelebrityRecognitionRequest startCelebrityRecognitionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startCelebrityRecognitionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startCelebrityRecognitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartCelebrityRecognition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartCelebrityRecognitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartCelebrityRecognitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartCelebrityRecognitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartCelebrityRecognitionRequest, StartCelebrityRecognitionResponse>()
                            .withOperationName("StartCelebrityRecognition").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartCelebrityRecognitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startCelebrityRecognitionRequest));
            CompletableFuture<StartCelebrityRecognitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts asynchronous detection of inappropriate, unwanted, or offensive content in a stored video. For a list of
     * moderation labels in Amazon Rekognition, see <a
     * href="https://docs.aws.amazon.com/rekognition/latest/dg/moderation.html#moderation-api">Using the image and video
     * moderation APIs</a>.
     * </p>
     * <p>
     * Amazon Rekognition Video can moderate content in a video stored in an Amazon S3 bucket. Use <a>Video</a> to
     * specify the bucket name and the filename of the video. <code>StartContentModeration</code> returns a job
     * identifier (<code>JobId</code>) which you use to get the results of the analysis. When content analysis is
     * finished, Amazon Rekognition Video publishes a completion status to the Amazon Simple Notification Service topic
     * that you specify in <code>NotificationChannel</code>.
     * </p>
     * <p>
     * To get the results of the content analysis, first check that the status value published to the Amazon SNS topic
     * is <code>SUCCEEDED</code>. If so, call <a>GetContentModeration</a> and pass the job identifier (
     * <code>JobId</code>) from the initial call to <code>StartContentModeration</code>.
     * </p>
     * <p>
     * For more information, see Moderating content in the Amazon Rekognition Developer Guide.
     * </p>
     *
     * @param startContentModerationRequest
     * @return A Java Future containing the result of the StartContentModeration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>IdempotentParameterMismatchException A <code>ClientRequestToken</code> input parameter was reused
     *         with an operation, but at least one of the other input parameters is different from the previous call to
     *         the operation.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>VideoTooLargeException The file size or duration of the supplied media is too large. The maximum file
     *         size is 10GB. The maximum duration is 6 hours.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>LimitExceededException An Amazon Rekognition service limit was exceeded. For example, if you start
     *         too many jobs concurrently, subsequent calls to start operations (ex: <code>StartLabelDetection</code>)
     *         will raise a <code>LimitExceededException</code> exception (HTTP status code: 400) until the number of
     *         concurrently running jobs is below the Amazon Rekognition service limit.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.StartContentModeration
     */
    @Override
    public CompletableFuture<StartContentModerationResponse> startContentModeration(
            StartContentModerationRequest startContentModerationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startContentModerationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startContentModerationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartContentModeration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartContentModerationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartContentModerationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartContentModerationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartContentModerationRequest, StartContentModerationResponse>()
                            .withOperationName("StartContentModeration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartContentModerationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startContentModerationRequest));
            CompletableFuture<StartContentModerationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts asynchronous detection of faces in a stored video.
     * </p>
     * <p>
     * Amazon Rekognition Video can detect faces in a video stored in an Amazon S3 bucket. Use <a>Video</a> to specify
     * the bucket name and the filename of the video. <code>StartFaceDetection</code> returns a job identifier (
     * <code>JobId</code>) that you use to get the results of the operation. When face detection is finished, Amazon
     * Rekognition Video publishes a completion status to the Amazon Simple Notification Service topic that you specify
     * in <code>NotificationChannel</code>. To get the results of the face detection operation, first check that the
     * status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call <a>GetFaceDetection</a> and
     * pass the job identifier (<code>JobId</code>) from the initial call to <code>StartFaceDetection</code>.
     * </p>
     * <p>
     * For more information, see Detecting faces in a stored video in the Amazon Rekognition Developer Guide.
     * </p>
     *
     * @param startFaceDetectionRequest
     * @return A Java Future containing the result of the StartFaceDetection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>IdempotentParameterMismatchException A <code>ClientRequestToken</code> input parameter was reused
     *         with an operation, but at least one of the other input parameters is different from the previous call to
     *         the operation.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>VideoTooLargeException The file size or duration of the supplied media is too large. The maximum file
     *         size is 10GB. The maximum duration is 6 hours.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>LimitExceededException An Amazon Rekognition service limit was exceeded. For example, if you start
     *         too many jobs concurrently, subsequent calls to start operations (ex: <code>StartLabelDetection</code>)
     *         will raise a <code>LimitExceededException</code> exception (HTTP status code: 400) until the number of
     *         concurrently running jobs is below the Amazon Rekognition service limit.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.StartFaceDetection
     */
    @Override
    public CompletableFuture<StartFaceDetectionResponse> startFaceDetection(StartFaceDetectionRequest startFaceDetectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startFaceDetectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startFaceDetectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartFaceDetection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartFaceDetectionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartFaceDetectionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartFaceDetectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartFaceDetectionRequest, StartFaceDetectionResponse>()
                            .withOperationName("StartFaceDetection").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartFaceDetectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startFaceDetectionRequest));
            CompletableFuture<StartFaceDetectionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts the asynchronous search for faces in a collection that match the faces of persons detected in a stored
     * video.
     * </p>
     * <p>
     * The video must be stored in an Amazon S3 bucket. Use <a>Video</a> to specify the bucket name and the filename of
     * the video. <code>StartFaceSearch</code> returns a job identifier (<code>JobId</code>) which you use to get the
     * search results once the search has completed. When searching is finished, Amazon Rekognition Video publishes a
     * completion status to the Amazon Simple Notification Service topic that you specify in
     * <code>NotificationChannel</code>. To get the search results, first check that the status value published to the
     * Amazon SNS topic is <code>SUCCEEDED</code>. If so, call <a>GetFaceSearch</a> and pass the job identifier (
     * <code>JobId</code>) from the initial call to <code>StartFaceSearch</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/rekognition/latest/dg/procedure-person-search-videos.html">Searching stored
     * videos for faces</a>.
     * </p>
     *
     * @param startFaceSearchRequest
     * @return A Java Future containing the result of the StartFaceSearch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>IdempotentParameterMismatchException A <code>ClientRequestToken</code> input parameter was reused
     *         with an operation, but at least one of the other input parameters is different from the previous call to
     *         the operation.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>VideoTooLargeException The file size or duration of the supplied media is too large. The maximum file
     *         size is 10GB. The maximum duration is 6 hours.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>LimitExceededException An Amazon Rekognition service limit was exceeded. For example, if you start
     *         too many jobs concurrently, subsequent calls to start operations (ex: <code>StartLabelDetection</code>)
     *         will raise a <code>LimitExceededException</code> exception (HTTP status code: 400) until the number of
     *         concurrently running jobs is below the Amazon Rekognition service limit.</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.StartFaceSearch
     */
    @Override
    public CompletableFuture<StartFaceSearchResponse> startFaceSearch(StartFaceSearchRequest startFaceSearchRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startFaceSearchRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startFaceSearchRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartFaceSearch");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartFaceSearchResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartFaceSearchResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartFaceSearchResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartFaceSearchRequest, StartFaceSearchResponse>()
                            .withOperationName("StartFaceSearch").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartFaceSearchRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startFaceSearchRequest));
            CompletableFuture<StartFaceSearchResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts asynchronous detection of labels in a stored video.
     * </p>
     * <p>
     * Amazon Rekognition Video can detect labels in a video. Labels are instances of real-world entities. This includes
     * objects like flower, tree, and table; events like wedding, graduation, and birthday party; concepts like
     * landscape, evening, and nature; and activities like a person getting out of a car or a person skiing.
     * </p>
     * <p>
     * The video must be stored in an Amazon S3 bucket. Use <a>Video</a> to specify the bucket name and the filename of
     * the video. <code>StartLabelDetection</code> returns a job identifier (<code>JobId</code>) which you use to get
     * the results of the operation. When label detection is finished, Amazon Rekognition Video publishes a completion
     * status to the Amazon Simple Notification Service topic that you specify in <code>NotificationChannel</code>.
     * </p>
     * <p>
     * To get the results of the label detection operation, first check that the status value published to the Amazon
     * SNS topic is <code>SUCCEEDED</code>. If so, call <a>GetLabelDetection</a> and pass the job identifier (
     * <code>JobId</code>) from the initial call to <code>StartLabelDetection</code>.
     * </p>
     * <p>
     * <i>Optional Parameters</i>
     * </p>
     * <p>
     * <code>StartLabelDetection</code> has the <code>GENERAL_LABELS</code> Feature applied by default. This feature
     * allows you to provide filtering criteria to the <code>Settings</code> parameter. You can filter with sets of
     * individual labels or with label categories. You can specify inclusive filters, exclusive filters, or a
     * combination of inclusive and exclusive filters. For more information on filtering, see <a
     * href="https://docs.aws.amazon.com/rekognition/latest/dg/labels-detecting-labels-video.html">Detecting labels in a
     * video</a>.
     * </p>
     * <p>
     * You can specify <code>MinConfidence</code> to control the confidence threshold for the labels returned. The
     * default is 50.
     * </p>
     *
     * @param startLabelDetectionRequest
     * @return A Java Future containing the result of the StartLabelDetection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>IdempotentParameterMismatchException A <code>ClientRequestToken</code> input parameter was reused
     *         with an operation, but at least one of the other input parameters is different from the previous call to
     *         the operation.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>VideoTooLargeException The file size or duration of the supplied media is too large. The maximum file
     *         size is 10GB. The maximum duration is 6 hours.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>LimitExceededException An Amazon Rekognition service limit was exceeded. For example, if you start
     *         too many jobs concurrently, subsequent calls to start operations (ex: <code>StartLabelDetection</code>)
     *         will raise a <code>LimitExceededException</code> exception (HTTP status code: 400) until the number of
     *         concurrently running jobs is below the Amazon Rekognition service limit.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.StartLabelDetection
     */
    @Override
    public CompletableFuture<StartLabelDetectionResponse> startLabelDetection(
            StartLabelDetectionRequest startLabelDetectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startLabelDetectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startLabelDetectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartLabelDetection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartLabelDetectionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartLabelDetectionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartLabelDetectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartLabelDetectionRequest, StartLabelDetectionResponse>()
                            .withOperationName("StartLabelDetection").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartLabelDetectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startLabelDetectionRequest));
            CompletableFuture<StartLabelDetectionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Initiates a new media analysis job. Accepts a manifest file in an Amazon S3 bucket. The output is a manifest file
     * and a summary of the manifest stored in the Amazon S3 bucket.
     * </p>
     *
     * @param startMediaAnalysisJobRequest
     * @return A Java Future containing the result of the StartMediaAnalysisJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidManifestException Indicates that a provided manifest file is empty or larger than the allowed
     *         limit.</li>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>ResourceNotReadyException The requested resource isn't ready. For example, this exception occurs when
     *         you call <code>DetectCustomLabels</code> with a model version that isn't deployed.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>LimitExceededException An Amazon Rekognition service limit was exceeded. For example, if you start
     *         too many jobs concurrently, subsequent calls to start operations (ex: <code>StartLabelDetection</code>)
     *         will raise a <code>LimitExceededException</code> exception (HTTP status code: 400) until the number of
     *         concurrently running jobs is below the Amazon Rekognition service limit.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>IdempotentParameterMismatchException A <code>ClientRequestToken</code> input parameter was reused
     *         with an operation, but at least one of the other input parameters is different from the previous call to
     *         the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.StartMediaAnalysisJob
     */
    @Override
    public CompletableFuture<StartMediaAnalysisJobResponse> startMediaAnalysisJob(
            StartMediaAnalysisJobRequest startMediaAnalysisJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startMediaAnalysisJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startMediaAnalysisJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartMediaAnalysisJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartMediaAnalysisJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartMediaAnalysisJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartMediaAnalysisJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartMediaAnalysisJobRequest, StartMediaAnalysisJobResponse>()
                            .withOperationName("StartMediaAnalysisJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartMediaAnalysisJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startMediaAnalysisJobRequest));
            CompletableFuture<StartMediaAnalysisJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts the asynchronous tracking of a person's path in a stored video.
     * </p>
     * <p>
     * Amazon Rekognition Video can track the path of people in a video stored in an Amazon S3 bucket. Use <a>Video</a>
     * to specify the bucket name and the filename of the video. <code>StartPersonTracking</code> returns a job
     * identifier (<code>JobId</code>) which you use to get the results of the operation. When label detection is
     * finished, Amazon Rekognition publishes a completion status to the Amazon Simple Notification Service topic that
     * you specify in <code>NotificationChannel</code>.
     * </p>
     * <p>
     * To get the results of the person detection operation, first check that the status value published to the Amazon
     * SNS topic is <code>SUCCEEDED</code>. If so, call <a>GetPersonTracking</a> and pass the job identifier (
     * <code>JobId</code>) from the initial call to <code>StartPersonTracking</code>.
     * </p>
     *
     * @param startPersonTrackingRequest
     * @return A Java Future containing the result of the StartPersonTracking operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>IdempotentParameterMismatchException A <code>ClientRequestToken</code> input parameter was reused
     *         with an operation, but at least one of the other input parameters is different from the previous call to
     *         the operation.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>VideoTooLargeException The file size or duration of the supplied media is too large. The maximum file
     *         size is 10GB. The maximum duration is 6 hours.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>LimitExceededException An Amazon Rekognition service limit was exceeded. For example, if you start
     *         too many jobs concurrently, subsequent calls to start operations (ex: <code>StartLabelDetection</code>)
     *         will raise a <code>LimitExceededException</code> exception (HTTP status code: 400) until the number of
     *         concurrently running jobs is below the Amazon Rekognition service limit.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.StartPersonTracking
     */
    @Override
    public CompletableFuture<StartPersonTrackingResponse> startPersonTracking(
            StartPersonTrackingRequest startPersonTrackingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startPersonTrackingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startPersonTrackingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartPersonTracking");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartPersonTrackingResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartPersonTrackingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartPersonTrackingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartPersonTrackingRequest, StartPersonTrackingResponse>()
                            .withOperationName("StartPersonTracking").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartPersonTrackingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startPersonTrackingRequest));
            CompletableFuture<StartPersonTrackingResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation applies only to Amazon Rekognition Custom Labels.
     * </p>
     * </note>
     * <p>
     * Starts the running of the version of a model. Starting a model takes a while to complete. To check the current
     * state of the model, use <a>DescribeProjectVersions</a>.
     * </p>
     * <p>
     * Once the model is running, you can detect custom labels in new images by calling <a>DetectCustomLabels</a>.
     * </p>
     * <note>
     * <p>
     * You are charged for the amount of time that the model is running. To stop a running model, call
     * <a>StopProjectVersion</a>.
     * </p>
     * </note>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:StartProjectVersion</code> action.
     * </p>
     *
     * @param startProjectVersionRequest
     * @return A Java Future containing the result of the StartProjectVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>ResourceInUseException The specified resource is already being used.</li>
     *         <li>LimitExceededException An Amazon Rekognition service limit was exceeded. For example, if you start
     *         too many jobs concurrently, subsequent calls to start operations (ex: <code>StartLabelDetection</code>)
     *         will raise a <code>LimitExceededException</code> exception (HTTP status code: 400) until the number of
     *         concurrently running jobs is below the Amazon Rekognition service limit.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.StartProjectVersion
     */
    @Override
    public CompletableFuture<StartProjectVersionResponse> startProjectVersion(
            StartProjectVersionRequest startProjectVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startProjectVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startProjectVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartProjectVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartProjectVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartProjectVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartProjectVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartProjectVersionRequest, StartProjectVersionResponse>()
                            .withOperationName("StartProjectVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartProjectVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startProjectVersionRequest));
            CompletableFuture<StartProjectVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts asynchronous detection of segment detection in a stored video.
     * </p>
     * <p>
     * Amazon Rekognition Video can detect segments in a video stored in an Amazon S3 bucket. Use <a>Video</a> to
     * specify the bucket name and the filename of the video. <code>StartSegmentDetection</code> returns a job
     * identifier (<code>JobId</code>) which you use to get the results of the operation. When segment detection is
     * finished, Amazon Rekognition Video publishes a completion status to the Amazon Simple Notification Service topic
     * that you specify in <code>NotificationChannel</code>.
     * </p>
     * <p>
     * You can use the <code>Filters</code> (<a>StartSegmentDetectionFilters</a>) input parameter to specify the minimum
     * detection confidence returned in the response. Within <code>Filters</code>, use <code>ShotFilter</code>
     * (<a>StartShotDetectionFilter</a>) to filter detected shots. Use <code>TechnicalCueFilter</code>
     * (<a>StartTechnicalCueDetectionFilter</a>) to filter technical cues.
     * </p>
     * <p>
     * To get the results of the segment detection operation, first check that the status value published to the Amazon
     * SNS topic is <code>SUCCEEDED</code>. if so, call <a>GetSegmentDetection</a> and pass the job identifier (
     * <code>JobId</code>) from the initial call to <code>StartSegmentDetection</code>.
     * </p>
     * <p>
     * For more information, see Detecting video segments in stored video in the Amazon Rekognition Developer Guide.
     * </p>
     *
     * @param startSegmentDetectionRequest
     * @return A Java Future containing the result of the StartSegmentDetection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>IdempotentParameterMismatchException A <code>ClientRequestToken</code> input parameter was reused
     *         with an operation, but at least one of the other input parameters is different from the previous call to
     *         the operation.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>VideoTooLargeException The file size or duration of the supplied media is too large. The maximum file
     *         size is 10GB. The maximum duration is 6 hours.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>LimitExceededException An Amazon Rekognition service limit was exceeded. For example, if you start
     *         too many jobs concurrently, subsequent calls to start operations (ex: <code>StartLabelDetection</code>)
     *         will raise a <code>LimitExceededException</code> exception (HTTP status code: 400) until the number of
     *         concurrently running jobs is below the Amazon Rekognition service limit.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.StartSegmentDetection
     */
    @Override
    public CompletableFuture<StartSegmentDetectionResponse> startSegmentDetection(
            StartSegmentDetectionRequest startSegmentDetectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startSegmentDetectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startSegmentDetectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartSegmentDetection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartSegmentDetectionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartSegmentDetectionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartSegmentDetectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartSegmentDetectionRequest, StartSegmentDetectionResponse>()
                            .withOperationName("StartSegmentDetection").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartSegmentDetectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startSegmentDetectionRequest));
            CompletableFuture<StartSegmentDetectionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts processing a stream processor. You create a stream processor by calling <a>CreateStreamProcessor</a>. To
     * tell <code>StartStreamProcessor</code> which stream processor to start, use the value of the <code>Name</code>
     * field specified in the call to <code>CreateStreamProcessor</code>.
     * </p>
     * <p>
     * If you are using a label detection stream processor to detect labels, you need to provide a
     * <code>Start selector</code> and a <code>Stop selector</code> to determine the length of the stream processing
     * time.
     * </p>
     *
     * @param startStreamProcessorRequest
     * @return A Java Future containing the result of the StartStreamProcessor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>ResourceInUseException The specified resource is already being used.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.StartStreamProcessor
     */
    @Override
    public CompletableFuture<StartStreamProcessorResponse> startStreamProcessor(
            StartStreamProcessorRequest startStreamProcessorRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startStreamProcessorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startStreamProcessorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartStreamProcessor");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartStreamProcessorResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartStreamProcessorResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartStreamProcessorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartStreamProcessorRequest, StartStreamProcessorResponse>()
                            .withOperationName("StartStreamProcessor").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartStreamProcessorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startStreamProcessorRequest));
            CompletableFuture<StartStreamProcessorResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts asynchronous detection of text in a stored video.
     * </p>
     * <p>
     * Amazon Rekognition Video can detect text in a video stored in an Amazon S3 bucket. Use <a>Video</a> to specify
     * the bucket name and the filename of the video. <code>StartTextDetection</code> returns a job identifier (
     * <code>JobId</code>) which you use to get the results of the operation. When text detection is finished, Amazon
     * Rekognition Video publishes a completion status to the Amazon Simple Notification Service topic that you specify
     * in <code>NotificationChannel</code>.
     * </p>
     * <p>
     * To get the results of the text detection operation, first check that the status value published to the Amazon SNS
     * topic is <code>SUCCEEDED</code>. if so, call <a>GetTextDetection</a> and pass the job identifier (
     * <code>JobId</code>) from the initial call to <code>StartTextDetection</code>.
     * </p>
     *
     * @param startTextDetectionRequest
     * @return A Java Future containing the result of the StartTextDetection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>IdempotentParameterMismatchException A <code>ClientRequestToken</code> input parameter was reused
     *         with an operation, but at least one of the other input parameters is different from the previous call to
     *         the operation.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>InvalidS3ObjectException Amazon Rekognition is unable to access the S3 object specified in the
     *         request.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>VideoTooLargeException The file size or duration of the supplied media is too large. The maximum file
     *         size is 10GB. The maximum duration is 6 hours.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>LimitExceededException An Amazon Rekognition service limit was exceeded. For example, if you start
     *         too many jobs concurrently, subsequent calls to start operations (ex: <code>StartLabelDetection</code>)
     *         will raise a <code>LimitExceededException</code> exception (HTTP status code: 400) until the number of
     *         concurrently running jobs is below the Amazon Rekognition service limit.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.StartTextDetection
     */
    @Override
    public CompletableFuture<StartTextDetectionResponse> startTextDetection(StartTextDetectionRequest startTextDetectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startTextDetectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startTextDetectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartTextDetection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartTextDetectionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartTextDetectionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartTextDetectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartTextDetectionRequest, StartTextDetectionResponse>()
                            .withOperationName("StartTextDetection").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartTextDetectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startTextDetectionRequest));
            CompletableFuture<StartTextDetectionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation applies only to Amazon Rekognition Custom Labels.
     * </p>
     * </note>
     * <p>
     * Stops a running model. The operation might take a while to complete. To check the current status, call
     * <a>DescribeProjectVersions</a>. Only applies to Custom Labels projects.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:StopProjectVersion</code> action.
     * </p>
     *
     * @param stopProjectVersionRequest
     * @return A Java Future containing the result of the StopProjectVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>ResourceInUseException The specified resource is already being used.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.StopProjectVersion
     */
    @Override
    public CompletableFuture<StopProjectVersionResponse> stopProjectVersion(StopProjectVersionRequest stopProjectVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopProjectVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopProjectVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopProjectVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopProjectVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopProjectVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StopProjectVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopProjectVersionRequest, StopProjectVersionResponse>()
                            .withOperationName("StopProjectVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StopProjectVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(stopProjectVersionRequest));
            CompletableFuture<StopProjectVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops a running stream processor that was created by <a>CreateStreamProcessor</a>.
     * </p>
     *
     * @param stopStreamProcessorRequest
     * @return A Java Future containing the result of the StopStreamProcessor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>ResourceInUseException The specified resource is already being used.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.StopStreamProcessor
     */
    @Override
    public CompletableFuture<StopStreamProcessorResponse> stopStreamProcessor(
            StopStreamProcessorRequest stopStreamProcessorRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopStreamProcessorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopStreamProcessorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopStreamProcessor");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopStreamProcessorResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopStreamProcessorResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StopStreamProcessorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopStreamProcessorRequest, StopStreamProcessorResponse>()
                            .withOperationName("StopStreamProcessor").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StopStreamProcessorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(stopStreamProcessorRequest));
            CompletableFuture<StopStreamProcessorResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds one or more key-value tags to an Amazon Rekognition collection, stream processor, or Custom Labels model.
     * For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS
     * Resources</a>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:TagResource</code> action.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ServiceQuotaExceededException
     *         <p>
     *         The size of the collection exceeds the allowed limit. For more information, see Guidelines and quotas in
     *         Amazon Rekognition in the Amazon Rekognition Developer Guide.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.TagResource
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes one or more tags from an Amazon Rekognition collection, stream processor, or Custom Labels model.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:UntagResource</code> action.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.UntagResource
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <note>
     * <p>
     * This operation applies only to Amazon Rekognition Custom Labels.
     * </p>
     * </note>
     * <p>
     * Adds or updates one or more entries (images) in a dataset. An entry is a JSON Line which contains the information
     * for a single image, including the image location, assigned labels, and object location bounding boxes. For more
     * information, see Image-Level labels in manifest files and Object localization in manifest files in the <i>Amazon
     * Rekognition Custom Labels Developer Guide</i>.
     * </p>
     * <p>
     * If the <code>source-ref</code> field in the JSON line references an existing image, the existing image in the
     * dataset is updated. If <code>source-ref</code> field doesn't reference an existing image, the image is added as a
     * new image to the dataset.
     * </p>
     * <p>
     * You specify the changes that you want to make in the <code>Changes</code> input parameter. There isn't a limit to
     * the number JSON Lines that you can change, but the size of <code>Changes</code> must be less than 5MB.
     * </p>
     * <p>
     * <code>UpdateDatasetEntries</code> returns immediatly, but the dataset update might take a while to complete. Use
     * <a>DescribeDataset</a> to check the current status. The dataset updated successfully if the value of
     * <code>Status</code> is <code>UPDATE_COMPLETE</code>.
     * </p>
     * <p>
     * To check if any non-terminal errors occured, call <a>ListDatasetEntries</a> and check for the presence of
     * <code>errors</code> lists in the JSON Lines.
     * </p>
     * <p>
     * Dataset update fails if a terminal error occurs (<code>Status</code> = <code>UPDATE_FAILED</code>). Currently,
     * you can't access the terminal error information from the Amazon Rekognition Custom Labels SDK.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>rekognition:UpdateDatasetEntries</code> action.
     * </p>
     *
     * @param updateDatasetEntriesRequest
     * @return A Java Future containing the result of the UpdateDatasetEntries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>LimitExceededException An Amazon Rekognition service limit was exceeded. For example, if you start
     *         too many jobs concurrently, subsequent calls to start operations (ex: <code>StartLabelDetection</code>)
     *         will raise a <code>LimitExceededException</code> exception (HTTP status code: 400) until the number of
     *         concurrently running jobs is below the Amazon Rekognition service limit.</li>
     *         <li>ResourceInUseException The specified resource is already being used.</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.UpdateDatasetEntries
     */
    @Override
    public CompletableFuture<UpdateDatasetEntriesResponse> updateDatasetEntries(
            UpdateDatasetEntriesRequest updateDatasetEntriesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateDatasetEntriesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDatasetEntriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDatasetEntries");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDatasetEntriesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDatasetEntriesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDatasetEntriesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDatasetEntriesRequest, UpdateDatasetEntriesResponse>()
                            .withOperationName("UpdateDatasetEntries").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateDatasetEntriesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateDatasetEntriesRequest));
            CompletableFuture<UpdateDatasetEntriesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Allows you to update a stream processor. You can change some settings and regions of interest and delete certain
     * parameters.
     * </p>
     *
     * @param updateStreamProcessorRequest
     * @return A Java Future containing the result of the UpdateStreamProcessor operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You are not authorized to perform the action.</li>
     *         <li>InternalServerErrorException Amazon Rekognition experienced a service issue. Try your call again.</li>
     *         <li>ThrottlingException Amazon Rekognition is temporarily unable to process the request. Try your call
     *         again.</li>
     *         <li>InvalidParameterException Input parameter violated a constraint. Validate your parameter before
     *         calling the API operation again.</li>
     *         <li>ResourceNotFoundException The resource specified in the request cannot be found.</li>
     *         <li>ProvisionedThroughputExceededException The number of requests exceeded your throughput limit. If you
     *         want to increase this limit, contact Amazon Rekognition.</li>
     *         <li>ResourceInUseException The specified resource is already being used.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RekognitionException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RekognitionAsyncClient.UpdateStreamProcessor
     */
    @Override
    public CompletableFuture<UpdateStreamProcessorResponse> updateStreamProcessor(
            UpdateStreamProcessorRequest updateStreamProcessorRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateStreamProcessorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateStreamProcessorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Rekognition");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateStreamProcessor");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateStreamProcessorResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateStreamProcessorResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateStreamProcessorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateStreamProcessorRequest, UpdateStreamProcessorResponse>()
                            .withOperationName("UpdateStreamProcessor").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateStreamProcessorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateStreamProcessorRequest));
            CompletableFuture<UpdateStreamProcessorResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public RekognitionAsyncWaiter waiter() {
        return RekognitionAsyncWaiter.builder().client(this).scheduledExecutorService(executorService).build();
    }

    @Override
    public final RekognitionServiceClientConfiguration serviceClientConfiguration() {
        return new RekognitionServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(RekognitionException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MalformedPolicyDocumentException")
                                .exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotReadyException")
                                .exceptionBuilderSupplier(ResourceNotReadyException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidPolicyRevisionIdException")
                                .exceptionBuilderSupplier(InvalidPolicyRevisionIdException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("HumanLoopQuotaExceededException")
                                .exceptionBuilderSupplier(HumanLoopQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException")
                                .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException")
                                .exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                                .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException")
                                .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameterException")
                                .exceptionBuilderSupplier(InvalidParameterException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceInUseException")
                                .exceptionBuilderSupplier(ResourceInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidImageFormatException")
                                .exceptionBuilderSupplier(InvalidImageFormatException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SessionNotFoundException")
                                .exceptionBuilderSupplier(SessionNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidS3ObjectException")
                                .exceptionBuilderSupplier(InvalidS3ObjectException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("VideoTooLargeException")
                                .exceptionBuilderSupplier(VideoTooLargeException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ImageTooLargeException")
                                .exceptionBuilderSupplier(ImageTooLargeException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidManifestException")
                                .exceptionBuilderSupplier(InvalidManifestException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerError")
                                .exceptionBuilderSupplier(InternalServerErrorException::builder).httpStatusCode(500).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        RekognitionServiceClientConfigurationBuilder serviceConfigBuilder = new RekognitionServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
