/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains filters for the object labels returned by DetectLabels. Filters can be inclusive, exclusive, or a
 * combination of both and can be applied to individual labels or entire label categories. To see a list of label
 * categories, see <a href="https://docs.aws.amazon.com/rekognition/latest/dg/labels.html">Detecting Labels</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeneralLabelsSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<GeneralLabelsSettings.Builder, GeneralLabelsSettings> {
    private static final SdkField<List<String>> LABEL_INCLUSION_FILTERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LabelInclusionFilters")
            .getter(getter(GeneralLabelsSettings::labelInclusionFilters))
            .setter(setter(Builder::labelInclusionFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelInclusionFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> LABEL_EXCLUSION_FILTERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LabelExclusionFilters")
            .getter(getter(GeneralLabelsSettings::labelExclusionFilters))
            .setter(setter(Builder::labelExclusionFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelExclusionFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> LABEL_CATEGORY_INCLUSION_FILTERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LabelCategoryInclusionFilters")
            .getter(getter(GeneralLabelsSettings::labelCategoryInclusionFilters))
            .setter(setter(Builder::labelCategoryInclusionFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelCategoryInclusionFilters")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> LABEL_CATEGORY_EXCLUSION_FILTERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LabelCategoryExclusionFilters")
            .getter(getter(GeneralLabelsSettings::labelCategoryExclusionFilters))
            .setter(setter(Builder::labelCategoryExclusionFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelCategoryExclusionFilters")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABEL_INCLUSION_FILTERS_FIELD,
            LABEL_EXCLUSION_FILTERS_FIELD, LABEL_CATEGORY_INCLUSION_FILTERS_FIELD, LABEL_CATEGORY_EXCLUSION_FILTERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> labelInclusionFilters;

    private final List<String> labelExclusionFilters;

    private final List<String> labelCategoryInclusionFilters;

    private final List<String> labelCategoryExclusionFilters;

    private GeneralLabelsSettings(BuilderImpl builder) {
        this.labelInclusionFilters = builder.labelInclusionFilters;
        this.labelExclusionFilters = builder.labelExclusionFilters;
        this.labelCategoryInclusionFilters = builder.labelCategoryInclusionFilters;
        this.labelCategoryExclusionFilters = builder.labelCategoryExclusionFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the LabelInclusionFilters property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLabelInclusionFilters() {
        return labelInclusionFilters != null && !(labelInclusionFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The labels that should be included in the return from DetectLabels.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLabelInclusionFilters} method.
     * </p>
     * 
     * @return The labels that should be included in the return from DetectLabels.
     */
    public final List<String> labelInclusionFilters() {
        return labelInclusionFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the LabelExclusionFilters property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLabelExclusionFilters() {
        return labelExclusionFilters != null && !(labelExclusionFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The labels that should be excluded from the return from DetectLabels.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLabelExclusionFilters} method.
     * </p>
     * 
     * @return The labels that should be excluded from the return from DetectLabels.
     */
    public final List<String> labelExclusionFilters() {
        return labelExclusionFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the LabelCategoryInclusionFilters property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLabelCategoryInclusionFilters() {
        return labelCategoryInclusionFilters != null && !(labelCategoryInclusionFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The label categories that should be included in the return from DetectLabels.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLabelCategoryInclusionFilters} method.
     * </p>
     * 
     * @return The label categories that should be included in the return from DetectLabels.
     */
    public final List<String> labelCategoryInclusionFilters() {
        return labelCategoryInclusionFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the LabelCategoryExclusionFilters property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLabelCategoryExclusionFilters() {
        return labelCategoryExclusionFilters != null && !(labelCategoryExclusionFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The label categories that should be excluded from the return from DetectLabels.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLabelCategoryExclusionFilters} method.
     * </p>
     * 
     * @return The label categories that should be excluded from the return from DetectLabels.
     */
    public final List<String> labelCategoryExclusionFilters() {
        return labelCategoryExclusionFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasLabelInclusionFilters() ? labelInclusionFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLabelExclusionFilters() ? labelExclusionFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLabelCategoryInclusionFilters() ? labelCategoryInclusionFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLabelCategoryExclusionFilters() ? labelCategoryExclusionFilters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeneralLabelsSettings)) {
            return false;
        }
        GeneralLabelsSettings other = (GeneralLabelsSettings) obj;
        return hasLabelInclusionFilters() == other.hasLabelInclusionFilters()
                && Objects.equals(labelInclusionFilters(), other.labelInclusionFilters())
                && hasLabelExclusionFilters() == other.hasLabelExclusionFilters()
                && Objects.equals(labelExclusionFilters(), other.labelExclusionFilters())
                && hasLabelCategoryInclusionFilters() == other.hasLabelCategoryInclusionFilters()
                && Objects.equals(labelCategoryInclusionFilters(), other.labelCategoryInclusionFilters())
                && hasLabelCategoryExclusionFilters() == other.hasLabelCategoryExclusionFilters()
                && Objects.equals(labelCategoryExclusionFilters(), other.labelCategoryExclusionFilters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("GeneralLabelsSettings")
                .add("LabelInclusionFilters", hasLabelInclusionFilters() ? labelInclusionFilters() : null)
                .add("LabelExclusionFilters", hasLabelExclusionFilters() ? labelExclusionFilters() : null)
                .add("LabelCategoryInclusionFilters", hasLabelCategoryInclusionFilters() ? labelCategoryInclusionFilters() : null)
                .add("LabelCategoryExclusionFilters", hasLabelCategoryExclusionFilters() ? labelCategoryExclusionFilters() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LabelInclusionFilters":
            return Optional.ofNullable(clazz.cast(labelInclusionFilters()));
        case "LabelExclusionFilters":
            return Optional.ofNullable(clazz.cast(labelExclusionFilters()));
        case "LabelCategoryInclusionFilters":
            return Optional.ofNullable(clazz.cast(labelCategoryInclusionFilters()));
        case "LabelCategoryExclusionFilters":
            return Optional.ofNullable(clazz.cast(labelCategoryExclusionFilters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GeneralLabelsSettings, T> g) {
        return obj -> g.apply((GeneralLabelsSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeneralLabelsSettings> {
        /**
         * <p>
         * The labels that should be included in the return from DetectLabels.
         * </p>
         * 
         * @param labelInclusionFilters
         *        The labels that should be included in the return from DetectLabels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelInclusionFilters(Collection<String> labelInclusionFilters);

        /**
         * <p>
         * The labels that should be included in the return from DetectLabels.
         * </p>
         * 
         * @param labelInclusionFilters
         *        The labels that should be included in the return from DetectLabels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelInclusionFilters(String... labelInclusionFilters);

        /**
         * <p>
         * The labels that should be excluded from the return from DetectLabels.
         * </p>
         * 
         * @param labelExclusionFilters
         *        The labels that should be excluded from the return from DetectLabels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelExclusionFilters(Collection<String> labelExclusionFilters);

        /**
         * <p>
         * The labels that should be excluded from the return from DetectLabels.
         * </p>
         * 
         * @param labelExclusionFilters
         *        The labels that should be excluded from the return from DetectLabels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelExclusionFilters(String... labelExclusionFilters);

        /**
         * <p>
         * The label categories that should be included in the return from DetectLabels.
         * </p>
         * 
         * @param labelCategoryInclusionFilters
         *        The label categories that should be included in the return from DetectLabels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelCategoryInclusionFilters(Collection<String> labelCategoryInclusionFilters);

        /**
         * <p>
         * The label categories that should be included in the return from DetectLabels.
         * </p>
         * 
         * @param labelCategoryInclusionFilters
         *        The label categories that should be included in the return from DetectLabels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelCategoryInclusionFilters(String... labelCategoryInclusionFilters);

        /**
         * <p>
         * The label categories that should be excluded from the return from DetectLabels.
         * </p>
         * 
         * @param labelCategoryExclusionFilters
         *        The label categories that should be excluded from the return from DetectLabels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelCategoryExclusionFilters(Collection<String> labelCategoryExclusionFilters);

        /**
         * <p>
         * The label categories that should be excluded from the return from DetectLabels.
         * </p>
         * 
         * @param labelCategoryExclusionFilters
         *        The label categories that should be excluded from the return from DetectLabels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelCategoryExclusionFilters(String... labelCategoryExclusionFilters);
    }

    static final class BuilderImpl implements Builder {
        private List<String> labelInclusionFilters = DefaultSdkAutoConstructList.getInstance();

        private List<String> labelExclusionFilters = DefaultSdkAutoConstructList.getInstance();

        private List<String> labelCategoryInclusionFilters = DefaultSdkAutoConstructList.getInstance();

        private List<String> labelCategoryExclusionFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GeneralLabelsSettings model) {
            labelInclusionFilters(model.labelInclusionFilters);
            labelExclusionFilters(model.labelExclusionFilters);
            labelCategoryInclusionFilters(model.labelCategoryInclusionFilters);
            labelCategoryExclusionFilters(model.labelCategoryExclusionFilters);
        }

        public final Collection<String> getLabelInclusionFilters() {
            if (labelInclusionFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return labelInclusionFilters;
        }

        public final void setLabelInclusionFilters(Collection<String> labelInclusionFilters) {
            this.labelInclusionFilters = GeneralLabelsFilterListCopier.copy(labelInclusionFilters);
        }

        @Override
        public final Builder labelInclusionFilters(Collection<String> labelInclusionFilters) {
            this.labelInclusionFilters = GeneralLabelsFilterListCopier.copy(labelInclusionFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labelInclusionFilters(String... labelInclusionFilters) {
            labelInclusionFilters(Arrays.asList(labelInclusionFilters));
            return this;
        }

        public final Collection<String> getLabelExclusionFilters() {
            if (labelExclusionFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return labelExclusionFilters;
        }

        public final void setLabelExclusionFilters(Collection<String> labelExclusionFilters) {
            this.labelExclusionFilters = GeneralLabelsFilterListCopier.copy(labelExclusionFilters);
        }

        @Override
        public final Builder labelExclusionFilters(Collection<String> labelExclusionFilters) {
            this.labelExclusionFilters = GeneralLabelsFilterListCopier.copy(labelExclusionFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labelExclusionFilters(String... labelExclusionFilters) {
            labelExclusionFilters(Arrays.asList(labelExclusionFilters));
            return this;
        }

        public final Collection<String> getLabelCategoryInclusionFilters() {
            if (labelCategoryInclusionFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return labelCategoryInclusionFilters;
        }

        public final void setLabelCategoryInclusionFilters(Collection<String> labelCategoryInclusionFilters) {
            this.labelCategoryInclusionFilters = GeneralLabelsFilterListCopier.copy(labelCategoryInclusionFilters);
        }

        @Override
        public final Builder labelCategoryInclusionFilters(Collection<String> labelCategoryInclusionFilters) {
            this.labelCategoryInclusionFilters = GeneralLabelsFilterListCopier.copy(labelCategoryInclusionFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labelCategoryInclusionFilters(String... labelCategoryInclusionFilters) {
            labelCategoryInclusionFilters(Arrays.asList(labelCategoryInclusionFilters));
            return this;
        }

        public final Collection<String> getLabelCategoryExclusionFilters() {
            if (labelCategoryExclusionFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return labelCategoryExclusionFilters;
        }

        public final void setLabelCategoryExclusionFilters(Collection<String> labelCategoryExclusionFilters) {
            this.labelCategoryExclusionFilters = GeneralLabelsFilterListCopier.copy(labelCategoryExclusionFilters);
        }

        @Override
        public final Builder labelCategoryExclusionFilters(Collection<String> labelCategoryExclusionFilters) {
            this.labelCategoryExclusionFilters = GeneralLabelsFilterListCopier.copy(labelCategoryExclusionFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labelCategoryExclusionFilters(String... labelCategoryExclusionFilters) {
            labelCategoryExclusionFilters(Arrays.asList(labelCategoryExclusionFilters));
            return this;
        }

        @Override
        public GeneralLabelsSettings build() {
            return new GeneralLabelsSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
