/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rekognition.RekognitionAsyncClient;
import software.amazon.awssdk.services.rekognition.internal.UserAgentUtils;
import software.amazon.awssdk.services.rekognition.model.ListProjectPoliciesRequest;
import software.amazon.awssdk.services.rekognition.model.ListProjectPoliciesResponse;
import software.amazon.awssdk.services.rekognition.model.ProjectPolicy;

public class ListProjectPoliciesPublisher
implements SdkPublisher<ListProjectPoliciesResponse> {
    private final RekognitionAsyncClient client;
    private final ListProjectPoliciesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProjectPoliciesPublisher(RekognitionAsyncClient client, ListProjectPoliciesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProjectPoliciesPublisher(RekognitionAsyncClient client, ListProjectPoliciesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProjectPoliciesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProjectPoliciesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ProjectPolicy> projectPolicies() {
        Function<ListProjectPoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.projectPolicies() != null) {
                return response.projectPolicies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListProjectPoliciesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListProjectPoliciesResponseFetcher
    implements AsyncPageFetcher<ListProjectPoliciesResponse> {
        private ListProjectPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListProjectPoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListProjectPoliciesResponse> nextPage(ListProjectPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListProjectPoliciesPublisher.this.client.listProjectPolicies(ListProjectPoliciesPublisher.this.firstRequest);
            }
            return ListProjectPoliciesPublisher.this.client.listProjectPolicies((ListProjectPoliciesRequest)((Object)ListProjectPoliciesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

