/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectModerationLabelsResponse extends RekognitionResponse implements
        ToCopyableBuilder<DetectModerationLabelsResponse.Builder, DetectModerationLabelsResponse> {
    private static final SdkField<List<ModerationLabel>> MODERATION_LABELS_FIELD = SdkField
            .<List<ModerationLabel>> builder(MarshallingType.LIST)
            .memberName("ModerationLabels")
            .getter(getter(DetectModerationLabelsResponse::moderationLabels))
            .setter(setter(Builder::moderationLabels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModerationLabels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ModerationLabel> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModerationLabel::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MODERATION_MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModerationModelVersion").getter(getter(DetectModerationLabelsResponse::moderationModelVersion))
            .setter(setter(Builder::moderationModelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModerationModelVersion").build())
            .build();

    private static final SdkField<HumanLoopActivationOutput> HUMAN_LOOP_ACTIVATION_OUTPUT_FIELD = SdkField
            .<HumanLoopActivationOutput> builder(MarshallingType.SDK_POJO).memberName("HumanLoopActivationOutput")
            .getter(getter(DetectModerationLabelsResponse::humanLoopActivationOutput))
            .setter(setter(Builder::humanLoopActivationOutput)).constructor(HumanLoopActivationOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopActivationOutput").build())
            .build();

    private static final SdkField<String> PROJECT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectVersion").getter(getter(DetectModerationLabelsResponse::projectVersion))
            .setter(setter(Builder::projectVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectVersion").build()).build();

    private static final SdkField<List<ContentType>> CONTENT_TYPES_FIELD = SdkField
            .<List<ContentType>> builder(MarshallingType.LIST)
            .memberName("ContentTypes")
            .getter(getter(DetectModerationLabelsResponse::contentTypes))
            .setter(setter(Builder::contentTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContentType> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContentType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODERATION_LABELS_FIELD,
            MODERATION_MODEL_VERSION_FIELD, HUMAN_LOOP_ACTIVATION_OUTPUT_FIELD, PROJECT_VERSION_FIELD, CONTENT_TYPES_FIELD));

    private final List<ModerationLabel> moderationLabels;

    private final String moderationModelVersion;

    private final HumanLoopActivationOutput humanLoopActivationOutput;

    private final String projectVersion;

    private final List<ContentType> contentTypes;

    private DetectModerationLabelsResponse(BuilderImpl builder) {
        super(builder);
        this.moderationLabels = builder.moderationLabels;
        this.moderationModelVersion = builder.moderationModelVersion;
        this.humanLoopActivationOutput = builder.humanLoopActivationOutput;
        this.projectVersion = builder.projectVersion;
        this.contentTypes = builder.contentTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the ModerationLabels property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasModerationLabels() {
        return moderationLabels != null && !(moderationLabels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Array of detected Moderation labels. For video operations, this includes the time, in milliseconds from the start
     * of the video, they were detected.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasModerationLabels} method.
     * </p>
     * 
     * @return Array of detected Moderation labels. For video operations, this includes the time, in milliseconds from
     *         the start of the video, they were detected.
     */
    public final List<ModerationLabel> moderationLabels() {
        return moderationLabels;
    }

    /**
     * <p>
     * Version number of the base moderation detection model that was used to detect unsafe content.
     * </p>
     * 
     * @return Version number of the base moderation detection model that was used to detect unsafe content.
     */
    public final String moderationModelVersion() {
        return moderationModelVersion;
    }

    /**
     * <p>
     * Shows the results of the human in the loop evaluation.
     * </p>
     * 
     * @return Shows the results of the human in the loop evaluation.
     */
    public final HumanLoopActivationOutput humanLoopActivationOutput() {
        return humanLoopActivationOutput;
    }

    /**
     * <p>
     * Identifier of the custom adapter that was used during inference. If during inference the adapter was EXPIRED,
     * then the parameter will not be returned, indicating that a base moderation detection project version was used.
     * </p>
     * 
     * @return Identifier of the custom adapter that was used during inference. If during inference the adapter was
     *         EXPIRED, then the parameter will not be returned, indicating that a base moderation detection project
     *         version was used.
     */
    public final String projectVersion() {
        return projectVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContentTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasContentTypes() {
        return contentTypes != null && !(contentTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of predicted results for the type of content an image contains. For example, the image content might be
     * from animation, sports, or a video game.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContentTypes} method.
     * </p>
     * 
     * @return A list of predicted results for the type of content an image contains. For example, the image content
     *         might be from animation, sports, or a video game.
     */
    public final List<ContentType> contentTypes() {
        return contentTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasModerationLabels() ? moderationLabels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(moderationModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(humanLoopActivationOutput());
        hashCode = 31 * hashCode + Objects.hashCode(projectVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasContentTypes() ? contentTypes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectModerationLabelsResponse)) {
            return false;
        }
        DetectModerationLabelsResponse other = (DetectModerationLabelsResponse) obj;
        return hasModerationLabels() == other.hasModerationLabels()
                && Objects.equals(moderationLabels(), other.moderationLabels())
                && Objects.equals(moderationModelVersion(), other.moderationModelVersion())
                && Objects.equals(humanLoopActivationOutput(), other.humanLoopActivationOutput())
                && Objects.equals(projectVersion(), other.projectVersion()) && hasContentTypes() == other.hasContentTypes()
                && Objects.equals(contentTypes(), other.contentTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectModerationLabelsResponse")
                .add("ModerationLabels", hasModerationLabels() ? moderationLabels() : null)
                .add("ModerationModelVersion", moderationModelVersion())
                .add("HumanLoopActivationOutput", humanLoopActivationOutput()).add("ProjectVersion", projectVersion())
                .add("ContentTypes", hasContentTypes() ? contentTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModerationLabels":
            return Optional.ofNullable(clazz.cast(moderationLabels()));
        case "ModerationModelVersion":
            return Optional.ofNullable(clazz.cast(moderationModelVersion()));
        case "HumanLoopActivationOutput":
            return Optional.ofNullable(clazz.cast(humanLoopActivationOutput()));
        case "ProjectVersion":
            return Optional.ofNullable(clazz.cast(projectVersion()));
        case "ContentTypes":
            return Optional.ofNullable(clazz.cast(contentTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectModerationLabelsResponse, T> g) {
        return obj -> g.apply((DetectModerationLabelsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DetectModerationLabelsResponse> {
        /**
         * <p>
         * Array of detected Moderation labels. For video operations, this includes the time, in milliseconds from the
         * start of the video, they were detected.
         * </p>
         * 
         * @param moderationLabels
         *        Array of detected Moderation labels. For video operations, this includes the time, in milliseconds
         *        from the start of the video, they were detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder moderationLabels(Collection<ModerationLabel> moderationLabels);

        /**
         * <p>
         * Array of detected Moderation labels. For video operations, this includes the time, in milliseconds from the
         * start of the video, they were detected.
         * </p>
         * 
         * @param moderationLabels
         *        Array of detected Moderation labels. For video operations, this includes the time, in milliseconds
         *        from the start of the video, they were detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder moderationLabels(ModerationLabel... moderationLabels);

        /**
         * <p>
         * Array of detected Moderation labels. For video operations, this includes the time, in milliseconds from the
         * start of the video, they were detected.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rekognition.model.ModerationLabel.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.rekognition.model.ModerationLabel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rekognition.model.ModerationLabel.Builder#build()} is called
         * immediately and its result is passed to {@link #moderationLabels(List<ModerationLabel>)}.
         * 
         * @param moderationLabels
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rekognition.model.ModerationLabel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #moderationLabels(java.util.Collection<ModerationLabel>)
         */
        Builder moderationLabels(Consumer<ModerationLabel.Builder>... moderationLabels);

        /**
         * <p>
         * Version number of the base moderation detection model that was used to detect unsafe content.
         * </p>
         * 
         * @param moderationModelVersion
         *        Version number of the base moderation detection model that was used to detect unsafe content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder moderationModelVersion(String moderationModelVersion);

        /**
         * <p>
         * Shows the results of the human in the loop evaluation.
         * </p>
         * 
         * @param humanLoopActivationOutput
         *        Shows the results of the human in the loop evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanLoopActivationOutput(HumanLoopActivationOutput humanLoopActivationOutput);

        /**
         * <p>
         * Shows the results of the human in the loop evaluation.
         * </p>
         * This is a convenience method that creates an instance of the {@link HumanLoopActivationOutput.Builder}
         * avoiding the need to create one manually via {@link HumanLoopActivationOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HumanLoopActivationOutput.Builder#build()} is called immediately
         * and its result is passed to {@link #humanLoopActivationOutput(HumanLoopActivationOutput)}.
         * 
         * @param humanLoopActivationOutput
         *        a consumer that will call methods on {@link HumanLoopActivationOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #humanLoopActivationOutput(HumanLoopActivationOutput)
         */
        default Builder humanLoopActivationOutput(Consumer<HumanLoopActivationOutput.Builder> humanLoopActivationOutput) {
            return humanLoopActivationOutput(HumanLoopActivationOutput.builder().applyMutation(humanLoopActivationOutput).build());
        }

        /**
         * <p>
         * Identifier of the custom adapter that was used during inference. If during inference the adapter was EXPIRED,
         * then the parameter will not be returned, indicating that a base moderation detection project version was
         * used.
         * </p>
         * 
         * @param projectVersion
         *        Identifier of the custom adapter that was used during inference. If during inference the adapter was
         *        EXPIRED, then the parameter will not be returned, indicating that a base moderation detection project
         *        version was used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectVersion(String projectVersion);

        /**
         * <p>
         * A list of predicted results for the type of content an image contains. For example, the image content might
         * be from animation, sports, or a video game.
         * </p>
         * 
         * @param contentTypes
         *        A list of predicted results for the type of content an image contains. For example, the image content
         *        might be from animation, sports, or a video game.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentTypes(Collection<ContentType> contentTypes);

        /**
         * <p>
         * A list of predicted results for the type of content an image contains. For example, the image content might
         * be from animation, sports, or a video game.
         * </p>
         * 
         * @param contentTypes
         *        A list of predicted results for the type of content an image contains. For example, the image content
         *        might be from animation, sports, or a video game.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentTypes(ContentType... contentTypes);

        /**
         * <p>
         * A list of predicted results for the type of content an image contains. For example, the image content might
         * be from animation, sports, or a video game.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rekognition.model.ContentType.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.rekognition.model.ContentType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rekognition.model.ContentType.Builder#build()} is called immediately
         * and its result is passed to {@link #contentTypes(List<ContentType>)}.
         * 
         * @param contentTypes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rekognition.model.ContentType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contentTypes(java.util.Collection<ContentType>)
         */
        Builder contentTypes(Consumer<ContentType.Builder>... contentTypes);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private List<ModerationLabel> moderationLabels = DefaultSdkAutoConstructList.getInstance();

        private String moderationModelVersion;

        private HumanLoopActivationOutput humanLoopActivationOutput;

        private String projectVersion;

        private List<ContentType> contentTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetectModerationLabelsResponse model) {
            super(model);
            moderationLabels(model.moderationLabels);
            moderationModelVersion(model.moderationModelVersion);
            humanLoopActivationOutput(model.humanLoopActivationOutput);
            projectVersion(model.projectVersion);
            contentTypes(model.contentTypes);
        }

        public final List<ModerationLabel.Builder> getModerationLabels() {
            List<ModerationLabel.Builder> result = ModerationLabelsCopier.copyToBuilder(this.moderationLabels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModerationLabels(Collection<ModerationLabel.BuilderImpl> moderationLabels) {
            this.moderationLabels = ModerationLabelsCopier.copyFromBuilder(moderationLabels);
        }

        @Override
        public final Builder moderationLabels(Collection<ModerationLabel> moderationLabels) {
            this.moderationLabels = ModerationLabelsCopier.copy(moderationLabels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder moderationLabels(ModerationLabel... moderationLabels) {
            moderationLabels(Arrays.asList(moderationLabels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder moderationLabels(Consumer<ModerationLabel.Builder>... moderationLabels) {
            moderationLabels(Stream.of(moderationLabels).map(c -> ModerationLabel.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getModerationModelVersion() {
            return moderationModelVersion;
        }

        public final void setModerationModelVersion(String moderationModelVersion) {
            this.moderationModelVersion = moderationModelVersion;
        }

        @Override
        public final Builder moderationModelVersion(String moderationModelVersion) {
            this.moderationModelVersion = moderationModelVersion;
            return this;
        }

        public final HumanLoopActivationOutput.Builder getHumanLoopActivationOutput() {
            return humanLoopActivationOutput != null ? humanLoopActivationOutput.toBuilder() : null;
        }

        public final void setHumanLoopActivationOutput(HumanLoopActivationOutput.BuilderImpl humanLoopActivationOutput) {
            this.humanLoopActivationOutput = humanLoopActivationOutput != null ? humanLoopActivationOutput.build() : null;
        }

        @Override
        public final Builder humanLoopActivationOutput(HumanLoopActivationOutput humanLoopActivationOutput) {
            this.humanLoopActivationOutput = humanLoopActivationOutput;
            return this;
        }

        public final String getProjectVersion() {
            return projectVersion;
        }

        public final void setProjectVersion(String projectVersion) {
            this.projectVersion = projectVersion;
        }

        @Override
        public final Builder projectVersion(String projectVersion) {
            this.projectVersion = projectVersion;
            return this;
        }

        public final List<ContentType.Builder> getContentTypes() {
            List<ContentType.Builder> result = ContentTypesCopier.copyToBuilder(this.contentTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContentTypes(Collection<ContentType.BuilderImpl> contentTypes) {
            this.contentTypes = ContentTypesCopier.copyFromBuilder(contentTypes);
        }

        @Override
        public final Builder contentTypes(Collection<ContentType> contentTypes) {
            this.contentTypes = ContentTypesCopier.copy(contentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contentTypes(ContentType... contentTypes) {
            contentTypes(Arrays.asList(contentTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contentTypes(Consumer<ContentType.Builder>... contentTypes) {
            contentTypes(Stream.of(contentTypes).map(c -> ContentType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DetectModerationLabelsResponse build() {
            return new DetectModerationLabelsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
