/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.Geometry;
import software.amazon.awssdk.services.rekognition.model.TextTypes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TextDetection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TextDetection> {
    private static final SdkField<String> DETECTED_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DetectedText").getter(TextDetection.getter(TextDetection::detectedText)).setter(TextDetection.setter(Builder::detectedText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetectedText").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(TextDetection.getter(TextDetection::typeAsString)).setter(TextDetection.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Integer> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Id").getter(TextDetection.getter(TextDetection::id)).setter(TextDetection.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<Integer> PARENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ParentId").getter(TextDetection.getter(TextDetection::parentId)).setter(TextDetection.setter(Builder::parentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentId").build()}).build();
    private static final SdkField<Float> CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Confidence").getter(TextDetection.getter(TextDetection::confidence)).setter(TextDetection.setter(Builder::confidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()}).build();
    private static final SdkField<Geometry> GEOMETRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Geometry").getter(TextDetection.getter(TextDetection::geometry)).setter(TextDetection.setter(Builder::geometry)).constructor(Geometry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Geometry").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTED_TEXT_FIELD, TYPE_FIELD, ID_FIELD, PARENT_ID_FIELD, CONFIDENCE_FIELD, GEOMETRY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DetectedText", DETECTED_TEXT_FIELD);
            this.put("Type", TYPE_FIELD);
            this.put("Id", ID_FIELD);
            this.put("ParentId", PARENT_ID_FIELD);
            this.put("Confidence", CONFIDENCE_FIELD);
            this.put("Geometry", GEOMETRY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String detectedText;
    private final String type;
    private final Integer id;
    private final Integer parentId;
    private final Float confidence;
    private final Geometry geometry;

    private TextDetection(BuilderImpl builder) {
        this.detectedText = builder.detectedText;
        this.type = builder.type;
        this.id = builder.id;
        this.parentId = builder.parentId;
        this.confidence = builder.confidence;
        this.geometry = builder.geometry;
    }

    public final String detectedText() {
        return this.detectedText;
    }

    public final TextTypes type() {
        return TextTypes.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Integer id() {
        return this.id;
    }

    public final Integer parentId() {
        return this.parentId;
    }

    public final Float confidence() {
        return this.confidence;
    }

    public final Geometry geometry() {
        return this.geometry;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.detectedText());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.geometry());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextDetection)) {
            return false;
        }
        TextDetection other = (TextDetection)obj;
        return Objects.equals(this.detectedText(), other.detectedText()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.parentId(), other.parentId()) && Objects.equals(this.confidence(), other.confidence()) && Objects.equals(this.geometry(), other.geometry());
    }

    public final String toString() {
        return ToString.builder((String)"TextDetection").add("DetectedText", (Object)this.detectedText()).add("Type", (Object)this.typeAsString()).add("Id", (Object)this.id()).add("ParentId", (Object)this.parentId()).add("Confidence", (Object)this.confidence()).add("Geometry", (Object)this.geometry()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DetectedText": {
                return Optional.ofNullable(clazz.cast(this.detectedText()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "ParentId": {
                return Optional.ofNullable(clazz.cast(this.parentId()));
            }
            case "Confidence": {
                return Optional.ofNullable(clazz.cast(this.confidence()));
            }
            case "Geometry": {
                return Optional.ofNullable(clazz.cast(this.geometry()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TextDetection, T> g) {
        return obj -> g.apply((TextDetection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String detectedText;
        private String type;
        private Integer id;
        private Integer parentId;
        private Float confidence;
        private Geometry geometry;

        private BuilderImpl() {
        }

        private BuilderImpl(TextDetection model) {
            this.detectedText(model.detectedText);
            this.type(model.type);
            this.id(model.id);
            this.parentId(model.parentId);
            this.confidence(model.confidence);
            this.geometry(model.geometry);
        }

        public final String getDetectedText() {
            return this.detectedText;
        }

        public final void setDetectedText(String detectedText) {
            this.detectedText = detectedText;
        }

        @Override
        public final Builder detectedText(String detectedText) {
            this.detectedText = detectedText;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TextTypes type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Integer getId() {
            return this.id;
        }

        public final void setId(Integer id) {
            this.id = id;
        }

        @Override
        public final Builder id(Integer id) {
            this.id = id;
            return this;
        }

        public final Integer getParentId() {
            return this.parentId;
        }

        public final void setParentId(Integer parentId) {
            this.parentId = parentId;
        }

        @Override
        public final Builder parentId(Integer parentId) {
            this.parentId = parentId;
            return this;
        }

        public final Float getConfidence() {
            return this.confidence;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final Geometry.Builder getGeometry() {
            return this.geometry != null ? this.geometry.toBuilder() : null;
        }

        public final void setGeometry(Geometry.BuilderImpl geometry) {
            this.geometry = geometry != null ? geometry.build() : null;
        }

        @Override
        public final Builder geometry(Geometry geometry) {
            this.geometry = geometry;
            return this;
        }

        public TextDetection build() {
            return new TextDetection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TextDetection> {
        public Builder detectedText(String var1);

        public Builder type(String var1);

        public Builder type(TextTypes var1);

        public Builder id(Integer var1);

        public Builder parentId(Integer var1);

        public Builder confidence(Float var1);

        public Builder geometry(Geometry var1);

        default public Builder geometry(Consumer<Geometry.Builder> geometry) {
            return this.geometry((Geometry)((Geometry.Builder)Geometry.builder().applyMutation(geometry)).build());
        }
    }
}

