/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.ConnectedHomeLabelsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectedHomeSettingsForUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectedHomeSettingsForUpdate> {
    private static final SdkField<List<String>> LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Labels").getter(ConnectedHomeSettingsForUpdate.getter(ConnectedHomeSettingsForUpdate::labels)).setter(ConnectedHomeSettingsForUpdate.setter(Builder::labels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Labels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Float> MIN_CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("MinConfidence").getter(ConnectedHomeSettingsForUpdate.getter(ConnectedHomeSettingsForUpdate::minConfidence)).setter(ConnectedHomeSettingsForUpdate.setter(Builder::minConfidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinConfidence").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABELS_FIELD, MIN_CONFIDENCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Labels", LABELS_FIELD);
            this.put("MinConfidence", MIN_CONFIDENCE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> labels;
    private final Float minConfidence;

    private ConnectedHomeSettingsForUpdate(BuilderImpl builder) {
        this.labels = builder.labels;
        this.minConfidence = builder.minConfidence;
    }

    public final boolean hasLabels() {
        return this.labels != null && !(this.labels instanceof SdkAutoConstructList);
    }

    public final List<String> labels() {
        return this.labels;
    }

    public final Float minConfidence() {
        return this.minConfidence;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLabels() ? this.labels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.minConfidence());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectedHomeSettingsForUpdate)) {
            return false;
        }
        ConnectedHomeSettingsForUpdate other = (ConnectedHomeSettingsForUpdate)obj;
        return this.hasLabels() == other.hasLabels() && Objects.equals(this.labels(), other.labels()) && Objects.equals(this.minConfidence(), other.minConfidence());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectedHomeSettingsForUpdate").add("Labels", this.hasLabels() ? this.labels() : null).add("MinConfidence", (Object)this.minConfidence()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Labels": {
                return Optional.ofNullable(clazz.cast(this.labels()));
            }
            case "MinConfidence": {
                return Optional.ofNullable(clazz.cast(this.minConfidence()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ConnectedHomeSettingsForUpdate, T> g) {
        return obj -> g.apply((ConnectedHomeSettingsForUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> labels = DefaultSdkAutoConstructList.getInstance();
        private Float minConfidence;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectedHomeSettingsForUpdate model) {
            this.labels(model.labels);
            this.minConfidence(model.minConfidence);
        }

        public final Collection<String> getLabels() {
            if (this.labels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.labels;
        }

        public final void setLabels(Collection<String> labels) {
            this.labels = ConnectedHomeLabelsCopier.copy(labels);
        }

        @Override
        public final Builder labels(Collection<String> labels) {
            this.labels = ConnectedHomeLabelsCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(String ... labels) {
            this.labels(Arrays.asList(labels));
            return this;
        }

        public final Float getMinConfidence() {
            return this.minConfidence;
        }

        public final void setMinConfidence(Float minConfidence) {
            this.minConfidence = minConfidence;
        }

        @Override
        public final Builder minConfidence(Float minConfidence) {
            this.minConfidence = minConfidence;
            return this;
        }

        public ConnectedHomeSettingsForUpdate build() {
            return new ConnectedHomeSettingsForUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectedHomeSettingsForUpdate> {
        public Builder labels(Collection<String> var1);

        public Builder labels(String ... var1);

        public Builder minConfidence(Float var1);
    }
}

