/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.AuditImage;
import software.amazon.awssdk.services.rekognition.model.AuditImagesCopier;
import software.amazon.awssdk.services.rekognition.model.LivenessSessionStatus;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFaceLivenessSessionResultsResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, GetFaceLivenessSessionResultsResponse> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SessionId").getter(GetFaceLivenessSessionResultsResponse.getter(GetFaceLivenessSessionResultsResponse::sessionId)).setter(GetFaceLivenessSessionResultsResponse.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetFaceLivenessSessionResultsResponse.getter(GetFaceLivenessSessionResultsResponse::statusAsString)).setter(GetFaceLivenessSessionResultsResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Float> CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Confidence").getter(GetFaceLivenessSessionResultsResponse.getter(GetFaceLivenessSessionResultsResponse::confidence)).setter(GetFaceLivenessSessionResultsResponse.setter(Builder::confidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()}).build();
    private static final SdkField<AuditImage> REFERENCE_IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReferenceImage").getter(GetFaceLivenessSessionResultsResponse.getter(GetFaceLivenessSessionResultsResponse::referenceImage)).setter(GetFaceLivenessSessionResultsResponse.setter(Builder::referenceImage)).constructor(AuditImage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceImage").build()}).build();
    private static final SdkField<List<AuditImage>> AUDIT_IMAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AuditImages").getter(GetFaceLivenessSessionResultsResponse.getter(GetFaceLivenessSessionResultsResponse::auditImages)).setter(GetFaceLivenessSessionResultsResponse.setter(Builder::auditImages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditImages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AuditImage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ID_FIELD, STATUS_FIELD, CONFIDENCE_FIELD, REFERENCE_IMAGE_FIELD, AUDIT_IMAGES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SessionId", SESSION_ID_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("Confidence", CONFIDENCE_FIELD);
            this.put("ReferenceImage", REFERENCE_IMAGE_FIELD);
            this.put("AuditImages", AUDIT_IMAGES_FIELD);
        }
    });
    private final String sessionId;
    private final String status;
    private final Float confidence;
    private final AuditImage referenceImage;
    private final List<AuditImage> auditImages;

    private GetFaceLivenessSessionResultsResponse(BuilderImpl builder) {
        super(builder);
        this.sessionId = builder.sessionId;
        this.status = builder.status;
        this.confidence = builder.confidence;
        this.referenceImage = builder.referenceImage;
        this.auditImages = builder.auditImages;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final LivenessSessionStatus status() {
        return LivenessSessionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Float confidence() {
        return this.confidence;
    }

    public final AuditImage referenceImage() {
        return this.referenceImage;
    }

    public final boolean hasAuditImages() {
        return this.auditImages != null && !(this.auditImages instanceof SdkAutoConstructList);
    }

    public final List<AuditImage> auditImages() {
        return this.auditImages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuditImages() ? this.auditImages() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFaceLivenessSessionResultsResponse)) {
            return false;
        }
        GetFaceLivenessSessionResultsResponse other = (GetFaceLivenessSessionResultsResponse)((Object)obj);
        return Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.confidence(), other.confidence()) && Objects.equals(this.referenceImage(), other.referenceImage()) && this.hasAuditImages() == other.hasAuditImages() && Objects.equals(this.auditImages(), other.auditImages());
    }

    public final String toString() {
        return ToString.builder((String)"GetFaceLivenessSessionResultsResponse").add("SessionId", (Object)this.sessionId()).add("Status", (Object)this.statusAsString()).add("Confidence", (Object)this.confidence()).add("ReferenceImage", (Object)this.referenceImage()).add("AuditImages", this.hasAuditImages() ? this.auditImages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Confidence": {
                return Optional.ofNullable(clazz.cast(this.confidence()));
            }
            case "ReferenceImage": {
                return Optional.ofNullable(clazz.cast(this.referenceImage()));
            }
            case "AuditImages": {
                return Optional.ofNullable(clazz.cast(this.auditImages()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetFaceLivenessSessionResultsResponse, T> g) {
        return obj -> g.apply((GetFaceLivenessSessionResultsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private String sessionId;
        private String status;
        private Float confidence;
        private AuditImage referenceImage;
        private List<AuditImage> auditImages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetFaceLivenessSessionResultsResponse model) {
            super(model);
            this.sessionId(model.sessionId);
            this.status(model.status);
            this.confidence(model.confidence);
            this.referenceImage(model.referenceImage);
            this.auditImages(model.auditImages);
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LivenessSessionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Float getConfidence() {
            return this.confidence;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final AuditImage.Builder getReferenceImage() {
            return this.referenceImage != null ? this.referenceImage.toBuilder() : null;
        }

        public final void setReferenceImage(AuditImage.BuilderImpl referenceImage) {
            this.referenceImage = referenceImage != null ? referenceImage.build() : null;
        }

        @Override
        public final Builder referenceImage(AuditImage referenceImage) {
            this.referenceImage = referenceImage;
            return this;
        }

        public final List<AuditImage.Builder> getAuditImages() {
            List<AuditImage.Builder> result = AuditImagesCopier.copyToBuilder(this.auditImages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAuditImages(Collection<AuditImage.BuilderImpl> auditImages) {
            this.auditImages = AuditImagesCopier.copyFromBuilder(auditImages);
        }

        @Override
        public final Builder auditImages(Collection<AuditImage> auditImages) {
            this.auditImages = AuditImagesCopier.copy(auditImages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auditImages(AuditImage ... auditImages) {
            this.auditImages(Arrays.asList(auditImages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auditImages(Consumer<AuditImage.Builder> ... auditImages) {
            this.auditImages(Stream.of(auditImages).map(c -> (AuditImage)((AuditImage.Builder)AuditImage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetFaceLivenessSessionResultsResponse build() {
            return new GetFaceLivenessSessionResultsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetFaceLivenessSessionResultsResponse> {
        public Builder sessionId(String var1);

        public Builder status(String var1);

        public Builder status(LivenessSessionStatus var1);

        public Builder confidence(Float var1);

        public Builder referenceImage(AuditImage var1);

        default public Builder referenceImage(Consumer<AuditImage.Builder> referenceImage) {
            return this.referenceImage((AuditImage)((AuditImage.Builder)AuditImage.builder().applyMutation(referenceImage)).build());
        }

        public Builder auditImages(Collection<AuditImage> var1);

        public Builder auditImages(AuditImage ... var1);

        public Builder auditImages(Consumer<AuditImage.Builder> ... var1);
    }
}

